// This file is part of the "jQuery.Syntax" project, and is distributed under the MIT License.
// Copyright (c) 2011 Samuel G. D. Williams. <http://www.oriontransfer.co.nz>


if(!Function.prototype.bind){Function.prototype.bind=function(target){var args=Array.prototype.slice.call(arguments,1),fn=this;return function(){return fn.apply(target,args);};};}
function ResourceLoader(loader){this.dependencies={};this.loading={};this.loader=loader;}
ResourceLoader.prototype._finish=function(name){var deps=this.dependencies[name];if(deps){var chain=this._loaded.bind(this,name);for(var i=0;i<deps.length;i+=1){chain=this.get.bind(this,deps[i],chain);}
chain();}else{this._loaded(name);}};ResourceLoader.prototype._loaded=function(name){var resource=this[name],loading=this.loading[name];this.loading[name]=null;if(!resource){alert("Could not load resource named "+name);}else{for(var i=0;i<loading.length;i+=1){loading[i](resource);}}};ResourceLoader.prototype.dependency=function(current,next){if(this[next]&&!this.loading[name]){return;}
if(this.dependencies[current]){this.dependencies[current].push(next);}else{this.dependencies[current]=[next];}};ResourceLoader.prototype.get=function(name,callback){if(this.loading[name]){this.loading[name].push(callback)}else if(this[name]){callback(this[name]);}else{this.loading[name]=[callback];this.loader(name,this._finish.bind(this,name));}};var Syntax={root:null,aliases:{},styles:{},lib:{},defaultOptions:{cacheScripts:true,cacheStyleSheets:true},brushes:new ResourceLoader(function(name,callback){name=Syntax.aliases[name]||name;Syntax.getResource('jquery.syntax.brush',name,callback);}),layouts:new ResourceLoader(function(name,callback){Syntax.getResource('jquery.syntax.layout',name,callback);}),loader:new ResourceLoader(function(name,callback){Syntax.getResource('jquery.syntax',name,callback);}),getStyles:function(path){var link=jQuery('<link>');jQuery("head").append(link);if(!Syntax.defaultOptions.cacheStyleSheets){path=path+"?"+Math.random()}
link.attr({rel:"stylesheet",type:"text/css",href:path});},getScript:function(path,callback){var script=document.createElement('script');script.onreadystatechange=function(){if(this.onload&&(this.readyState=='loaded'||this.readyState=='complete')){this.onload();this.onload=null;}};script.onload=callback;script.type="text/javascript";if(!Syntax.defaultOptions.cacheScripts)
path=path+'?'+Math.random()
script.src=path;document.getElementsByTagName('head')[0].appendChild(script);},getResource:function(prefix,name,callback){var basename=prefix+"."+name;if(this.styles[basename]){this.getStyles(this.root+this.styles[basename]);}
Syntax.getScript(this.root+basename+'.js',callback);},alias:function(name,aliases){Syntax.aliases[name]=name;for(var i=0;i<aliases.length;i+=1){Syntax.aliases[aliases[i]]=name;}},brushAliases:function(brush){var aliases=[];for(var name in Syntax.aliases){if(Syntax.aliases[name]===brush){aliases.push(name);}}
return aliases;},brushNames:function(){var names=[];for(var name in Syntax.aliases){if(name===Syntax.aliases[name]){names.push(name);}}
return names;},extractBrushName:function(className){className=className.toLowerCase();var match=className.match(/brush-([\S]+)/);if(match){return match[1];}else{var classes=className.split(/ /);if(jQuery.inArray("syntax",classes)!==-1){for(var i=0;i<classes.length;i+=1){var name=Syntax.aliases[classes[i]];if(name){return name;}}}}
return null;},detectRoot:function(){if(Syntax.root==null){var scripts=$('script').filter(function(){return this.src.match(/jquery\.syntax/);});var first=scripts.get(0);if(first){var root=first.src.match(/.*\//);if(root){Syntax.root=root[0];}}}},log:function(){if(console&&console.log){console.log.apply(console,arguments);}else{alert(arguments.join(" "));}}};jQuery.fn.syntax=function(options,callback){Syntax.detectRoot();var elements=this;Syntax.loader.get('core',function(){Syntax.highlight(elements,options,callback);});};jQuery.syntax=function(options,callback){options=options||{};var context=options.context;if(options.root){Syntax.root=options.root;}else{Syntax.detectRoot();}
options=jQuery.extend(Syntax.defaultOptions,options)
options.blockSelector=options.blockSelector||'pre.syntax:not(.highlighted)';options.inlineSelector=options.inlineSelector||'code.syntax:not(.highlighted)';options.blockLayout=options.blockLayout||'list';options.inlineLayout=options.inlineLayout||'inline';if(typeof options.replace=="undefined")
options.replace=true;jQuery(options.blockSelector,context).each(function(){jQuery(this).syntax(jQuery.extend({},options,{brush:Syntax.extractBrushName(this.className),layout:options.blockLayout}),callback);});jQuery(options.inlineSelector,context).each(function(){jQuery(this).syntax(jQuery.extend({},options,{brush:Syntax.extractBrushName(this.className),layout:options.inlineLayout}),callback);});};Syntax.alias("apache",[]);Syntax.alias("applescript",[]);Syntax.alias("assembly",["asm"]);Syntax.alias("bash-script",[]);Syntax.alias("bash",[]);Syntax.alias("basic",['vb']);Syntax.alias("clang",["cpp","c++","c","objective-c"]);Syntax.alias("csharp",["c-sharp","c#"]);Syntax.alias("css",[]);Syntax.alias("diff",["patch"]);Syntax.alias("haskell",[]);Syntax.alias("html",[]);Syntax.alias("io",[]);Syntax.alias("java",[]);Syntax.alias("javascript",["js","actionscript"]);Syntax.alias("kai",[]);Syntax.alias("lisp",['scheme','clojure']);Syntax.alias("lua",[]);Syntax.alias("ooc",[]);Syntax.alias("pascal",["delphi"]);Syntax.alias("perl5",[]);Syntax.alias("php-script",[]);Syntax.alias("php",[]);Syntax.alias("plain",["text"]);Syntax.alias("python",[]);Syntax.alias("ruby",[]);Syntax.alias("smalltalk",[]);Syntax.alias("sql",[]);Syntax.alias("xml",[]);Syntax.alias("yaml",[]);Syntax.styles["jquery.syntax.brush.apache"]="jquery.syntax.brush.apache.css";Syntax.styles["jquery.syntax.brush.applescript"]="jquery.syntax.brush.applescript.css";Syntax.styles["jquery.syntax.brush.assembly"]="jquery.syntax.brush.assembly.css";Syntax.styles["jquery.syntax.brush.bash-script"]="jquery.syntax.brush.bash-script.css";Syntax.styles["jquery.syntax.brush.bash"]="jquery.syntax.brush.bash.css";Syntax.styles["jquery.syntax.brush.clang"]="jquery.syntax.brush.clang.css";Syntax.styles["jquery.syntax.brush.css"]="jquery.syntax.brush.css.css";Syntax.styles["jquery.syntax.brush.diff"]="jquery.syntax.brush.diff.css";Syntax.styles["jquery.syntax.brush.html"]="jquery.syntax.brush.html.css";Syntax.styles["jquery.syntax.brush.python"]="jquery.syntax.brush.python.css";Syntax.styles["jquery.syntax.brush.xml"]="jquery.syntax.brush.xml.css";Syntax.styles["jquery.syntax.core"]="jquery.syntax.core.css";Syntax.styles["jquery.syntax.layout.fixed"]="jquery.syntax.layout.fixed.css";Syntax.styles["jquery.syntax.layout.inline"]="jquery.syntax.layout.inline.css";Syntax.styles["jquery.syntax.layout.list"]="jquery.syntax.layout.list.css";Syntax.styles["jquery.syntax.layout.plain"]="jquery.syntax.layout.plain.css";Syntax.styles["jquery.syntax.layout.table"]="jquery.syntax.layout.table.css";