/*
* Kendo UI Complete v2013.1.319 (http://kendoui.com)
* Copyright 2013 Telerik AD. All rights reserved.
*
* Kendo UI Complete commercial licenses may be obtained at
* https://www.kendoui.com/purchase/license-agreement/kendo-ui-complete-commercial.aspx
* If you do not own a commercial license, this file shall be governed by the trial license terms.
*/
(function($, evil, undefined) {
    var kendo = window.kendo = window.kendo || {}, extend = $.extend, each = $.each, proxy = $.proxy, isArray = $.isArray, noop = $.noop, isFunction = $.isFunction, math = Math, Template, JSON = window.JSON || {}, support = {}, percentRegExp = /%/, formatRegExp = /\{(\d+)(:[^\}]+)?\}/g, boxShadowRegExp = /(\d+?)px\s*(\d+?)px\s*(\d+?)px\s*(\d+?)?/i, FUNCTION = "function", STRING = "string", NUMBER = "number", OBJECT = "object", NULL = "null", BOOLEAN = "boolean", UNDEFINED = "undefined", getterCache = {}, setterCache = {}, slice = [].slice, globalize = window.Globalize;
    function Class() {}
    Class.extend = function(proto) {
        var base = function() {}, member, that = this, subclass = proto && proto.init ? proto.init : function() {
            that.apply(this, arguments);
        }, fn;
        base.prototype = that.prototype;
        fn = subclass.fn = subclass.prototype = new base();
        for (member in proto) {
            if (typeof proto[member] === OBJECT && !(proto[member] instanceof Array) && proto[member] !== null) {
                // Merge object members
                fn[member] = extend(true, {}, base.prototype[member], proto[member]);
            } else {
                fn[member] = proto[member];
            }
        }
        fn.constructor = subclass;
        subclass.extend = that.extend;
        return subclass;
    };
    var preventDefault = function() {
        this._defaultPrevented = true;
    };
    var isDefaultPrevented = function() {
        return this._defaultPrevented === true;
    };
    var Observable = Class.extend({
        init: function() {
            this._events = {};
        },
        bind: function(eventName, handlers, one) {
            var that = this, idx, eventNames = typeof eventName === STRING ? [ eventName ] : eventName, length, original, handler, handlersIsFunction = typeof handlers === FUNCTION, events;
            if (handlers === undefined) {
                for (idx in eventName) {
                    that.bind(idx, eventName[idx]);
                }
                return that;
            }
            for (idx = 0, length = eventNames.length; idx < length; idx++) {
                eventName = eventNames[idx];
                handler = handlersIsFunction ? handlers : handlers[eventName];
                if (handler) {
                    if (one) {
                        original = handler;
                        handler = function() {
                            that.unbind(eventName, handler);
                            original.apply(that, arguments);
                        };
                    }
                    events = that._events[eventName] = that._events[eventName] || [];
                    events.push(handler);
                }
            }
            return that;
        },
        one: function(eventNames, handlers) {
            return this.bind(eventNames, handlers, true);
        },
        first: function(eventName, handlers) {
            var that = this, idx, eventNames = typeof eventName === STRING ? [ eventName ] : eventName, length, handler, handlersIsFunction = typeof handlers === FUNCTION, events;
            for (idx = 0, length = eventNames.length; idx < length; idx++) {
                eventName = eventNames[idx];
                handler = handlersIsFunction ? handlers : handlers[eventName];
                if (handler) {
                    events = that._events[eventName] = that._events[eventName] || [];
                    events.unshift(handler);
                }
            }
            return that;
        },
        trigger: function(eventName, e) {
            var that = this, events = that._events[eventName], idx, length;
            if (events) {
                e = e || {};
                e.sender = that;
                e._defaultPrevented = false;
                e.preventDefault = preventDefault;
                e.isDefaultPrevented = isDefaultPrevented;
                events = events.slice();
                for (idx = 0, length = events.length; idx < length; idx++) {
                    events[idx].call(that, e);
                }
                return e._defaultPrevented === true;
            }
            return false;
        },
        unbind: function(eventName, handler) {
            var that = this, events = that._events[eventName], idx, length;
            if (eventName === undefined) {
                that._events = {};
            } else if (events) {
                if (handler) {
                    for (idx = 0, length = events.length; idx < length; idx++) {
                        if (events[idx] === handler) {
                            events.splice(idx, 1);
                        }
                    }
                } else {
                    that._events[eventName] = [];
                }
            }
            return that;
        }
    });
    function compilePart(part, stringPart) {
        if (stringPart) {
            return "'" + part.split("'").join("\\'").split('\\"').join('\\\\\\"').replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/\t/g, "\\t") + "'";
        } else {
            var first = part.charAt(0), rest = part.substring(1);
            if (first === "=") {
                return "+(" + rest + ")+";
            } else if (first === ":") {
                return "+e(" + rest + ")+";
            } else {
                return ";" + part + ";o+=";
            }
        }
    }
    var argumentNameRegExp = /^\w+/, encodeRegExp = /\$\{([^}]*)\}/g, escapedCurlyRegExp = /\\\}/g, curlyRegExp = /__CURLY__/g, escapedSharpRegExp = /\\#/g, sharpRegExp = /__SHARP__/g, zeros = [ "", "0", "00", "000", "0000" ];
    Template = {
        paramName: "data",
        // name of the parameter of the generated template
        useWithBlock: true,
        // whether to wrap the template in a with() block
        render: function(template, data) {
            var idx, length, html = "";
            for (idx = 0, length = data.length; idx < length; idx++) {
                html += template(data[idx]);
            }
            return html;
        },
        compile: function(template, options) {
            var settings = extend({}, this, options), paramName = settings.paramName, argumentName = paramName.match(argumentNameRegExp)[0], useWithBlock = settings.useWithBlock, functionBody = "var o,e=kendo.htmlEncode;", parts, idx;
            if (isFunction(template)) {
                if (template.length === 2) {
                    //looks like jQuery.template
                    return function(d) {
                        return template($, {
                            data: d
                        }).join("");
                    };
                }
                return template;
            }
            functionBody += useWithBlock ? "with(" + paramName + "){" : "";
            functionBody += "o=";
            parts = template.replace(escapedCurlyRegExp, "__CURLY__").replace(encodeRegExp, "#=e($1)#").replace(curlyRegExp, "}").replace(escapedSharpRegExp, "__SHARP__").split("#");
            for (idx = 0; idx < parts.length; idx++) {
                functionBody += compilePart(parts[idx], idx % 2 === 0);
            }
            functionBody += useWithBlock ? ";}" : ";";
            functionBody += "return o;";
            functionBody = functionBody.replace(sharpRegExp, "#");
            try {
                return new Function(argumentName, functionBody);
            } catch (e) {
                throw new Error(kendo.format("Invalid template:'{0}' Generated code:'{1}'", template, functionBody));
            }
        }
    };
    function pad(number, digits, end) {
        number = number + "";
        digits = digits || 2;
        end = digits - number.length;
        if (end) {
            return zeros[digits].substring(0, end) + number;
        }
        return number;
    }
    //JSON stringify
    (function() {
        var escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g, gap, indent, meta = {
            "\b": "\\b",
            "	": "\\t",
            "\n": "\\n",
            "\f": "\\f",
            "\r": "\\r",
            '"': '\\"',
            "\\": "\\\\"
        }, rep, toString = {}.toString;
        if (typeof Date.prototype.toJSON !== FUNCTION) {
            Date.prototype.toJSON = function() {
                var that = this;
                return isFinite(that.valueOf()) ? pad(that.getUTCFullYear(), 4) + "-" + pad(that.getUTCMonth() + 1) + "-" + pad(that.getUTCDate()) + "T" + pad(that.getUTCHours()) + ":" + pad(that.getUTCMinutes()) + ":" + pad(that.getUTCSeconds()) + "Z" : null;
            };
            String.prototype.toJSON = Number.prototype.toJSON = Boolean.prototype.toJSON = function() {
                return this.valueOf();
            };
        }
        function quote(string) {
            escapable.lastIndex = 0;
            return escapable.test(string) ? '"' + string.replace(escapable, function(a) {
                var c = meta[a];
                return typeof c === STRING ? c : "\\u" + ("0000" + a.charCodeAt(0).toString(16)).slice(-4);
            }) + '"' : '"' + string + '"';
        }
        function str(key, holder) {
            var i, k, v, length, mind = gap, partial, value = holder[key], type;
            if (value && typeof value === OBJECT && typeof value.toJSON === FUNCTION) {
                value = value.toJSON(key);
            }
            if (typeof rep === FUNCTION) {
                value = rep.call(holder, key, value);
            }
            type = typeof value;
            if (type === STRING) {
                return quote(value);
            } else if (type === NUMBER) {
                return isFinite(value) ? String(value) : NULL;
            } else if (type === BOOLEAN || type === NULL) {
                return String(value);
            } else if (type === OBJECT) {
                if (!value) {
                    return NULL;
                }
                gap += indent;
                partial = [];
                if (toString.apply(value) === "[object Array]") {
                    length = value.length;
                    for (i = 0; i < length; i++) {
                        partial[i] = str(i, value) || NULL;
                    }
                    v = partial.length === 0 ? "[]" : gap ? "[\n" + gap + partial.join(",\n" + gap) + "\n" + mind + "]" : "[" + partial.join(",") + "]";
                    gap = mind;
                    return v;
                }
                if (rep && typeof rep === OBJECT) {
                    length = rep.length;
                    for (i = 0; i < length; i++) {
                        if (typeof rep[i] === STRING) {
                            k = rep[i];
                            v = str(k, value);
                            if (v) {
                                partial.push(quote(k) + (gap ? ": " : ":") + v);
                            }
                        }
                    }
                } else {
                    for (k in value) {
                        if (Object.hasOwnProperty.call(value, k)) {
                            v = str(k, value);
                            if (v) {
                                partial.push(quote(k) + (gap ? ": " : ":") + v);
                            }
                        }
                    }
                }
                v = partial.length === 0 ? "{}" : gap ? "{\n" + gap + partial.join(",\n" + gap) + "\n" + mind + "}" : "{" + partial.join(",") + "}";
                gap = mind;
                return v;
            }
        }
        if (typeof JSON.stringify !== FUNCTION) {
            JSON.stringify = function(value, replacer, space) {
                var i;
                gap = "";
                indent = "";
                if (typeof space === NUMBER) {
                    for (i = 0; i < space; i += 1) {
                        indent += " ";
                    }
                } else if (typeof space === STRING) {
                    indent = space;
                }
                rep = replacer;
                if (replacer && typeof replacer !== FUNCTION && (typeof replacer !== OBJECT || typeof replacer.length !== NUMBER)) {
                    throw new Error("JSON.stringify");
                }
                return str("", {
                    "": value
                });
            };
        }
    })();
    // Date and Number formatting
    (function() {
        var dateFormatRegExp = /dddd|ddd|dd|d|MMMM|MMM|MM|M|yyyy|yy|HH|H|hh|h|mm|m|fff|ff|f|tt|ss|s|"[^"]*"|'[^']*'/g, standardFormatRegExp = /^(n|c|p|e)(\d*)$/i, literalRegExp = /["'].*?["']/g, commaRegExp = /\,/g, EMPTY = "", POINT = ".", COMMA = ",", SHARP = "#", ZERO = "0", PLACEHOLDER = "??", EN = "en-US";
        //cultures
        kendo.cultures = {
            "en-US": {
                name: EN,
                numberFormat: {
                    pattern: [ "-n" ],
                    decimals: 2,
                    ",": ",",
                    ".": ".",
                    groupSize: [ 3 ],
                    percent: {
                        pattern: [ "-n %", "n %" ],
                        decimals: 2,
                        ",": ",",
                        ".": ".",
                        groupSize: [ 3 ],
                        symbol: "%"
                    },
                    currency: {
                        pattern: [ "($n)", "$n" ],
                        decimals: 2,
                        ",": ",",
                        ".": ".",
                        groupSize: [ 3 ],
                        symbol: "$"
                    }
                },
                calendars: {
                    standard: {
                        days: {
                            names: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
                            namesAbbr: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
                            namesShort: [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
                        },
                        months: {
                            names: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ],
                            namesAbbr: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ]
                        },
                        AM: [ "AM", "am", "AM" ],
                        PM: [ "PM", "pm", "PM" ],
                        patterns: {
                            d: "M/d/yyyy",
                            D: "dddd, MMMM dd, yyyy",
                            F: "dddd, MMMM dd, yyyy h:mm:ss tt",
                            g: "M/d/yyyy h:mm tt",
                            G: "M/d/yyyy h:mm:ss tt",
                            m: "MMMM dd",
                            M: "MMMM dd",
                            s: "yyyy'-'MM'-'ddTHH':'mm':'ss",
                            t: "h:mm tt",
                            T: "h:mm:ss tt",
                            u: "yyyy'-'MM'-'dd HH':'mm':'ss'Z'",
                            y: "MMMM, yyyy",
                            Y: "MMMM, yyyy"
                        },
                        "/": "/",
                        ":": ":",
                        firstDay: 0,
                        twoDigitYearMax: 2029
                    }
                }
            }
        };
        function findCulture(culture) {
            if (culture) {
                if (culture.numberFormat) {
                    return culture;
                }
                if (typeof culture === STRING) {
                    var cultures = kendo.cultures;
                    return cultures[culture] || cultures[culture.split("-")[0]] || null;
                }
                return null;
            }
            return null;
        }
        function getCulture(culture) {
            if (culture) {
                culture = findCulture(culture);
            }
            return culture || kendo.cultures.current;
        }
        function expandNumberFormat(numberFormat) {
            numberFormat.groupSizes = numberFormat.groupSize;
            numberFormat.percent.groupSizes = numberFormat.percent.groupSize;
            numberFormat.currency.groupSizes = numberFormat.currency.groupSize;
        }
        kendo.culture = function(cultureName) {
            var cultures = kendo.cultures, culture;
            if (cultureName !== undefined) {
                culture = findCulture(cultureName) || cultures[EN];
                culture.calendar = culture.calendars.standard;
                cultures.current = culture;
                if (globalize) {
                    expandNumberFormat(culture.numberFormat);
                }
            } else {
                return cultures.current;
            }
        };
        kendo.findCulture = findCulture;
        kendo.getCulture = getCulture;
        //set current culture to en-US.
        kendo.culture(EN);
        function formatDate(date, format, culture) {
            culture = getCulture(culture);
            var calendar = culture.calendars.standard, days = calendar.days, months = calendar.months;
            format = calendar.patterns[format] || format;
            return format.replace(dateFormatRegExp, function(match) {
                var result;
                if (match === "d") {
                    result = date.getDate();
                } else if (match === "dd") {
                    result = pad(date.getDate());
                } else if (match === "ddd") {
                    result = days.namesAbbr[date.getDay()];
                } else if (match === "dddd") {
                    result = days.names[date.getDay()];
                } else if (match === "M") {
                    result = date.getMonth() + 1;
                } else if (match === "MM") {
                    result = pad(date.getMonth() + 1);
                } else if (match === "MMM") {
                    result = months.namesAbbr[date.getMonth()];
                } else if (match === "MMMM") {
                    result = months.names[date.getMonth()];
                } else if (match === "yy") {
                    result = pad(date.getFullYear() % 100);
                } else if (match === "yyyy") {
                    result = pad(date.getFullYear(), 4);
                } else if (match === "h") {
                    result = date.getHours() % 12 || 12;
                } else if (match === "hh") {
                    result = pad(date.getHours() % 12 || 12);
                } else if (match === "H") {
                    result = date.getHours();
                } else if (match === "HH") {
                    result = pad(date.getHours());
                } else if (match === "m") {
                    result = date.getMinutes();
                } else if (match === "mm") {
                    result = pad(date.getMinutes());
                } else if (match === "s") {
                    result = date.getSeconds();
                } else if (match === "ss") {
                    result = pad(date.getSeconds());
                } else if (match === "f") {
                    result = math.floor(date.getMilliseconds() / 100);
                } else if (match === "ff") {
                    result = math.floor(date.getMilliseconds() / 10);
                } else if (match === "fff") {
                    result = date.getMilliseconds();
                } else if (match === "tt") {
                    result = date.getHours() < 12 ? calendar.AM[0] : calendar.PM[0];
                }
                return result !== undefined ? result : match.slice(1, match.length - 1);
            });
        }
        //number formatting
        function formatNumber(number, format, culture) {
            culture = getCulture(culture);
            var numberFormat = culture.numberFormat, groupSize = numberFormat.groupSize[0], groupSeparator = numberFormat[COMMA], decimal = numberFormat[POINT], precision = numberFormat.decimals, pattern = numberFormat.pattern[0], literals = [], symbol, isCurrency, isPercent, customPrecision, formatAndPrecision, negative = number < 0, integer, fraction, integerLength, fractionLength, replacement = EMPTY, value = EMPTY, idx, length, ch, hasGroup, hasNegativeFormat, decimalIndex, sharpIndex, zeroIndex, hasZero, hasSharp, percentIndex, currencyIndex, startZeroIndex, start = -1, end;
            //return empty string if no number
            if (number === undefined) {
                return EMPTY;
            }
            if (!isFinite(number)) {
                return number;
            }
            //if no format then return number.toString() or number.toLocaleString() if culture.name is not defined
            if (!format) {
                return culture.name.length ? number.toLocaleString() : number.toString();
            }
            formatAndPrecision = standardFormatRegExp.exec(format);
            // standard formatting
            if (formatAndPrecision) {
                format = formatAndPrecision[1].toLowerCase();
                isCurrency = format === "c";
                isPercent = format === "p";
                if (isCurrency || isPercent) {
                    //get specific number format information if format is currency or percent
                    numberFormat = isCurrency ? numberFormat.currency : numberFormat.percent;
                    groupSize = numberFormat.groupSize[0];
                    groupSeparator = numberFormat[COMMA];
                    decimal = numberFormat[POINT];
                    precision = numberFormat.decimals;
                    symbol = numberFormat.symbol;
                    pattern = numberFormat.pattern[negative ? 0 : 1];
                }
                customPrecision = formatAndPrecision[2];
                if (customPrecision) {
                    precision = +customPrecision;
                }
                //return number in exponential format
                if (format === "e") {
                    return customPrecision ? number.toExponential(precision) : number.toExponential();
                }
                // multiply if format is percent
                if (isPercent) {
                    number *= 100;
                }
                number = number.toFixed(precision);
                number = number.split(POINT);
                integer = number[0];
                fraction = number[1];
                //exclude "-" if number is negative.
                if (negative) {
                    integer = integer.substring(1);
                }
                value = integer;
                integerLength = integer.length;
                //add group separator to the number if it is longer enough
                if (integerLength >= groupSize) {
                    value = EMPTY;
                    for (idx = 0; idx < integerLength; idx++) {
                        if (idx > 0 && (integerLength - idx) % groupSize === 0) {
                            value += groupSeparator;
                        }
                        value += integer.charAt(idx);
                    }
                }
                if (fraction) {
                    value += decimal + fraction;
                }
                if (format === "n" && !negative) {
                    return value;
                }
                number = EMPTY;
                for (idx = 0, length = pattern.length; idx < length; idx++) {
                    ch = pattern.charAt(idx);
                    if (ch === "n") {
                        number += value;
                    } else if (ch === "$" || ch === "%") {
                        number += symbol;
                    } else {
                        number += ch;
                    }
                }
                return number;
            }
            //custom formatting
            //
            //separate format by sections.
            //make number positive
            if (negative) {
                number = -number;
            }
            format = format.split(";");
            if (negative && format[1]) {
                //get negative format
                format = format[1];
                hasNegativeFormat = true;
            } else if (number === 0) {
                //format for zeros
                format = format[2] || format[0];
                if (format.indexOf(SHARP) == -1 && format.indexOf(ZERO) == -1) {
                    //return format if it is string constant.
                    return format;
                }
            } else {
                format = format[0];
            }
            if (format.indexOf("'") > -1 || format.indexOf('"') > -1) {
                format = format.replace(literalRegExp, function(match) {
                    literals.push(match);
                    return PLACEHOLDER;
                });
            }
            percentIndex = format.indexOf("%");
            currencyIndex = format.indexOf("$");
            isPercent = percentIndex != -1;
            isCurrency = currencyIndex != -1;
            //multiply number if the format has percent
            if (isPercent) {
                if (format[percentIndex - 1] !== "\\") {
                    number *= 100;
                } else {
                    format = format.split("\\").join("");
                }
            }
            if (isCurrency && format[currencyIndex - 1] === "\\") {
                format = format.split("\\").join("");
                isCurrency = false;
            }
            if (isCurrency || isPercent) {
                //get specific number format information if format is currency or percent
                numberFormat = isCurrency ? numberFormat.currency : numberFormat.percent;
                groupSize = numberFormat.groupSize[0];
                groupSeparator = numberFormat[COMMA];
                decimal = numberFormat[POINT];
                precision = numberFormat.decimals;
                symbol = numberFormat.symbol;
            }
            hasGroup = format.indexOf(COMMA) > -1;
            if (hasGroup) {
                format = format.replace(commaRegExp, EMPTY);
            }
            decimalIndex = format.indexOf(POINT);
            length = format.length;
            if (decimalIndex != -1) {
                zeroIndex = format.lastIndexOf(ZERO) - decimalIndex;
                sharpIndex = format.lastIndexOf(SHARP) - decimalIndex;
                fraction = number.toString().split(POINT)[1] || EMPTY;
                hasZero = zeroIndex > -1;
                hasSharp = sharpIndex > -1;
                idx = fraction.length;
                if (!hasZero && !hasSharp) {
                    format = format.substring(0, decimalIndex) + format.substring(decimalIndex + 1);
                    length = format.length;
                    decimalIndex = -1;
                    idx = 0;
                }
                if (hasZero && zeroIndex > sharpIndex) {
                    idx = zeroIndex;
                } else if (sharpIndex > zeroIndex) {
                    if (hasSharp && idx > sharpIndex) {
                        idx = sharpIndex;
                    } else if (hasZero && idx < zeroIndex) {
                        idx = zeroIndex;
                    }
                }
                if (idx > -1) {
                    number = number.toFixed(idx);
                }
            } else {
                number = number.toFixed(0);
            }
            sharpIndex = format.indexOf(SHARP);
            startZeroIndex = zeroIndex = format.indexOf(ZERO);
            //define the index of the first digit placeholder
            if (sharpIndex == -1 && zeroIndex != -1) {
                start = zeroIndex;
            } else if (sharpIndex != -1 && zeroIndex == -1) {
                start = sharpIndex;
            } else {
                start = sharpIndex > zeroIndex ? zeroIndex : sharpIndex;
            }
            sharpIndex = format.lastIndexOf(SHARP);
            zeroIndex = format.lastIndexOf(ZERO);
            //define the index of the last digit placeholder
            if (sharpIndex == -1 && zeroIndex != -1) {
                end = zeroIndex;
            } else if (sharpIndex != -1 && zeroIndex == -1) {
                end = sharpIndex;
            } else {
                end = sharpIndex > zeroIndex ? sharpIndex : zeroIndex;
            }
            if (start == length) {
                end = start;
            }
            if (start != -1) {
                value = number.toString().split(POINT);
                integer = value[0];
                fraction = value[1] || EMPTY;
                integerLength = integer.length;
                fractionLength = fraction.length;
                //add group separator to the number if it is longer enough
                if (hasGroup) {
                    if (integerLength === groupSize && integerLength < decimalIndex - startZeroIndex) {
                        integer = groupSeparator + integer;
                    } else if (integerLength > groupSize) {
                        value = EMPTY;
                        for (idx = 0; idx < integerLength; idx++) {
                            if (idx > 0 && (integerLength - idx) % groupSize === 0) {
                                value += groupSeparator;
                            }
                            value += integer.charAt(idx);
                        }
                        integer = value;
                    }
                }
                number = format.substring(0, start);
                if (negative && !hasNegativeFormat) {
                    number += "-";
                }
                for (idx = start; idx < length; idx++) {
                    ch = format.charAt(idx);
                    if (decimalIndex == -1) {
                        if (end - idx < integerLength) {
                            number += integer;
                            break;
                        }
                    } else {
                        if (zeroIndex != -1 && zeroIndex < idx) {
                            replacement = EMPTY;
                        }
                        if (decimalIndex - idx <= integerLength && decimalIndex - idx > -1) {
                            number += integer;
                            idx = decimalIndex;
                        }
                        if (decimalIndex === idx) {
                            number += (fraction ? decimal : EMPTY) + fraction;
                            idx += end - decimalIndex + 1;
                            continue;
                        }
                    }
                    if (ch === ZERO) {
                        number += ch;
                        replacement = ch;
                    } else if (ch === SHARP) {
                        number += replacement;
                    }
                }
                if (end >= start) {
                    number += format.substring(end + 1);
                }
                //replace symbol placeholders
                if (isCurrency || isPercent) {
                    value = EMPTY;
                    for (idx = 0, length = number.length; idx < length; idx++) {
                        ch = number.charAt(idx);
                        value += ch === "$" || ch === "%" ? symbol : ch;
                    }
                    number = value;
                }
                if (literals[0]) {
                    length = literals.length;
                    for (idx = 0; idx < length; idx++) {
                        number = number.replace(PLACEHOLDER, literals[idx]);
                    }
                }
            }
            return number;
        }
        var toString = function(value, fmt, culture) {
            if (fmt) {
                if (value instanceof Date) {
                    return formatDate(value, fmt, culture);
                } else if (typeof value === NUMBER) {
                    return formatNumber(value, fmt, culture);
                }
            }
            return value !== undefined ? value : "";
        };
        if (globalize) {
            toString = proxy(globalize.format, globalize);
        }
        kendo.format = function(fmt) {
            var values = arguments;
            return fmt.replace(formatRegExp, function(match, index, placeholderFormat) {
                var value = values[parseInt(index, 10) + 1];
                return toString(value, placeholderFormat ? placeholderFormat.substring(1) : "");
            });
        };
        kendo._extractFormat = function(format) {
            if (format.slice(0, 3) === "{0:") {
                format = format.slice(3, format.length - 1);
            }
            return format;
        };
        kendo._activeElement = function() {
            try {
                return document.activeElement;
            } catch (e) {
                return document.documentElement.activeElement;
            }
        };
        kendo.toString = toString;
    })();
    (function() {
        var nonBreakingSpaceRegExp = /\u00A0/g, exponentRegExp = /[eE][\-+]?[0-9]+/, shortTimeZoneRegExp = /[+|\-]\d{1,2}/, longTimeZoneRegExp = /[+|\-]\d{1,2}:\d{2}/, dateRegExp = /^\/Date\((.*?)\)\/$/, formatsSequence = [ "G", "g", "d", "F", "D", "y", "m", "T", "t" ], numberRegExp = {
            2: /^\d{1,2}/,
            4: /^\d{4}/
        };
        function outOfRange(value, start, end) {
            return !(value >= start && value <= end);
        }
        function designatorPredicate(designator) {
            return designator.charAt(0);
        }
        function mapDesignators(designators) {
            return $.map(designators, designatorPredicate);
        }
        //if date's day is different than the typed one - adjust
        function adjustDate(date, hours) {
            if (!hours && date.getHours() === 23) {
                date.setHours(date.getHours() + 2);
            }
        }
        function parseExact(value, format, culture) {
            if (!value) {
                return null;
            }
            var lookAhead = function(match) {
                var i = 0;
                while (format[idx] === match) {
                    i++;
                    idx++;
                }
                if (i > 0) {
                    idx -= 1;
                }
                return i;
            }, getNumber = function(size) {
                var rg = numberRegExp[size] || new RegExp("^\\d{1," + size + "}"), match = value.substr(valueIdx, size).match(rg);
                if (match) {
                    match = match[0];
                    valueIdx += match.length;
                    return parseInt(match, 10);
                }
                return null;
            }, getIndexByName = function(names) {
                var i = 0, length = names.length, name, nameLength;
                for (;i < length; i++) {
                    name = names[i];
                    nameLength = name.length;
                    if (value.substr(valueIdx, nameLength) == name) {
                        valueIdx += nameLength;
                        return i + 1;
                    }
                }
                return null;
            }, checkLiteral = function() {
                var result = false;
                if (value.charAt(valueIdx) === format[idx]) {
                    valueIdx++;
                    result = true;
                }
                return result;
            }, calendar = culture.calendars.standard, year = null, month = null, day = null, hours = null, minutes = null, seconds = null, milliseconds = null, idx = 0, valueIdx = 0, literal = false, date = new Date(), twoDigitYearMax = calendar.twoDigitYearMax || 2029, defaultYear = date.getFullYear(), ch, count, length, pattern, pmHour, UTC, ISO8601, matches, amDesignators, pmDesignators, hoursOffset, minutesOffset;
            if (!format) {
                format = "d";
            }
            //if format is part of the patterns get real format
            pattern = calendar.patterns[format];
            if (pattern) {
                format = pattern;
            }
            format = format.split("");
            length = format.length;
            for (;idx < length; idx++) {
                ch = format[idx];
                if (literal) {
                    if (ch === "'") {
                        literal = false;
                    } else {
                        checkLiteral();
                    }
                } else {
                    if (ch === "d") {
                        count = lookAhead("d");
                        day = count < 3 ? getNumber(2) : getIndexByName(calendar.days[count == 3 ? "namesAbbr" : "names"]);
                        if (day === null || outOfRange(day, 1, 31)) {
                            return null;
                        }
                    } else if (ch === "M") {
                        count = lookAhead("M");
                        month = count < 3 ? getNumber(2) : getIndexByName(calendar.months[count == 3 ? "namesAbbr" : "names"]);
                        if (month === null || outOfRange(month, 1, 12)) {
                            return null;
                        }
                        month -= 1;
                    } else if (ch === "y") {
                        count = lookAhead("y");
                        year = getNumber(count);
                        if (year === null) {
                            return null;
                        }
                        if (count == 2) {
                            if (typeof twoDigitYearMax === "string") {
                                twoDigitYearMax = defaultYear + parseInt(twoDigitYearMax, 10);
                            }
                            year = defaultYear - defaultYear % 100 + year;
                            if (year > twoDigitYearMax) {
                                year -= 100;
                            }
                        }
                    } else if (ch === "h") {
                        lookAhead("h");
                        hours = getNumber(2);
                        if (hours == 12) {
                            hours = 0;
                        }
                        if (hours === null || outOfRange(hours, 0, 11)) {
                            return null;
                        }
                    } else if (ch === "H") {
                        lookAhead("H");
                        hours = getNumber(2);
                        if (hours === null || outOfRange(hours, 0, 23)) {
                            return null;
                        }
                    } else if (ch === "m") {
                        lookAhead("m");
                        minutes = getNumber(2);
                        if (minutes === null || outOfRange(minutes, 0, 59)) {
                            return null;
                        }
                    } else if (ch === "s") {
                        lookAhead("s");
                        seconds = getNumber(2);
                        if (seconds === null || outOfRange(seconds, 0, 59)) {
                            return null;
                        }
                    } else if (ch === "f") {
                        count = lookAhead("f");
                        milliseconds = getNumber(count);
                        if (milliseconds !== null && count > 3) {
                            milliseconds = parseInt(milliseconds.toString().substring(0, 3), 10);
                        }
                        if (milliseconds === null || outOfRange(milliseconds, 0, 999)) {
                            return null;
                        }
                    } else if (ch === "t") {
                        count = lookAhead("t");
                        amDesignators = calendar.AM;
                        pmDesignators = calendar.PM;
                        if (count === 1) {
                            amDesignators = mapDesignators(amDesignators);
                            pmDesignators = mapDesignators(pmDesignators);
                        }
                        pmHour = getIndexByName(pmDesignators);
                        if (!pmHour && !getIndexByName(amDesignators)) {
                            return null;
                        }
                    } else if (ch === "z") {
                        UTC = true;
                        count = lookAhead("z");
                        if (value.substr(valueIdx, 1) === "Z") {
                            if (!ISO8601) {
                                return null;
                            }
                            checkLiteral();
                            continue;
                        }
                        matches = value.substr(valueIdx, 6).match(count > 2 ? longTimeZoneRegExp : shortTimeZoneRegExp);
                        if (!matches) {
                            return null;
                        }
                        matches = matches[0];
                        valueIdx = matches.length;
                        matches = matches.split(":");
                        hoursOffset = parseInt(matches[0], 10);
                        if (outOfRange(hoursOffset, -12, 13)) {
                            return null;
                        }
                        if (count > 2) {
                            minutesOffset = parseInt(matches[1], 10);
                            if (isNaN(minutesOffset) || outOfRange(minutesOffset, 0, 59)) {
                                return null;
                            }
                        }
                    } else if (ch === "T") {
                        ISO8601 = checkLiteral();
                    } else if (ch === "'") {
                        literal = true;
                        checkLiteral();
                    } else if (!checkLiteral()) {
                        return null;
                    }
                }
            }
            if (year === null) {
                year = defaultYear;
            }
            if (pmHour && hours < 12) {
                hours += 12;
            }
            if (day === null) {
                day = 1;
            }
            if (UTC) {
                if (hoursOffset) {
                    hours += -hoursOffset;
                }
                if (minutesOffset) {
                    minutes += -minutesOffset;
                }
                value = new Date(Date.UTC(year, month, day, hours, minutes, seconds, milliseconds));
            } else {
                value = new Date(year, month, day, hours, minutes, seconds, milliseconds);
                adjustDate(value, hours);
            }
            if (year < 100) {
                value.setFullYear(year);
            }
            if (value.getDate() !== day && UTC === undefined) {
                return null;
            }
            return value;
        }
        kendo._adjustDate = adjustDate;
        kendo.parseDate = function(value, formats, culture) {
            if (value instanceof Date) {
                return value;
            }
            var idx = 0, date = null, length, patterns;
            if (value && value.indexOf("/D") === 0) {
                date = dateRegExp.exec(value);
                if (date) {
                    return new Date(parseInt(date[1], 10));
                }
            }
            culture = kendo.getCulture(culture);
            if (!formats) {
                formats = [];
                patterns = culture.calendar.patterns;
                length = formatsSequence.length;
                for (;idx < length; idx++) {
                    formats[idx] = patterns[formatsSequence[idx]];
                }
                formats[idx] = "ddd MMM dd yyyy HH:mm:ss";
                formats[++idx] = "yyyy-MM-ddTHH:mm:ss.fffffffzzz";
                formats[++idx] = "yyyy-MM-ddTHH:mm:ss.fffzzz";
                formats[++idx] = "yyyy-MM-ddTHH:mm:sszzz";
                formats[++idx] = "yyyy-MM-ddTHH:mmzzz";
                formats[++idx] = "yyyy-MM-ddTHH:mmzz";
                formats[++idx] = "yyyy-MM-ddTHH:mm:ss";
                formats[++idx] = "yyyy-MM-ddTHH:mm";
                formats[++idx] = "yyyy-MM-dd";
                idx = 0;
            }
            formats = isArray(formats) ? formats : [ formats ];
            length = formats.length;
            for (;idx < length; idx++) {
                date = parseExact(value, formats[idx], culture);
                if (date) {
                    return date;
                }
            }
            return date;
        };
        kendo.parseInt = function(value, culture) {
            var result = kendo.parseFloat(value, culture);
            if (result) {
                result = result | 0;
            }
            return result;
        };
        kendo.parseFloat = function(value, culture, format) {
            if (!value && value !== 0) {
                return null;
            }
            if (typeof value === NUMBER) {
                return value;
            }
            value = value.toString();
            culture = kendo.getCulture(culture);
            var number = culture.numberFormat, percent = number.percent, currency = number.currency, symbol = currency.symbol, percentSymbol = percent.symbol, negative = value.indexOf("-") > -1, parts, isPercent;
            //handle exponential number
            if (exponentRegExp.test(value)) {
                value = parseFloat(value);
                if (isNaN(value)) {
                    value = null;
                }
                return value;
            }
            if (value.indexOf(symbol) > -1 || format && format.toLowerCase().indexOf("c") > -1) {
                number = currency;
                parts = number.pattern[0].replace("$", symbol).split("n");
                if (value.indexOf(parts[0]) > -1 && value.indexOf(parts[1]) > -1) {
                    value = value.replace(parts[0], "").replace(parts[1], "");
                    negative = true;
                }
            } else if (value.indexOf(percentSymbol) > -1) {
                isPercent = true;
                number = percent;
                symbol = percentSymbol;
            }
            value = value.replace("-", "").replace(symbol, "").replace(nonBreakingSpaceRegExp, " ").split(number[","].replace(nonBreakingSpaceRegExp, " ")).join("").replace(number["."], ".");
            value = parseFloat(value);
            if (isNaN(value)) {
                value = null;
            } else if (negative) {
                value *= -1;
            }
            if (value && isPercent) {
                value /= 100;
            }
            return value;
        };
        if (globalize) {
            kendo.parseDate = function(value, format, culture) {
                if (value instanceof Date) {
                    return value;
                }
                return globalize.parseDate(value, format, culture);
            };
            kendo.parseFloat = function(value, culture) {
                if (typeof value === NUMBER) {
                    return value;
                }
                if (value === undefined) {
                    return null;
                }
                return globalize.parseFloat(value, culture);
            };
        }
    })();
    function wrap(element) {
        var browser = support.browser, percentage, isRtl = element.css("direction") == "rtl";
        if (!element.parent().hasClass("k-animation-container")) {
            var shadow = element.css(kendo.support.transitions.css + "box-shadow") || element.css("box-shadow"), radius = shadow ? shadow.match(boxShadowRegExp) || [ 0, 0, 0, 0, 0 ] : [ 0, 0, 0, 0, 0 ], blur = math.max(+radius[3], +(radius[4] || 0)), left = -radius[1] + blur, right = +radius[1] + blur, bottom = +radius[2] + blur, width = element[0].style.width, height = element[0].style.height, percentWidth = percentRegExp.test(width), percentHeight = percentRegExp.test(height);
            if (browser.opera) {
                // Box shadow can't be retrieved in Opera
                left = right = bottom = 5;
            }
            percentage = percentWidth || percentHeight;
            if (!percentWidth) {
                width = element.outerWidth();
            }
            if (!percentHeight) {
                height = element.outerHeight();
            }
            element.wrap($("<div/>").addClass("k-animation-container").css({
                width: width,
                height: height,
                marginLeft: left * (isRtl ? 1 : -1),
                paddingLeft: left,
                paddingRight: right,
                paddingBottom: bottom
            }));
            if (percentage) {
                element.css({
                    width: "100%",
                    height: "100%",
                    boxSizing: "border-box",
                    mozBoxSizing: "border-box",
                    webkitBoxSizing: "border-box"
                });
            }
        } else {
            var wrapper = element.parent(".k-animation-container"), wrapperStyle = wrapper[0].style;
            if (wrapper.is(":hidden")) {
                wrapper.show();
            }
            percentage = percentRegExp.test(wrapperStyle.width) || percentRegExp.test(wrapperStyle.height);
            if (!percentage) {
                wrapper.css({
                    width: element.outerWidth(),
                    height: element.outerHeight()
                });
            }
        }
        if (browser.msie && math.floor(browser.version) <= 7) {
            element.css({
                zoom: 1
            });
        }
        return element.parent();
    }
    function deepExtend(destination) {
        var i = 1, length = arguments.length;
        for (i = 1; i < length; i++) {
            deepExtendOne(destination, arguments[i]);
        }
        return destination;
    }
    function deepExtendOne(destination, source) {
        var ObservableArray = kendo.data.ObservableArray, property, propValue, propType, destProp;
        for (property in source) {
            propValue = source[property];
            propType = typeof propValue;
            if (propType === OBJECT && propValue !== null && propValue.constructor !== Array && propValue.constructor !== ObservableArray) {
                if (propValue instanceof Date) {
                    destination[property] = new Date(propValue.getTime());
                } else {
                    destProp = destination[property];
                    if (typeof destProp === OBJECT) {
                        destination[property] = destProp || {};
                    } else {
                        destination[property] = {};
                    }
                    deepExtendOne(destination[property], propValue);
                }
            } else if (propType !== UNDEFINED) {
                destination[property] = propValue;
            }
        }
        return destination;
    }
    function testRx(agent, rxs, dflt) {
        for (var rx in rxs) {
            if (rxs.hasOwnProperty(rx) && rxs[rx].test(agent)) {
                return rx;
            }
        }
        return dflt !== undefined ? dflt : agent;
    }
    function getComputedStyles(element, properties) {
        var styles = {}, computedStyle;
        if (document.defaultView && document.defaultView.getComputedStyle) {
            computedStyle = document.defaultView.getComputedStyle(element, "");
            if (properties) {
                $.each(properties, function(idx, value) {
                    styles[value] = computedStyle.getPropertyValue(value);
                });
            }
        } else {
            computedStyle = element.currentStyle;
            if (properties) {
                $.each(properties, function(idx, value) {
                    styles[value] = computedStyle[value.replace(/\-(\w)/g, function(strMatch, g1) {
                        return g1.toUpperCase();
                    })];
                });
            }
        }
        if (!kendo.size(styles)) {
            styles = computedStyle;
        }
        return styles;
    }
    (function() {
        support.scrollbar = function() {
            var div = document.createElement("div"), result;
            div.style.cssText = "overflow:scroll;overflow-x:hidden;zoom:1;clear:both";
            div.innerHTML = "&nbsp;";
            document.body.appendChild(div);
            result = div.offsetWidth - div.scrollWidth;
            document.body.removeChild(div);
            return result;
        };
        support.isRtl = function(element) {
            return $(element).closest(".k-rtl").length > 0;
        };
        var table = document.createElement("table");
        // Internet Explorer does not support setting the innerHTML of TBODY and TABLE elements
        try {
            table.innerHTML = "<tr><td></td></tr>";
            support.tbodyInnerHtml = true;
        } catch (e) {
            support.tbodyInnerHtml = false;
        }
        support.touch = "ontouchstart" in window;
        support.pointers = navigator.msPointerEnabled;
        var transitions = support.transitions = false, transforms = support.transforms = false, elementProto = "HTMLElement" in window ? HTMLElement.prototype : [];
        support.hasHW3D = "WebKitCSSMatrix" in window && "m11" in new window.WebKitCSSMatrix() || "MozPerspective" in document.documentElement.style || "msPerspective" in document.documentElement.style;
        each([ "Moz", "webkit", "O", "ms" ], function() {
            var prefix = this.toString(), hasTransitions = typeof table.style[prefix + "Transition"] === STRING;
            if (hasTransitions || typeof table.style[prefix + "Transform"] === STRING) {
                var lowPrefix = prefix.toLowerCase();
                transforms = {
                    css: lowPrefix != "ms" ? "-" + lowPrefix + "-" : "",
                    prefix: prefix,
                    event: lowPrefix === "o" || lowPrefix === "webkit" ? lowPrefix : ""
                };
                if (hasTransitions) {
                    transitions = transforms;
                    transitions.event = transitions.event ? transitions.event + "TransitionEnd" : "transitionend";
                }
                return false;
            }
        });
        support.transforms = transforms;
        support.transitions = transitions;
        support.devicePixelRatio = window.devicePixelRatio === undefined ? 1 : window.devicePixelRatio;
        support.screenWidth = window.outerWidth || window.screen ? window.screen.availWidth : window.innerWidth;
        support.screenHeight = window.outerHeight || window.screen ? window.screen.availHeight : window.innerHeight;
        support.detectOS = function(ua) {
            var os = false, minorVersion, match = [], notAndroidPhone = !/mobile safari/i.test(ua), agentRxs = {
                fire: /(Silk)\/(\d+)\.(\d+(\.\d+)?)/,
                android: /(Android|Android.*(?:Opera|Firefox).*?\/)\s*(\d+)\.(\d+(\.\d+)?)/,
                iphone: /(iPhone|iPod).*OS\s+(\d+)[\._]([\d\._]+)/,
                ipad: /(iPad).*OS\s+(\d+)[\._]([\d_]+)/,
                meego: /(MeeGo).+NokiaBrowser\/(\d+)\.([\d\._]+)/,
                webos: /(webOS)\/(\d+)\.(\d+(\.\d+)?)/,
                blackberry: /(BlackBerry|BB10).*?Version\/(\d+)\.(\d+(\.\d+)?)/,
                playbook: /(PlayBook).*?Tablet\s*OS\s*(\d+)\.(\d+(\.\d+)?)/,
                wp: /(Windows Phone(?: OS)?)\s(\d+)\.(\d+(\.\d+)?)/,
                windows: /(MSIE)\s+(\d+)\.(\d+(\.\d+)?)/,
                ffos: /(Mobile).*rv:(\d+)\.(\d+(\.\d+)?).*Firefox/
            }, osRxs = {
                ios: /^i(phone|pad|pod)$/i,
                android: /^android|fire$/i,
                blackberry: /^blackberry|playbook/i,
                windows: /windows/,
                wp: /wp/,
                meego: /meego|ffos/
            }, formFactorRxs = {
                tablet: /playbook|ipad|fire/i
            }, browserRxs = {
                omini: /Opera\sMini/i,
                omobile: /Opera\sMobi/i,
                firefox: /Firefox|Fennec/i,
                mobilesafari: /version\/.*safari/i,
                chrome: /chrome/i,
                webkit: /webkit/i,
                ie: /MSIE|Windows\sPhone/i
            };
            for (var agent in agentRxs) {
                if (agentRxs.hasOwnProperty(agent)) {
                    match = ua.match(agentRxs[agent]);
                    if (match) {
                        if (agent == "windows" && "plugins" in navigator) {
                            return false;
                        }
                        // Break if not Metro/Mobile Windows
                        os = {};
                        os.device = agent;
                        os.tablet = testRx(agent, formFactorRxs, false);
                        os.browser = testRx(ua, browserRxs, "default");
                        os.name = testRx(agent, osRxs);
                        os[os.name] = true;
                        os.majorVersion = match[2];
                        os.minorVersion = match[3].replace("_", ".");
                        minorVersion = os.minorVersion.replace(".", "").substr(0, 2);
                        os.flatVersion = os.majorVersion + minorVersion + new Array(3 - (minorVersion.length < 3 ? minorVersion.length : 2)).join("0");
                        os.appMode = window.navigator.standalone || /file|local/.test(window.location.protocol) || typeof window.PhoneGap !== UNDEFINED || typeof window.cordova !== UNDEFINED;
                        // Use file protocol to detect appModes.
                        if (os.android && (support.devicePixelRatio < 1.5 && os.flatVersion < 400 || notAndroidPhone) && (support.screenWidth > 800 || support.screenHeight > 800)) {
                            os.tablet = agent;
                        }
                        break;
                    }
                }
            }
            return os;
        };
        var mobileOS = support.mobileOS = support.detectOS(navigator.userAgent);
        support.kineticScrollNeeded = mobileOS && (support.touch || support.pointers);
        support.hasNativeScrolling = false;
        if (mobileOS.ios && mobileOS.majorVersion > 4 || mobileOS.android && mobileOS.majorVersion > 2 || mobileOS.wp) {
            support.hasNativeScrolling = mobileOS;
        }
        support.mouseAndTouchPresent = support.touch && !(support.mobileOS.ios || support.mobileOS.android);
        function detectBrowser(ua) {
            var browser = false, match = [], browserRxs = {
                webkit: /(chrome)[ \/]([\w.]+)/i,
                safari: /(webkit)[ \/]([\w.]+)/i,
                opera: /(opera)(?:.*version|)[ \/]([\w.]+)/i,
                msie: /(msie) ([\w.]+)/i,
                mozilla: /(mozilla)(?:.*? rv:([\w.]+)|)/i
            };
            for (var agent in browserRxs) {
                if (browserRxs.hasOwnProperty(agent)) {
                    match = ua.match(browserRxs[agent]);
                    if (match) {
                        browser = {};
                        browser[agent] = true;
                        browser[match[1].toLowerCase()] = true;
                        browser.version = parseInt(document.documentMode || match[2], 10);
                        break;
                    }
                }
            }
            return browser;
        }
        support.browser = detectBrowser(navigator.userAgent);
        (function(browser) {
            // add browser-specific CSS class
            var cssClass, majorVersion = parseInt(browser.version, 10);
            if (browser.msie) {
                cssClass = "ie";
            } else if (browser.mozilla) {
                cssClass = "ff";
            } else if (browser.safari) {
                cssClass = "safari";
            } else if (browser.webkit) {
                cssClass = "webkit";
            } else if (browser.opera) {
                cssClass = "opera";
            }
            if (cssClass) {
                $(document.documentElement).addClass("k-" + cssClass + " k-" + cssClass + majorVersion);
            }
        })(support.browser);
        support.zoomLevel = function() {
            return support.touch ? document.documentElement.clientWidth / window.innerWidth : support.pointers ? window.outerWidth / window.innerWidth : 1;
        };
        support.eventCapture = document.documentElement.addEventListener;
        support.placeholder = "placeholder" in document.createElement("input");
        support.stableSort = function() {
            var sorted = [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ].sort(function() {
                return 0;
            });
            return sorted[0] === 0 && sorted[1] === 1 && sorted[2] === 2 && sorted[3] === 3 && sorted[4] === 4 && sorted[5] === 5 && sorted[6] === 6 && sorted[7] === 7 && sorted[8] === 8 && sorted[9] === 9 && sorted[10] === 10 && sorted[11] === 11 && sorted[12] === 12;
        }();
        support.matchesSelector = elementProto.webkitMatchesSelector || elementProto.mozMatchesSelector || elementProto.msMatchesSelector || elementProto.oMatchesSelector || elementProto.matchesSelector || function(selector) {
            var nodeList = document.querySelectorAll ? (this.parentNode || document).querySelectorAll(selector) || [] : $(selector), i = nodeList.length;
            while (i--) {
                if (nodeList[i] == this) {
                    return true;
                }
            }
            return false;
        };
    })();
    function size(obj) {
        var result = 0, key;
        for (key in obj) {
            if (obj.hasOwnProperty(key) && key != "toJSON") {
                // Ignore fake IE7 toJSON.
                result++;
            }
        }
        return result;
    }
    function isNodeEmpty(element) {
        return $.trim($(element).contents().filter(function() {
            return this.nodeType != 8;
        }).html()) === "";
    }
    function getOffset(element, type, positioned) {
        if (!type) {
            type = "offset";
        }
        var result = element[type](), mobileOS = support.mobileOS;
        if (support.touch && mobileOS.ios && mobileOS.flatVersion < 410) {
            // Extra processing only in broken iOS'
            var offset = type == "offset" ? result : element.offset(), position = result.left == offset.left && result.top == offset.top;
            if (position) {
                return {
                    top: result.top - window.scrollY,
                    left: result.left - window.scrollX
                };
            }
        }
        if (kendo.support.pointers && !positioned) {
            // IE10 touch zoom is living in a separate viewport.
            result.top -= window.pageYOffset - document.documentElement.scrollTop;
            result.left -= window.pageXOffset - document.documentElement.scrollLeft;
        }
        return result;
    }
    var directions = {
        left: {
            reverse: "right"
        },
        right: {
            reverse: "left"
        },
        down: {
            reverse: "up"
        },
        up: {
            reverse: "down"
        },
        top: {
            reverse: "bottom"
        },
        bottom: {
            reverse: "top"
        },
        "in": {
            reverse: "out"
        },
        out: {
            reverse: "in"
        }
    };
    function parseEffects(input) {
        var effects = {};
        each(typeof input === "string" ? input.split(" ") : input, function(idx) {
            effects[idx] = this;
        });
        return effects;
    }
    function fx(element) {
        return new kendo.fx.Element(element);
    }
    $.extend(fx, {
        Element: function(element) {
            this.element = $(element);
        },
        promise: function(element, options) {
            if (!element.is(":visible")) {
                element.css({
                    display: element.data("olddisplay") || "block"
                }).css("display");
            }
            if (options.hide) {
                element.data("olddisplay", element.css("display")).hide();
            }
            if (options.init) {
                options.init();
            }
            if (options.completeCallback) {
                options.completeCallback(element);
            }
            element.dequeue();
        },
        transitionPromise: function(element, destination, options) {
            var container = kendo.wrap(element);
            container.append(destination);
            element.hide();
            destination.show();
            if (options.completeCallback) {
                options.completeCallback(element);
            }
            return element;
        }
    });
    function prepareAnimationOptions(options, duration, reverse, complete) {
        if (typeof options === STRING) {
            // options is the list of effect names separated by space e.g. animate(element, "fadeIn slideDown")
            // only callback is provided e.g. animate(element, options, function() {});
            if (isFunction(duration)) {
                complete = duration;
                duration = 400;
                reverse = false;
            }
            if (isFunction(reverse)) {
                complete = reverse;
                reverse = false;
            }
            if (typeof duration === BOOLEAN) {
                reverse = duration;
                duration = 400;
            }
            options = {
                effects: options,
                duration: duration,
                reverse: reverse,
                complete: complete
            };
        }
        return extend({
            //default options
            effects: {},
            duration: 400,
            //jQuery default duration
            reverse: false,
            init: noop,
            teardown: noop,
            hide: false
        }, options, {
            completeCallback: options.complete,
            complete: noop
        });
    }
    function animate(element, options, duration, reverse, complete) {
        var idx = 0, length = element.length, instance;
        for (;idx < length; idx++) {
            instance = $(element[idx]);
            instance.queue(function() {
                fx.promise(instance, prepareAnimationOptions(options, duration, reverse, complete));
            });
        }
        return element;
    }
    function animateTo(element, destination, options, duration, reverse, complete) {
        return fx.transitionPromise(element, destination, prepareAnimationOptions(options, duration, reverse, complete));
    }
    function toggleClass(element, classes, options, add) {
        if (classes) {
            classes = classes.split(" ");
            each(classes, function(idx, value) {
                element.toggleClass(value, add);
            });
        }
        return element;
    }
    if (!("kendoAnimate" in $.fn)) {
        extend($.fn, {
            kendoStop: function(clearQueue, gotoEnd) {
                return this.stop(clearQueue, gotoEnd);
            },
            kendoAnimate: function(options, duration, reverse, complete) {
                return animate(this, options, duration, reverse, complete);
            },
            kendoAnimateTo: function(destination, options, duration, reverse, complete) {
                return animateTo(this, destination, options, duration, reverse, complete);
            },
            kendoAddClass: function(classes, options) {
                return kendo.toggleClass(this, classes, options, true);
            },
            kendoRemoveClass: function(classes, options) {
                return kendo.toggleClass(this, classes, options, false);
            },
            kendoToggleClass: function(classes, options, toggle) {
                return kendo.toggleClass(this, classes, options, toggle);
            }
        });
    }
    var ampRegExp = /&/g, ltRegExp = /</g, gtRegExp = />/g;
    function htmlEncode(value) {
        return ("" + value).replace(ampRegExp, "&amp;").replace(ltRegExp, "&lt;").replace(gtRegExp, "&gt;");
    }
    var eventTarget = function(e) {
        return e.target;
    };
    if (support.touch) {
        var mobileChrome = support.mobileOS.browser == "chrome" && !support.mobileOS.ios;
        eventTarget = function(e) {
            var touches = "originalEvent" in e ? e.originalEvent.changedTouches : "changedTouches" in e ? e.changedTouches : null, property = mobileChrome ? "screen" : "client";
            return touches ? document.elementFromPoint(touches[0][property + "X"], touches[0][property + "Y"]) : e.target;
        };
        each([ "swipe", "swipeLeft", "swipeRight", "swipeUp", "swipeDown", "doubleTap", "tap" ], function(m, value) {
            $.fn[value] = function(callback) {
                return this.bind(value, callback);
            };
        });
    }
    if (support.touch) {
        if (!support.mobileOS) {
            support.mousedown = "mousedown touchstart";
            support.mouseup = "mouseup touchend";
            support.mousemove = "mousemove touchmove";
            support.mousecancel = "mouseleave touchcancel";
            support.click = "click";
            support.resize = "resize";
        } else {
            support.mousedown = "touchstart";
            support.mouseup = "touchend";
            support.mousemove = "touchmove";
            support.mousecancel = "touchcancel";
            support.click = "touchend";
            support.resize = "orientationchange";
        }
    } else if (support.pointers) {
        support.mousemove = "MSPointerMove";
        support.mousedown = "MSPointerDown";
        support.mouseup = "MSPointerUp";
        support.mousecancel = "MSPointerCancel";
        support.click = "MSPointerUp";
        support.resize = "orientationchange resize";
    } else {
        support.mousemove = "mousemove";
        support.mousedown = "mousedown";
        support.mouseup = "mouseup";
        support.mousecancel = "mouseleave";
        support.click = "click";
        support.resize = "resize";
    }
    var wrapExpression = function(members, paramName) {
        var result = paramName || "d", index, idx, length, member, count = 1;
        for (idx = 0, length = members.length; idx < length; idx++) {
            member = members[idx];
            if (member !== "") {
                index = member.indexOf("[");
                if (index !== 0) {
                    if (index == -1) {
                        member = "." + member;
                    } else {
                        count++;
                        member = "." + member.substring(0, index) + " || {})" + member.substring(index);
                    }
                }
                count++;
                result += member + (idx < length - 1 ? " || {})" : ")");
            }
        }
        return new Array(count).join("(") + result;
    }, localUrlRe = /^([a-z]+:)?\/\//i;
    extend(kendo, {
        ui: kendo.ui || {},
        fx: kendo.fx || fx,
        mobile: kendo.mobile || {},
        data: kendo.data || {},
        dataviz: kendo.dataviz || {
            ui: {
                roles: {}
            }
        },
        keys: {
            INSERT: 45,
            DELETE: 46,
            BACKSPACE: 8,
            TAB: 9,
            ENTER: 13,
            ESC: 27,
            LEFT: 37,
            UP: 38,
            RIGHT: 39,
            DOWN: 40,
            END: 35,
            HOME: 36,
            SPACEBAR: 32,
            PAGEUP: 33,
            PAGEDOWN: 34,
            F2: 113,
            F10: 121,
            F12: 123
        },
        support: kendo.support || support,
        animate: kendo.animate || animate,
        ns: "",
        attr: function(value) {
            return "data-" + kendo.ns + value;
        },
        wrap: wrap,
        deepExtend: deepExtend,
        getComputedStyles: getComputedStyles,
        size: size,
        isNodeEmpty: isNodeEmpty,
        getOffset: kendo.getOffset || getOffset,
        parseEffects: kendo.parseEffects || parseEffects,
        toggleClass: kendo.toggleClass || toggleClass,
        directions: kendo.directions || directions,
        Observable: Observable,
        Class: Class,
        Template: Template,
        template: proxy(Template.compile, Template),
        render: proxy(Template.render, Template),
        stringify: proxy(JSON.stringify, JSON),
        eventTarget: eventTarget,
        htmlEncode: htmlEncode,
        isLocalUrl: function(url) {
            return url && !localUrlRe.test(url);
        },
        expr: function(expression, safe, paramName) {
            expression = expression || "";
            if (typeof safe == STRING) {
                paramName = safe;
                safe = false;
            }
            paramName = paramName || "d";
            if (expression && expression.charAt(0) !== "[") {
                expression = "." + expression;
            }
            if (safe) {
                expression = wrapExpression(expression.split("."), paramName);
            } else {
                expression = paramName + expression;
            }
            return expression;
        },
        getter: function(expression, safe) {
            return getterCache[expression] = getterCache[expression] || new Function("d", "return " + kendo.expr(expression, safe));
        },
        setter: function(expression) {
            return setterCache[expression] = setterCache[expression] || new Function("d,value", kendo.expr(expression) + "=value");
        },
        accessor: function(expression) {
            return {
                get: kendo.getter(expression),
                set: kendo.setter(expression)
            };
        },
        guid: function() {
            var id = "", i, random;
            for (i = 0; i < 32; i++) {
                random = math.random() * 16 | 0;
                if (i == 8 || i == 12 || i == 16 || i == 20) {
                    id += "-";
                }
                id += (i == 12 ? 4 : i == 16 ? random & 3 | 8 : random).toString(16);
            }
            return id;
        },
        roleSelector: function(role) {
            return role.replace(/(\S+)/g, "[" + kendo.attr("role") + "=$1],").slice(0, -1);
        },
        logToConsole: function(message) {
            var console = window.console;
            if (typeof console != "undefined" && console.log) {
                console.log(message);
            }
        }
    });
    var Widget = Observable.extend({
        init: function(element, options) {
            var that = this;
            that.element = kendo.jQuery(element).handler(that);
            Observable.fn.init.call(that);
            options = that.options = extend(true, {}, that.options, options);
            if (!that.element.attr(kendo.attr("role"))) {
                that.element.attr(kendo.attr("role"), (options.name || "").toLowerCase());
            }
            that.element.data("kendo" + options.prefix + options.name, that);
            that.bind(that.events, options);
        },
        events: [],
        options: {
            prefix: ""
        },
        _tabindex: function(target) {
            target = target || this.wrapper;
            var element = this.element, TABINDEX = "tabindex", tabindex = target.attr(TABINDEX) || element.attr(TABINDEX);
            element.removeAttr(TABINDEX);
            target.attr(TABINDEX, !isNaN(tabindex) ? tabindex : 0);
        },
        setOptions: function(options) {
            var that = this, idx = 0, length = that.events.length, e;
            for (;idx < length; idx++) {
                e = that.events[idx];
                if (that.options[e] && options[e]) {
                    that.unbind(e, that.options[e]);
                }
            }
            $.extend(that.options, options);
            that.bind(that.events, options);
        },
        destroy: function() {
            var that = this;
            that.element.removeData("kendo" + that.options.prefix + that.options.name);
            that.unbind();
        }
    });
    kendo.notify = noop;
    var templateRegExp = /template$/i, jsonRegExp = /^\s*(?:\{(?:.|\r\n|\n)*\}|\[(?:.|\r\n|\n)*\])\s*$/, jsonFormatRegExp = /^\{(\d+)(:[^\}]+)?\}/, dashRegExp = /([A-Z])/g;
    function parseOption(element, option) {
        var value;
        if (option.indexOf("data") === 0) {
            option = option.substring(4);
            option = option.charAt(0).toLowerCase() + option.substring(1);
        }
        option = option.replace(dashRegExp, "-$1");
        value = element.getAttribute("data-" + kendo.ns + option);
        if (value === null) {
            value = undefined;
        } else if (value === "null") {
            value = null;
        } else if (value === "true") {
            value = true;
        } else if (value === "false") {
            value = false;
        } else if (!isNaN(parseFloat(value))) {
            value = parseFloat(value);
        } else if (jsonRegExp.test(value) && !jsonFormatRegExp.test(value)) {
            value = evil("(" + value + ")");
        }
        return value;
    }
    function parseOptions(element, options) {
        var result = {}, option, value;
        for (option in options) {
            value = parseOption(element, option);
            if (value !== undefined) {
                if (templateRegExp.test(option)) {
                    value = kendo.template($("#" + value).html());
                }
                result[option] = value;
            }
        }
        return result;
    }
    kendo.initWidget = function(element, options, roles) {
        var result, option, widget, idx, length, role, value, dataSource;
        // Preserve backwards compatibility with (element, options, namespace) signature, where namespace was kendo.ui
        if (!roles) {
            roles = kendo.ui.roles;
        } else if (roles.roles) {
            roles = roles.roles;
        }
        element = element.nodeType ? element : element[0];
        role = element.getAttribute("data-" + kendo.ns + "role");
        if (!role) {
            return;
        }
        if (role.indexOf(".") === -1) {
            widget = roles[role];
        } else {
            // full namespace path - like kendo.ui.Widget
            widget = kendo.getter(role)(window);
        }
        if (!widget) {
            return;
        }
        dataSource = parseOption(element, "dataSource");
        options = $.extend({}, parseOptions(element, widget.fn.options), options);
        if (dataSource) {
            if (typeof dataSource === STRING) {
                options.dataSource = kendo.getter(dataSource)(window);
            } else {
                options.dataSource = dataSource;
            }
        }
        for (idx = 0, length = widget.fn.events.length; idx < length; idx++) {
            option = widget.fn.events[idx];
            value = parseOption(element, option);
            if (value !== undefined) {
                options[option] = kendo.getter(value)(window);
            }
        }
        result = $(element).data("kendo" + widget.fn.options.prefix + widget.fn.options.name);
        if (!result) {
            result = new widget(element, options);
        } else {
            result.setOptions(options);
        }
        return result;
    };
    kendo.rolesFromNamespaces = function(namespaces) {
        var roles = [], idx, length;
        if (!namespaces[0]) {
            namespaces = [ kendo.ui, kendo.dataviz.ui ];
        }
        for (idx = 0, length = namespaces.length; idx < length; idx++) {
            roles[idx] = namespaces[idx].roles;
        }
        return extend.apply(null, [ {} ].concat(roles.reverse()));
    };
    kendo.init = function(element) {
        var roles = kendo.rolesFromNamespaces(slice.call(arguments, 1));
        $(element).find("[data-" + kendo.ns + "role]").andSelf().each(function() {
            kendo.initWidget(this, {}, roles);
        });
    };
    kendo.destroy = function(element) {
        $(element).find("[data-" + kendo.ns + "role]").andSelf().each(function() {
            var element = $(this), widget = kendo.widgetInstance(element, kendo.ui) || kendo.widgetInstance(element, kendo.mobile.ui) || kendo.widgetInstance(element, kendo.dataviz.ui);
            if (widget) {
                widget.destroy();
            }
        });
    };
    kendo.parseOptions = parseOptions;
    extend(kendo.ui, {
        Widget: Widget,
        roles: {},
        progress: function(container, toggle) {
            var mask = container.find(".k-loading-mask");
            if (toggle) {
                if (!mask.length) {
                    mask = $("<div class='k-loading-mask'><span class='k-loading-text'>Loading...</span><div class='k-loading-image'/><div class='k-loading-color'/></div>").width("100%").height("100%").prependTo(container).css({
                        top: container.scrollTop(),
                        left: container.scrollLeft()
                    });
                }
            } else if (mask) {
                mask.remove();
            }
        },
        plugin: function(widget, register, prefix) {
            var name = widget.fn.options.name, getter;
            register = register || kendo.ui;
            prefix = prefix || "";
            register[name] = widget;
            register.roles[name.toLowerCase()] = widget;
            getter = "getKendo" + prefix + name;
            name = "kendo" + prefix + name;
            $.fn[name] = function(options) {
                var value = this, args;
                if (typeof options === STRING) {
                    args = slice.call(arguments, 1);
                    this.each(function() {
                        var widget = $.data(this, name), method, result;
                        if (!widget) {
                            throw new Error(kendo.format("Cannot call method '{0}' of {1} before it is initialized", options, name));
                        }
                        method = widget[options];
                        if (typeof method !== FUNCTION) {
                            throw new Error(kendo.format("Cannot find method '{0}' of {1}", options, name));
                        }
                        result = method.apply(widget, args);
                        if (result !== undefined) {
                            value = result;
                            return false;
                        }
                    });
                } else {
                    this.each(function() {
                        new widget(this, options);
                    });
                }
                return value;
            };
            $.fn[getter] = function() {
                return this.data(name);
            };
        }
    });
    var ContainerNullObject = {
        bind: $.noop
    };
    var MobileWidget = Widget.extend({
        init: function(element, options) {
            Widget.fn.init.call(this, element, options);
            this.element.autoApplyNS();
            this.wrapper = this.element;
        },
        destroy: function() {
            Widget.fn.destroy.call(this);
            this.element.kendoDestroy();
        },
        options: {
            prefix: "Mobile"
        },
        events: [],
        view: function() {
            var viewElement = this.element.closest(kendo.roleSelector("view splitview modalview"));
            return kendo.widgetInstance(viewElement, kendo.mobile.ui);
        },
        container: function() {
            var element = this.element.closest(kendo.roleSelector("view layout modalview"));
            return kendo.widgetInstance(element, kendo.mobile.ui) || ContainerNullObject;
        }
    });
    extend(kendo.mobile, {
        init: function(element) {
            kendo.init(element, kendo.mobile.ui, kendo.ui, kendo.dataviz.ui);
        },
        ui: {
            Widget: MobileWidget,
            roles: {},
            plugin: function(widget) {
                kendo.ui.plugin(widget, kendo.mobile.ui, "Mobile");
            }
        }
    });
    kendo.touchScroller = function(elements, options) {
        // return the first touch scroller
        return $(elements).map(function(idx, element) {
            element = $(element);
            if (support.kineticScrollNeeded && kendo.mobile.ui.Scroller && !element.data("kendoMobileScroller")) {
                element.kendoMobileScroller(options);
                return element.data("kendoMobileScroller");
            } else {
                return false;
            }
        })[0];
    };
    kendo.preventDefault = function(e) {
        e.preventDefault();
    };
    kendo.widgetInstance = function(element, suite) {
        var widget = suite.roles[element.data(kendo.ns + "role")];
        if (widget) {
            return element.data("kendo" + widget.fn.options.prefix + widget.fn.options.name);
        }
    };
    kendo.onResize = function(callback) {
        var handler = callback;
        if (support.mobileOS.android) {
            handler = function() {
                setTimeout(callback, 200);
            };
        }
        $(window).on(support.resize, handler);
    };
    kendo.attrValue = function(element, key) {
        return element.data(kendo.ns + key);
    };
    kendo.days = {
        Sunday: 0,
        Monday: 1,
        Tuesday: 2,
        Wednesday: 3,
        Thursday: 4,
        Friday: 5,
        Saturday: 6
    };
    function focusable(element, isTabIndexNotNaN) {
        var nodeName = element.nodeName.toLowerCase();
        return (/input|select|textarea|button|object/.test(nodeName) ? !element.disabled : "a" === nodeName ? element.href || isTabIndexNotNaN : isTabIndexNotNaN) && visible(element);
    }
    function visible(element) {
        return !$(element).parents().andSelf().filter(function() {
            return $.css(this, "visibility") === "hidden" || $.expr.filters.hidden(this);
        }).length;
    }
    $.extend($.expr[":"], {
        focusable: function(element) {
            var idx = $.attr(element, "tabindex");
            return focusable(element, !isNaN(idx) && idx > -1);
        }
    });
    var MOUSE_EVENTS = [ "mousedown", "mousemove", "mouseenter", "mouseleave", "mouseover", "mouseout", "mouseup", "click" ];
    var EXCLUDE_BUST_CLICK_SELECTOR = "label, input, [data-rel=external]";
    var MouseEventNormalizer = {
        setupMouseMute: function() {
            var idx = 0, length = MOUSE_EVENTS.length, element = document.documentElement;
            if (MouseEventNormalizer.mouseTrap || !support.eventCapture) {
                return;
            }
            MouseEventNormalizer.mouseTrap = true;
            MouseEventNormalizer.bustClick = false;
            MouseEventNormalizer.captureMouse = false;
            var handler = function(e) {
                if (MouseEventNormalizer.captureMouse) {
                    if (e.type === "click") {
                        if (MouseEventNormalizer.bustClick && !$(e.target).is(EXCLUDE_BUST_CLICK_SELECTOR)) {
                            e.preventDefault();
                            e.stopPropagation();
                        }
                    } else {
                        e.stopPropagation();
                    }
                }
            };
            for (;idx < length; idx++) {
                element.addEventListener(MOUSE_EVENTS[idx], handler, true);
            }
        },
        muteMouse: function(e) {
            MouseEventNormalizer.captureMouse = true;
            if (e.data.bustClick) {
                MouseEventNormalizer.bustClick = true;
            }
            clearTimeout(MouseEventNormalizer.mouseTrapTimeoutID);
        },
        unMuteMouse: function() {
            clearTimeout(MouseEventNormalizer.mouseTrapTimeoutID);
            MouseEventNormalizer.mouseTrapTimeoutID = setTimeout(function() {
                MouseEventNormalizer.captureMouse = false;
                MouseEventNormalizer.bustClick = false;
            }, 400);
        }
    };
    var eventMap = {
        down: "touchstart mousedown",
        move: "mousemove touchmove",
        up: "mouseup touchend touchcancel",
        cancel: "mouseleave touchcancel"
    };
    if (support.touch && (support.mobileOS.ios || support.mobileOS.android)) {
        eventMap = {
            down: "touchstart",
            move: "touchmove",
            up: "touchend touchcancel",
            cancel: "touchcancel"
        };
    }
    if (support.pointers) {
        eventMap = {
            down: "MSPointerDown",
            move: "MSPointerMove",
            up: "MSPointerUp",
            cancel: "MSPointerCancel MSPointerLeave"
        };
        // Create MSPointerEnter/MSPointerLeave events using mouseover/out and event-time checks
        jQuery.each({
            MSPointerEnter: "MSPointerOver",
            MSPointerLeave: "MSPointerOut"
        }, function(orig, fix) {
            jQuery.event.special[orig] = {
                delegateType: fix,
                bindType: fix,
                handle: function(event) {
                    var ret, target = this, related = event.relatedTarget, handleObj = event.handleObj;
                    // For mousenter/leave call the handler if related is outside the target.
                    // NB: No relatedTarget if the mouse left/entered the browser window
                    if (!related || related !== target && !jQuery.contains(target, related)) {
                        event.type = handleObj.origType;
                        ret = handleObj.handler.apply(this, arguments);
                        event.type = fix;
                    }
                    return ret;
                }
            };
        });
    }
    var getEventMap = function(e) {
        return eventMap[e] || e;
    }, eventRegEx = /([^ ]+)/g;
    kendo.applyEventMap = function(events, ns) {
        events = events.replace(eventRegEx, getEventMap);
        if (ns) {
            events = events.replace(eventRegEx, "$1." + ns);
        }
        return events;
    };
    var on = $.fn.on;
    function kendoJQuery(selector, context) {
        return new kendoJQuery.fn.init(selector, context);
    }
    extend(true, kendoJQuery, $);
    kendoJQuery.fn = kendoJQuery.prototype = new $();
    kendoJQuery.fn.constructor = kendoJQuery;
    kendoJQuery.fn.init = function(selector, context) {
        if (context && context instanceof $ && !(context instanceof kendoJQuery)) {
            context = kendoJQuery(context);
        }
        return $.fn.init.call(this, selector, context, rootjQuery);
    };
    kendoJQuery.fn.init.prototype = kendoJQuery.fn;
    var rootjQuery = kendoJQuery(document);
    extend(kendoJQuery.fn, {
        handler: function(handler) {
            this.data("handler", handler);
            return this;
        },
        autoApplyNS: function(ns) {
            this.data("kendoNS", ns || kendo.guid());
            return this;
        },
        on: function() {
            var that = this, ns = that.data("kendoNS");
            // support for event map signature
            if (arguments.length === 1) {
                return on.call(that, arguments[0]);
            }
            var context = that, args = slice.call(arguments);
            if (typeof args[args.length - 1] === UNDEFINED) {
                args.pop();
            }
            var callback = args[args.length - 1], events = kendo.applyEventMap(args[0], ns);
            // setup mouse trap
            if (support.mouseAndTouchPresent && events.search(/mouse|click/) > -1 && this[0] !== document.documentElement) {
                MouseEventNormalizer.setupMouseMute();
                var selector = args.length === 2 ? null : args[1], bustClick = events.indexOf("click") > -1 && events.indexOf("touchend") > -1;
                on.call(this, {
                    touchstart: MouseEventNormalizer.muteMouse,
                    touchend: MouseEventNormalizer.unMuteMouse
                }, selector, {
                    bustClick: bustClick
                });
            }
            if (typeof callback === STRING) {
                context = that.data("handler");
                callback = context[callback];
                args[args.length - 1] = function(e) {
                    callback.call(context, e);
                };
            }
            args[0] = events;
            on.apply(that, args);
            return that;
        },
        kendoDestroy: function(ns) {
            ns = ns || this.data("kendoNS");
            if (ns) {
                this.off("." + ns);
            }
            return this;
        }
    });
    kendo.jQuery = kendoJQuery;
    kendo.eventMap = eventMap;
})(jQuery, eval);

/*global kendo_module:true */
if (typeof kendo_module === "undefined") {
    kendo_module = function() {};
}

(function($, undefined) {
    var kendo = window.kendo, location = window.location, history = window.history, _checkUrlInterval = 50, hashStrip = /^#*/, documentMode = window.document.documentMode, oldIE = kendo.support.browser.msie && (!documentMode || documentMode <= 8), hashChangeSupported = "onhashchange" in window && !oldIE, document = window.document;
    var History = kendo.Observable.extend({
        start: function(options) {
            options = options || {};
            var that = this;
            that._pushStateRequested = !!options.pushState;
            that._pushState = that._pushStateRequested && that._pushStateSupported();
            that.root = options.root || "/";
            that._interval = 0;
            this.bind([ "change", "ready" ], options);
            if (that._normalizeUrl()) {
                return true;
            }
            that.current = that._currentLocation();
            that._listenToLocationChange();
            that.trigger("ready", {
                url: that.current
            });
        },
        stop: function() {
            $(window).unbind(".kendo");
            this.unbind("change");
            this.unbind("ready");
            clearInterval(this._interval);
        },
        _normalizeUrl: function() {
            var that = this, pushStateUrl, atRoot = that.root == location.pathname, pushStateUrlNeedsTransform = that._pushStateRequested && !that._pushStateSupported() && !atRoot, hashUrlNeedsTransform = that._pushState && atRoot && location.hash;
            if (pushStateUrlNeedsTransform) {
                location.replace(that.root + "#" + that._stripRoot(location.pathname));
                return true;
            } else if (hashUrlNeedsTransform) {
                pushStateUrl = that._makePushStateUrl(location.hash.replace(hashStrip, ""));
                history.replaceState({}, document.title, pushStateUrl);
                return false;
            }
            return false;
        },
        _listenToLocationChange: function() {
            var that = this, _checkUrlProxy = $.proxy(that._checkUrl, that);
            if (this._pushState) {
                $(window).bind("popstate.kendo", _checkUrlProxy);
            } else if (hashChangeSupported) {
                $(window).bind("hashchange.kendo", _checkUrlProxy);
            } else {
                that._interval = setInterval(_checkUrlProxy, _checkUrlInterval);
            }
        },
        _pushStateSupported: function() {
            return window.history && window.history.pushState;
        },
        _checkUrl: function() {
            var that = this, current = that._currentLocation();
            if (current != that.current) {
                that.navigate(current);
            }
        },
        _stripRoot: function(url) {
            var that = this;
            if (url.indexOf(that.root) === 0) {
                return ("/" + url.substr(that.root.length)).replace(/\/\//g, "/");
            } else {
                return url;
            }
        },
        _makePushStateUrl: function(address) {
            var that = this;
            if (address.indexOf(that.root) !== 0) {
                address = (that.root + address).replace(/\/\//g, "/");
            }
            return location.protocol + "//" + location.host + address;
        },
        _currentLocation: function() {
            var that = this, current;
            if (that._pushState) {
                current = location.pathname;
                if (location.search) {
                    current += location.search;
                }
                return that._stripRoot(current);
            } else {
                return location.hash.replace(hashStrip, "");
            }
        },
        change: function(callback) {
            this.bind("change", callback);
        },
        navigate: function(to, silent) {
            var that = this;
            if (to === "#:back") {
                history.back();
                return;
            }
            to = to.replace(hashStrip, "");
            if (that.current === to || that.current === decodeURIComponent(to)) {
                return;
            }
            if (!silent) {
                if (that.trigger("change", {
                    url: to
                })) {
                    to = that.current;
                }
            }
            if (that._pushState) {
                history.pushState({}, document.title, that._makePushStateUrl(to));
                that.current = to;
            } else {
                location.hash = that.current = to;
            }
        }
    });
    kendo.history = new History();
})(window.kendo.jQuery);

(function() {
    var kendo = window.kendo, history = kendo.history, Observable = kendo.Observable, INIT = "init", ROUTE_MISSING = "routeMissing", CHANGE = "change", optionalParam = /\((.*?)\)/g, namedParam = /(\(\?)?:\w+/g, splatParam = /\*\w+/g, escapeRegExp = /[\-{}\[\]+?.,\\\^$|#\s]/g;
    function namedParamReplace(match, optional) {
        return optional ? match : "([^/]+)";
    }
    function routeToRegExp(route) {
        return new RegExp("^" + route.replace(escapeRegExp, "\\$&").replace(optionalParam, "(?:$1)?").replace(namedParam, namedParamReplace).replace(splatParam, "(.*?)") + "$");
    }
    var Route = kendo.Class.extend({
        init: function(route, callback) {
            if (!(route instanceof RegExp)) {
                route = routeToRegExp(route);
            }
            this.route = route;
            this._callback = callback;
        },
        callback: function(url) {
            var params = this.route.exec(url).slice(1), idx = 0, length = params.length;
            for (;idx < length; idx++) {
                if (typeof params[idx] !== "undefined") {
                    params[idx] = decodeURIComponent(params[idx]);
                }
            }
            this._callback.apply(null, params);
        },
        worksWith: function(url) {
            if (this.route.test(url)) {
                this.callback(url);
                return true;
            } else {
                return false;
            }
        }
    });
    var Router = Observable.extend({
        init: function(options) {
            Observable.fn.init.call(this);
            this.routes = [];
            this.bind([ INIT, ROUTE_MISSING, CHANGE ], options);
        },
        destroy: function() {
            history.unbind("ready", this._readyProxy);
            history.unbind("change", this._urlChangedProxy);
            this.unbind();
        },
        start: function() {
            var that = this, readyProxy = function(e) {
                if (!e.url) {
                    e.url = "/";
                }
                if (!that.trigger(INIT, e)) {
                    that._urlChanged(e);
                }
            }, urlChangedProxy = function(e) {
                that._urlChanged(e);
            };
            kendo.history.start({
                ready: readyProxy,
                change: urlChangedProxy
            });
            this._urlChangedProxy = urlChangedProxy;
            this._readyProxy = readyProxy;
        },
        route: function(route, callback) {
            this.routes.push(new Route(route, callback));
        },
        navigate: function(url, silent) {
            kendo.history.navigate(url, silent);
        },
        _urlChanged: function(e) {
            var url = e.url;
            if (!url) {
                url = "/";
            }
            if (this.trigger(CHANGE, {
                url: e.url
            })) {
                e.preventDefault();
                return;
            }
            var idx = 0, routes = this.routes, route, length = routes.length;
            for (;idx < length; idx++) {
                route = routes[idx];
                if (route.worksWith(url)) {
                    return;
                }
            }
            this.trigger(ROUTE_MISSING, {
                url: url
            });
        }
    });
    kendo.Router = Router;
})();

(function($, undefined) {
    var kendo = window.kendo, Observable = kendo.Observable, SCRIPT = "SCRIPT", INIT = "init", SHOW = "show", HIDE = "hide";
    var View = Observable.extend({
        init: function(content, options) {
            var that = this;
            options = options || {};
            Observable.fn.init.call(that);
            that.content = content;
            that.tagName = options.tagName || "div";
            that.model = options.model;
            that.bind([ INIT, SHOW, HIDE ], options);
        },
        render: function(container) {
            var that = this, element, content;
            if (!that.element) {
                element = $("<" + that.tagName + " />");
                content = $(document.getElementById(that.content) || that.content);
                // support passing id without #
                element.append(content[0].tagName === SCRIPT ? content.html() : content);
                that.element = element;
                kendo.bind(that.element, that.model);
                this.trigger(INIT);
            }
            if (container) {
                this.trigger(SHOW);
                $(container).append(that.element);
            }
            return that.element;
        },
        hide: function() {
            this.element.detach();
            this.trigger(HIDE);
        },
        destroy: function() {
            if (this.element) {
                kendo.unbind(this.element);
                this.element.remove();
            }
        }
    });
    var Layout = View.extend({
        init: function(content, options) {
            View.fn.init.call(this, content, options);
            this.regions = {};
        },
        showIn: function(container, view) {
            var previousView = this.regions[container];
            if (previousView) {
                previousView.hide();
            }
            view.render(this.render().find(container), previousView);
            this.regions[container] = view;
        }
    });
    kendo.Layout = Layout;
    kendo.View = View;
})(window.kendo.jQuery);

(function($, undefined) {
    /**
     * @name kendo.fx
     * @namespace This object contains the fx library that is used by all widgets using animation.
     * If this file is not included, all animations will be disabled but the basic functionality preserved.
     */
    var kendo = window.kendo, fx = kendo.fx, each = $.each, extend = $.extend, proxy = $.proxy, support = kendo.support, browser = support.browser, transforms = support.transforms, transitions = support.transitions, scaleProperties = {
        scale: 0,
        scalex: 0,
        scaley: 0,
        scale3d: 0
    }, translateProperties = {
        translate: 0,
        translatex: 0,
        translatey: 0,
        translate3d: 0
    }, hasZoom = typeof document.documentElement.style.zoom !== "undefined" && !transforms, matrix3dRegExp = /matrix3?d?\s*\(.*,\s*([\d\.\-]+)\w*?,\s*([\d\.\-]+)\w*?,\s*([\d\.\-]+)\w*?,\s*([\d\.\-]+)\w*?/i, cssParamsRegExp = /^(-?[\d\.\-]+)?[\w\s]*,?\s*(-?[\d\.\-]+)?[\w\s]*/i, translateXRegExp = /translatex?$/i, oldEffectsRegExp = /(zoom|fade|expand)(\w+)/, singleEffectRegExp = /(zoom|fade|expand)/, unitRegExp = /[xy]$/i, transformProps = [ "perspective", "rotate", "rotatex", "rotatey", "rotatez", "rotate3d", "scale", "scalex", "scaley", "scalez", "scale3d", "skew", "skewx", "skewy", "translate", "translatex", "translatey", "translatez", "translate3d", "matrix", "matrix3d" ], transform2d = [ "rotate", "scale", "scalex", "scaley", "skew", "skewx", "skewy", "translate", "translatex", "translatey", "matrix" ], transform2units = {
        rotate: "deg",
        scale: "",
        skew: "px",
        translate: "px"
    }, cssPrefix = transforms.css, Effects = {}, round = Math.round, BLANK = "", PX = "px", NONE = "none", AUTO = "auto", WIDTH = "width", HEIGHT = "height", HIDDEN = "hidden", ORIGIN = "origin", ABORT_ID = "abortId", OVERFLOW = "overflow", TRANSLATE = "translate", COMPLETE_CALLBACK = "completeCallback", TRANSITION = cssPrefix + "transition", TRANSFORM = cssPrefix + "transform", BACKFACE = cssPrefix + "backface-visibility", PERSPECTIVE = cssPrefix + "perspective", DEFAULT_PERSPECTIVE = "800px", TRANSFORM_PERSPECTIVE = "perspective(" + DEFAULT_PERSPECTIVE + ")", directions = {
        left: {
            reverse: "right",
            property: "left",
            transition: "translatex",
            vertical: false,
            modifier: -1
        },
        right: {
            reverse: "left",
            property: "left",
            transition: "translatex",
            vertical: false,
            modifier: 1
        },
        down: {
            reverse: "up",
            property: "top",
            transition: "translatey",
            vertical: true,
            modifier: 1
        },
        up: {
            reverse: "down",
            property: "top",
            transition: "translatey",
            vertical: true,
            modifier: -1
        },
        top: {
            reverse: "bottom"
        },
        bottom: {
            reverse: "top"
        },
        "in": {
            reverse: "out",
            modifier: -1
        },
        out: {
            reverse: "in",
            modifier: 1
        },
        vertical: {
            reverse: "vertical"
        },
        horizontal: {
            reverse: "horizontal"
        }
    };
    kendo.directions = directions;
    extend($.fn, {
        kendoStop: function(clearQueue, gotoEnd) {
            if (transitions) {
                return kendo.fx.stopQueue(this, clearQueue || false, gotoEnd || false);
            } else {
                return this.stop(clearQueue, gotoEnd);
            }
        }
    });
    /* jQuery support for all transform animations (FF 3.5/3.6, Opera 10.x, IE9 */
    if (transforms && !transitions) {
        each(transform2d, function(idx, value) {
            $.fn[value] = function(val) {
                if (typeof val == "undefined") {
                    return animationProperty(this, value);
                } else {
                    var that = $(this)[0], transformValue = value + "(" + val + transform2units[value.replace(unitRegExp, "")] + ")";
                    if (that.style.cssText.indexOf(TRANSFORM) == -1) {
                        $(this).css(TRANSFORM, transformValue);
                    } else {
                        that.style.cssText = that.style.cssText.replace(new RegExp(value + "\\(.*?\\)", "i"), transformValue);
                    }
                }
                return this;
            };
            $.fx.step[value] = function(fx) {
                $(fx.elem)[value](fx.now);
            };
        });
        var curProxy = $.fx.prototype.cur;
        $.fx.prototype.cur = function() {
            if (transform2d.indexOf(this.prop) != -1) {
                return parseFloat($(this.elem)[this.prop]());
            }
            return curProxy.apply(this, arguments);
        };
    }
    kendo.toggleClass = function(element, classes, options, add) {
        if (classes) {
            classes = classes.split(" ");
            if (transitions) {
                options = extend({
                    exclusive: "all",
                    duration: 400,
                    ease: "ease-out"
                }, options);
                element.css(TRANSITION, options.exclusive + " " + options.duration + "ms " + options.ease);
                setTimeout(function() {
                    element.css(TRANSITION, "").css(HEIGHT);
                }, options.duration);
            }
            each(classes, function(idx, value) {
                element.toggleClass(value, add);
            });
        }
        return element;
    };
    kendo.parseEffects = function(input, mirror) {
        var effects = {};
        if (typeof input === "string") {
            each(input.split(" "), function(idx, value) {
                var redirectedEffect = !singleEffectRegExp.test(value), resolved = value.replace(oldEffectsRegExp, function(match, $1, $2) {
                    return $1 + ":" + $2.toLowerCase();
                }), // Support for old zoomIn/fadeOut style, now deprecated.
                effect = resolved.split(":"), direction = effect[1], effectBody = {};
                if (effect.length > 1) {
                    effectBody.direction = mirror && redirectedEffect ? directions[direction].reverse : direction;
                }
                effects[effect[0]] = effectBody;
            });
        } else {
            each(input, function(idx) {
                var direction = this.direction;
                if (direction && mirror && !singleEffectRegExp.test(idx)) {
                    this.direction = directions[direction].reverse;
                }
                effects[idx] = this;
            });
        }
        return effects;
    };
    function parseInteger(value) {
        return parseInt(value, 10);
    }
    function parseCSS(element, property) {
        return parseInteger(element.css(property));
    }
    function parseTransitionEffects(options) {
        var effects = options.effects;
        if (effects === "zoom") {
            effects = "zoom:in fade:in";
        }
        if (effects === "fade") {
            effects = "fade:in";
        }
        if (effects === "slide") {
            effects = "tile:left";
        }
        if (/^slide:(.+)$/.test(effects)) {
            effects = "tile:" + RegExp.$1;
        }
        if (effects === "overlay") {
            effects = "slideIn:left";
        }
        if (/^overlay:(.+)$/.test(effects)) {
            effects = "slideIn:" + RegExp.$1;
        }
        options.effects = kendo.parseEffects(effects);
        return options;
    }
    function keys(obj) {
        var acc = [];
        for (var propertyName in obj) {
            acc.push(propertyName);
        }
        return acc;
    }
    function strip3DTransforms(properties) {
        for (var key in properties) {
            if (transformProps.indexOf(key) != -1 && transform2d.indexOf(key) == -1) {
                delete properties[key];
            }
        }
        return properties;
    }
    function normalizeCSS(element, properties) {
        var transformation = [], cssValues = {}, lowerKey, key, value, isTransformed;
        for (key in properties) {
            lowerKey = key.toLowerCase();
            isTransformed = transforms && transformProps.indexOf(lowerKey) != -1;
            if (!support.hasHW3D && isTransformed && transform2d.indexOf(lowerKey) == -1) {
                delete properties[key];
            } else {
                value = properties[key];
                if (isTransformed) {
                    transformation.push(key + "(" + value + ")");
                } else {
                    cssValues[key] = value;
                }
            }
        }
        if (transformation.length) {
            cssValues[TRANSFORM] = transformation.join(" ");
        }
        return cssValues;
    }
    if (transitions) {
        extend(kendo.fx, {
            transition: function(element, properties, options) {
                var css, delay = 0, oldKeys = element.data("keys") || [], timeoutID;
                options = extend({
                    duration: 200,
                    ease: "ease-out",
                    complete: null,
                    exclusive: "all"
                }, options);
                var stopTransitionCalled = false;
                var stopTransition = function() {
                    if (!stopTransitionCalled) {
                        stopTransitionCalled = true;
                        if (timeoutID) {
                            clearTimeout(timeoutID);
                            timeoutID = null;
                        }
                        element.removeData(ABORT_ID).dequeue().css(TRANSITION, "").css(TRANSITION);
                        options.complete.call(element);
                    }
                };
                options.duration = $.fx ? $.fx.speeds[options.duration] || options.duration : options.duration;
                css = normalizeCSS(element, properties);
                $.merge(oldKeys, keys(css));
                element.data("keys", $.unique(oldKeys)).height();
                element.css(TRANSITION, options.exclusive + " " + options.duration + "ms " + options.ease).css(TRANSITION);
                element.css(css).css(TRANSFORM);
                /**
                 * Use transitionEnd event for browsers who support it - but duplicate it with setTimeout, as the transitionEnd event will not be triggered if no CSS properties change.
                 * This should be cleaned up at some point (widget by widget), and refactored to widgets not relying on the complete callback if no transition occurs.
                 *
                 * For IE9 and below, resort to setTimeout.
                 */
                if (transitions.event) {
                    element.one(transitions.event, stopTransition);
                    if (options.duration !== 0) {
                        delay = 500;
                    }
                }
                timeoutID = setTimeout(stopTransition, options.duration + delay);
                element.data(ABORT_ID, timeoutID);
                element.data(COMPLETE_CALLBACK, stopTransition);
            },
            stopQueue: function(element, clearQueue, gotoEnd) {
                var cssValues, taskKeys = element.data("keys"), retainPosition = !gotoEnd && taskKeys, completeCallback = element.data(COMPLETE_CALLBACK);
                if (retainPosition) {
                    cssValues = kendo.getComputedStyles(element[0], taskKeys);
                }
                if (completeCallback) {
                    completeCallback();
                }
                if (retainPosition) {
                    element.css(cssValues);
                }
                return element.removeData("keys").stop(clearQueue);
            }
        });
    }
    function animationProperty(element, property) {
        if (transforms) {
            var transform = element.css(TRANSFORM);
            if (transform == NONE) {
                return property == "scale" ? 1 : 0;
            }
            var match = transform.match(new RegExp(property + "\\s*\\(([\\d\\w\\.]+)")), computed = 0;
            if (match) {
                computed = parseInteger(match[1]);
            } else {
                match = transform.match(matrix3dRegExp) || [ 0, 0, 0, 0, 0 ];
                property = property.toLowerCase();
                if (translateXRegExp.test(property)) {
                    computed = parseFloat(match[3] / match[2]);
                } else if (property == "translatey") {
                    computed = parseFloat(match[4] / match[2]);
                } else if (property == "scale") {
                    computed = parseFloat(match[2]);
                } else if (property == "rotate") {
                    computed = parseFloat(Math.atan2(match[2], match[1]));
                }
            }
            return computed;
        } else {
            return parseFloat(element.css(property));
        }
    }
    var EffectSet = kendo.Class.extend({
        init: function(element, options) {
            var that = this;
            that.element = element;
            that.effects = [];
            that.options = options;
            that.restore = [];
        },
        run: function(effects) {
            var that = this, effect, idx, jdx, length = effects.length, element = that.element, options = that.options, deferred = $.Deferred(), start = {}, end = {}, target, children, childrenLength;
            that.effects = effects;
            deferred.then($.proxy(that, "complete"));
            element.data("animating", true);
            for (idx = 0; idx < length; idx++) {
                effect = effects[idx];
                effect.setReverse(options.reverse);
                effect.setOptions(options);
                that.addRestoreProperties(effect.restore);
                effect.prepare(start, end);
                children = effect.children();
                for (jdx = 0, childrenLength = children.length; jdx < childrenLength; jdx++) {
                    children[jdx].duration(options.duration).run();
                }
            }
            // legacy support for options.properties
            for (var effectName in options.effects) {
                extend(end, options.effects[effectName].properties);
            }
            // Show the element initially
            if (!element.is(":visible")) {
                extend(start, {
                    display: element.data("olddisplay") || "block"
                });
            }
            if (transforms && !options.reset) {
                target = element.data("targetTransform");
                if (target) {
                    start = extend(target, start);
                }
            }
            start = normalizeCSS(element, start);
            if (transforms && !transitions) {
                start = strip3DTransforms(start);
            }
            element.css(start).css(TRANSFORM);
            // Nudge
            for (idx = 0; idx < length; idx++) {
                effects[idx].setup();
            }
            if (options.init) {
                options.init();
            }
            element.data("targetTransform", end);
            kendo.fx.animate(element, end, extend({}, options, {
                complete: deferred.resolve
            }));
            return deferred.promise();
        },
        stop: function() {
            $(this.element).kendoStop(true, true);
        },
        addRestoreProperties: function(restore) {
            var element = this.element, value, i = 0, length = restore.length;
            for (;i < length; i++) {
                value = restore[i];
                this.restore.push(value);
                if (!element.data(value)) {
                    element.data(value, element.css(value));
                }
            }
        },
        restoreCallback: function() {
            var element = this.element;
            for (var i = 0, length = this.restore.length; i < length; i++) {
                var value = this.restore[i];
                element.css(value, element.data(value));
            }
        },
        complete: function() {
            var that = this, idx = 0, element = that.element, options = that.options, effects = that.effects, length = effects.length;
            element.removeData("animating").dequeue();
            // call next animation from the queue
            if (options.hide) {
                element.data("olddisplay", element.css("display")).hide();
            }
            this.restoreCallback();
            if (hasZoom && !transforms) {
                setTimeout($.proxy(this, "restoreCallback"), 0);
            }
            for (;idx < length; idx++) {
                effects[idx].teardown();
            }
            if (options.completeCallback) {
                options.completeCallback(element);
            }
        }
    });
    kendo.fx.promise = function(element, options) {
        var effects = [], effectClass, effectSet = new EffectSet(element, options), parsedEffects = kendo.parseEffects(options.effects), effect;
        options.effects = parsedEffects;
        for (var effectName in parsedEffects) {
            effectClass = Effects[effectName];
            if (effectClass) {
                effect = new effectClass(element, parsedEffects[effectName].direction);
                effects.push(effect);
            }
        }
        if (effects[0]) {
            effectSet.run(effects);
        } else {
            // Not sure how would an fx promise reach this state - means that you call kendoAnimate with no valid effects? Why?
            if (!element.is(":visible")) {
                element.css({
                    display: element.data("olddisplay") || "block"
                }).css("display");
            }
            if (options.init) {
                options.init();
            }
            element.dequeue();
            effectSet.complete();
        }
    };
    kendo.fx.transitionPromise = function(element, destination, options) {
        kendo.fx.animateTo(element, destination, options);
        return element;
    };
    extend(kendo.fx, {
        animate: function(elements, properties, options) {
            var useTransition = options.transition !== false;
            delete options.transition;
            if (transitions && "transition" in fx && useTransition) {
                fx.transition(elements, properties, options);
            } else {
                if (transforms) {
                    elements.animate(strip3DTransforms(properties), {
                        queue: false,
                        show: false,
                        hide: false,
                        duration: options.duration,
                        complete: options.complete
                    });
                } else {
                    elements.each(function() {
                        var element = $(this), multiple = {};
                        each(transformProps, function(idx, value) {
                            // remove transforms to avoid IE and older browsers confusion
                            var params, currentValue = properties ? properties[value] + " " : null;
                            // We need to match
                            if (currentValue) {
                                var single = properties;
                                if (value in scaleProperties && properties[value] !== undefined) {
                                    params = currentValue.match(cssParamsRegExp);
                                    if (transforms) {
                                        extend(single, {
                                            scale: +params[0]
                                        });
                                    }
                                } else {
                                    if (value in translateProperties && properties[value] !== undefined) {
                                        var position = element.css("position"), isFixed = position == "absolute" || position == "fixed";
                                        if (!element.data(TRANSLATE)) {
                                            if (isFixed) {
                                                element.data(TRANSLATE, {
                                                    top: parseCSS(element, "top") || 0,
                                                    left: parseCSS(element, "left") || 0,
                                                    bottom: parseCSS(element, "bottom"),
                                                    right: parseCSS(element, "right")
                                                });
                                            } else {
                                                element.data(TRANSLATE, {
                                                    top: parseCSS(element, "marginTop") || 0,
                                                    left: parseCSS(element, "marginLeft") || 0
                                                });
                                            }
                                        }
                                        var originalPosition = element.data(TRANSLATE);
                                        params = currentValue.match(cssParamsRegExp);
                                        if (params) {
                                            var dX = value == TRANSLATE + "y" ? +null : +params[1], dY = value == TRANSLATE + "y" ? +params[1] : +params[2];
                                            if (isFixed) {
                                                if (!isNaN(originalPosition.right)) {
                                                    if (!isNaN(dX)) {
                                                        extend(single, {
                                                            right: originalPosition.right - dX
                                                        });
                                                    }
                                                } else {
                                                    if (!isNaN(dX)) {
                                                        extend(single, {
                                                            left: originalPosition.left + dX
                                                        });
                                                    }
                                                }
                                                if (!isNaN(originalPosition.bottom)) {
                                                    if (!isNaN(dY)) {
                                                        extend(single, {
                                                            bottom: originalPosition.bottom - dY
                                                        });
                                                    }
                                                } else {
                                                    if (!isNaN(dY)) {
                                                        extend(single, {
                                                            top: originalPosition.top + dY
                                                        });
                                                    }
                                                }
                                            } else {
                                                if (!isNaN(dX)) {
                                                    extend(single, {
                                                        marginLeft: originalPosition.left + dX
                                                    });
                                                }
                                                if (!isNaN(dY)) {
                                                    extend(single, {
                                                        marginTop: originalPosition.top + dY
                                                    });
                                                }
                                            }
                                        }
                                    }
                                }
                                if (!transforms && value != "scale" && value in single) {
                                    delete single[value];
                                }
                                if (single) {
                                    extend(multiple, single);
                                }
                            }
                        });
                        if (browser.msie) {
                            delete multiple.scale;
                        }
                        element.animate(multiple, {
                            queue: false,
                            show: false,
                            hide: false,
                            duration: options.duration,
                            complete: options.complete
                        });
                    });
                }
            }
        },
        animateTo: function(element, destination, options) {
            var direction, commonParent = element.parents().filter(destination.parents()).first(), originalOverflow;
            options = parseTransitionEffects(options);
            if (!support.mobileOS.android) {
                originalOverflow = commonParent.css(OVERFLOW);
                commonParent.css(OVERFLOW, "hidden");
            }
            $.each(options.effects, function(name, definition) {
                direction = direction || definition.direction;
            });
            function complete(animatedElement) {
                destination[0].style.cssText = "";
                element[0].style.cssText = "";
                // Removing the whole style attribute breaks Android.
                if (!support.mobileOS.android) {
                    commonParent.css(OVERFLOW, originalOverflow);
                }
                if (options.completeCallback) {
                    options.completeCallback.call(element, animatedElement);
                }
            }
            options.complete = browser.msie ? function() {
                setTimeout(complete, 0);
            } : complete;
            options.previous = options.reverse ? destination : element;
            options.reset = true;
            // Reset transforms if there are any.
            // execute callback only once, and hook up derived animations to previous view only once.
            (options.reverse ? element : destination).each(function() {
                $(this).kendoAnimate(extend(true, {}, options));
                options.complete = null;
                options.previous = null;
            });
        }
    });
    var Effect = kendo.Class.extend({
        init: function(element, direction) {
            var that = this;
            that.element = element;
            that._direction = direction;
            that.options = {};
            that._additionalEffects = [];
            if (!that.restore) {
                that.restore = [];
            }
        },
        // Public API
        reverse: function() {
            this._reverse = true;
            return this.run();
        },
        play: function() {
            this._reverse = false;
            return this.run();
        },
        add: function(additional) {
            this._additionalEffects.push(additional);
            return this;
        },
        direction: function(value) {
            this._direction = value;
            return this;
        },
        duration: function(duration) {
            this._duration = duration;
            return this;
        },
        compositeRun: function() {
            var that = this, effectSet = new EffectSet(that.element, {
                reverse: that._reverse,
                duration: that._duration
            }), effects = that._additionalEffects.concat([ that ]);
            return effectSet.run(effects);
        },
        run: function() {
            if (this._additionalEffects && this._additionalEffects[0]) {
                return this.compositeRun();
            }
            var that = this, element = that.element, idx = 0, restore = that.restore, length = restore.length, value, deferred = $.Deferred(), start = {}, end = {}, target, children = that.children(), childrenLength = children.length;
            deferred.then($.proxy(that, "_complete"));
            element.data("animating", true);
            for (idx = 0; idx < length; idx++) {
                value = restore[idx];
                if (!element.data(value)) {
                    element.data(value, element.css(value));
                }
            }
            for (idx = 0; idx < childrenLength; idx++) {
                children[idx].duration(that._duration).run();
            }
            that.prepare(start, end);
            if (!element.is(":visible")) {
                extend(start, {
                    display: element.data("olddisplay") || "block"
                });
            }
            if (transforms) {
                target = element.data("targetTransform");
                if (target) {
                    start = extend(target, start);
                }
            }
            start = normalizeCSS(element, start);
            if (transforms && !transitions) {
                start = strip3DTransforms(start);
            }
            element.css(start).css(TRANSFORM);
            // Nudge
            that.setup();
            element.data("targetTransform", end);
            kendo.fx.animate(element, end, {
                duration: that._duration,
                complete: deferred.resolve
            });
            return deferred.promise();
        },
        stop: function() {
            var idx = 0, children = this.children(), childrenLength = children.length;
            for (idx = 0; idx < childrenLength; idx++) {
                children[idx].stop();
            }
            $(this.element).kendoStop(true, true);
            return this;
        },
        restoreCallback: function() {
            var element = this.element;
            for (var i = 0, length = this.restore.length; i < length; i++) {
                var value = this.restore[i];
                element.css(value, element.data(value));
            }
        },
        _complete: function() {
            var that = this, element = that.element;
            element.removeData("animating").dequeue();
            // call next animation from the queue
            that.restoreCallback();
            if (that.shouldHide()) {
                element.data("olddisplay", element.css("display")).hide();
            }
            if (hasZoom && !transforms) {
                setTimeout($.proxy(that, "restoreCallback"), 0);
            }
            that.teardown();
        },
        /////////////////////////// Support for kendo.animate;
        setOptions: function(options) {
            extend(true, this.options, options);
        },
        children: function() {
            return [];
        },
        shouldHide: $.noop,
        setup: $.noop,
        prepare: $.noop,
        teardown: $.noop,
        directions: [],
        setReverse: function(reverse) {
            this._reverse = reverse;
            return this;
        }
    });
    function toUpperCase(letter) {
        return letter.toUpperCase();
    }
    function capitalize(word) {
        return word.replace(/^./, toUpperCase);
    }
    function createEffect(name, definition) {
        var effectClass = Effect.extend(definition), directions = effectClass.prototype.directions;
        Effects[name] = effectClass;
        fx.Element.prototype[name] = function(direction, opt1, opt2, opt3) {
            return new effectClass(this.element, direction, opt1, opt2, opt3);
        };
        each(directions, function(idx, theDirection) {
            fx.Element.prototype[name + capitalize(theDirection)] = function(opt1, opt2, opt3) {
                return new effectClass(this.element, theDirection, opt1, opt2, opt3);
            };
        });
    }
    var FOUR_DIRECTIONS = [ "left", "right", "up", "down" ], IN_OUT = [ "in", "out" ];
    createEffect("slideIn", {
        directions: FOUR_DIRECTIONS,
        prepare: function(start, end) {
            var that = this, tmp, element = that.element, direction = directions[that._direction], offset = -direction.modifier * (direction.vertical ? element.outerHeight() : element.outerWidth()), startValue = offset / (that.options && that.options.divisor || 1) + PX, endValue = "0px";
            if (that._reverse) {
                tmp = start;
                start = end;
                end = tmp;
            }
            if (transforms) {
                start[direction.transition] = startValue;
                end[direction.transition] = endValue;
            } else {
                start[direction.property] = startValue;
                end[direction.property] = endValue;
            }
        }
    });
    createEffect("tile", {
        directions: FOUR_DIRECTIONS,
        init: function(element, direction, previous) {
            Effect.prototype.init.call(this, element, direction);
            this.options = {
                previous: previous
            };
        },
        children: function() {
            var that = this, reverse = that._reverse, previous = that.options.previous, dir = that._direction;
            var children = [ fx(that.element).slideIn(dir).setReverse(reverse) ];
            if (previous) {
                children.push(fx(previous).slideIn(directions[dir].reverse).setReverse(!reverse));
            }
            return children;
        }
    });
    function createToggleEffect(name, property, endValue) {
        createEffect(name, {
            directions: IN_OUT,
            restore: [ property ],
            startValue: function(value) {
                this._startValue = value;
                return this;
            },
            endValue: function(value) {
                this._endValue = value;
                return this;
            },
            shouldHide: function() {
                return this._direction === "out" && this._end() === endValue ? !this._reverse : this._reverse;
            },
            _end: function() {
                return this._endValue || endValue;
            },
            _start: function() {
                return this._startValue || 1;
            },
            prepare: function(start, end) {
                var that = this, opacity = that.element.data(property), out = that.shouldHide(), value = isNaN(opacity) || opacity === "" ? that._start() : opacity;
                start[property] = end[property] = that._end();
                if (out) {
                    start[property] = value;
                } else {
                    end[property] = value;
                }
            }
        });
    }
    createToggleEffect("fade", "opacity", 0);
    createToggleEffect("zoom", "scale", .01);
    createEffect("slideMargin", {
        prepare: function(start, end) {
            var that = this, element = that.element, options = that.options, origin = element.data(ORIGIN), offset = options.offset, margin, reverse = that._reverse;
            if (!reverse && origin === null) {
                element.data(ORIGIN, parseFloat(element.css("margin-" + options.axis)));
            }
            margin = element.data(ORIGIN) || 0;
            end["margin-" + options.axis] = !reverse ? margin + offset : margin;
        }
    });
    createEffect("slideTo", {
        prepare: function(start, end) {
            var that = this, element = that.element, options = that.options, offset = options.offset.split(","), reverse = that._reverse;
            if (transforms) {
                end.translatex = !reverse ? offset[0] : 0;
                end.translatey = !reverse ? offset[1] : 0;
            } else {
                end.left = !reverse ? offset[0] : 0;
                end.top = !reverse ? offset[1] : 0;
            }
            element.css("left");
        }
    });
    createEffect("expand", {
        directions: [ "horizontal", "vertical" ],
        restore: [ OVERFLOW ],
        prepare: function(start, end) {
            var that = this, element = that.element, options = that.options, reverse = that._reverse, property = that._direction === "vertical" ? HEIGHT : WIDTH, setLength = element[0].style[property], oldLength = element.data(property), length = parseFloat(oldLength || setLength), realLength = round(element.css(property, AUTO)[property]());
            start.overflow = HIDDEN;
            length = options && options.reset ? realLength || length : length || realLength;
            end[property] = (reverse ? 0 : length) + PX;
            start[property] = (reverse ? length : 0) + PX;
            if (oldLength === undefined) {
                element.data(property, setLength);
            }
        },
        shouldHide: function() {
            return this._reverse;
        },
        teardown: function() {
            var that = this, element = that.element, property = that._direction === "vertical" ? HEIGHT : WIDTH, length = element.data(property);
            if (length == AUTO || length === BLANK) {
                setTimeout(function() {
                    element.css(property, AUTO).css(property);
                }, 0);
            }
        }
    });
    var TRANSFER_START_STATE = {
        position: "absolute",
        marginLeft: 0,
        marginTop: 0,
        scale: 1
    };
    /**
     * Intersection point formulas are taken from here - http://zonalandeducation.com/mmts/intersections/intersectionOfTwoLines1/intersectionOfTwoLines1.html
     * Formula for a linear function from two points from here - http://demo.activemath.org/ActiveMath2/search/show.cmd?id=mbase://AC_UK_calculus/functions/ex_linear_equation_two_points
     * The transform origin point is the intersection point of the two lines from the top left corners/top right corners of the element and target.
     * The math and variables below MAY BE SIMPLIFIED (zeroes removed), but this would make the formula too cryptic.
     */
    createEffect("transfer", {
        init: function(element, target) {
            this.element = element;
            this.options = {
                target: target
            };
            this.restore = [];
        },
        setup: function() {
            this.element.appendTo(document.body);
        },
        prepare: function(start, end) {
            var that = this, element = that.element, options = that.options, reverse = that._reverse, target = options.target, offset, currentScale = animationProperty(element, "scale"), targetOffset = target.offset(), scale = target.outerHeight() / element.outerHeight();
            extend(start, TRANSFER_START_STATE);
            end.scale = 1;
            element.css(TRANSFORM, "scale(1)").css(TRANSFORM);
            offset = element.offset();
            element.css(TRANSFORM, "scale(" + currentScale + ")");
            var x1 = 0, y1 = 0, x2 = targetOffset.left - offset.left, y2 = targetOffset.top - offset.top, x3 = x1 + element.outerWidth(), y3 = y1, x4 = x2 + target.outerWidth(), y4 = y2, Z1 = (y2 - y1) / (x2 - x1), Z2 = (y4 - y3) / (x4 - x3), X = (y1 - y3 - Z1 * x1 + Z2 * x3) / (Z2 - Z1), Y = y1 + Z1 * (X - x1);
            start.top = offset.top;
            start.left = offset.left;
            start.transformOrigin = X + PX + " " + Y + PX;
            if (reverse) {
                start.scale = scale;
            } else {
                end.scale = scale;
            }
        }
    });
    var CLIPS = {
        top: "rect(auto auto $size auto)",
        bottom: "rect($size auto auto auto)",
        left: "rect(auto $size auto auto)",
        right: "rect(auto auto auto $size)"
    };
    var ROTATIONS = {
        top: {
            start: "rotatex(0deg)",
            end: "rotatex(180deg)"
        },
        bottom: {
            start: "rotatex(-180deg)",
            end: "rotatex(0deg)"
        },
        left: {
            start: "rotatey(0deg)",
            end: "rotatey(-180deg)"
        },
        right: {
            start: "rotatey(180deg)",
            end: "rotatey(0deg)"
        }
    };
    function clipInHalf(container, direction) {
        var vertical = kendo.directions[direction].vertical, size = container[vertical ? HEIGHT : WIDTH]() / 2 + "px";
        return CLIPS[direction].replace("$size", size);
    }
    createEffect("turningPage", {
        directions: FOUR_DIRECTIONS,
        init: function(element, direction, container) {
            Effect.prototype.init.call(this, element, direction);
            this._container = container;
        },
        prepare: function(start, end) {
            var that = this, reverse = that._reverse, direction = reverse ? directions[that._direction].reverse : that._direction, rotation = ROTATIONS[direction];
            start.zIndex = 1;
            if (that._clipInHalf) {
                start.clip = clipInHalf(that._container, kendo.directions[direction].reverse);
            }
            start[BACKFACE] = HIDDEN;
            end[TRANSFORM] = TRANSFORM_PERSPECTIVE + (reverse ? rotation.start : rotation.end);
            start[TRANSFORM] = TRANSFORM_PERSPECTIVE + (reverse ? rotation.end : rotation.start);
        },
        setup: function() {
            this._container.append(this.element);
        },
        face: function(value) {
            this._face = value;
            return this;
        },
        shouldHide: function() {
            var that = this, reverse = that._reverse, face = that._face;
            return reverse && !face || !reverse && face;
        },
        clipInHalf: function(value) {
            this._clipInHalf = value;
            return this;
        },
        temporary: function(value) {
            this._temporary = value;
            return this;
        },
        teardown: function() {
            if (this._temporary) {
                this.element.remove();
            }
        }
    });
    createEffect("staticPage", {
        directions: FOUR_DIRECTIONS,
        init: function(element, direction, container) {
            Effect.prototype.init.call(this, element, direction);
            this._container = container;
        },
        restore: [ "clip" ],
        prepare: function(start) {
            var that = this, direction = that._reverse ? directions[that._direction].reverse : that._direction;
            start.clip = clipInHalf(that._container, direction);
        },
        shouldHide: function() {
            var that = this, reverse = that._reverse, face = that._face;
            return reverse && !face || !reverse && face;
        },
        face: function(value) {
            this._face = value;
            return this;
        }
    });
    createEffect("pageturn", {
        directions: [ "horizontal", "vertical" ],
        init: function(element, direction, face, back) {
            Effect.prototype.init.call(this, element, direction);
            this.options = {};
            this.options.face = face;
            this.options.back = back;
        },
        children: function() {
            var that = this, options = that.options, direction = that._direction === "horizontal" ? "left" : "top", reverseDirection = kendo.directions[direction].reverse, reverse = that._reverse, temp, faceClone = options.face.clone(true).removeAttr("id"), backClone = options.back.clone(true).removeAttr("id"), element = that.element;
            if (reverse) {
                temp = direction;
                direction = reverseDirection;
                reverseDirection = temp;
            }
            return [ fx(options.face).staticPage(direction, element).face(true).setReverse(reverse), fx(options.back).staticPage(reverseDirection, element).setReverse(reverse), fx(faceClone).turningPage(direction, element).face(true).clipInHalf(true).temporary(true).setReverse(reverse), fx(backClone).turningPage(reverseDirection, element).clipInHalf(true).temporary(true).setReverse(reverse) ];
        },
        prepare: function(start) {
            start[PERSPECTIVE] = DEFAULT_PERSPECTIVE;
            start.transformStyle = "preserve-3d";
        },
        teardown: function() {
            this.element.find(".temp-pages").remove();
        }
    });
    createEffect("flip", {
        directions: [ "horizontal", "vertical" ],
        init: function(element, direction, face, back) {
            Effect.prototype.init.call(this, element, direction);
            this.options = {};
            this.options.face = face;
            this.options.back = back;
        },
        children: function() {
            var that = this, options = that.options, direction = that._direction === "horizontal" ? "left" : "top", reverseDirection = kendo.directions[direction].reverse, reverse = that._reverse, temp, element = that.element;
            if (reverse) {
                temp = direction;
                direction = reverseDirection;
                reverseDirection = temp;
            }
            return [ fx(options.face).turningPage(direction, element).face(true).setReverse(reverse), fx(options.back).turningPage(reverseDirection, element).setReverse(reverse) ];
        },
        prepare: function(start) {
            start[PERSPECTIVE] = DEFAULT_PERSPECTIVE;
            start.transformStyle = "preserve-3d";
        }
    });
    var animationFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function(callback) {
        setTimeout(callback, 1e3 / 60);
    };
    var Animation = kendo.Class.extend({
        init: function() {
            var that = this;
            that._tickProxy = proxy(that._tick, that);
            that._started = false;
        },
        tick: $.noop,
        done: $.noop,
        onEnd: $.noop,
        onCancel: $.noop,
        start: function() {
            if (!this.done()) {
                this._started = true;
                animationFrame(this._tickProxy);
            }
        },
        cancel: function() {
            this._started = false;
            this.onCancel();
        },
        _tick: function() {
            var that = this;
            if (!that._started) {
                return;
            }
            that.tick();
            if (!that.done()) {
                animationFrame(that._tickProxy);
            } else {
                that._started = false;
                that.onEnd();
            }
        }
    });
    var Transition = Animation.extend({
        init: function(options) {
            var that = this;
            extend(that, options);
            Animation.fn.init.call(that);
        },
        done: function() {
            return this.timePassed() >= this.duration;
        },
        timePassed: function() {
            return Math.min(this.duration, Date.now() - this.startDate);
        },
        moveTo: function(options) {
            var that = this, movable = that.movable;
            that.initial = movable[that.axis];
            that.delta = options.location - that.initial;
            that.duration = options.duration || 300;
            that.tick = that._easeProxy(options.ease);
            that.startDate = Date.now();
            that.start();
        },
        _easeProxy: function(ease) {
            var that = this;
            return function() {
                that.movable.moveAxis(that.axis, ease(that.timePassed(), that.initial, that.delta, that.duration));
            };
        }
    });
    extend(Transition, {
        easeOutExpo: function(t, b, c, d) {
            return t == d ? b + c : c * (-Math.pow(2, -10 * t / d) + 1) + b;
        },
        easeOutBack: function(t, b, c, d, s) {
            s = 1.70158;
            return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
        }
    });
    fx.Animation = Animation;
    fx.Transition = Transition;
    fx.createEffect = createEffect;
    fx.Effects = Effects;
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, extend = $.extend, odataFilters = {
        eq: "eq",
        neq: "ne",
        gt: "gt",
        gte: "ge",
        lt: "lt",
        lte: "le",
        contains: "substringof",
        doesnotcontain: "substringof",
        endswith: "endswith",
        startswith: "startswith"
    }, mappers = {
        pageSize: $.noop,
        page: $.noop,
        filter: function(params, filter) {
            if (filter) {
                params.$filter = toOdataFilter(filter);
            }
        },
        sort: function(params, orderby) {
            var expr = $.map(orderby, function(value) {
                var order = value.field.replace(/\./g, "/");
                if (value.dir === "desc") {
                    order += " desc";
                }
                return order;
            }).join(",");
            if (expr) {
                params.$orderby = expr;
            }
        },
        skip: function(params, skip) {
            if (skip) {
                params.$skip = skip;
            }
        },
        take: function(params, take) {
            if (take) {
                params.$top = take;
            }
        }
    }, defaultDataType = {
        read: {
            dataType: "jsonp"
        }
    };
    function toOdataFilter(filter) {
        var result = [], logic = filter.logic || "and", idx, length, field, type, format, operator, value, ignoreCase, filters = filter.filters;
        for (idx = 0, length = filters.length; idx < length; idx++) {
            filter = filters[idx];
            field = filter.field;
            value = filter.value;
            operator = filter.operator;
            if (filter.filters) {
                filter = toOdataFilter(filter);
            } else {
                ignoreCase = filter.ignoreCase;
                field = field.replace(/\./g, "/");
                filter = odataFilters[operator];
                if (filter && value !== undefined) {
                    type = $.type(value);
                    if (type === "string") {
                        format = "'{1}'";
                        value = value.replace(/'/g, "''");
                        if (ignoreCase === true) {
                            field = "tolower(" + field + ")";
                        }
                    } else if (type === "date") {
                        format = "datetime'{1:yyyy-MM-ddTHH:mm:ss}'";
                    } else {
                        format = "{1}";
                    }
                    if (filter.length > 3) {
                        if (filter !== "substringof") {
                            format = "{0}({2}," + format + ")";
                        } else {
                            format = "{0}(" + format + ",{2})";
                            if (operator === "doesnotcontain") {
                                format += " eq false";
                            }
                        }
                    } else {
                        format = "{2} {0} " + format;
                    }
                    filter = kendo.format(format, filter, value, field);
                }
            }
            result.push(filter);
        }
        filter = result.join(" " + logic + " ");
        if (result.length > 1) {
            filter = "(" + filter + ")";
        }
        return filter;
    }
    extend(true, kendo.data, {
        schemas: {
            odata: {
                type: "json",
                data: function(data) {
                    return data.d.results || [ data.d ];
                },
                total: "d.__count"
            }
        },
        transports: {
            odata: {
                read: {
                    cache: true,
                    // to prevent jQuery from adding cache buster
                    dataType: "jsonp",
                    jsonp: "$callback"
                },
                update: {
                    cache: true,
                    dataType: "json",
                    contentType: "application/json",
                    // to inform the server the the request body is JSON encoded
                    type: "PUT"
                },
                create: {
                    cache: true,
                    dataType: "json",
                    contentType: "application/json",
                    type: "POST"
                },
                destroy: {
                    cache: true,
                    dataType: "json",
                    type: "DELETE"
                },
                parameterMap: function(options, type) {
                    var params, value, option, dataType;
                    options = options || {};
                    type = type || "read";
                    dataType = (this.options || defaultDataType)[type];
                    dataType = dataType ? dataType.dataType : "json";
                    if (type === "read") {
                        params = {
                            $inlinecount: "allpages"
                        };
                        if (dataType != "json") {
                            params.$format = "json";
                        }
                        for (option in options) {
                            if (mappers[option]) {
                                mappers[option](params, options[option]);
                            } else {
                                params[option] = options[option];
                            }
                        }
                    } else {
                        if (dataType !== "json") {
                            throw new Error("Only json dataType can be used for " + type + " operation.");
                        }
                        if (type !== "destroy") {
                            for (option in options) {
                                value = options[option];
                                if (typeof value === "number") {
                                    options[option] = value + "";
                                }
                            }
                            params = kendo.stringify(options);
                        }
                    }
                    return params;
                }
            }
        }
    });
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, isArray = $.isArray, isPlainObject = $.isPlainObject, map = $.map, each = $.each, extend = $.extend, getter = kendo.getter, Class = kendo.Class;
    var XmlDataReader = Class.extend({
        init: function(options) {
            var that = this, total = options.total, model = options.model, parse = options.parse, errors = options.errors, data = options.data;
            if (model) {
                if (isPlainObject(model)) {
                    if (model.fields) {
                        each(model.fields, function(field, value) {
                            if (isPlainObject(value) && value.field) {
                                value = extend(value, {
                                    field: that.getter(value.field)
                                });
                            } else {
                                value = {
                                    field: that.getter(value)
                                };
                            }
                            model.fields[field] = value;
                        });
                    }
                    var id = model.id;
                    if (id) {
                        var idField = {};
                        idField[that.xpathToMember(id, true)] = {
                            field: that.getter(id)
                        };
                        model.fields = extend(idField, model.fields);
                        model.id = that.xpathToMember(id);
                    }
                    model = kendo.data.Model.define(model);
                }
                that.model = model;
            }
            if (total) {
                if (typeof total == "string") {
                    total = that.getter(total);
                    that.total = function(data) {
                        return parseInt(total(data), 10);
                    };
                } else if (typeof total == "function") {
                    that.total = total;
                }
            }
            if (errors) {
                if (typeof errors == "string") {
                    errors = that.getter(errors);
                    that.errors = function(data) {
                        return errors(data) || null;
                    };
                } else if (typeof errors == "function") {
                    that.errors = errors;
                }
            }
            if (data) {
                if (typeof data == "string") {
                    data = that.xpathToMember(data);
                    that.data = function(value) {
                        var result = that.evaluate(value, data), modelInstance;
                        result = isArray(result) ? result : [ result ];
                        if (that.model && model.fields) {
                            modelInstance = new that.model();
                            return map(result, function(value) {
                                if (value) {
                                    var record = {}, field;
                                    for (field in model.fields) {
                                        record[field] = modelInstance._parse(field, model.fields[field].field(value));
                                    }
                                    return record;
                                }
                            });
                        }
                        return result;
                    };
                } else if (typeof data == "function") {
                    that.data = data;
                }
            }
            if (typeof parse == "function") {
                var xmlParse = that.parse;
                that.parse = function(data) {
                    var xml = parse.call(that, data);
                    return xmlParse.call(that, xml);
                };
            }
        },
        total: function(result) {
            return this.data(result).length;
        },
        errors: function(data) {
            return data ? data.errors : null;
        },
        parseDOM: function(element) {
            var result = {}, parsedNode, node, nodeType, nodeName, member, attribute, attributes = element.attributes, attributeCount = attributes.length, idx;
            for (idx = 0; idx < attributeCount; idx++) {
                attribute = attributes[idx];
                result["@" + attribute.nodeName] = attribute.nodeValue;
            }
            for (node = element.firstChild; node; node = node.nextSibling) {
                nodeType = node.nodeType;
                if (nodeType === 3 || nodeType === 4) {
                    // text nodes or CDATA are stored as #text field
                    result["#text"] = node.nodeValue;
                } else if (nodeType === 1) {
                    // elements are stored as fields
                    parsedNode = this.parseDOM(node);
                    nodeName = node.nodeName;
                    member = result[nodeName];
                    if (isArray(member)) {
                        // elements of same nodeName are stored as array
                        member.push(parsedNode);
                    } else if (member !== undefined) {
                        member = [ member, parsedNode ];
                    } else {
                        member = parsedNode;
                    }
                    result[nodeName] = member;
                }
            }
            return result;
        },
        evaluate: function(value, expression) {
            var members = expression.split("."), member, result, length, intermediateResult, idx;
            while (member = members.shift()) {
                value = value[member];
                if (isArray(value)) {
                    result = [];
                    expression = members.join(".");
                    for (idx = 0, length = value.length; idx < length; idx++) {
                        intermediateResult = this.evaluate(value[idx], expression);
                        intermediateResult = isArray(intermediateResult) ? intermediateResult : [ intermediateResult ];
                        result.push.apply(result, intermediateResult);
                    }
                    return result;
                }
            }
            return value;
        },
        parse: function(xml) {
            var documentElement, tree, result = {};
            documentElement = xml.documentElement || $.parseXML(xml).documentElement;
            tree = this.parseDOM(documentElement);
            result[documentElement.nodeName] = tree;
            return result;
        },
        xpathToMember: function(member, raw) {
            if (!member) {
                return "";
            }
            member = member.replace(/^\//, "").replace(/\//g, ".");
            // replace all "/" with "."
            if (member.indexOf("@") >= 0) {
                // replace @attribute with '["@attribute"]'
                return member.replace(/\.?(@.*)/, raw ? "$1" : '["$1"]');
            }
            if (member.indexOf("text()") >= 0) {
                // replace ".text()" with '["#text"]'
                return member.replace(/(\.?text\(\))/, raw ? "#text" : '["#text"]');
            }
            return member;
        },
        getter: function(member) {
            return getter(this.xpathToMember(member), true);
        }
    });
    $.extend(true, kendo.data, {
        XmlDataReader: XmlDataReader,
        readers: {
            xml: XmlDataReader
        }
    });
})(window.kendo.jQuery);

(function($, undefined) {
    var extend = $.extend, proxy = $.proxy, isFunction = $.isFunction, isPlainObject = $.isPlainObject, isEmptyObject = $.isEmptyObject, isArray = $.isArray, grep = $.grep, ajax = $.ajax, map, each = $.each, noop = $.noop, kendo = window.kendo, Observable = kendo.Observable, Class = kendo.Class, STRING = "string", FUNCTION = "function", CREATE = "create", READ = "read", UPDATE = "update", DESTROY = "destroy", CHANGE = "change", SYNC = "sync", GET = "get", ERROR = "error", REQUESTSTART = "requestStart", PROGRESS = "progress", REQUESTEND = "requestEnd", crud = [ CREATE, READ, UPDATE, DESTROY ], identity = function(o) {
        return o;
    }, getter = kendo.getter, stringify = kendo.stringify, math = Math, push = [].push, join = [].join, pop = [].pop, splice = [].splice, shift = [].shift, slice = [].slice, unshift = [].unshift, toString = {}.toString, stableSort = kendo.support.stableSort, dateRegExp = /^\/Date\((.*?)\)\/$/, newLineRegExp = /(\r+|\n+)/g, quoteRegExp = /(?=['\\])/g;
    var ObservableArray = Observable.extend({
        init: function(array, type) {
            var that = this;
            that.type = type || ObservableObject;
            Observable.fn.init.call(that);
            that.length = array.length;
            that.wrapAll(array, that);
        },
        toJSON: function() {
            var idx, length = this.length, value, json = new Array(length);
            for (idx = 0; idx < length; idx++) {
                value = this[idx];
                if (value instanceof ObservableObject) {
                    value = value.toJSON();
                }
                json[idx] = value;
            }
            return json;
        },
        parent: noop,
        wrapAll: function(source, target) {
            var that = this, idx, length, parent = function() {
                return that;
            };
            target = target || [];
            for (idx = 0, length = source.length; idx < length; idx++) {
                target[idx] = that.wrap(source[idx], parent);
            }
            return target;
        },
        wrap: function(object, parent) {
            var that = this, observable;
            if (object !== null && toString.call(object) === "[object Object]") {
                observable = object instanceof that.type || object instanceof Model;
                if (!observable) {
                    object = object instanceof ObservableObject ? object.toJSON() : object;
                    object = new that.type(object);
                }
                object.parent = parent;
                object.bind(CHANGE, function(e) {
                    that.trigger(CHANGE, {
                        field: e.field,
                        node: e.node,
                        index: e.index,
                        items: e.items || [ this ],
                        action: e.node ? e.action || "itemchange" : "itemchange"
                    });
                });
            }
            return object;
        },
        push: function() {
            var index = this.length, items = this.wrapAll(arguments), result;
            result = push.apply(this, items);
            this.trigger(CHANGE, {
                action: "add",
                index: index,
                items: items
            });
            return result;
        },
        slice: slice,
        join: join,
        pop: function() {
            var length = this.length, result = pop.apply(this);
            if (length) {
                this.trigger(CHANGE, {
                    action: "remove",
                    index: length - 1,
                    items: [ result ]
                });
            }
            return result;
        },
        splice: function(index, howMany, item) {
            var items = this.wrapAll(slice.call(arguments, 2)), result, i, len;
            result = splice.apply(this, [ index, howMany ].concat(items));
            if (result.length) {
                this.trigger(CHANGE, {
                    action: "remove",
                    index: index,
                    items: result
                });
                for (i = 0, len = result.length; i < len; i++) {
                    if (result[i].children) {
                        result[i].unbind(CHANGE);
                    }
                }
            }
            if (item) {
                this.trigger(CHANGE, {
                    action: "add",
                    index: index,
                    items: items
                });
            }
            return result;
        },
        shift: function() {
            var length = this.length, result = shift.apply(this);
            if (length) {
                this.trigger(CHANGE, {
                    action: "remove",
                    index: 0,
                    items: [ result ]
                });
            }
            return result;
        },
        unshift: function() {
            var items = this.wrapAll(arguments), result;
            result = unshift.apply(this, items);
            this.trigger(CHANGE, {
                action: "add",
                index: 0,
                items: items
            });
            return result;
        },
        indexOf: function(item) {
            var that = this, idx, length;
            for (idx = 0, length = that.length; idx < length; idx++) {
                if (that[idx] === item) {
                    return idx;
                }
            }
            return -1;
        },
        forEach: function(callback) {
            var idx = 0, length = this.length;
            for (;idx < length; idx++) {
                callback(this[idx], idx, this);
            }
        },
        map: function(callback) {
            var idx = 0, result = [], length = this.length;
            for (;idx < length; idx++) {
                result[idx] = callback(this[idx], idx, this);
            }
            return result;
        },
        filter: function(callback) {
            var idx = 0, result = [], item, length = this.length;
            for (;idx < length; idx++) {
                item = this[idx];
                if (callback(item, idx, this)) {
                    result[result.length] = item;
                }
            }
            return result;
        },
        find: function(callback) {
            var idx = 0, item, length = this.length;
            for (;idx < length; idx++) {
                item = this[idx];
                if (callback(item, idx, this)) {
                    return item;
                }
            }
        },
        every: function(callback) {
            var idx = 0, item, length = this.length;
            for (;idx < length; idx++) {
                item = this[idx];
                if (!callback(item, idx, this)) {
                    return false;
                }
            }
            return true;
        },
        some: function(callback) {
            var idx = 0, item, length = this.length;
            for (;idx < length; idx++) {
                item = this[idx];
                if (callback(item, idx, this)) {
                    return true;
                }
            }
            return false;
        },
        // non-standard collection methods
        remove: function(item) {
            this.splice(this.indexOf(item), 1);
        }
    });
    function eventHandler(context, type, field, prefix) {
        return function(e) {
            var event = {}, key;
            for (key in e) {
                event[key] = e[key];
            }
            if (prefix) {
                event.field = field + "." + e.field;
            } else {
                event.field = field;
            }
            context.trigger(type, event);
        };
    }
    var ObservableObject = Observable.extend({
        init: function(value) {
            var that = this, member, field, parent = function() {
                return that;
            };
            Observable.fn.init.call(this);
            for (field in value) {
                member = value[field];
                if (field.charAt(0) != "_") {
                    member = that.wrap(member, field, parent);
                }
                that[field] = member;
            }
            that.uid = kendo.guid();
        },
        shouldSerialize: function(field) {
            return this.hasOwnProperty(field) && field !== "_events" && typeof this[field] !== FUNCTION && field !== "uid";
        },
        forEach: function(f) {
            for (var i in this) {
                if (this.shouldSerialize(i)) {
                    f(this[i], i);
                }
            }
        },
        toJSON: function() {
            var result = {}, value, field;
            for (field in this) {
                if (this.shouldSerialize(field)) {
                    value = this[field];
                    if (value instanceof ObservableObject || value instanceof ObservableArray) {
                        value = value.toJSON();
                    }
                    result[field] = value;
                }
            }
            return result;
        },
        get: function(field) {
            var that = this, result;
            that.trigger(GET, {
                field: field
            });
            if (field === "this") {
                result = that;
            } else {
                result = kendo.getter(field, true)(that);
            }
            return result;
        },
        _set: function(field, value) {
            var that = this;
            if (field.indexOf(".")) {
                var paths = field.split("."), path = "";
                while (paths.length > 1) {
                    path += paths.shift();
                    var obj = kendo.getter(path, true)(that);
                    if (obj instanceof ObservableObject) {
                        obj.set(paths.join("."), value);
                        return;
                    }
                    path += ".";
                }
            }
            kendo.setter(field)(that, value);
        },
        set: function(field, value) {
            var that = this, current = kendo.getter(field, true)(that);
            if (current !== value) {
                if (!that.trigger("set", {
                    field: field,
                    value: value
                })) {
                    that._set(field, that.wrap(value, field, function() {
                        return that;
                    }));
                    that.trigger(CHANGE, {
                        field: field
                    });
                }
            }
        },
        parent: noop,
        wrap: function(object, field, parent) {
            var that = this, type = toString.call(object);
            if (object !== null && (type === "[object Object]" || type === "[object Array]")) {
                var isObservableArray = object instanceof ObservableArray;
                var isDataSource = object instanceof DataSource;
                if (type === "[object Object]" && !isDataSource && !isObservableArray) {
                    if (!(object instanceof ObservableObject)) {
                        object = new ObservableObject(object);
                    }
                    if (object.parent() != parent()) {
                        object.bind(GET, eventHandler(that, GET, field, true));
                        object.bind(CHANGE, eventHandler(that, CHANGE, field, true));
                    }
                } else if (type === "[object Array]" || isObservableArray || isDataSource) {
                    if (!isObservableArray && !isDataSource) {
                        object = new ObservableArray(object);
                    }
                    if (object.parent() != parent()) {
                        object.bind(CHANGE, eventHandler(that, CHANGE, field, false));
                    }
                }
                object.parent = parent;
            }
            return object;
        }
    });
    function equal(x, y) {
        if (x === y) {
            return true;
        }
        var xtype = $.type(x), ytype = $.type(y), field;
        if (xtype !== ytype) {
            return false;
        }
        if (xtype === "date") {
            return x.getTime() === y.getTime();
        }
        if (xtype !== "object" && xtype !== "array") {
            return false;
        }
        for (field in x) {
            if (!equal(x[field], y[field])) {
                return false;
            }
        }
        return true;
    }
    var parsers = {
        number: function(value) {
            return kendo.parseFloat(value);
        },
        date: function(value) {
            return kendo.parseDate(value);
        },
        "boolean": function(value) {
            if (typeof value === STRING) {
                return value.toLowerCase() === "true";
            }
            return value != null ? !!value : value;
        },
        string: function(value) {
            return value != null ? value + "" : value;
        },
        "default": function(value) {
            return value;
        }
    };
    var defaultValues = {
        string: "",
        number: 0,
        date: new Date(),
        "boolean": false,
        "default": ""
    };
    function getFieldByName(obj, name) {
        var field, fieldName;
        for (fieldName in obj) {
            field = obj[fieldName];
            if (isPlainObject(field) && field.field && field.field === name) {
                return field;
            } else if (field === name) {
                return field;
            }
        }
        return null;
    }
    var Model = ObservableObject.extend({
        init: function(data) {
            var that = this;
            if (!data || $.isEmptyObject(data)) {
                data = $.extend({}, that.defaults, data);
            }
            ObservableObject.fn.init.call(that, data);
            that.dirty = false;
            if (that.idField) {
                that.id = that.get(that.idField);
                if (that.id === undefined) {
                    that.id = that._defaultId;
                }
            }
        },
        shouldSerialize: function(field) {
            return ObservableObject.fn.shouldSerialize.call(this, field) && field !== "uid" && !(this.idField !== "id" && field === "id") && field !== "dirty" && field !== "_accessors";
        },
        _parse: function(field, value) {
            var that = this, fieldName = field, fields = that.fields || {}, parse;
            field = fields[field];
            if (!field) {
                field = getFieldByName(fields, fieldName);
            }
            if (field) {
                parse = field.parse;
                if (!parse && field.type) {
                    parse = parsers[field.type.toLowerCase()];
                }
            }
            return parse ? parse(value) : value;
        },
        editable: function(field) {
            field = (this.fields || {})[field];
            return field ? field.editable !== false : true;
        },
        set: function(field, value, initiator) {
            var that = this;
            if (that.editable(field)) {
                value = that._parse(field, value);
                if (!equal(value, that.get(field))) {
                    that.dirty = true;
                    ObservableObject.fn.set.call(that, field, value, initiator);
                }
            }
        },
        accept: function(data) {
            var that = this, parent = function() {
                return that;
            }, field;
            for (field in data) {
                that._set(field, that.wrap(data[field], field, parent));
            }
            if (that.idField) {
                that.id = that.get(that.idField);
            }
            that.dirty = false;
        },
        isNew: function() {
            return this.id === this._defaultId;
        }
    });
    Model.define = function(base, options) {
        if (options === undefined) {
            options = base;
            base = Model;
        }
        var model, proto = extend({
            defaults: {}
        }, options), name, field, type, value, idx, length, fields = {}, id = proto.id;
        if (id) {
            proto.idField = id;
        }
        if (proto.id) {
            delete proto.id;
        }
        if (id) {
            proto.defaults[id] = proto._defaultId = "";
        }
        if (toString.call(proto.fields) === "[object Array]") {
            for (idx = 0, length = proto.fields.length; idx < length; idx++) {
                field = proto.fields[idx];
                if (typeof field === STRING) {
                    fields[field] = {};
                } else if (field.field) {
                    fields[field.field] = field;
                }
            }
            proto.fields = fields;
        }
        for (name in proto.fields) {
            field = proto.fields[name];
            type = field.type || "default";
            value = null;
            name = typeof field.field === STRING ? field.field : name;
            if (!field.nullable) {
                value = proto.defaults[name] = field.defaultValue !== undefined ? field.defaultValue : defaultValues[type.toLowerCase()];
            }
            if (options.id === name) {
                proto._defaultId = value;
            }
            proto.defaults[name] = value;
            field.parse = field.parse || parsers[type];
        }
        model = base.extend(proto);
        model.define = function(options) {
            return Model.define(model, options);
        };
        if (proto.fields) {
            model.fields = proto.fields;
            model.idField = proto.idField;
        }
        return model;
    };
    var Comparer = {
        selector: function(field) {
            return isFunction(field) ? field : getter(field);
        },
        asc: function(field) {
            var selector = this.selector(field);
            return function(a, b) {
                a = selector(a);
                b = selector(b);
                if (a == null && b == null) {
                    return 0;
                }
                if (a && !b && a > 0 || b == null) {
                    return 1;
                }
                if (b && !a && b > 0) {
                    return -1;
                }
                return a > b ? 1 : a < b ? -1 : 0;
            };
        },
        desc: function(field) {
            var selector = this.selector(field);
            return function(a, b) {
                a = selector(a);
                b = selector(b);
                if (a == null && b == null) {
                    return 0;
                }
                if (a && !b && a > 0 || b == null) {
                    return -1;
                }
                if (b && !a && b > 0 || a == null) {
                    return 1;
                }
                return a < b ? 1 : a > b ? -1 : 0;
            };
        },
        create: function(descriptor) {
            return this[descriptor.dir.toLowerCase()](descriptor.field);
        },
        combine: function(comparers) {
            return function(a, b) {
                var result = comparers[0](a, b), idx, length;
                for (idx = 1, length = comparers.length; idx < length; idx++) {
                    result = result || comparers[idx](a, b);
                }
                return result;
            };
        }
    };
    var PositionComparer = extend({}, Comparer, {
        asc: function(field) {
            var selector = this.selector(field);
            return function(a, b) {
                var valueA = selector(a);
                var valueB = selector(b);
                if (valueA && valueA.getTime && valueB && valueB.getTime) {
                    valueA = valueA.getTime();
                    valueB = valueB.getTime();
                }
                if (valueA === valueB) {
                    return a.__position - b.__position;
                }
                if (valueB == null) {
                    return 1;
                }
                return valueA > valueB ? 1 : valueA < valueB ? -1 : 0;
            };
        },
        desc: function(field) {
            var selector = this.selector(field);
            return function(a, b) {
                var valueA = selector(a);
                var valueB = selector(b);
                if (valueA && valueA.getTime && valueB && valueB.getTime) {
                    valueA = valueA.getTime();
                    valueB = valueB.getTime();
                }
                if (valueA === valueB) {
                    return a.__position - b.__position;
                }
                return valueA < valueB ? 1 : valueA > valueB ? -1 : 0;
            };
        }
    });
    map = function(array, callback) {
        var idx, length = array.length, result = new Array(length);
        for (idx = 0; idx < length; idx++) {
            result[idx] = callback(array[idx], idx, array);
        }
        return result;
    };
    var operators = function() {
        function quote(value) {
            return value.replace(quoteRegExp, "\\").replace(newLineRegExp, "");
        }
        function operator(op, a, b, ignore) {
            var date;
            if (b != null) {
                if (typeof b === STRING) {
                    b = quote(b);
                    date = dateRegExp.exec(b);
                    if (date) {
                        b = new Date(+date[1]);
                    } else if (ignore) {
                        b = "'" + b.toLowerCase() + "'";
                        a = "(" + a + " || '').toLowerCase()";
                    } else {
                        b = "'" + b + "'";
                    }
                }
                if (b.getTime) {
                    //b looks like a Date
                    a = "(" + a + "?" + a + ".getTime():" + a + ")";
                    b = b.getTime();
                }
            }
            return a + " " + op + " " + b;
        }
        return {
            eq: function(a, b, ignore) {
                return operator("==", a, b, ignore);
            },
            neq: function(a, b, ignore) {
                return operator("!=", a, b, ignore);
            },
            gt: function(a, b, ignore) {
                return operator(">", a, b, ignore);
            },
            gte: function(a, b, ignore) {
                return operator(">=", a, b, ignore);
            },
            lt: function(a, b, ignore) {
                return operator("<", a, b, ignore);
            },
            lte: function(a, b, ignore) {
                return operator("<=", a, b, ignore);
            },
            startswith: function(a, b, ignore) {
                if (ignore) {
                    a = a + ".toLowerCase()";
                    if (b) {
                        b = b.toLowerCase();
                    }
                }
                if (b) {
                    b = quote(b);
                }
                return a + ".lastIndexOf('" + b + "', 0) == 0";
            },
            endswith: function(a, b, ignore) {
                if (ignore) {
                    a = a + ".toLowerCase()";
                    if (b) {
                        b = b.toLowerCase();
                    }
                }
                if (b) {
                    b = quote(b);
                }
                return a + ".indexOf('" + b + "', " + a + ".length - " + (b || "").length + ") >= 0";
            },
            contains: function(a, b, ignore) {
                if (ignore) {
                    a = "(" + a + " || '').toLowerCase()";
                    if (b) {
                        b = b.toLowerCase();
                    }
                }
                if (b) {
                    b = quote(b);
                }
                return a + ".indexOf('" + b + "') >= 0";
            },
            doesnotcontain: function(a, b, ignore) {
                if (ignore) {
                    a = "(" + a + " || '').toLowerCase()";
                    if (b) {
                        b = b.toLowerCase();
                    }
                }
                if (b) {
                    b = quote(b);
                }
                return a + ".indexOf('" + b + "') == -1";
            }
        };
    }();
    function Query(data) {
        this.data = data || [];
    }
    Query.filterExpr = function(expression) {
        var expressions = [], logic = {
            and: " && ",
            or: " || "
        }, idx, length, filter, expr, fieldFunctions = [], operatorFunctions = [], field, operator, filters = expression.filters;
        for (idx = 0, length = filters.length; idx < length; idx++) {
            filter = filters[idx];
            field = filter.field;
            operator = filter.operator;
            if (filter.filters) {
                expr = Query.filterExpr(filter);
                //Nested function fields or operators - update their index e.g. __o[0] -> __o[1]
                filter = expr.expression.replace(/__o\[(\d+)\]/g, function(match, index) {
                    index = +index;
                    return "__o[" + (operatorFunctions.length + index) + "]";
                }).replace(/__f\[(\d+)\]/g, function(match, index) {
                    index = +index;
                    return "__f[" + (fieldFunctions.length + index) + "]";
                });
                operatorFunctions.push.apply(operatorFunctions, expr.operators);
                fieldFunctions.push.apply(fieldFunctions, expr.fields);
            } else {
                if (typeof field === FUNCTION) {
                    expr = "__f[" + fieldFunctions.length + "](d)";
                    fieldFunctions.push(field);
                } else {
                    expr = kendo.expr(field);
                }
                if (typeof operator === FUNCTION) {
                    filter = "__o[" + operatorFunctions.length + "](" + expr + ", " + filter.value + ")";
                    operatorFunctions.push(operator);
                } else {
                    filter = operators[(operator || "eq").toLowerCase()](expr, filter.value, filter.ignoreCase !== undefined ? filter.ignoreCase : true);
                }
            }
            expressions.push(filter);
        }
        return {
            expression: "(" + expressions.join(logic[expression.logic]) + ")",
            fields: fieldFunctions,
            operators: operatorFunctions
        };
    };
    function normalizeSort(field, dir) {
        if (field) {
            var descriptor = typeof field === STRING ? {
                field: field,
                dir: dir
            } : field, descriptors = isArray(descriptor) ? descriptor : descriptor !== undefined ? [ descriptor ] : [];
            return grep(descriptors, function(d) {
                return !!d.dir;
            });
        }
    }
    var operatorMap = {
        "==": "eq",
        equals: "eq",
        isequalto: "eq",
        equalto: "eq",
        equal: "eq",
        "!=": "neq",
        ne: "neq",
        notequals: "neq",
        isnotequalto: "neq",
        notequalto: "neq",
        notequal: "neq",
        "<": "lt",
        islessthan: "lt",
        lessthan: "lt",
        less: "lt",
        "<=": "lte",
        le: "lte",
        islessthanorequalto: "lte",
        lessthanequal: "lte",
        ">": "gt",
        isgreaterthan: "gt",
        greaterthan: "gt",
        greater: "gt",
        ">=": "gte",
        isgreaterthanorequalto: "gte",
        greaterthanequal: "gte",
        ge: "gte",
        notsubstringof: "doesnotcontain"
    };
    function normalizeOperator(expression) {
        var idx, length, filter, operator, filters = expression.filters;
        if (filters) {
            for (idx = 0, length = filters.length; idx < length; idx++) {
                filter = filters[idx];
                operator = filter.operator;
                if (operator && typeof operator === STRING) {
                    filter.operator = operatorMap[operator.toLowerCase()] || operator;
                }
                normalizeOperator(filter);
            }
        }
    }
    function normalizeFilter(expression) {
        if (expression && !isEmptyObject(expression)) {
            if (isArray(expression) || !expression.filters) {
                expression = {
                    logic: "and",
                    filters: isArray(expression) ? expression : [ expression ]
                };
            }
            normalizeOperator(expression);
            return expression;
        }
    }
    Query.normalizeFilter = normalizeFilter;
    function normalizeAggregate(expressions) {
        return isArray(expressions) ? expressions : [ expressions ];
    }
    function normalizeGroup(field, dir) {
        var descriptor = typeof field === STRING ? {
            field: field,
            dir: dir
        } : field, descriptors = isArray(descriptor) ? descriptor : descriptor !== undefined ? [ descriptor ] : [];
        return map(descriptors, function(d) {
            return {
                field: d.field,
                dir: d.dir || "asc",
                aggregates: d.aggregates
            };
        });
    }
    Query.prototype = {
        toArray: function() {
            return this.data;
        },
        range: function(index, count) {
            return new Query(this.data.slice(index, index + count));
        },
        skip: function(count) {
            return new Query(this.data.slice(count));
        },
        take: function(count) {
            return new Query(this.data.slice(0, count));
        },
        select: function(selector) {
            return new Query(map(this.data, selector));
        },
        orderBy: function(selector) {
            var result = this.data.slice(0), comparer = isFunction(selector) || !selector ? Comparer.asc(selector) : selector.compare;
            return new Query(result.sort(comparer));
        },
        orderByDescending: function(selector) {
            return new Query(this.data.slice(0).sort(Comparer.desc(selector)));
        },
        sort: function(field, dir, comparer) {
            var idx, length, descriptors = normalizeSort(field, dir), comparers = [];
            comparer = comparer || Comparer;
            if (descriptors.length) {
                for (idx = 0, length = descriptors.length; idx < length; idx++) {
                    comparers.push(comparer.create(descriptors[idx]));
                }
                return this.orderBy({
                    compare: comparer.combine(comparers)
                });
            }
            return this;
        },
        filter: function(expressions) {
            var idx, current, length, compiled, predicate, data = this.data, fields, operators, result = [], filter;
            expressions = normalizeFilter(expressions);
            if (!expressions || expressions.filters.length === 0) {
                return this;
            }
            compiled = Query.filterExpr(expressions);
            fields = compiled.fields;
            operators = compiled.operators;
            predicate = filter = new Function("d, __f, __o", "return " + compiled.expression);
            if (fields.length || operators.length) {
                filter = function(d) {
                    return predicate(d, fields, operators);
                };
            }
            for (idx = 0, length = data.length; idx < length; idx++) {
                current = data[idx];
                if (filter(current)) {
                    result.push(current);
                }
            }
            return new Query(result);
        },
        group: function(descriptors, allData) {
            descriptors = normalizeGroup(descriptors || []);
            allData = allData || this.data;
            var that = this, result = new Query(that.data), descriptor;
            if (descriptors.length > 0) {
                descriptor = descriptors[0];
                result = result.groupBy(descriptor).select(function(group) {
                    var data = new Query(allData).filter([ {
                        field: group.field,
                        operator: "eq",
                        value: group.value
                    } ]);
                    return {
                        field: group.field,
                        value: group.value,
                        items: descriptors.length > 1 ? new Query(group.items).group(descriptors.slice(1), data.toArray()).toArray() : group.items,
                        hasSubgroups: descriptors.length > 1,
                        aggregates: data.aggregate(descriptor.aggregates)
                    };
                });
            }
            return result;
        },
        groupBy: function(descriptor) {
            if (isEmptyObject(descriptor) || !this.data.length) {
                return new Query([]);
            }
            var field = descriptor.field, sorted = this._sortForGrouping(field, descriptor.dir || "asc"), accessor = kendo.accessor(field), item, groupValue = accessor.get(sorted[0], field), group = {
                field: field,
                value: groupValue,
                items: []
            }, currentValue, idx, len, result = [ group ];
            for (idx = 0, len = sorted.length; idx < len; idx++) {
                item = sorted[idx];
                currentValue = accessor.get(item, field);
                if (!groupValueComparer(groupValue, currentValue)) {
                    groupValue = currentValue;
                    group = {
                        field: field,
                        value: groupValue,
                        items: []
                    };
                    result.push(group);
                }
                group.items.push(item);
            }
            return new Query(result);
        },
        _sortForGrouping: function(field, dir) {
            var idx, length, data = this.data;
            if (!stableSort) {
                for (idx = 0, length = data.length; idx < length; idx++) {
                    data[idx].__position = idx;
                }
                data = new Query(data).sort(field, dir, PositionComparer).toArray();
                for (idx = 0, length = data.length; idx < length; idx++) {
                    delete data[idx].__position;
                }
                return data;
            }
            return this.sort(field, dir).toArray();
        },
        aggregate: function(aggregates) {
            var idx, len, result = {};
            if (aggregates && aggregates.length) {
                for (idx = 0, len = this.data.length; idx < len; idx++) {
                    calculateAggregate(result, aggregates, this.data[idx], idx, len);
                }
            }
            return result;
        }
    };
    function groupValueComparer(a, b) {
        if (a && a.getTime && b && b.getTime) {
            return a.getTime() === b.getTime();
        }
        return a === b;
    }
    function calculateAggregate(accumulator, aggregates, item, index, length) {
        aggregates = aggregates || [];
        var idx, aggr, functionName, len = aggregates.length;
        for (idx = 0; idx < len; idx++) {
            aggr = aggregates[idx];
            functionName = aggr.aggregate;
            var field = aggr.field;
            accumulator[field] = accumulator[field] || {};
            accumulator[field][functionName] = functions[functionName.toLowerCase()](accumulator[field][functionName], item, kendo.accessor(field), index, length);
        }
    }
    var functions = {
        sum: function(accumulator, item, accessor) {
            return (accumulator || 0) + accessor.get(item);
        },
        count: function(accumulator) {
            return (accumulator || 0) + 1;
        },
        average: function(accumulator, item, accessor, index, length) {
            accumulator = (accumulator || 0) + accessor.get(item);
            if (index == length - 1) {
                accumulator = accumulator / length;
            }
            return accumulator;
        },
        max: function(accumulator, item, accessor) {
            var value = accessor.get(item);
            accumulator = accumulator || 0;
            if (accumulator < value) {
                accumulator = value;
            }
            return accumulator;
        },
        min: function(accumulator, item, accessor) {
            var value = accessor.get(item);
            accumulator = accumulator || value;
            if (accumulator > value) {
                accumulator = value;
            }
            return accumulator;
        }
    };
    function toJSON(array) {
        var idx, length = array.length, result = new Array(length);
        for (idx = 0; idx < length; idx++) {
            result[idx] = array[idx].toJSON();
        }
        return result;
    }
    Query.process = function(data, options) {
        options = options || {};
        var query = new Query(data), group = options.group, sort = normalizeGroup(group || []).concat(normalizeSort(options.sort || [])), total, filter = options.filter, skip = options.skip, take = options.take;
        if (filter) {
            query = query.filter(filter);
            total = query.toArray().length;
        }
        if (sort) {
            query = query.sort(sort);
            if (group) {
                data = query.toArray();
            }
        }
        if (skip !== undefined && take !== undefined) {
            query = query.range(skip, take);
        }
        if (group) {
            query = query.group(group, data);
        }
        return {
            total: total,
            data: query.toArray()
        };
    };
    function calculateAggregates(data, options) {
        options = options || {};
        var query = new Query(data), aggregates = options.aggregate, filter = options.filter;
        if (filter) {
            query = query.filter(filter);
        }
        return query.aggregate(aggregates);
    }
    var LocalTransport = Class.extend({
        init: function(options) {
            this.data = options.data;
        },
        read: function(options) {
            options.success(this.data);
        },
        update: function(options) {
            options.success(options.data);
        },
        create: function(options) {
            options.success(options.data);
        },
        destroy: function(options) {
            options.success(options.data);
        }
    });
    var RemoteTransport = Class.extend({
        init: function(options) {
            var that = this, parameterMap;
            options = that.options = extend({}, that.options, options);
            each(crud, function(index, type) {
                if (typeof options[type] === STRING) {
                    options[type] = {
                        url: options[type]
                    };
                }
            });
            that.cache = options.cache ? Cache.create(options.cache) : {
                find: noop,
                add: noop
            };
            parameterMap = options.parameterMap;
            that.parameterMap = isFunction(parameterMap) ? parameterMap : function(options) {
                var result = {};
                each(options, function(option, value) {
                    if (option in parameterMap) {
                        option = parameterMap[option];
                        if (isPlainObject(option)) {
                            value = option.value(value);
                            option = option.key;
                        }
                    }
                    result[option] = value;
                });
                return result;
            };
        },
        options: {
            parameterMap: identity
        },
        create: function(options) {
            return ajax(this.setup(options, CREATE));
        },
        read: function(options) {
            var that = this, success, error, result, cache = that.cache;
            options = that.setup(options, READ);
            success = options.success || noop;
            error = options.error || noop;
            result = cache.find(options.data);
            if (result !== undefined) {
                success(result);
            } else {
                options.success = function(result) {
                    cache.add(options.data, result);
                    success(result);
                };
                $.ajax(options);
            }
        },
        update: function(options) {
            return ajax(this.setup(options, UPDATE));
        },
        destroy: function(options) {
            return ajax(this.setup(options, DESTROY));
        },
        setup: function(options, type) {
            options = options || {};
            var that = this, parameters, operation = that.options[type], data = isFunction(operation.data) ? operation.data(options.data) : operation.data;
            options = extend(true, {}, operation, options);
            parameters = extend(true, {}, data, options.data);
            options.data = that.parameterMap(parameters, type);
            if (isFunction(options.url)) {
                options.url = options.url(parameters);
            }
            return options;
        }
    });
    var Cache = Class.extend({
        init: function() {
            this._store = {};
        },
        add: function(key, data) {
            if (key !== undefined) {
                this._store[stringify(key)] = data;
            }
        },
        find: function(key) {
            return this._store[stringify(key)];
        },
        clear: function() {
            this._store = {};
        },
        remove: function(key) {
            delete this._store[stringify(key)];
        }
    });
    Cache.create = function(options) {
        var store = {
            inmemory: function() {
                return new Cache();
            }
        };
        if (isPlainObject(options) && isFunction(options.find)) {
            return options;
        }
        if (options === true) {
            return new Cache();
        }
        return store[options]();
    };
    function convertRecords(data, getters, modelInstance) {
        var record, getter, idx, length;
        for (idx = 0, length = data.length; idx < length; idx++) {
            record = data[idx];
            for (getter in getters) {
                record[getter] = modelInstance._parse(getter, getters[getter](record));
            }
        }
    }
    function convertGroup(data, getters, modelInstance) {
        var record, idx, length;
        for (idx = 0, length = data.length; idx < length; idx++) {
            record = data[idx];
            record.value = modelInstance._parse(record.field, record.value);
            if (record.hasSubgroups) {
                convertGroup(record.items, getters, modelInstance);
            } else {
                convertRecords(record.items, getters, modelInstance);
            }
        }
    }
    function wrapDataAccess(originalFunction, model, converter, getters) {
        return function(data) {
            data = originalFunction(data);
            if (data && !isEmptyObject(getters)) {
                if (toString.call(data) !== "[object Array]" && !(data instanceof ObservableArray)) {
                    data = [ data ];
                }
                converter(data, getters, new model());
            }
            return data || [];
        };
    }
    var DataReader = Class.extend({
        init: function(schema) {
            var that = this, member, get, model, base;
            schema = schema || {};
            for (member in schema) {
                get = schema[member];
                that[member] = typeof get === STRING ? getter(get) : get;
            }
            base = schema.modelBase || Model;
            if (isPlainObject(that.model)) {
                that.model = model = base.define(that.model);
            }
            if (that.model) {
                var dataFunction = proxy(that.data, that), groupsFunction = proxy(that.groups, that), getters = {};
                model = that.model;
                if (model.fields) {
                    each(model.fields, function(field, value) {
                        if (isPlainObject(value) && value.field) {
                            getters[value.field] = getter(value.field);
                        } else {
                            getters[field] = getter(field);
                        }
                    });
                }
                that.data = wrapDataAccess(dataFunction, model, convertRecords, getters);
                that.groups = wrapDataAccess(groupsFunction, model, convertGroup, getters);
            }
        },
        errors: function(data) {
            return data ? data.errors : null;
        },
        parse: identity,
        data: identity,
        total: function(data) {
            return data.length;
        },
        groups: identity,
        status: function(data) {
            return data.status;
        },
        aggregates: function() {
            return {};
        }
    });
    function mergeGroups(target, dest, start, count) {
        var group, idx = 0, items;
        while (dest.length && count) {
            group = dest[idx];
            items = group.items;
            if (target && target.field === group.field && target.value === group.value) {
                if (target.hasSubgroups && target.items.length) {
                    mergeGroups(target.items[target.items.length - 1], group.items, start, count);
                } else {
                    items = items.slice(start, count);
                    count -= items.length;
                    target.items = target.items.concat(items);
                }
                dest.splice(idx--, 1);
            } else {
                items = items.slice(start, count);
                count -= items.length;
                group.items = items;
                if (!group.items.length) {
                    dest.splice(idx--, 1);
                }
            }
            start = 0;
            if (++idx >= dest.length) {
                break;
            }
        }
    }
    function flattenGroups(data) {
        var idx, length, result = [];
        for (idx = 0, length = data.length; idx < length; idx++) {
            if (data[idx].hasSubgroups) {
                result = result.concat(flattenGroups(data[idx].items));
            } else {
                result = result.concat(data[idx].items.slice());
            }
        }
        return result;
    }
    function wrapGroupItems(data, model) {
        var idx, length, group, items;
        if (model) {
            for (idx = 0, length = data.length; idx < length; idx++) {
                group = data[idx];
                items = group.items;
                if (group.hasSubgroups) {
                    wrapGroupItems(items, model);
                } else if (items.length && !(items[0] instanceof model)) {
                    items.type = model;
                    items.wrapAll(items, items);
                }
            }
        }
    }
    function eachGroupItems(data, func) {
        var idx, length;
        for (idx = 0, length = data.length; idx < length; idx++) {
            if (data[idx].hasSubgroups) {
                if (eachGroupItems(data[idx].items, func)) {
                    return true;
                }
            } else if (func(data[idx].items, data[idx])) {
                return true;
            }
        }
    }
    function removeModel(data, model) {
        var idx, length;
        for (idx = 0, length = data.length; idx < length; idx++) {
            if (data[idx].uid == model.uid) {
                model = data[idx];
                data.splice(idx, 1);
                return model;
            }
        }
    }
    function wrapInEmptyGroup(groups, model) {
        var parent, group, idx, length;
        for (idx = groups.length - 1, length = 0; idx >= length; idx--) {
            group = groups[idx];
            parent = {
                value: model.get(group.field),
                field: group.field,
                items: parent ? [ parent ] : [ model ],
                hasSubgroups: !!parent,
                aggregates: {}
            };
        }
        return parent;
    }
    function indexOfPristineModel(data, model) {
        if (model) {
            return indexOf(data, function(item) {
                return item[model.idField] === model.id;
            });
        }
        return -1;
    }
    function indexOfModel(data, model) {
        if (model) {
            return indexOf(data, function(item) {
                return item.uid == model.uid;
            });
        }
        return -1;
    }
    function indexOf(data, comparer) {
        var idx, length;
        for (idx = 0, length = data.length; idx < length; idx++) {
            if (comparer(data[idx])) {
                return idx;
            }
        }
        return -1;
    }
    var DataSource = Observable.extend({
        init: function(options) {
            var that = this, model, data;
            if (options) {
                data = options.data;
            }
            options = that.options = extend({}, that.options, options);
            that._map = {};
            that._prefetch = {};
            that._data = [];
            that._ranges = [];
            that._view = [];
            that._pristine = [];
            that._destroyed = [];
            that._pageSize = options.pageSize;
            that._page = options.page || (options.pageSize ? 1 : undefined);
            that._sort = normalizeSort(options.sort);
            that._filter = normalizeFilter(options.filter);
            that._group = normalizeGroup(options.group);
            that._aggregate = options.aggregate;
            that._total = options.total;
            Observable.fn.init.call(that);
            that.transport = Transport.create(options, data);
            that.reader = new kendo.data.readers[options.schema.type || "json"](options.schema);
            model = that.reader.model || {};
            that._data = that._observe(that._data);
            that.bind([ ERROR, CHANGE, REQUESTSTART, SYNC, REQUESTEND, PROGRESS ], options);
        },
        options: {
            data: [],
            schema: {
                modelBase: Model
            },
            serverSorting: false,
            serverPaging: false,
            serverFiltering: false,
            serverGrouping: false,
            serverAggregates: false,
            batch: false
        },
        _isServerGrouped: function() {
            var group = this.group() || [];
            return this.options.serverGrouping && group.length;
        },
        _flatData: function(data) {
            if (this._isServerGrouped()) {
                return flattenGroups(data);
            }
            return data;
        },
        parent: noop,
        get: function(id) {
            var idx, length, data = this._flatData(this._data);
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx].id == id) {
                    return data[idx];
                }
            }
        },
        getByUid: function(id) {
            var idx, length, data = this._flatData(this._data);
            if (!data) {
                return;
            }
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx].uid == id) {
                    return data[idx];
                }
            }
        },
        indexOf: function(model) {
            return indexOfModel(this._data, model);
        },
        at: function(index) {
            return this._data[index];
        },
        data: function(value) {
            var that = this;
            if (value !== undefined) {
                that._data = this._observe(value);
                that._ranges = [];
                that._addRange(that._data);
                that._total = that._data.length;
                that._process(that._data);
            } else {
                return that._data;
            }
        },
        view: function() {
            return this._view;
        },
        add: function(model) {
            return this.insert(this._data.length, model);
        },
        insert: function(index, model) {
            if (!model) {
                model = index;
                index = 0;
            }
            if (!(model instanceof Model)) {
                if (this.reader.model) {
                    model = new this.reader.model(model);
                } else {
                    model = new ObservableObject(model);
                }
            }
            if (this._isServerGrouped()) {
                this._data.splice(index, 0, wrapInEmptyGroup(this.group(), model));
            } else {
                this._data.splice(index, 0, model);
            }
            return model;
        },
        remove: function(model) {
            var result, that = this, hasGroups = that._isServerGrouped();
            this._eachItem(that._data, function(items) {
                result = removeModel(items, model);
                if (result && hasGroups) {
                    if (!result.isNew || !result.isNew()) {
                        that._destroyed.push(result);
                    }
                    return true;
                }
            });
            return model;
        },
        sync: function() {
            var that = this, idx, length, created = [], updated = [], destroyed = that._destroyed, data = that._flatData(that._data);
            if (!that.reader.model) {
                return;
            }
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx].isNew()) {
                    created.push(data[idx]);
                } else if (data[idx].dirty) {
                    updated.push(data[idx]);
                }
            }
            var promises = that._send("create", created);
            promises.push.apply(promises, that._send("update", updated));
            promises.push.apply(promises, that._send("destroy", destroyed));
            $.when.apply(null, promises).then(function() {
                var idx, length;
                for (idx = 0, length = arguments.length; idx < length; idx++) {
                    that._accept(arguments[idx]);
                }
                that._change({
                    action: "sync"
                });
                that.trigger(SYNC);
            });
        },
        cancelChanges: function(model) {
            var that = this, pristine = that._readData(that._pristine);
            if (model instanceof kendo.data.Model) {
                that._cancelModel(model);
            } else {
                that._destroyed = [];
                that._data = that._observe(pristine);
                if (that.options.serverPaging) {
                    that._total = that.reader.total(that._pristine);
                }
                that._change();
            }
        },
        hasChanges: function() {
            var idx, length, data = this._data;
            if (this._destroyed.length) {
                return true;
            }
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx].isNew() || data[idx].dirty) {
                    return true;
                }
            }
            return false;
        },
        _accept: function(result) {
            var that = this, models = result.models, response = result.response, idx = 0, serverGroup = that._isServerGrouped(), pristine = that._readData(that._pristine), type = result.type, length;
            that.trigger(REQUESTEND, {
                response: response,
                type: type
            });
            if (response) {
                response = that.reader.parse(response);
                if (that._handleCustomErrors(response)) {
                    return;
                }
                response = that.reader.data(response);
                if (!$.isArray(response)) {
                    response = [ response ];
                }
            } else {
                response = $.map(models, function(model) {
                    return model.toJSON();
                });
            }
            if (type === "destroy") {
                that._destroyed = [];
            }
            for (idx = 0, length = models.length; idx < length; idx++) {
                if (type !== "destroy") {
                    models[idx].accept(response[idx]);
                    if (type === "create") {
                        pristine.push(serverGroup ? wrapInEmptyGroup(that.group(), models[idx]) : response[idx]);
                    } else if (type === "update") {
                        that._updatePristineForModel(models[idx], response[idx]);
                    }
                } else {
                    that._removePristineForModel(models[idx]);
                }
            }
        },
        _updatePristineForModel: function(model, values) {
            this._executeOnPristineForModel(model, function(index, items) {
                extend(true, items[index], values);
            });
        },
        _executeOnPristineForModel: function(model, callback) {
            this._eachPristineItem(function(items) {
                var index = indexOfPristineModel(items, model);
                if (index > -1) {
                    callback(index, items);
                    return true;
                }
            });
        },
        _removePristineForModel: function(model) {
            this._executeOnPristineForModel(model, function(index, items) {
                items.splice(index, 1);
            });
        },
        _readData: function(data) {
            var read = !this._isServerGrouped() ? this.reader.data : this.reader.groups;
            return read(data);
        },
        _eachPristineItem: function(callback) {
            this._eachItem(this._readData(this._pristine), callback);
        },
        _eachItem: function(data, callback) {
            if (data && data.length) {
                if (this._isServerGrouped()) {
                    eachGroupItems(data, callback);
                } else {
                    callback(data);
                }
            }
        },
        _pristineForModel: function(model) {
            var pristine, idx, callback = function(items) {
                idx = indexOfPristineModel(items, model);
                if (idx > -1) {
                    pristine = items[idx];
                    return true;
                }
            };
            this._eachPristineItem(callback);
            return pristine;
        },
        _cancelModel: function(model) {
            var pristine = this._pristineForModel(model), idx;
            this._eachItem(this._data, function(items) {
                idx = indexOfModel(items, model);
                if (idx != -1) {
                    if (!model.isNew() && pristine) {
                        items[idx].accept(pristine);
                    } else {
                        items.splice(idx, 1);
                    }
                }
            });
        },
        _promise: function(data, models, type) {
            var that = this, transport = that.transport;
            return $.Deferred(function(deferred) {
                transport[type].call(transport, extend({
                    success: function(response) {
                        deferred.resolve({
                            response: response,
                            models: models,
                            type: type
                        });
                    },
                    error: function(response, status, error) {
                        deferred.reject(response);
                        that.error(response, status, error);
                    }
                }, data));
            }).promise();
        },
        _send: function(method, data) {
            var that = this, idx, length, promises = [];
            if (that.options.batch) {
                if (data.length) {
                    promises.push(that._promise({
                        data: {
                            models: toJSON(data)
                        }
                    }, data, method));
                }
            } else {
                for (idx = 0, length = data.length; idx < length; idx++) {
                    promises.push(that._promise({
                        data: data[idx].toJSON()
                    }, [ data[idx] ], method));
                }
            }
            return promises;
        },
        read: function(data) {
            var that = this, params = that._params(data);
            that._queueRequest(params, function() {
                if (!that.trigger(REQUESTSTART)) {
                    that.trigger(PROGRESS);
                    that._ranges = [];
                    that.transport.read({
                        data: params,
                        success: proxy(that.success, that),
                        error: proxy(that.error, that)
                    });
                } else {
                    that._dequeueRequest();
                }
            });
        },
        success: function(data) {
            var that = this, options = that.options;
            that.trigger(REQUESTEND, {
                response: data,
                type: "read"
            });
            data = that.reader.parse(data);
            if (that._handleCustomErrors(data)) {
                that._dequeueRequest();
                return;
            }
            that._pristine = isPlainObject(data) ? $.extend(true, {}, data) : data.slice ? data.slice(0) : data;
            that._total = that.reader.total(data);
            if (that._aggregate && options.serverAggregates) {
                that._aggregateResult = that.reader.aggregates(data);
            }
            data = that._readData(data);
            that._data = that._observe(data);
            that._addRange(that._data);
            that._dequeueRequest();
            that._process(that._data);
        },
        _addRange: function(data) {
            var that = this, start = that._skip || 0, end = start + that._flatData(data).length;
            that._ranges.push({
                start: start,
                end: end,
                data: data
            });
            that._ranges.sort(function(x, y) {
                return x.start - y.start;
            });
        },
        error: function(xhr, status, errorThrown) {
            this._dequeueRequest();
            this.trigger(REQUESTEND, {});
            this.trigger(ERROR, {
                xhr: xhr,
                status: status,
                errorThrown: errorThrown
            });
        },
        _params: function(data) {
            var that = this, options = extend({
                take: that.take(),
                skip: that.skip(),
                page: that.page(),
                pageSize: that.pageSize(),
                sort: that._sort,
                filter: that._filter,
                group: that._group,
                aggregate: that._aggregate
            }, data);
            if (!that.options.serverPaging) {
                delete options.take;
                delete options.skip;
                delete options.page;
                delete options.pageSize;
            }
            if (!that.options.serverGrouping) {
                delete options.group;
            }
            if (!that.options.serverFiltering) {
                delete options.filter;
            }
            if (!that.options.serverSorting) {
                delete options.sort;
            }
            if (!that.options.serverAggregates) {
                delete options.aggregate;
            }
            return options;
        },
        _queueRequest: function(options, callback) {
            var that = this;
            if (!that._requestInProgress) {
                that._requestInProgress = true;
                that._pending = undefined;
                callback();
            } else {
                that._pending = {
                    callback: proxy(callback, that),
                    options: options
                };
            }
        },
        _dequeueRequest: function() {
            var that = this;
            that._requestInProgress = false;
            if (that._pending) {
                that._queueRequest(that._pending.options, that._pending.callback);
            }
        },
        _handleCustomErrors: function(response) {
            if (this.reader.errors) {
                var errors = this.reader.errors(response);
                if (errors) {
                    this.trigger(ERROR, {
                        xhr: null,
                        status: "customerror",
                        errorThrown: "custom error",
                        errors: errors
                    });
                    return true;
                }
            }
            return false;
        },
        _observe: function(data) {
            var that = this, model = that.reader.model, wrap = false;
            if (model && data.length) {
                wrap = !(data[0] instanceof model);
            }
            if (data instanceof ObservableArray) {
                if (wrap) {
                    data.type = that.reader.model;
                    data.wrapAll(data, data);
                }
            } else {
                data = new ObservableArray(data, that.reader.model);
                data.parent = function() {
                    return that.parent();
                };
            }
            if (that._isServerGrouped()) {
                wrapGroupItems(data, model);
            }
            return data.bind(CHANGE, proxy(that._change, that));
        },
        _change: function(e) {
            var that = this, idx, length, action = e ? e.action : "";
            if (action === "remove") {
                for (idx = 0, length = e.items.length; idx < length; idx++) {
                    if (!e.items[idx].isNew || !e.items[idx].isNew()) {
                        that._destroyed.push(e.items[idx]);
                    }
                }
            }
            if (that.options.autoSync && (action === "add" || action === "remove" || action === "itemchange")) {
                that.sync();
            } else {
                var total = that._total || that.reader.total(that._pristine);
                if (action === "add") {
                    total++;
                } else if (action === "remove") {
                    total--;
                } else if (action !== "itemchange" && action !== "sync" && !that.options.serverPaging) {
                    total = that.reader.total(that._pristine);
                }
                that._total = total;
                that._process(that._data, e);
            }
        },
        _process: function(data, e) {
            var that = this, options = {}, result;
            if (that.options.serverPaging !== true) {
                options.skip = that._skip;
                options.take = that._take || that._pageSize;
                if (options.skip === undefined && that._page !== undefined && that._pageSize !== undefined) {
                    options.skip = (that._page - 1) * that._pageSize;
                }
            }
            if (that.options.serverSorting !== true) {
                options.sort = that._sort;
            }
            if (that.options.serverFiltering !== true) {
                options.filter = that._filter;
            }
            if (that.options.serverGrouping !== true) {
                options.group = that._group;
            }
            if (that.options.serverAggregates !== true) {
                options.aggregate = that._aggregate;
                that._aggregateResult = calculateAggregates(data, options);
            }
            result = Query.process(data, options);
            that._view = result.data;
            if (result.total !== undefined && !that.options.serverFiltering) {
                that._total = result.total;
            }
            e = e || {};
            e.items = e.items || that._view;
            that.trigger(CHANGE, e);
        },
        _mergeState: function(options) {
            var that = this;
            if (options !== undefined) {
                that._pageSize = options.pageSize;
                that._page = options.page;
                that._sort = options.sort;
                that._filter = options.filter;
                that._group = options.group;
                that._aggregate = options.aggregate;
                that._skip = options.skip;
                that._take = options.take;
                if (that._skip === undefined) {
                    that._skip = that.skip();
                    options.skip = that.skip();
                }
                if (that._take === undefined && that._pageSize !== undefined) {
                    that._take = that._pageSize;
                    options.take = that._take;
                }
                if (options.sort) {
                    that._sort = options.sort = normalizeSort(options.sort);
                }
                if (options.filter) {
                    that._filter = options.filter = normalizeFilter(options.filter);
                }
                if (options.group) {
                    that._group = options.group = normalizeGroup(options.group);
                }
                if (options.aggregate) {
                    that._aggregate = options.aggregate = normalizeAggregate(options.aggregate);
                }
            }
            return options;
        },
        query: function(options) {
            var that = this, result, remote = that.options.serverSorting || that.options.serverPaging || that.options.serverFiltering || that.options.serverGrouping || that.options.serverAggregates;
            if (remote || that._data === undefined || that._data.length === 0) {
                that.read(that._mergeState(options));
            } else {
                if (!that.trigger(REQUESTSTART)) {
                    that.trigger(PROGRESS);
                    result = Query.process(that._data, that._mergeState(options));
                    if (!that.options.serverFiltering) {
                        if (result.total !== undefined) {
                            that._total = result.total;
                        } else {
                            that._total = that._data.length;
                        }
                    }
                    that._view = result.data;
                    that._aggregateResult = calculateAggregates(that._data, options);
                    that.trigger(REQUESTEND, {});
                    that.trigger(CHANGE, {
                        items: result.data
                    });
                }
            }
        },
        fetch: function(callback) {
            var that = this;
            if (callback && isFunction(callback)) {
                that.one(CHANGE, callback);
            }
            that._query();
        },
        _query: function(options) {
            var that = this;
            that.query(extend({}, {
                page: that.page(),
                pageSize: that.pageSize(),
                sort: that.sort(),
                filter: that.filter(),
                group: that.group(),
                aggregate: that.aggregate()
            }, options));
        },
        next: function(options) {
            var that = this, page = that.page(), total = that.total();
            options = options || {};
            if (!page || total && page + 1 > that.totalPages()) {
                return;
            }
            that._skip = page * that.take();
            page += 1;
            options.page = page;
            that._query(options);
            return page;
        },
        prev: function(options) {
            var that = this, page = that.page();
            options = options || {};
            if (!page || page === 1) {
                return;
            }
            that._skip = that._skip - that.take();
            page -= 1;
            options.page = page;
            that._query(options);
            return page;
        },
        page: function(val) {
            var that = this, skip;
            if (val !== undefined) {
                val = math.max(math.min(math.max(val, 1), that.totalPages()), 1);
                that._query({
                    page: val
                });
                return;
            }
            skip = that.skip();
            return skip !== undefined ? math.round((skip || 0) / (that.take() || 1)) + 1 : undefined;
        },
        pageSize: function(val) {
            var that = this;
            if (val !== undefined) {
                that._query({
                    pageSize: val,
                    page: 1
                });
                return;
            }
            return that.take();
        },
        sort: function(val) {
            var that = this;
            if (val !== undefined) {
                that._query({
                    sort: val
                });
                return;
            }
            return that._sort;
        },
        filter: function(val) {
            var that = this;
            if (val === undefined) {
                return that._filter;
            }
            that._query({
                filter: val,
                page: 1
            });
        },
        group: function(val) {
            var that = this;
            if (val !== undefined) {
                that._query({
                    group: val
                });
                return;
            }
            return that._group;
        },
        total: function() {
            return this._total || 0;
        },
        aggregate: function(val) {
            var that = this;
            if (val !== undefined) {
                that._query({
                    aggregate: val
                });
                return;
            }
            return that._aggregate;
        },
        aggregates: function() {
            return this._aggregateResult;
        },
        totalPages: function() {
            var that = this, pageSize = that.pageSize() || that.total();
            return math.ceil((that.total() || 0) / pageSize);
        },
        inRange: function(skip, take) {
            var that = this, end = math.min(skip + take, that.total());
            if (!that.options.serverPaging && that.data.length > 0) {
                return true;
            }
            return that._findRange(skip, end).length > 0;
        },
        range: function(skip, take) {
            skip = math.min(skip || 0, this.total());
            var that = this, pageSkip = math.max(math.floor(skip / take), 0) * take, size = math.min(pageSkip + take, that.total()), data;
            data = that._findRange(skip, math.min(skip + take, that.total()));
            if (data.length) {
                that._skip = skip > that.skip() ? math.min(size, (that.totalPages() - 1) * that.take()) : pageSkip;
                that._take = take;
                var paging = that.options.serverPaging;
                var sorting = that.options.serverSorting;
                var filtering = that.options.serverFiltering;
                try {
                    that.options.serverPaging = true;
                    that.options.serverSorting = true;
                    that.options.serverFiltering = true;
                    if (paging) {
                        that._data = data = that._observe(data);
                    }
                    that._process(data);
                } finally {
                    that.options.serverPaging = paging;
                    that.options.serverSorting = sorting;
                    that.options.serverFiltering = filtering;
                }
                return;
            }
            if (take !== undefined) {
                if (!that._rangeExists(pageSkip, size)) {
                    that.prefetch(pageSkip, take, function() {
                        if (skip > pageSkip && size < that.total() && !that._rangeExists(size, math.min(size + take, that.total()))) {
                            that.prefetch(size, take, function() {
                                that.range(skip, take);
                            });
                        } else {
                            that.range(skip, take);
                        }
                    });
                } else if (pageSkip < skip) {
                    that.prefetch(size, take, function() {
                        that.range(skip, take);
                    });
                }
            }
        },
        _findRange: function(start, end) {
            var that = this, ranges = that._ranges, range, data = [], skipIdx, takeIdx, startIndex, endIndex, rangeData, rangeEnd, processed, options = that.options, remote = options.serverSorting || options.serverPaging || options.serverFiltering || options.serverGrouping || options.serverAggregates, flatData, count, length;
            for (skipIdx = 0, length = ranges.length; skipIdx < length; skipIdx++) {
                range = ranges[skipIdx];
                if (start >= range.start && start <= range.end) {
                    count = 0;
                    for (takeIdx = skipIdx; takeIdx < length; takeIdx++) {
                        range = ranges[takeIdx];
                        flatData = that._flatData(range.data);
                        if (flatData.length && start + count >= range.start) {
                            rangeData = range.data;
                            rangeEnd = range.end;
                            if (!remote) {
                                var sort = normalizeGroup(that.group() || []).concat(normalizeSort(that.sort() || []));
                                processed = Query.process(range.data, {
                                    sort: sort,
                                    filter: that.filter()
                                });
                                flatData = rangeData = processed.data;
                                if (processed.total !== undefined) {
                                    rangeEnd = processed.total;
                                }
                            }
                            startIndex = 0;
                            if (start + count > range.start) {
                                startIndex = start + count - range.start;
                            }
                            endIndex = flatData.length;
                            if (rangeEnd > end) {
                                endIndex = endIndex - (rangeEnd - end);
                            }
                            count += endIndex - startIndex;
                            data = that._mergeGroups(data, rangeData, startIndex, endIndex);
                            if (end <= range.end && count == end - start) {
                                return data;
                            }
                        }
                    }
                    break;
                }
            }
            return [];
        },
        _mergeGroups: function(data, range, startIndex, endIndex) {
            if (this._isServerGrouped()) {
                var temp = range.toJSON(), prevGroup;
                if (data.length) {
                    prevGroup = data[data.length - 1];
                }
                mergeGroups(prevGroup, temp, startIndex, endIndex);
                return data.concat(temp);
            }
            return data.concat(range.slice(startIndex, endIndex));
        },
        skip: function() {
            var that = this;
            if (that._skip === undefined) {
                return that._page !== undefined ? (that._page - 1) * (that.take() || 1) : undefined;
            }
            return that._skip;
        },
        take: function() {
            return this._take || this._pageSize;
        },
        _prefetchSuccessHandler: function(skip, size, callback) {
            var that = this;
            return function(data) {
                var found = false, range = {
                    start: skip,
                    end: size,
                    data: []
                }, idx, length;
                that._dequeueRequest();
                for (idx = 0, length = that._ranges.length; idx < length; idx++) {
                    if (that._ranges[idx].start === skip) {
                        found = true;
                        range = that._ranges[idx];
                        break;
                    }
                }
                if (!found) {
                    that._ranges.push(range);
                }
                data = that.reader.parse(data);
                range.data = that._observe(that._readData(data));
                range.end = range.start + that._flatData(range.data).length;
                that._ranges.sort(function(x, y) {
                    return x.start - y.start;
                });
                that._total = that.reader.total(data);
                if (callback) {
                    callback();
                }
            };
        },
        prefetch: function(skip, take, callback) {
            var that = this, size = math.min(skip + take, that.total()), options = {
                take: take,
                skip: skip,
                page: skip / take + 1,
                pageSize: take,
                sort: that._sort,
                filter: that._filter,
                group: that._group,
                aggregate: that._aggregate
            };
            if (!that._rangeExists(skip, size)) {
                clearTimeout(that._timeout);
                that._timeout = setTimeout(function() {
                    that._queueRequest(options, function() {
                        that.transport.read({
                            data: options,
                            success: that._prefetchSuccessHandler(skip, size, callback)
                        });
                    });
                }, 100);
            } else if (callback) {
                callback();
            }
        },
        _rangeExists: function(start, end) {
            var that = this, ranges = that._ranges, idx, length;
            for (idx = 0, length = ranges.length; idx < length; idx++) {
                if (ranges[idx].start <= start && ranges[idx].end >= end) {
                    return true;
                }
            }
            return false;
        }
    });
    var Transport = {};
    Transport.create = function(options, data) {
        var transport, transportOptions = options.transport;
        if (transportOptions) {
            transportOptions.read = typeof transportOptions.read === STRING ? {
                url: transportOptions.read
            } : transportOptions.read;
            if (options.type) {
                if (kendo.data.transports[options.type] && !isPlainObject(kendo.data.transports[options.type])) {
                    transport = new kendo.data.transports[options.type](extend(transportOptions, {
                        data: data
                    }));
                } else {
                    transportOptions = extend(true, {}, kendo.data.transports[options.type], transportOptions);
                }
                options.schema = extend(true, {}, kendo.data.schemas[options.type], options.schema);
            }
            if (!transport) {
                transport = isFunction(transportOptions.read) ? transportOptions : new RemoteTransport(transportOptions);
            }
        } else {
            transport = new LocalTransport({
                data: options.data
            });
        }
        return transport;
    };
    DataSource.create = function(options) {
        options = options && options.push ? {
            data: options
        } : options;
        var dataSource = options || {}, data = dataSource.data, fields = dataSource.fields, table = dataSource.table, select = dataSource.select, idx, length, model = {}, field;
        if (!data && fields && !dataSource.transport) {
            if (table) {
                data = inferTable(table, fields);
            } else if (select) {
                data = inferSelect(select, fields);
            }
        }
        if (kendo.data.Model && fields && (!dataSource.schema || !dataSource.schema.model)) {
            for (idx = 0, length = fields.length; idx < length; idx++) {
                field = fields[idx];
                if (field.type) {
                    model[field.field] = field;
                }
            }
            if (!isEmptyObject(model)) {
                dataSource.schema = extend(true, dataSource.schema, {
                    model: {
                        fields: model
                    }
                });
            }
        }
        dataSource.data = data;
        return dataSource instanceof DataSource ? dataSource : new DataSource(dataSource);
    };
    function inferSelect(select, fields) {
        var options = $(select)[0].children, idx, length, data = [], record, firstField = fields[0], secondField = fields[1], value, option;
        for (idx = 0, length = options.length; idx < length; idx++) {
            record = {};
            option = options[idx];
            if (option.disabled) {
                continue;
            }
            record[firstField.field] = option.text;
            value = option.attributes.value;
            if (value && value.specified) {
                value = option.value;
            } else {
                value = option.text;
            }
            record[secondField.field] = value;
            data.push(record);
        }
        return data;
    }
    function inferTable(table, fields) {
        var tbody = $(table)[0].tBodies[0], rows = tbody ? tbody.rows : [], idx, length, fieldIndex, fieldCount = fields.length, data = [], cells, record, cell, empty;
        for (idx = 0, length = rows.length; idx < length; idx++) {
            record = {};
            empty = true;
            cells = rows[idx].cells;
            for (fieldIndex = 0; fieldIndex < fieldCount; fieldIndex++) {
                cell = cells[fieldIndex];
                if (cell.nodeName.toLowerCase() !== "th") {
                    empty = false;
                    record[fields[fieldIndex].field] = cell.innerHTML;
                }
            }
            if (!empty) {
                data.push(record);
            }
        }
        return data;
    }
    var Node = Model.define({
        init: function(value) {
            var that = this, hasChildren = that.hasChildren || value && value.hasChildren, childrenField = "items", childrenOptions = {};
            kendo.data.Model.fn.init.call(that, value);
            if (typeof that.children === STRING) {
                childrenField = that.children;
            }
            childrenOptions = {
                schema: {
                    data: childrenField,
                    model: {
                        hasChildren: hasChildren,
                        id: that.idField
                    }
                }
            };
            if (typeof that.children !== STRING) {
                extend(childrenOptions, that.children);
            }
            childrenOptions.data = value;
            if (!hasChildren) {
                hasChildren = childrenOptions.schema.data;
            }
            if (typeof hasChildren === STRING) {
                hasChildren = kendo.getter(hasChildren);
            }
            if (isFunction(hasChildren)) {
                that.hasChildren = !!hasChildren.call(that, that);
            }
            that._childrenOptions = childrenOptions;
            if (that.hasChildren) {
                that._initChildren();
            }
            that._loaded = !!(value && value[childrenField]);
        },
        _initChildren: function() {
            var that = this;
            if (!(that.children instanceof HierarchicalDataSource)) {
                that.children = new HierarchicalDataSource(that._childrenOptions);
                that.children.parent = function() {
                    return that;
                };
                that.children.bind(CHANGE, function(e) {
                    e.node = e.node || that;
                    that.trigger(CHANGE, e);
                });
                that._updateChildrenField();
            }
        },
        append: function(model) {
            this._initChildren();
            this.loaded(true);
            this.children.add(model);
        },
        hasChildren: false,
        level: function() {
            var parentNode = this.parentNode(), level = 0;
            while (parentNode && parentNode.parentNode) {
                level++;
                parentNode = parentNode.parentNode ? parentNode.parentNode() : null;
            }
            return level;
        },
        _updateChildrenField: function() {
            var fieldName = this._childrenOptions.schema.data;
            this[fieldName || "items"] = this.children.data();
        },
        load: function() {
            var that = this, options = {};
            if (that.hasChildren) {
                that._initChildren();
                options[that.idField || "id"] = that.id;
                if (!that._loaded) {
                    that.children._data = undefined;
                }
                that.children.one(CHANGE, function() {
                    that._loaded = true;
                    that._updateChildrenField();
                })._query(options);
            }
        },
        parentNode: function() {
            var array = this.parent();
            return array.parent();
        },
        loaded: function(value) {
            if (value !== undefined) {
                this._loaded = value;
            } else {
                return this._loaded;
            }
        },
        shouldSerialize: function(field) {
            return Model.fn.shouldSerialize.call(this, field) && field !== "children" && field !== "_loaded" && field !== "hasChildren" && field !== "_childrenOptions";
        }
    });
    var HierarchicalDataSource = DataSource.extend({
        init: function(options) {
            var node = Node.define({
                children: options
            });
            DataSource.fn.init.call(this, extend(true, {}, {
                schema: {
                    modelBase: node,
                    model: node
                }
            }, options));
        },
        remove: function(node) {
            var parentNode = node.parentNode(), dataSource = this, result;
            if (parentNode) {
                dataSource = parentNode.children;
            }
            result = DataSource.fn.remove.call(dataSource, node);
            if (parentNode && !dataSource.data().length) {
                parentNode.hasChildren = false;
            }
            return result;
        },
        insert: function(index, model) {
            var parentNode = this.parent();
            if (parentNode) {
                parentNode.hasChildren = true;
                parentNode._initChildren();
            }
            return DataSource.fn.insert.call(this, index, model);
        },
        _find: function(method, value) {
            var idx, length, node, data, children;
            node = DataSource.fn[method].call(this, value);
            if (node) {
                return node;
            }
            data = this._flatData(this.data());
            if (!data) {
                return;
            }
            for (idx = 0, length = data.length; idx < length; idx++) {
                children = data[idx].children;
                if (!(children instanceof HierarchicalDataSource)) {
                    continue;
                }
                node = children[method](value);
                if (node) {
                    return node;
                }
            }
        },
        get: function(id) {
            return this._find("get", id);
        },
        getByUid: function(uid) {
            return this._find("getByUid", uid);
        }
    });
    function inferList(list, fields) {
        var items = $(list).children(), idx, length, data = [], record, textField = fields[0].field, urlField = fields[1] && fields[1].field, spriteCssClassField = fields[2] && fields[2].field, imageUrlField = fields[3] && fields[3].field, item, id, textChild, className, children;
        for (idx = 0, length = items.length; idx < length; idx++) {
            record = {};
            item = items.eq(idx);
            textChild = item[0].firstChild;
            children = item.children();
            list = children.filter("ul");
            children = children.filter(":not(ul)");
            id = item.attr("data-id");
            if (id) {
                record.id = id;
            }
            if (textChild) {
                record[textField] = textChild.nodeType == 3 ? textChild.nodeValue : children.text();
            }
            if (urlField) {
                record[urlField] = children.find("a").attr("href");
            }
            if (imageUrlField) {
                record[imageUrlField] = children.find("img").attr("src");
            }
            if (spriteCssClassField) {
                className = children.find(".k-sprite").prop("className");
                record[spriteCssClassField] = className && $.trim(className.replace("k-sprite", ""));
            }
            if (list.length) {
                record.items = inferList(list.eq(0), fields);
            }
            if (item.attr("data-hasChildren") == "true") {
                record.hasChildren = true;
            }
            data.push(record);
        }
        return data;
    }
    HierarchicalDataSource.create = function(options) {
        options = options && options.push ? {
            data: options
        } : options;
        var dataSource = options || {}, data = dataSource.data, fields = dataSource.fields, list = dataSource.list;
        if (data && data._dataSource) {
            return data._dataSource;
        }
        if (!data && fields && !dataSource.transport) {
            if (list) {
                data = inferList(list, fields);
            }
        }
        dataSource.data = data;
        return dataSource instanceof HierarchicalDataSource ? dataSource : new HierarchicalDataSource(dataSource);
    };
    extend(true, kendo.data, {
        readers: {
            json: DataReader
        },
        Query: Query,
        DataSource: DataSource,
        HierarchicalDataSource: HierarchicalDataSource,
        Node: Node,
        ObservableObject: ObservableObject,
        ObservableArray: ObservableArray,
        LocalTransport: LocalTransport,
        RemoteTransport: RemoteTransport,
        Cache: Cache,
        DataReader: DataReader,
        Model: Model
    });
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, Observable = kendo.Observable, ObservableObject = kendo.data.ObservableObject, ObservableArray = kendo.data.ObservableArray, toString = {}.toString, binders = {}, Class = kendo.Class, innerText, proxy = $.proxy, VALUE = "value", SOURCE = "source", EVENTS = "events", CHECKED = "checked", CHANGE = "change";
    (function() {
        var a = document.createElement("a");
        if (a.innerText !== undefined) {
            innerText = "innerText";
        } else if (a.textContent !== undefined) {
            innerText = "textContent";
        }
    })();
    var Binding = Observable.extend({
        init: function(parents, path) {
            var that = this;
            Observable.fn.init.call(that);
            that.source = parents[0];
            that.parents = parents;
            that.path = path;
            that.dependencies = {};
            that.dependencies[path] = true;
            that.observable = that.source instanceof Observable;
            that._access = function(e) {
                that.dependencies[e.field] = true;
            };
            if (that.observable) {
                that._change = function(e) {
                    that.change(e);
                };
                that.source.bind(CHANGE, that._change);
            }
        },
        change: function(e) {
            var dependency, ch, field = e.field, that = this;
            if (that.path === "this") {
                that.trigger(CHANGE, e);
            } else {
                for (dependency in that.dependencies) {
                    if (dependency.indexOf(field) === 0) {
                        ch = dependency.charAt(field.length);
                        if (!ch || ch === "." || ch === "[") {
                            that.trigger(CHANGE, e);
                            break;
                        }
                    }
                }
            }
        },
        start: function(source) {
            source.bind("get", this._access);
        },
        stop: function(source) {
            source.unbind("get", this._access);
        },
        get: function() {
            var that = this, source = that.source, index = 0, path = that.path, result = source;
            if (!that.observable) {
                return result;
            }
            that.start(that.source);
            result = source.get(path);
            // Traverse the observable hierarchy if the binding is not resolved at the current level.
            while (result === undefined && source) {
                source = that.parents[++index];
                if (source instanceof ObservableObject) {
                    result = source.get(path);
                }
            }
            // If the result is a function - invoke it
            if (typeof result === "function") {
                index = path.lastIndexOf(".");
                // If the function is a member of a nested observable object make that nested observable the context (this) of the function
                if (index > 0) {
                    source = source.get(path.substring(0, index));
                }
                // Invoke the function
                that.start(source);
                result = result.call(source, that.source);
                that.stop(source);
            }
            // If the binding is resolved by a parent object
            if (source && source !== that.source) {
                that.currentSource = source;
                // save parent object
                // Listen for changes in the parent object
                source.unbind(CHANGE, that._change).bind(CHANGE, that._change);
            }
            that.stop(that.source);
            return result;
        },
        set: function(value) {
            var that = this, source = that.currentSource || that.source;
            source.set(that.path, value);
        },
        destroy: function() {
            if (this.observable) {
                this.source.unbind(CHANGE, this._change);
            }
        }
    });
    var EventBinding = Binding.extend({
        get: function() {
            var source = this.source, path = this.path, index = 0, handler;
            handler = source.get(path);
            while (!handler && source) {
                source = this.parents[++index];
                if (source instanceof ObservableObject) {
                    handler = source.get(path);
                }
            }
            return proxy(handler, source);
        }
    });
    var TemplateBinding = Binding.extend({
        init: function(source, path, template) {
            var that = this;
            Binding.fn.init.call(that, source, path);
            that.template = template;
        },
        render: function(value) {
            var html;
            this.start(this.source);
            html = kendo.render(this.template, value);
            this.stop(this.source);
            return html;
        }
    });
    var Binder = Class.extend({
        init: function(element, bindings, options) {
            this.element = element;
            this.bindings = bindings;
            this.options = options;
        },
        bind: function(binding, attribute) {
            var that = this;
            binding = attribute ? binding[attribute] : binding;
            binding.bind(CHANGE, function(e) {
                that.refresh(attribute || e);
            });
            that.refresh(attribute);
        },
        destroy: function() {}
    });
    binders.attr = Binder.extend({
        refresh: function(key) {
            this.element.setAttribute(key, this.bindings.attr[key].get());
        }
    });
    binders.style = Binder.extend({
        refresh: function(key) {
            this.element.style[key] = this.bindings.style[key].get();
        }
    });
    binders.enabled = Binder.extend({
        refresh: function() {
            if (this.bindings.enabled.get()) {
                this.element.removeAttribute("disabled");
            } else {
                this.element.setAttribute("disabled", "disabled");
            }
        }
    });
    binders.readonly = Binder.extend({
        refresh: function() {
            if (this.bindings.readonly.get()) {
                this.element.setAttribute("readonly", "readonly");
            } else {
                this.element.removeAttribute("readonly");
            }
        }
    });
    binders.disabled = Binder.extend({
        refresh: function() {
            if (this.bindings.disabled.get()) {
                this.element.setAttribute("disabled", "disabled");
            } else {
                this.element.removeAttribute("disabled");
            }
        }
    });
    binders.events = Binder.extend({
        init: function(element, bindings, options) {
            Binder.fn.init.call(this, element, bindings, options);
            this.handlers = {};
        },
        refresh: function(key) {
            var element = $(this.element), binding = this.bindings.events[key], handler = this.handlers[key];
            if (handler) {
                element.off(key, handler);
            }
            handler = this.handlers[key] = binding.get();
            element.on(key, binding.source, handler);
        },
        destroy: function() {
            var element = $(this.element), handler;
            for (handler in this.handlers) {
                element.off(handler, this.handlers[handler]);
            }
        }
    });
    binders.text = Binder.extend({
        refresh: function() {
            var text = this.bindings.text.get();
            if (text == null) {
                text = "";
            }
            this.element[innerText] = text;
        }
    });
    binders.visible = Binder.extend({
        refresh: function() {
            if (this.bindings.visible.get()) {
                this.element.style.display = "";
            } else {
                this.element.style.display = "none";
            }
        }
    });
    binders.invisible = Binder.extend({
        refresh: function() {
            if (!this.bindings.invisible.get()) {
                this.element.style.display = "";
            } else {
                this.element.style.display = "none";
            }
        }
    });
    binders.html = Binder.extend({
        refresh: function() {
            this.element.innerHTML = this.bindings.html.get();
        }
    });
    binders.value = Binder.extend({
        init: function(element, bindings, options) {
            Binder.fn.init.call(this, element, bindings, options);
            this._change = proxy(this.change, this);
            this.eventName = options.valueUpdate || CHANGE;
            $(this.element).on(this.eventName, this._change);
            this._initChange = false;
        },
        change: function() {
            this._initChange = this.eventName != CHANGE;
            this.bindings[VALUE].set(this.element.value);
            this._initChange = false;
        },
        refresh: function() {
            if (!this._initChange) {
                var value = this.bindings[VALUE].get();
                if (value == null) {
                    value = "";
                }
                this.element.value = value;
            }
            this._initChange = false;
        },
        destroy: function() {
            $(this.element).off(this.eventName, this._change);
        }
    });
    binders.source = Binder.extend({
        init: function(element, bindings, options) {
            Binder.fn.init.call(this, element, bindings, options);
        },
        refresh: function(e) {
            var that = this, source = that.bindings.source.get();
            if (source instanceof ObservableArray) {
                e = e || {};
                if (e.action == "add") {
                    that.add(e.index, e.items);
                } else if (e.action == "remove") {
                    that.remove(e.index, e.items);
                } else if (e.action != "itemchange") {
                    that.render();
                }
            } else {
                that.render();
            }
        },
        container: function() {
            var element = this.element;
            if (element.nodeName.toLowerCase() == "table") {
                if (!element.tBodies[0]) {
                    element.appendChild(document.createElement("tbody"));
                }
                element = element.tBodies[0];
            }
            return element;
        },
        template: function() {
            var options = this.options, template = options.template, nodeName = this.container().nodeName.toLowerCase();
            if (!template) {
                if (nodeName == "select") {
                    if (options.valueField || options.textField) {
                        template = kendo.format('<option value="#:{0}#">#:{1}#</option>', options.valueField || options.textField, options.textField || options.valueField);
                    } else {
                        template = "<option>#:data#</option>";
                    }
                } else if (nodeName == "tbody") {
                    template = "<tr><td>#:data#</td></tr>";
                } else if (nodeName == "ul" || nodeName == "ol") {
                    template = "<li>#:data#</li>";
                } else {
                    template = "#:data#";
                }
                template = kendo.template(template);
            }
            return template;
        },
        destroy: function() {
            var source = this.bindings.source.get();
            source.unbind(CHANGE, this._change);
        },
        add: function(index, items) {
            var element = this.container(), idx, length, child, clone = element.cloneNode(false), reference = element.children[index];
            $(clone).html(kendo.render(this.template(), items));
            if (clone.children.length) {
                for (idx = 0, length = items.length; idx < length; idx++) {
                    child = clone.children[0];
                    element.insertBefore(child, reference || null);
                    bindElement(child, items[idx], this.options.roles, [ items[idx] ].concat(this.bindings.source.parents));
                }
            }
        },
        remove: function(index, items) {
            var idx, element = this.container();
            for (idx = 0; idx < items.length; idx++) {
                element.removeChild(element.children[index]);
            }
        },
        render: function() {
            var source = this.bindings.source.get(), idx, length, element = this.container(), template = this.template(), parent;
            if (!(source instanceof ObservableArray) && toString.call(source) !== "[object Array]") {
                if (source.parent) {
                    parent = source.parent;
                }
                source = new ObservableArray([ source ]);
                if (source.parent) {
                    source.parent = parent;
                }
            }
            if (this.bindings.template) {
                $(element).html(this.bindings.template.render(source));
                if (element.children.length) {
                    for (idx = 0, length = source.length; idx < length; idx++) {
                        bindElement(element.children[idx], source[idx], this.options.roles, [ source[idx] ].concat(this.bindings.source.parents));
                    }
                }
            } else {
                $(element).html(kendo.render(template, source));
            }
        }
    });
    binders.input = {
        checked: Binder.extend({
            init: function(element, bindings, options) {
                Binder.fn.init.call(this, element, bindings, options);
                this._change = proxy(this.change, this);
                $(this.element).change(this._change);
            },
            change: function() {
                var element = this.element;
                var value = this.value();
                if (element.type == "radio") {
                    this.bindings[CHECKED].set(value);
                } else if (element.type == "checkbox") {
                    var source = this.bindings[CHECKED].get();
                    var index;
                    if (source instanceof ObservableArray) {
                        value = this.element.value;
                        if (value !== "on" && value !== "off") {
                            index = source.indexOf(value);
                            if (index > -1) {
                                source.splice(index, 1);
                            } else {
                                source.push(value);
                            }
                        }
                    } else {
                        this.bindings[CHECKED].set(value);
                    }
                }
            },
            refresh: function() {
                var value = this.bindings[CHECKED].get(), source = value, element = this.element;
                if (element.type == "checkbox") {
                    if (source instanceof ObservableArray) {
                        value = this.element.value;
                        if (source.indexOf(value) >= 0) {
                            value = true;
                        }
                    }
                    element.checked = value === true;
                } else if (element.type == "radio" && value != null) {
                    if (element.value === value.toString()) {
                        element.checked = true;
                    }
                }
            },
            value: function() {
                var element = this.element, value = element.value;
                if (element.type == "checkbox") {
                    value = element.checked;
                }
                return value;
            },
            destroy: function() {
                $(this.element).off(CHANGE, this._change);
            }
        })
    };
    binders.select = {
        value: Binder.extend({
            init: function(target, bindings, options) {
                Binder.fn.init.call(this, target, bindings, options);
                this._change = proxy(this.change, this);
                $(this.element).change(this._change);
            },
            change: function() {
                var values = [], element = this.element, source, field = this.options.valueField || this.options.textField, option, valueIndex, value, idx, length;
                for (idx = 0, length = element.options.length; idx < length; idx++) {
                    option = element.options[idx];
                    if (option.selected) {
                        value = option.attributes.value;
                        if (value && value.specified) {
                            value = option.value;
                        } else {
                            value = option.text;
                        }
                        values.push(value);
                    }
                }
                if (field) {
                    source = this.bindings.source.get();
                    for (valueIndex = 0; valueIndex < values.length; valueIndex++) {
                        for (idx = 0, length = source.length; idx < length; idx++) {
                            if (source[idx].get(field) == values[valueIndex]) {
                                values[valueIndex] = source[idx];
                                break;
                            }
                        }
                    }
                }
                value = this.bindings[VALUE].get();
                if (value instanceof ObservableArray) {
                    value.splice.apply(value, [ 0, value.length ].concat(values));
                } else if (value instanceof ObservableObject || !field) {
                    this.bindings[VALUE].set(values[0]);
                } else {
                    this.bindings[VALUE].set(values[0].get(field));
                }
            },
            refresh: function() {
                var optionIndex, element = this.element, options = element.options, value = this.bindings[VALUE].get(), values = value, field = this.options.valueField || this.options.textField, found = false, optionValue;
                if (!(values instanceof ObservableArray)) {
                    values = new ObservableArray([ value ]);
                }
                element.selectedIndex = -1;
                for (var valueIndex = 0; valueIndex < values.length; valueIndex++) {
                    value = values[valueIndex];
                    if (field && value instanceof ObservableObject) {
                        value = value.get(field);
                    }
                    for (optionIndex = 0; optionIndex < options.length; optionIndex++) {
                        optionValue = options[optionIndex].value;
                        if (optionValue === "" && value !== "") {
                            optionValue = options[optionIndex].text;
                        }
                        if (optionValue == value) {
                            options[optionIndex].selected = true;
                            found = true;
                        }
                    }
                }
            },
            destroy: function() {
                $(this.element).off(CHANGE, this._change);
            }
        })
    };
    binders.widget = {
        events: Binder.extend({
            init: function(widget, bindings, options) {
                Binder.fn.init.call(this, widget.element[0], bindings, options);
                this.widget = widget;
                this.handlers = {};
            },
            refresh: function(key) {
                var binding = this.bindings.events[key], handler = this.handlers[key];
                if (handler) {
                    this.widget.unbind(key, handler);
                }
                handler = binding.get();
                this.handlers[key] = function(e) {
                    e.data = binding.source;
                    handler(e);
                    if (e.data === binding.source) {
                        delete e.data;
                    }
                };
                this.widget.bind(key, this.handlers[key]);
            },
            destroy: function() {
                var handler;
                for (handler in this.handlers) {
                    this.widget.unbind(handler, this.handlers[handler]);
                }
            }
        }),
        checked: Binder.extend({
            init: function(widget, bindings, options) {
                Binder.fn.init.call(this, widget.element[0], bindings, options);
                this.widget = widget;
                this._change = proxy(this.change, this);
                this.widget.bind(CHANGE, this._change);
            },
            change: function() {
                this.bindings[CHECKED].set(this.value());
            },
            refresh: function() {
                this.widget.check(this.bindings[CHECKED].get() === true);
            },
            value: function() {
                var element = this.element, value = element.value;
                if (value == "on" || value == "off") {
                    value = element.checked;
                }
                return value;
            },
            destroy: function() {
                this.widget.unbind(CHANGE, this._change);
            }
        }),
        visible: Binder.extend({
            init: function(widget, bindings, options) {
                Binder.fn.init.call(this, widget.element[0], bindings, options);
                this.widget = widget;
            },
            refresh: function() {
                var visible = this.bindings.visible.get();
                this.widget.wrapper[0].style.display = visible ? "" : "none";
            }
        }),
        invisible: Binder.extend({
            init: function(widget, bindings, options) {
                Binder.fn.init.call(this, widget.element[0], bindings, options);
                this.widget = widget;
            },
            refresh: function() {
                var invisible = this.bindings.invisible.get();
                this.widget.wrapper[0].style.display = invisible ? "none" : "";
            }
        }),
        enabled: Binder.extend({
            init: function(widget, bindings, options) {
                Binder.fn.init.call(this, widget.element[0], bindings, options);
                this.widget = widget;
            },
            refresh: function() {
                if (this.widget.enable) {
                    this.widget.enable(this.bindings.enabled.get());
                }
            }
        }),
        disabled: Binder.extend({
            init: function(widget, bindings, options) {
                Binder.fn.init.call(this, widget.element[0], bindings, options);
                this.widget = widget;
            },
            refresh: function() {
                if (this.widget.enable) {
                    this.widget.enable(!this.bindings.disabled.get());
                }
            }
        }),
        source: Binder.extend({
            init: function(widget, bindings, options) {
                var that = this;
                Binder.fn.init.call(that, widget.element[0], bindings, options);
                that.widget = widget;
                that._dataBinding = proxy(that.dataBinding, that);
                that._dataBound = proxy(that.dataBound, that);
                that._itemChange = proxy(that.itemChange, that);
            },
            itemChange: function(e) {
                bindElement(e.item[0], e.data, this._ns(e.ns), [ e.data ].concat(this.bindings.source.parents));
            },
            dataBinding: function() {
                var idx, length, widget = this.widget, items = widget.items();
                for (idx = 0, length = items.length; idx < length; idx++) {
                    unbindElementTree(items[idx]);
                }
            },
            _ns: function(ns) {
                ns = ns || kendo.ui;
                var all = [ kendo.ui, kendo.dataviz.ui, kendo.mobile.ui ];
                all.splice($.inArray(ns, all), 1);
                all.unshift(ns);
                return kendo.rolesFromNamespaces(all);
            },
            dataBound: function(e) {
                var idx, length, widget = this.widget, items = widget.items(), dataSource = widget.dataSource, view = dataSource.view(), groups = dataSource.group() || [];
                if (items.length) {
                    if (groups.length) {
                        view = flattenGroups(view);
                    }
                    for (idx = 0, length = view.length; idx < length; idx++) {
                        bindElement(items[idx], view[idx], this._ns(e.ns), [ view[idx] ].concat(this.bindings.source.parents));
                    }
                }
            },
            refresh: function(e) {
                var that = this, source, widget = that.widget;
                e = e || {};
                if (!e.action) {
                    that.destroy();
                    widget.bind("dataBinding", that._dataBinding);
                    widget.bind("dataBound", that._dataBound);
                    widget.bind("itemChange", that._itemChange);
                    source = that.bindings.source.get();
                    if (widget.dataSource instanceof kendo.data.DataSource && widget.dataSource != source) {
                        if (source instanceof kendo.data.DataSource) {
                            widget.setDataSource(source);
                        } else if (source && source._dataSource) {
                            widget.setDataSource(source._dataSource);
                        } else {
                            widget.dataSource.data(source);
                        }
                    }
                }
            },
            destroy: function() {
                var widget = this.widget;
                widget.unbind("dataBinding", this._dataBinding);
                widget.unbind("dataBound", this._dataBound);
                widget.unbind("itemChange", this._itemChange);
            }
        }),
        value: Binder.extend({
            init: function(widget, bindings, options) {
                Binder.fn.init.call(this, widget.element[0], bindings, options);
                this.widget = widget;
                this._change = $.proxy(this.change, this);
                this.widget.first(CHANGE, this._change);
                var value = this.bindings.value.get();
                this._valueIsObservableObject = value == null || value instanceof ObservableObject;
                this._valueIsObservableArray = value instanceof ObservableArray;
                this._initChange = false;
            },
            change: function() {
                var value = this.widget.value(), field = this.options.dataValueField || this.options.dataTextField, isArray = toString.call(value) === "[object Array]", isObservableObject = this._valueIsObservableObject, valueIndex, valueLength, values = [], sourceItem, sourceValue, idx, length, source;
                this._initChange = true;
                if (field) {
                    if (this.bindings.source) {
                        source = this.bindings.source.get();
                    }
                    if (value === "" && isObservableObject) {
                        value = null;
                    } else {
                        if (!source || source instanceof kendo.data.DataSource) {
                            source = this.widget.dataSource.view();
                        }
                        if (isArray) {
                            valueLength = value.length;
                            values = value.slice(0);
                        }
                        for (idx = 0, length = source.length; idx < length; idx++) {
                            sourceItem = source[idx];
                            sourceValue = sourceItem.get(field);
                            if (isArray) {
                                for (valueIndex = 0; valueIndex < valueLength; valueIndex++) {
                                    if (sourceValue == values[valueIndex]) {
                                        values[valueIndex] = sourceItem;
                                        break;
                                    }
                                }
                            } else if (sourceValue == value) {
                                value = isObservableObject ? sourceItem : sourceValue;
                                break;
                            }
                        }
                        if (values[0]) {
                            if (this._valueIsObservableArray) {
                                value = values;
                            } else if (isObservableObject || !field) {
                                value = values[0];
                            } else {
                                value = values[0].get(field);
                            }
                        }
                    }
                }
                this.bindings.value.set(value);
                this._initChange = false;
            },
            refresh: function() {
                if (!this._initChange) {
                    var field = this.options.dataValueField || this.options.dataTextField, value = this.bindings.value.get(), idx = 0, length, values = [];
                    if (field) {
                        if (value instanceof ObservableArray) {
                            for (length = value.length; idx < length; idx++) {
                                values[idx] = value[idx].get(field);
                            }
                            value = values;
                        } else if (value instanceof ObservableObject) {
                            value = value.get(field);
                        }
                    }
                    this.widget.value(value);
                }
                this._initChange = false;
            },
            destroy: function() {
                this.widget.unbind(CHANGE, this._change);
            }
        })
    };
    var BindingTarget = Class.extend({
        init: function(target, options) {
            this.target = target;
            this.options = options;
            this.toDestroy = [];
        },
        bind: function(bindings) {
            var nodeName = this.target.nodeName.toLowerCase(), key, hasValue, hasSource, hasEvents, specificBinders = binders[nodeName] || {};
            for (key in bindings) {
                if (key == VALUE) {
                    hasValue = true;
                } else if (key == SOURCE) {
                    hasSource = true;
                } else if (key == EVENTS) {
                    hasEvents = true;
                } else {
                    this.applyBinding(key, bindings, specificBinders);
                }
            }
            if (hasSource) {
                this.applyBinding(SOURCE, bindings, specificBinders);
            }
            if (hasValue) {
                this.applyBinding(VALUE, bindings, specificBinders);
            }
            if (hasEvents) {
                this.applyBinding(EVENTS, bindings, specificBinders);
            }
        },
        applyBinding: function(name, bindings, specificBinders) {
            var binder = specificBinders[name] || binders[name], toDestroy = this.toDestroy, attribute, binding = bindings[name];
            if (binder) {
                binder = new binder(this.target, bindings, this.options);
                toDestroy.push(binder);
                if (binding instanceof Binding) {
                    binder.bind(binding);
                    toDestroy.push(binding);
                } else {
                    for (attribute in binding) {
                        binder.bind(binding, attribute);
                        toDestroy.push(binding[attribute]);
                    }
                }
            } else if (name !== "template") {
                throw new Error("The " + name + " binding is not supported by the " + this.target.nodeName.toLowerCase() + " element");
            }
        },
        destroy: function() {
            var idx, length, toDestroy = this.toDestroy;
            for (idx = 0, length = toDestroy.length; idx < length; idx++) {
                toDestroy[idx].destroy();
            }
        }
    });
    var WidgetBindingTarget = BindingTarget.extend({
        bind: function(bindings) {
            var that = this, binding, hasValue = false, hasSource = false;
            for (binding in bindings) {
                if (binding == VALUE) {
                    hasValue = true;
                } else if (binding == SOURCE) {
                    hasSource = true;
                } else {
                    that.applyBinding(binding, bindings);
                }
            }
            if (hasSource) {
                that.applyBinding(SOURCE, bindings);
            }
            if (hasValue) {
                that.applyBinding(VALUE, bindings);
            }
        },
        applyBinding: function(name, bindings) {
            var binder = binders.widget[name], toDestroy = this.toDestroy, attribute, binding = bindings[name];
            if (binder) {
                binder = new binder(this.target, bindings, this.target.options);
                toDestroy.push(binder);
                if (binding instanceof Binding) {
                    binder.bind(binding);
                    toDestroy.push(binding);
                } else {
                    for (attribute in binding) {
                        binder.bind(binding, attribute);
                        toDestroy.push(binding[attribute]);
                    }
                }
            } else {
                throw new Error("The " + name + " binding is not supported by the " + this.target.options.name + " widget");
            }
        }
    });
    function flattenGroups(data) {
        var idx, length, result = [];
        for (idx = 0, length = data.length; idx < length; idx++) {
            if (data[idx].hasSubgroups) {
                result = result.concat(flattenGroups(data[idx].items));
            } else {
                result = result.concat(data[idx].items);
            }
        }
        return result;
    }
    function bindingTargetForRole(role, element, roles) {
        var type = roles[role];
        if (type) {
            return new WidgetBindingTarget(kendo.initWidget(element, type.options, roles));
        }
    }
    var keyValueRegExp = /[A-Za-z0-9_\-]+:(\{([^}]*)\}|[^,}]+)/g, whiteSpaceRegExp = /\s/g;
    function parseBindings(bind) {
        var result = {}, idx, length, token, colonIndex, key, value, tokens;
        tokens = bind.match(keyValueRegExp);
        for (idx = 0, length = tokens.length; idx < length; idx++) {
            token = tokens[idx];
            colonIndex = token.indexOf(":");
            key = token.substring(0, colonIndex);
            value = token.substring(colonIndex + 1);
            if (value.charAt(0) == "{") {
                value = parseBindings(value);
            }
            result[key] = value;
        }
        return result;
    }
    function createBindings(bindings, source, type) {
        var binding, result = {};
        for (binding in bindings) {
            result[binding] = new type(source, bindings[binding]);
        }
        return result;
    }
    function bindElement(element, source, roles, parents) {
        var role = element.getAttribute("data-" + kendo.ns + "role"), idx, bind = element.getAttribute("data-" + kendo.ns + "bind"), children = element.children, childrenCopy = [], deep = true, bindings, options = {}, target;
        parents = parents || [ source ];
        if (role || bind) {
            unbindElement(element);
        }
        if (role) {
            target = bindingTargetForRole(role, element, roles);
        }
        if (bind) {
            bind = parseBindings(bind.replace(whiteSpaceRegExp, ""));
            if (!target) {
                options = kendo.parseOptions(element, {
                    textField: "",
                    valueField: "",
                    template: "",
                    valueUpdate: CHANGE
                });
                options.roles = roles;
                target = new BindingTarget(element, options);
            }
            target.source = source;
            bindings = createBindings(bind, parents, Binding);
            if (options.template) {
                bindings.template = new TemplateBinding(parents, "", options.template);
            }
            if (bindings.click) {
                bind.events = bind.events || {};
                bind.events.click = bind.click;
                delete bindings.click;
            }
            if (bindings.source) {
                deep = false;
            }
            if (bind.attr) {
                bindings.attr = createBindings(bind.attr, parents, Binding);
            }
            if (bind.style) {
                bindings.style = createBindings(bind.style, parents, Binding);
            }
            if (bind.events) {
                bindings.events = createBindings(bind.events, parents, EventBinding);
            }
            target.bind(bindings);
        }
        if (target) {
            element.kendoBindingTarget = target;
        }
        if (deep && children) {
            // https://github.com/telerik/kendo/issues/1240 for the weirdness.
            for (idx = 0; idx < children.length; idx++) {
                childrenCopy[idx] = children[idx];
            }
            for (idx = 0; idx < childrenCopy.length; idx++) {
                bindElement(childrenCopy[idx], source, roles, parents);
            }
        }
    }
    function bind(dom, object) {
        var idx, length, roles = kendo.rolesFromNamespaces([].slice.call(arguments, 2));
        object = kendo.observable(object);
        dom = $(dom);
        for (idx = 0, length = dom.length; idx < length; idx++) {
            bindElement(dom[idx], object, roles);
        }
    }
    function unbindElement(element) {
        var bindingTarget = element.kendoBindingTarget;
        if (bindingTarget) {
            bindingTarget.destroy();
            if ($.support.deleteExpando) {
                delete element.kendoBindingTarget;
            } else if (element.removeAttribute) {
                element.removeAttribute("kendoBindingTarget");
            } else {
                element.kendoBindingTarget = null;
            }
        }
    }
    function unbindElementTree(element) {
        var idx, length, children = element.children;
        unbindElement(element);
        if (children) {
            for (idx = 0, length = children.length; idx < length; idx++) {
                unbindElementTree(children[idx]);
            }
        }
    }
    function unbind(dom) {
        var idx, length;
        dom = $(dom);
        for (idx = 0, length = dom.length; idx < length; idx++) {
            unbindElementTree(dom[idx]);
        }
    }
    function notify(widget, namespace) {
        var element = widget.element, bindingTarget = element[0].kendoBindingTarget;
        if (bindingTarget) {
            bind(element, bindingTarget.source, namespace);
        }
    }
    kendo.unbind = unbind;
    kendo.bind = bind;
    kendo.data.binders = binders;
    kendo.data.Binder = Binder;
    kendo.notify = notify;
    kendo.observable = function(object) {
        if (!(object instanceof ObservableObject)) {
            object = new ObservableObject(object);
        }
        return object;
    };
    kendo.observableHierarchy = function(array) {
        var dataSource = kendo.data.HierarchicalDataSource.create(array);
        function recursiveRead(data) {
            var i, children;
            for (i = 0; i < data.length; i++) {
                data[i]._initChildren();
                children = data[i].children;
                children.fetch();
                data[i].items = children.data();
                recursiveRead(data[i].items);
            }
        }
        dataSource.fetch();
        recursiveRead(dataSource.data());
        dataSource._data._dataSource = dataSource;
        return dataSource._data;
    };
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, Widget = kendo.ui.Widget, NS = ".kendoValidator", INVALIDMSG = "k-invalid-msg", INVALIDINPUT = "k-invalid", emailRegExp = /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i, urlRegExp = /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i, INPUTSELECTOR = ":input:not(:button,[type=submit],[type=reset],[disabled],[readonly])", CHECKBOXSELECTOR = ":checkbox:not([disabled],[readonly])", NUMBERINPUTSELECTOR = "[type=number],[type=range]", BLUR = "blur", NAME = "name", FORM = "form", NOVALIDATE = "novalidate", proxy = $.proxy, patternMatcher = function(value, pattern) {
        if (typeof pattern === "string") {
            pattern = new RegExp("^(?:" + pattern + ")$");
        }
        return pattern.test(value);
    }, matcher = function(input, selector, pattern) {
        var value = input.val();
        if (input.filter(selector).length && value !== "") {
            return patternMatcher(value, pattern);
        }
        return true;
    }, hasAttribute = function(input, name) {
        if (input.length) {
            return input[0].attributes[name] !== undefined;
        }
        return false;
    }, nameSpecialCharRegExp = /("|'|\[|\]|\$|\.|\:|\+)/g;
    if (!kendo.ui.validator) {
        kendo.ui.validator = {
            rules: {},
            messages: {}
        };
    }
    function resolveRules(element) {
        var resolvers = kendo.ui.validator.ruleResolvers || {}, rules = {}, name;
        for (name in resolvers) {
            $.extend(true, rules, resolvers[name].resolve(element));
        }
        return rules;
    }
    function decode(value) {
        return value.replace(/&amp/g, "&amp;").replace(/&quot;/g, '"').replace(/&#39;/g, "'").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
    }
    function numberOfDecimalDigits(value) {
        value = (value + "").split(".");
        if (value.length > 1) {
            return value[1].length;
        }
        return 0;
    }
    var Validator = Widget.extend({
        init: function(element, options) {
            var that = this, resolved = resolveRules(element);
            options = options || {};
            options.rules = $.extend({}, kendo.ui.validator.rules, resolved.rules, options.rules);
            options.messages = $.extend({}, kendo.ui.validator.messages, resolved.messages, options.messages);
            Widget.fn.init.call(that, element, options);
            that._errorTemplate = kendo.template(that.options.errorTemplate);
            if (that.element.is(FORM)) {
                that.element.attr(NOVALIDATE, NOVALIDATE);
            }
            that._errors = {};
            that._attachEvents();
        },
        options: {
            name: "Validator",
            errorTemplate: '<span class="k-widget k-tooltip k-tooltip-validation">' + '<span class="k-icon k-warning"> </span> #=message#</span>',
            messages: {
                required: "{0} is required",
                pattern: "{0} is not valid",
                min: "{0} should be greater than or equal to {1}",
                max: "{0} should be smaller than or equal to {1}",
                step: "{0} is not valid",
                email: "{0} is not valid email",
                url: "{0} is not valid URL",
                date: "{0} is not valid date"
            },
            rules: {
                required: function(input) {
                    var checkbox = input.filter("[type=checkbox]").length && input.attr("checked") !== "checked", value = input.val();
                    return !(hasAttribute(input, "required") && (value === "" || !value || checkbox));
                },
                pattern: function(input) {
                    if (input.filter("[type=text],[type=email],[type=url],[type=tel],[type=search],[type=password]").filter("[pattern]").length && input.val() !== "") {
                        return patternMatcher(input.val(), input.attr("pattern"));
                    }
                    return true;
                },
                min: function(input) {
                    if (input.filter(NUMBERINPUTSELECTOR + ",[" + kendo.attr("type") + "=number]").filter("[min]").length && input.val() !== "") {
                        var min = parseFloat(input.attr("min")) || 0, val = parseFloat(input.val());
                        return min <= val;
                    }
                    return true;
                },
                max: function(input) {
                    if (input.filter(NUMBERINPUTSELECTOR + ",[" + kendo.attr("type") + "=number]").filter("[max]").length && input.val() !== "") {
                        var max = parseFloat(input.attr("max")) || 0, val = parseFloat(input.val());
                        return max >= val;
                    }
                    return true;
                },
                step: function(input) {
                    if (input.filter(NUMBERINPUTSELECTOR + ",[" + kendo.attr("type") + "=number]").filter("[step]").length && input.val() !== "") {
                        var min = parseFloat(input.attr("min")) || 0, step = parseFloat(input.attr("step")) || 1, val = parseFloat(input.val()), decimals = numberOfDecimalDigits(step), raise;
                        if (decimals) {
                            raise = Math.pow(10, decimals);
                            return (val - min) * raise % (step * raise) / Math.pow(100, decimals) === 0;
                        }
                        return (val - min) % step === 0;
                    }
                    return true;
                },
                email: function(input) {
                    return matcher(input, "[type=email],[" + kendo.attr("type") + "=email]", emailRegExp);
                },
                url: function(input) {
                    return matcher(input, "[type=url],[" + kendo.attr("type") + "=url]", urlRegExp);
                },
                date: function(input) {
                    if (input.filter("[type^=date],[" + kendo.attr("type") + "=date]").length && input.val() !== "") {
                        return kendo.parseDate(input.val(), input.attr(kendo.attr("format"))) !== null;
                    }
                    return true;
                }
            },
            validateOnBlur: true
        },
        destroy: function() {
            Widget.fn.destroy.call(this);
            this.element.off(NS);
        },
        _submit: function(e) {
            if (!this.validate()) {
                e.stopPropagation();
                e.stopImmediatePropagation();
                e.preventDefault();
                return false;
            }
            return true;
        },
        _attachEvents: function() {
            var that = this;
            if (that.element.is(FORM)) {
                that.element.on("submit" + NS, proxy(that._submit, that));
            }
            if (that.options.validateOnBlur) {
                if (!that.element.is(INPUTSELECTOR)) {
                    that.element.on(BLUR + NS, INPUTSELECTOR, function() {
                        that.validateInput($(this));
                    });
                    that.element.on("click" + NS, CHECKBOXSELECTOR, function() {
                        that.validateInput($(this));
                    });
                } else {
                    that.element.on(BLUR + NS, function() {
                        that.validateInput(that.element);
                    });
                    if (that.element.is(CHECKBOXSELECTOR)) {
                        that.element.on("click" + NS, function() {
                            that.validateInput(that.element);
                        });
                    }
                }
            }
        },
        validate: function() {
            var that = this, inputs, idx, invalid = false, length;
            that._errors = {};
            if (!that.element.is(INPUTSELECTOR)) {
                inputs = that.element.find(INPUTSELECTOR);
                for (idx = 0, length = inputs.length; idx < length; idx++) {
                    if (!that.validateInput(inputs.eq(idx))) {
                        invalid = true;
                    }
                }
                return !invalid;
            }
            return that.validateInput(that.element);
        },
        validateInput: function(input) {
            input = $(input);
            var that = this, template = that._errorTemplate, result = that._checkValidity(input), valid = result.valid, className = "." + INVALIDMSG, fieldName = input.attr(NAME) || "", lbl = that._findMessageContainer(fieldName).add(input.next(className)).hide(), messageText;
            input.removeAttr("aria-invalid");
            if (!valid) {
                messageText = that._extractMessage(input, result.key);
                that._errors[fieldName] = messageText;
                var messageLabel = $(template({
                    message: decode(messageText)
                }));
                that._decorateMessageContainer(messageLabel, fieldName);
                if (!lbl.replaceWith(messageLabel).length) {
                    messageLabel.insertAfter(input);
                }
                messageLabel.show();
                input.attr("aria-invalid", true);
            }
            input.toggleClass(INVALIDINPUT, !valid);
            return valid;
        },
        hideMessages: function() {
            var that = this, className = "." + INVALIDMSG, element = that.element;
            if (!element.is(INPUTSELECTOR)) {
                element.find(className).hide();
            } else {
                element.next(className).hide();
            }
        },
        _findMessageContainer: function(fieldName) {
            var locators = kendo.ui.validator.messageLocators, name, containers = this.element.find("." + INVALIDMSG + "[" + kendo.attr("for") + "=" + fieldName.replace(nameSpecialCharRegExp, "\\$1") + "]");
            for (name in locators) {
                containers = containers.add(locators[name].locate(this.element, fieldName));
            }
            return containers;
        },
        _decorateMessageContainer: function(container, fieldName) {
            var locators = kendo.ui.validator.messageLocators, name;
            container.addClass(INVALIDMSG).attr(kendo.attr("for"), fieldName || "");
            for (name in locators) {
                locators[name].decorate(container, fieldName);
            }
            container.attr("role", "alert");
        },
        _extractMessage: function(input, ruleKey) {
            var that = this, customMessage = that.options.messages[ruleKey], fieldName = input.attr(NAME);
            customMessage = $.isFunction(customMessage) ? customMessage(input) : customMessage;
            return kendo.format(input.attr(kendo.attr(ruleKey + "-msg")) || input.attr("validationMessage") || input.attr("title") || customMessage || "", fieldName, input.attr(ruleKey));
        },
        _checkValidity: function(input) {
            var rules = this.options.rules, rule;
            for (rule in rules) {
                if (!rules[rule](input)) {
                    return {
                        valid: false,
                        key: rule
                    };
                }
            }
            return {
                valid: true
            };
        },
        errors: function() {
            var results = [], errors = this._errors, error;
            for (error in errors) {
                results.push(errors[error]);
            }
            return results;
        }
    });
    kendo.ui.plugin(Validator);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, support = kendo.support, pointers = support.pointers, document = window.document, SURFACE = $(document.documentElement), Class = kendo.Class, Observable = kendo.Observable, now = $.now, extend = $.extend, OS = support.mobileOS, invalidZeroEvents = OS && OS.android, // UserEvents events
    PRESS = "press", SELECT = "select", START = "start", MOVE = "move", END = "end", CANCEL = "cancel", TAP = "tap", GESTURESTART = "gesturestart", GESTURECHANGE = "gesturechange", GESTUREEND = "gestureend", GESTURETAP = "gesturetap";
    function touchDelta(touch1, touch2) {
        var x1 = touch1.x.location, y1 = touch1.y.location, x2 = touch2.x.location, y2 = touch2.y.location, dx = x1 - x2, dy = y1 - y2;
        return {
            center: {
                x: (x1 + x2) / 2,
                y: (y1 + y2) / 2
            },
            distance: Math.sqrt(dx * dx + dy * dy)
        };
    }
    function getTouches(e) {
        var touches = [], originalEvent = e.originalEvent, currentTarget = e.currentTarget, idx = 0, length, changedTouches, touch;
        if (e.api) {
            touches.push({
                id: 2,
                // hardcoded ID for API call;
                event: e,
                target: e.target,
                currentTarget: e.target,
                location: e
            });
        } else if (e.type.match(/touch/)) {
            changedTouches = originalEvent ? originalEvent.changedTouches : [];
            for (length = changedTouches.length; idx < length; idx++) {
                touch = changedTouches[idx];
                touches.push({
                    location: touch,
                    event: e,
                    target: touch.target,
                    currentTarget: currentTarget,
                    id: touch.identifier
                });
            }
        } else if (support.pointers) {
            touches.push({
                location: originalEvent,
                event: e,
                target: e.target,
                currentTarget: currentTarget,
                id: originalEvent.pointerId
            });
        } else {
            touches.push({
                id: 1,
                // hardcoded ID for mouse event;
                event: e,
                target: e.target,
                currentTarget: currentTarget,
                location: e
            });
        }
        return touches;
    }
    var TouchAxis = Class.extend({
        init: function(axis, location) {
            var that = this;
            that.axis = axis;
            that._updateLocationData(location);
            that.startLocation = that.location;
            that.velocity = that.delta = 0;
            that.timeStamp = now();
        },
        move: function(location) {
            var that = this, offset = location["page" + that.axis], timeStamp = now(), timeDelta = timeStamp - that.timeStamp || 1;
            // Firing manually events in tests can make this 0;
            if (!offset && invalidZeroEvents) {
                return;
            }
            that.delta = offset - that.location;
            that._updateLocationData(location);
            that.initialDelta = offset - that.startLocation;
            that.velocity = that.delta / timeDelta;
            that.timeStamp = timeStamp;
        },
        _updateLocationData: function(location) {
            var that = this, axis = that.axis;
            that.location = location["page" + axis];
            that.client = location["client" + axis];
            that.screen = location["screen" + axis];
        }
    });
    var Touch = Class.extend({
        init: function(userEvents, target, touchInfo) {
            var that = this;
            extend(that, {
                x: new TouchAxis("X", touchInfo.location),
                y: new TouchAxis("Y", touchInfo.location),
                userEvents: userEvents,
                target: target,
                currentTarget: touchInfo.currentTarget,
                initialTouch: touchInfo.target,
                id: touchInfo.id,
                _moved: false,
                _finished: false
            });
            that.notifyInit = function() {
                that._trigger(PRESS, touchInfo);
            };
        },
        move: function(touchInfo) {
            var that = this;
            if (that._finished) {
                return;
            }
            that.x.move(touchInfo.location);
            that.y.move(touchInfo.location);
            if (!that._moved) {
                if (that._withinIgnoreThreshold()) {
                    return;
                }
                if (!UserEvents.current || UserEvents.current === that.userEvents) {
                    that._start(touchInfo);
                } else {
                    return that.dispose();
                }
            }
            // Event handlers may cancel the drag in the START event handler, hence the double check for pressed.
            if (!that._finished) {
                that._trigger(MOVE, touchInfo);
            }
        },
        end: function(touchInfo) {
            var that = this;
            that.endTime = now();
            if (that._finished) {
                return;
            }
            if (that._moved) {
                that._trigger(END, touchInfo);
            } else {
                that._trigger(TAP, touchInfo);
            }
            that.dispose();
        },
        dispose: function() {
            var that = this, userEvents = that.userEvents, activeTouches = userEvents.touches;
            that._finished = true;
            activeTouches.splice($.inArray(that, activeTouches), 1);
        },
        skip: function() {
            this.dispose();
        },
        cancel: function() {
            this.dispose();
        },
        isMoved: function() {
            return this._moved;
        },
        _start: function(touchInfo) {
            this.startTime = now();
            this._moved = true;
            this._trigger(START, touchInfo);
        },
        _trigger: function(name, touchInfo) {
            var that = this, jQueryEvent = touchInfo.event, data = {
                touch: that,
                x: that.x,
                y: that.y,
                target: that.target,
                event: jQueryEvent
            };
            if (that.userEvents.notify(name, data)) {
                jQueryEvent.preventDefault();
            }
        },
        _withinIgnoreThreshold: function() {
            var xDelta = this.x.initialDelta, yDelta = this.y.initialDelta;
            return Math.sqrt(xDelta * xDelta + yDelta * yDelta) <= this.userEvents.threshold;
        }
    });
    function preventTrigger(e) {
        e.preventDefault();
        var target = $(e.data.root), // Determine the correct parent to receive the event and bubble.
        parent = target.closest(".k-widget").parent();
        if (!parent[0]) {
            parent = target.parent();
        }
        parent.trigger($.Event(e.type, {
            target: target[0]
        }));
    }
    var UserEvents = Observable.extend({
        init: function(element, options) {
            var that = this, filter, ns = kendo.guid();
            options = options || {};
            filter = that.filter = options.filter;
            that.threshold = options.threshold || 0;
            that.touches = [];
            that._maxTouches = options.multiTouch ? 2 : 1;
            that.allowSelection = options.allowSelection;
            that.eventNS = ns;
            element = $(element).handler(that);
            Observable.fn.init.call(that);
            extend(that, {
                element: element,
                surface: options.global ? SURFACE : options.surface || element,
                stopPropagation: options.stopPropagation,
                pressed: false
            });
            that.surface.handler(that).on(kendo.applyEventMap("move", ns), "_move").on(kendo.applyEventMap("up cancel", ns), "_end");
            element.on(kendo.applyEventMap("down", ns), filter, "_start");
            if (pointers) {
                element.css("-ms-touch-action", "pinch-zoom double-tap-zoom");
            }
            if (options.preventDragEvent) {
                element.on(kendo.applyEventMap("dragstart", ns), kendo.preventDefault);
            }
            element.on(kendo.applyEventMap("mousedown selectstart", ns), filter, {
                root: element
            }, "_select");
            if (support.eventCapture) {
                var downEvents = kendo.eventMap.up.split(" "), idx = 0, length = downEvents.length, surfaceElement = that.surface[0], preventIfMoving = function(e) {
                    if (that._isMoved()) {
                        e.preventDefault();
                    }
                };
                for (;idx < length; idx++) {
                    surfaceElement.addEventListener(downEvents[idx], preventIfMoving, true);
                }
            }
            that.bind([ PRESS, TAP, START, MOVE, END, CANCEL, GESTURESTART, GESTURECHANGE, GESTUREEND, GESTURETAP, SELECT ], options);
        },
        destroy: function() {
            var that = this;
            that.element.kendoDestroy(that.eventNS);
            that.surface.kendoDestroy(that.eventNS);
            that._disposeAll();
            that.unbind();
        },
        capture: function() {
            UserEvents.current = this;
        },
        cancel: function() {
            this._disposeAll();
            this.trigger(CANCEL);
        },
        notify: function(eventName, data) {
            var that = this, touches = that.touches;
            if (this._isMultiTouch()) {
                switch (eventName) {
                  case MOVE:
                    eventName = GESTURECHANGE;
                    break;

                  case END:
                    eventName = GESTUREEND;
                    break;

                  case TAP:
                    eventName = GESTURETAP;
                    break;
                }
                extend(data, {
                    touches: touches
                }, touchDelta(touches[0], touches[1]));
            }
            return this.trigger(eventName, data);
        },
        // API
        press: function(x, y, target) {
            this._apiCall("_start", x, y, target);
        },
        move: function(x, y) {
            this._apiCall("_move", x, y);
        },
        end: function(x, y) {
            this._apiCall("_end", x, y);
        },
        _isMultiTouch: function() {
            return this.touches.length > 1;
        },
        _maxTouchesReached: function() {
            return this.touches.length >= this._maxTouches;
        },
        _disposeAll: function() {
            $.each(this.touches, function() {
                this.dispose();
            });
        },
        _isMoved: function() {
            return $.grep(this.touches, function(touch) {
                return touch.isMoved();
            }).length;
        },
        _select: function(e) {
            if (!this.allowSelection || this.trigger(SELECT, {
                event: e
            })) {
                preventTrigger(e);
            }
        },
        _start: function(e) {
            var that = this, idx = 0, filter = that.filter, target, touches = getTouches(e), length = touches.length, touch;
            if (that._maxTouchesReached()) {
                return;
            }
            UserEvents.current = null;
            that.currentTarget = e.currentTarget;
            if (that.stopPropagation) {
                e.stopPropagation();
            }
            for (;idx < length; idx++) {
                if (that._maxTouchesReached()) {
                    break;
                }
                touch = touches[idx];
                if (filter) {
                    target = $(touch.currentTarget);
                } else {
                    target = that.element;
                }
                if (!target.length) {
                    continue;
                }
                touch = new Touch(that, target, touch);
                that.touches.push(touch);
                touch.notifyInit();
                if (that._isMultiTouch()) {
                    that.notify("gesturestart", {});
                }
            }
        },
        _move: function(e) {
            this._eachTouch("move", e);
        },
        _end: function(e) {
            this._eachTouch("end", e);
        },
        _eachTouch: function(methodName, e) {
            var that = this, dict = {}, touches = getTouches(e), activeTouches = that.touches, idx, touch, touchInfo, matchingTouch;
            for (idx = 0; idx < activeTouches.length; idx++) {
                touch = activeTouches[idx];
                dict[touch.id] = touch;
            }
            for (idx = 0; idx < touches.length; idx++) {
                touchInfo = touches[idx];
                matchingTouch = dict[touchInfo.id];
                if (matchingTouch) {
                    matchingTouch[methodName](touchInfo);
                }
            }
        },
        _apiCall: function(type, x, y, target) {
            this[type]({
                api: true,
                pageX: x,
                pageY: y,
                target: target || this.element,
                stopPropagation: $.noop,
                preventDefault: $.noop
            });
        }
    });
    kendo.getTouches = getTouches;
    kendo.touchDelta = touchDelta;
    kendo.UserEvents = UserEvents;
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, support = kendo.support, document = window.document, Class = kendo.Class, Widget = kendo.ui.Widget, Observable = kendo.Observable, UserEvents = kendo.UserEvents, proxy = $.proxy, extend = $.extend, getOffset = kendo.getOffset, draggables = {}, dropTargets = {}, dropAreas = {}, lastDropTarget, OS = support.mobileOS, invalidZeroEvents = OS && OS.android, mobileChrome = invalidZeroEvents && OS.browser == "chrome", KEYUP = "keyup", CHANGE = "change", // Draggable events
    DRAGSTART = "dragstart", DRAG = "drag", DRAGEND = "dragend", DRAGCANCEL = "dragcancel", // DropTarget events
    DRAGENTER = "dragenter", DRAGLEAVE = "dragleave", DROP = "drop";
    function contains(parent, child) {
        try {
            return $.contains(parent, child) || parent == child;
        } catch (e) {
            return false;
        }
    }
    function elementUnderCursor(e) {
        if (mobileChrome) {
            return document.elementFromPoint(e.x.screen, e.y.screen);
        } else {
            return document.elementFromPoint(e.x.client, e.y.client);
        }
    }
    function numericCssPropery(element, property) {
        return parseInt(element.css(property), 10) || 0;
    }
    function within(value, range) {
        return Math.min(Math.max(value, range.min), range.max);
    }
    function containerBoundaries(container, element) {
        var offset = getOffset(container), minX = offset.left + numericCssPropery(container, "borderLeftWidth") + numericCssPropery(container, "paddingLeft"), minY = offset.top + numericCssPropery(container, "borderTopWidth") + numericCssPropery(container, "paddingTop"), maxX = minX + container.width() - element.outerWidth(true), maxY = minY + container.height() - element.outerHeight(true);
        return {
            x: {
                min: minX,
                max: maxX
            },
            y: {
                min: minY,
                max: maxY
            }
        };
    }
    function checkTarget(target, targets, areas) {
        var theTarget, theFilter, i = 0, targetLen = targets && targets.length, areaLen = areas && areas.length;
        while (target && target.parentNode) {
            for (i = 0; i < targetLen; i++) {
                theTarget = targets[i];
                if (theTarget.element[0] === target) {
                    return {
                        target: theTarget,
                        targetElement: target
                    };
                }
            }
            for (i = 0; i < areaLen; i++) {
                theFilter = areas[i];
                if (support.matchesSelector.call(target, theFilter.options.filter)) {
                    return {
                        target: theFilter,
                        targetElement: target
                    };
                }
            }
            target = target.parentNode;
        }
        return undefined;
    }
    var TapCapture = Observable.extend({
        init: function(element, options) {
            var that = this, domElement = element[0];
            that.capture = false;
            $.each(kendo.eventMap.down.split(" "), function() {
                domElement.addEventListener(this, proxy(that._press, that), true);
            });
            $.each(kendo.eventMap.up.split(" "), function() {
                domElement.addEventListener(this, proxy(that._release, that), true);
            });
            Observable.fn.init.call(that);
            that.bind([ "press", "release" ], options || {});
        },
        captureNext: function() {
            this.capture = true;
        },
        cancelCapture: function() {
            this.capture = false;
        },
        _press: function(e) {
            var that = this;
            that.trigger("press");
            if (that.capture) {
                e.preventDefault();
            }
        },
        _release: function(e) {
            var that = this;
            that.trigger("release");
            if (that.capture) {
                e.preventDefault();
                that.cancelCapture();
            }
        }
    });
    var PaneDimension = Observable.extend({
        init: function(options) {
            var that = this;
            Observable.fn.init.call(that);
            that.forcedEnabled = false;
            $.extend(that, options);
            that.scale = 1;
            that.max = 0;
            if (that.horizontal) {
                that.measure = "width";
                that.scrollSize = "scrollWidth";
                that.axis = "x";
            } else {
                that.measure = "height";
                that.scrollSize = "scrollHeight";
                that.axis = "y";
            }
        },
        outOfBounds: function(offset) {
            return offset > this.max || offset < this.min;
        },
        forceEnabled: function() {
            this.forcedEnabled = true;
        },
        getSize: function() {
            return this.container[this.measure]();
        },
        getTotal: function() {
            return this.element[0][this.scrollSize];
        },
        rescale: function(scale) {
            this.scale = scale;
        },
        update: function(silent) {
            var that = this, total = that.getTotal(), scaledTotal = total * that.scale, size = that.getSize();
            that.size = size;
            that.total = scaledTotal;
            that.min = Math.min(that.max, that.size - scaledTotal);
            that.minScale = that.size / total;
            that.enabled = that.forcedEnabled || scaledTotal > size;
            if (!silent) {
                that.trigger(CHANGE, that);
            }
        }
    });
    var PaneDimensions = Observable.extend({
        init: function(options) {
            var that = this, refresh = proxy(that.refresh, that);
            Observable.fn.init.call(that);
            that.x = new PaneDimension(extend({
                horizontal: true
            }, options));
            that.y = new PaneDimension(extend({
                horizontal: false
            }, options));
            that.forcedMinScale = options.minScale;
            that.bind(CHANGE, options);
            kendo.onResize(refresh);
        },
        rescale: function(newScale) {
            this.x.rescale(newScale);
            this.y.rescale(newScale);
            this.refresh();
        },
        refresh: function() {
            var that = this;
            that.x.update();
            that.y.update();
            that.enabled = that.x.enabled || that.y.enabled;
            that.minScale = that.forcedMinScale || Math.max(that.x.minScale, that.y.minScale);
            that.trigger(CHANGE);
        }
    });
    var PaneAxis = Observable.extend({
        init: function(options) {
            var that = this;
            extend(that, options);
            Observable.fn.init.call(that);
        },
        dragMove: function(delta) {
            var that = this, dimension = that.dimension, axis = that.axis, movable = that.movable, position = movable[axis] + delta;
            if (!dimension.enabled) {
                return;
            }
            if (position < dimension.min && delta < 0 || position > dimension.max && delta > 0) {
                delta *= that.resistance;
            }
            movable.translateAxis(axis, delta);
            that.trigger(CHANGE, that);
        }
    });
    var Pane = Class.extend({
        init: function(options) {
            var that = this, x, y, resistance, movable;
            extend(that, {
                elastic: true
            }, options);
            resistance = that.elastic ? .5 : 0;
            movable = that.movable;
            that.x = x = new PaneAxis({
                axis: "x",
                dimension: that.dimensions.x,
                resistance: resistance,
                movable: movable
            });
            that.y = y = new PaneAxis({
                axis: "y",
                dimension: that.dimensions.y,
                resistance: resistance,
                movable: movable
            });
            that.userEvents.bind([ "move", "end", "gesturestart", "gesturechange" ], {
                gesturestart: function(e) {
                    that.gesture = e;
                },
                gesturechange: function(e) {
                    var previousGesture = that.gesture, previousCenter = previousGesture.center, center = e.center, scaleDelta = e.distance / previousGesture.distance, minScale = that.dimensions.minScale, coordinates;
                    if (movable.scale <= minScale && scaleDelta < 1) {
                        // Resist shrinking. Instead of shrinking from 1 to 0.5, it will shrink to 0.5 + (1 /* minScale */ - 0.5) * 0.8 = 0.9;
                        scaleDelta += (1 - scaleDelta) * .8;
                    }
                    coordinates = {
                        x: (movable.x - previousCenter.x) * scaleDelta + center.x - movable.x,
                        y: (movable.y - previousCenter.y) * scaleDelta + center.y - movable.y
                    };
                    movable.scaleWith(scaleDelta);
                    x.dragMove(coordinates.x);
                    y.dragMove(coordinates.y);
                    that.dimensions.rescale(movable.scale);
                    that.gesture = e;
                },
                move: function(e) {
                    if (x.dimension.enabled || y.dimension.enabled) {
                        x.dragMove(e.x.delta);
                        y.dragMove(e.y.delta);
                        e.preventDefault();
                    } else {
                        e.touch.skip();
                    }
                },
                end: function(e) {
                    e.preventDefault();
                }
            });
        }
    });
    var TRANSFORM_STYLE = support.transitions.prefix + "Transform", round = Math.round, translate;
    if (support.hasHW3D) {
        translate = function(x, y, scale) {
            return "translate3d(" + round(x) + "px," + round(y) + "px,0) scale(" + scale + ")";
        };
    } else {
        translate = function(x, y, scale) {
            return "translate(" + round(x) + "px," + round(y) + "px) scale(" + scale + ")";
        };
    }
    var Movable = Observable.extend({
        init: function(element) {
            var that = this;
            Observable.fn.init.call(that);
            that.element = $(element);
            that.element[0].style.webkitTransformOrigin = "left top";
            that.x = 0;
            that.y = 0;
            that.scale = 1;
            that._saveCoordinates(translate(that.x, that.y, that.scale));
        },
        translateAxis: function(axis, by) {
            this[axis] += by;
            this.refresh();
        },
        scaleTo: function(scale) {
            this.scale = scale;
            this.refresh();
        },
        scaleWith: function(scaleDelta) {
            this.scale *= scaleDelta;
            this.refresh();
        },
        translate: function(coordinates) {
            this.x += coordinates.x;
            this.y += coordinates.y;
            this.refresh();
        },
        moveAxis: function(axis, value) {
            this[axis] = value;
            this.refresh();
        },
        moveTo: function(coordinates) {
            extend(this, coordinates);
            this.refresh();
        },
        refresh: function() {
            var that = this, newCoordinates = translate(that.x, that.y, that.scale);
            if (newCoordinates != that.coordinates) {
                that.element[0].style[TRANSFORM_STYLE] = newCoordinates;
                that._saveCoordinates(newCoordinates);
                that.trigger(CHANGE);
            }
        },
        _saveCoordinates: function(coordinates) {
            this.coordinates = coordinates;
        }
    });
    var DropTarget = Widget.extend({
        init: function(element, options) {
            var that = this;
            Widget.fn.init.call(that, element, options);
            var group = that.options.group;
            if (!(group in dropTargets)) {
                dropTargets[group] = [ that ];
            } else {
                dropTargets[group].push(that);
            }
        },
        events: [ DRAGENTER, DRAGLEAVE, DROP ],
        options: {
            name: "DropTarget",
            group: "default"
        },
        destroy: function() {
            var groupName = this.options.group, group = dropTargets[groupName] || dropAreas[groupName], i;
            if (group.length > 1) {
                Widget.fn.destroy.call(this);
                for (i = 0; i < group.length; i++) {
                    if (group[i] == this) {
                        group.splice(i, 1);
                        break;
                    }
                }
            } else {
                DropTarget.destroyGroup(groupName);
            }
        },
        _trigger: function(eventName, e) {
            var that = this, draggable = draggables[that.options.group];
            if (draggable) {
                return that.trigger(eventName, extend({}, e.event, {
                    draggable: draggable,
                    dropTarget: e.dropTarget
                }));
            }
        },
        _over: function(e) {
            this._trigger(DRAGENTER, e);
        },
        _out: function(e) {
            this._trigger(DRAGLEAVE, e);
        },
        _drop: function(e) {
            var that = this, draggable = draggables[that.options.group];
            if (draggable) {
                draggable.dropped = !that._trigger(DROP, e);
            }
        }
    });
    DropTarget.destroyGroup = function(groupName) {
        var group = dropTargets[groupName] || dropAreas[groupName], i;
        if (group) {
            for (i = 0; i < group.length; i++) {
                Widget.fn.destroy.call(group[i]);
            }
            group.length = 0;
            delete dropTargets[groupName];
            delete dropAreas[groupName];
        }
    };
    DropTarget._cache = dropTargets;
    var DropTargetArea = DropTarget.extend({
        init: function(element, options) {
            var that = this;
            Widget.fn.init.call(that, element, options);
            var group = that.options.group;
            if (!(group in dropAreas)) {
                dropAreas[group] = [ that ];
            } else {
                dropAreas[group].push(that);
            }
        },
        options: {
            name: "DropTargetArea",
            group: "default",
            filter: null
        }
    });
    var Draggable = Widget.extend({
        init: function(element, options) {
            var that = this;
            Widget.fn.init.call(that, element, options);
            that.userEvents = new UserEvents(that.element, {
                global: true,
                stopPropagation: true,
                filter: that.options.filter,
                threshold: that.options.distance,
                start: proxy(that._start, that),
                move: proxy(that._drag, that),
                end: proxy(that._end, that),
                cancel: proxy(that._cancel, that)
            });
            that._afterEndHandler = proxy(that._afterEnd, that);
            that.captureEscape = function(e) {
                if (e.keyCode === kendo.keys.ESC) {
                    that._trigger(DRAGCANCEL, {
                        event: e
                    });
                    that.userEvents.cancel();
                }
            };
        },
        events: [ DRAGSTART, DRAG, DRAGEND, DRAGCANCEL ],
        options: {
            name: "Draggable",
            distance: 5,
            group: "default",
            cursorOffset: null,
            axis: null,
            container: null,
            dropped: false
        },
        _updateHint: function(e) {
            var that = this, coordinates, options = that.options, boundaries = that.boundaries, axis = options.axis, cursorOffset = that.options.cursorOffset;
            if (cursorOffset) {
                coordinates = {
                    left: e.x.location + cursorOffset.left,
                    top: e.y.location + cursorOffset.top
                };
            } else {
                that.hintOffset.left += e.x.delta;
                that.hintOffset.top += e.y.delta;
                coordinates = $.extend({}, that.hintOffset);
            }
            if (boundaries) {
                coordinates.top = within(coordinates.top, boundaries.y);
                coordinates.left = within(coordinates.left, boundaries.x);
            }
            if (axis === "x") {
                delete coordinates.top;
            } else if (axis === "y") {
                delete coordinates.left;
            }
            that.hint.css(coordinates);
        },
        _start: function(e) {
            var that = this, options = that.options, container = options.container, hint = options.hint;
            that.currentTarget = e.target;
            that.currentTargetOffset = getOffset(that.currentTarget);
            if (hint) {
                if (that.hint) {
                    that.hint.stop(true, true).remove();
                }
                that.hint = $.isFunction(hint) ? $(hint.call(that, that.currentTarget)) : hint;
                var offset = getOffset(that.currentTarget);
                that.hintOffset = offset;
                that.hint.css({
                    position: "absolute",
                    zIndex: 2e4,
                    // the Window's z-index is 10000 and can be raised because of z-stacking
                    left: offset.left,
                    top: offset.top
                }).appendTo(document.body);
            }
            draggables[options.group] = that;
            that.dropped = false;
            if (container) {
                that.boundaries = containerBoundaries(container, that.hint);
            }
            if (that._trigger(DRAGSTART, e)) {
                that.userEvents.cancel();
                that._afterEnd();
            }
            $(document).on(KEYUP, that.captureEscape);
        },
        _drag: function(e) {
            var that = this;
            e.preventDefault();
            that._withDropTarget(e, function(target, targetElement) {
                if (!target) {
                    if (lastDropTarget) {
                        lastDropTarget._trigger(DRAGLEAVE, extend(e, {
                            dropTarget: $(lastDropTarget.targetElement)
                        }));
                        lastDropTarget = null;
                    }
                    return;
                }
                if (lastDropTarget) {
                    if (targetElement === lastDropTarget.targetElement) {
                        return;
                    }
                    lastDropTarget._trigger(DRAGLEAVE, extend(e, {
                        dropTarget: $(lastDropTarget.targetElement)
                    }));
                }
                target._trigger(DRAGENTER, extend(e, {
                    dropTarget: $(targetElement)
                }));
                lastDropTarget = extend(target, {
                    targetElement: targetElement
                });
            });
            that._trigger(DRAG, e);
            if (that.hint) {
                that._updateHint(e);
            }
        },
        _end: function(e) {
            var that = this;
            that._withDropTarget(e, function(target, targetElement) {
                if (target) {
                    target._drop(extend({}, e, {
                        dropTarget: $(targetElement)
                    }));
                    lastDropTarget = null;
                }
            });
            that._trigger(DRAGEND, e);
            that._cancel(e.event);
        },
        _cancel: function() {
            var that = this;
            if (that.hint && !that.dropped) {
                setTimeout(function() {
                    that.hint.stop(true, true).animate(that.currentTargetOffset, "fast", that._afterEndHandler);
                }, 0);
            } else {
                that._afterEnd();
            }
        },
        _trigger: function(eventName, e) {
            var that = this;
            return that.trigger(eventName, extend({}, e.event, {
                x: e.x,
                y: e.y,
                currentTarget: that.currentTarget,
                dropTarget: e.dropTarget
            }));
        },
        _withDropTarget: function(e, callback) {
            var that = this, target, result, options = that.options, targets = dropTargets[options.group], areas = dropAreas[options.group];
            if (targets && targets.length || areas && areas.length) {
                target = elementUnderCursor(e);
                if (that.hint && contains(that.hint[0], target)) {
                    that.hint.hide();
                    target = elementUnderCursor(e);
                    // IE8 does not return the element in iframe from first attempt
                    if (!target) {
                        target = elementUnderCursor(e);
                    }
                    that.hint.show();
                }
                result = checkTarget(target, targets, areas);
                if (result) {
                    callback(result.target, result.targetElement);
                } else {
                    callback();
                }
            }
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that._afterEnd();
            that.userEvents.destroy();
        },
        _afterEnd: function() {
            var that = this;
            if (that.hint) {
                that.hint.remove();
            }
            delete draggables[that.options.group];
            that.trigger("destroy");
            $(document).off(KEYUP, that.captureEscape);
        }
    });
    kendo.ui.plugin(DropTarget);
    kendo.ui.plugin(DropTargetArea);
    kendo.ui.plugin(Draggable);
    kendo.TapCapture = TapCapture;
    kendo.containerBoundaries = containerBoundaries;
    extend(kendo.ui, {
        Pane: Pane,
        PaneDimensions: PaneDimensions,
        Movable: Movable
    });
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, mobile = kendo.mobile, fx = kendo.fx, ui = mobile.ui, proxy = $.proxy, extend = $.extend, Widget = ui.Widget, Class = kendo.Class, Movable = kendo.ui.Movable, Pane = kendo.ui.Pane, PaneDimensions = kendo.ui.PaneDimensions, Transition = fx.Transition, Animation = fx.Animation, abs = Math.abs, SNAPBACK_DURATION = 500, SCROLLBAR_OPACITY = .7, FRICTION = .93, OUT_OF_BOUNDS_FRICTION = .5, RELEASECLASS = "km-scroller-release", REFRESHCLASS = "km-scroller-refresh", PULL = "pull", CHANGE = "change", RESIZE = "resize", SCROLL = "scroll";
    var ZoomSnapBack = Animation.extend({
        init: function(options) {
            var that = this;
            Animation.fn.init.call(that);
            extend(that, options);
            that.userEvents.bind("gestureend", proxy(that.start, that));
            that.tapCapture.bind("press", proxy(that.cancel, that));
        },
        done: function() {
            return this.dimensions.minScale - this.movable.scale < .01;
        },
        tick: function() {
            var movable = this.movable;
            movable.scaleWith(1.1);
            this.dimensions.rescale(movable.scale);
        },
        onEnd: function() {
            var movable = this.movable;
            movable.scaleTo(this.dimensions.minScale);
            this.dimensions.rescale(movable.scale);
        }
    });
    var DragInertia = Animation.extend({
        init: function(options) {
            var that = this;
            Animation.fn.init.call(that);
            extend(that, options, {
                transition: new Transition({
                    axis: options.axis,
                    movable: options.movable,
                    onEnd: function() {
                        that._end();
                    }
                })
            });
            that.tapCapture.bind("press", function() {
                that.cancel();
            });
            that.userEvents.bind("end", proxy(that.start, that));
            that.userEvents.bind("gestureend", proxy(that.start, that));
            that.userEvents.bind("tap", proxy(that.onEnd, that));
        },
        onCancel: function() {
            this.transition.cancel();
        },
        freeze: function(location) {
            var that = this;
            that.cancel();
            that._moveTo(location);
        },
        onEnd: function() {
            var that = this;
            if (that._outOfBounds()) {
                that._snapBack();
            } else {
                that._end();
            }
        },
        done: function() {
            return abs(this.velocity) < 1;
        },
        start: function(e) {
            var that = this;
            if (!that.dimension.enabled) {
                return;
            }
            if (that._outOfBounds()) {
                that._snapBack();
            } else {
                that.velocity = e.touch[that.axis].velocity * 16;
                if (that.velocity) {
                    that.tapCapture.captureNext();
                    Animation.fn.start.call(that);
                }
            }
        },
        tick: function() {
            var that = this, dimension = that.dimension, friction = that._outOfBounds() ? OUT_OF_BOUNDS_FRICTION : FRICTION, delta = that.velocity *= friction, location = that.movable[that.axis] + delta;
            if (!that.elastic && dimension.outOfBounds(location)) {
                location = Math.max(Math.min(location, dimension.max), dimension.min);
                that.velocity = 0;
            }
            that.movable.moveAxis(that.axis, location);
        },
        _end: function() {
            this.tapCapture.cancelCapture();
            this.end();
        },
        _outOfBounds: function() {
            return this.dimension.outOfBounds(this.movable[this.axis]);
        },
        _snapBack: function() {
            var that = this, dimension = that.dimension, snapBack = that.movable[that.axis] > dimension.max ? dimension.max : dimension.min;
            that._moveTo(snapBack);
        },
        _moveTo: function(location) {
            this.transition.moveTo({
                location: location,
                duration: SNAPBACK_DURATION,
                ease: Transition.easeOutExpo
            });
        }
    });
    var ScrollBar = Class.extend({
        init: function(options) {
            var that = this, horizontal = options.axis === "x", element = $('<div class="km-touch-scrollbar km-' + (horizontal ? "horizontal" : "vertical") + '-scrollbar" />');
            extend(that, options, {
                element: element,
                elementSize: 0,
                movable: new Movable(element),
                scrollMovable: options.movable,
                size: horizontal ? "width" : "height"
            });
            that.scrollMovable.bind(CHANGE, proxy(that._move, that));
            that.container.append(element);
        },
        _move: function() {
            var that = this, axis = that.axis, dimension = that.dimension, paneSize = dimension.size, scrollMovable = that.scrollMovable, sizeRatio = paneSize / dimension.total, position = Math.round(-scrollMovable[axis] * sizeRatio), size = Math.round(paneSize * sizeRatio);
            if (position + size > paneSize) {
                size = paneSize - position;
            } else if (position < 0) {
                size += position;
                position = 0;
            }
            if (that.elementSize != size) {
                that.element.css(that.size, size + "px");
                that.elementSize = size;
            }
            that.movable.moveAxis(axis, position);
        },
        show: function() {
            this.element.css({
                opacity: SCROLLBAR_OPACITY,
                visibility: "visible"
            });
        },
        hide: function() {
            this.element.css({
                opacity: 0
            });
        }
    });
    var Scroller = Widget.extend({
        init: function(element, options) {
            var that = this;
            Widget.fn.init.call(that, element, options);
            element = that.element;
            if (that.options.useNative && kendo.support.hasNativeScrolling) {
                element.addClass("km-native-scroller").prepend('<div class="km-scroll-header"/>');
                extend(that, {
                    scrollElement: element,
                    fixedContainer: element.children().first()
                });
                return;
            }
            element.css("overflow", "hidden").addClass("km-scroll-wrapper").wrapInner('<div class="km-scroll-container"/>').prepend('<div class="km-scroll-header"/>');
            var inner = element.children().eq(1), tapCapture = new kendo.TapCapture(element), movable = new Movable(inner), dimensions = new PaneDimensions({
                element: inner,
                container: element,
                forcedEnabled: that.options.zoom,
                change: function() {
                    that.trigger(RESIZE);
                }
            }), userEvents = new kendo.UserEvents(element, {
                allowSelection: true,
                preventDragEvent: true,
                multiTouch: that.options.zoom,
                start: function(e) {
                    dimensions.refresh();
                    var velocityX = abs(e.x.velocity), velocityY = abs(e.y.velocity);
                    if (dimensions.x.enabled && velocityX * 2 >= velocityY || dimensions.y.enabled && velocityY * 2 >= velocityX) {
                        userEvents.capture();
                    } else {
                        userEvents.cancel();
                    }
                }
            }), pane = new Pane({
                movable: movable,
                dimensions: dimensions,
                userEvents: userEvents,
                elastic: that.options.elastic
            }), zoomSnapBack = new ZoomSnapBack({
                movable: movable,
                dimensions: dimensions,
                userEvents: userEvents,
                tapCapture: tapCapture
            });
            movable.bind(CHANGE, function() {
                that.scrollTop = -movable.y;
                that.scrollLeft = -movable.x;
                that.trigger(SCROLL, {
                    scrollTop: that.scrollTop,
                    scrollLeft: that.scrollLeft
                });
            });
            extend(that, {
                movable: movable,
                dimensions: dimensions,
                zoomSnapBack: zoomSnapBack,
                userEvents: userEvents,
                pane: pane,
                tapCapture: tapCapture,
                pulled: false,
                scrollElement: inner,
                fixedContainer: element.children().first()
            });
            that._initAxis("x");
            that._initAxis("y");
            dimensions.refresh();
            if (that.options.pullToRefresh) {
                that._initPullToRefresh();
            }
            kendo.onResize($.proxy(that.reset, that));
        },
        scrollHeight: function() {
            return this.scrollElement[0].scrollHeight;
        },
        scrollWidth: function() {
            return this.scrollElement[0].scrollWidth;
        },
        options: {
            name: "Scroller",
            zoom: false,
            pullOffset: 140,
            elastic: true,
            useNative: false,
            pullTemplate: "Pull to refresh",
            releaseTemplate: "Release to refresh",
            refreshTemplate: "Refreshing"
        },
        events: [ PULL, SCROLL, RESIZE ],
        setOptions: function(options) {
            var that = this;
            Widget.fn.setOptions.call(that, options);
            if (options.pullToRefresh) {
                that._initPullToRefresh();
            }
        },
        reset: function() {
            this.movable.moveTo({
                x: 0,
                y: 0
            });
        },
        scrollTo: function(x, y) {
            this.movable.moveTo({
                x: x,
                y: y
            });
        },
        pullHandled: function() {
            var that = this;
            that.refreshHint.removeClass(REFRESHCLASS);
            that.hintContainer.html(that.pullTemplate({}));
            that.yinertia.onEnd();
            that.xinertia.onEnd();
        },
        destroy: function() {
            Widget.fn.destroy.call(this);
            this.userEvents.destroy();
        },
        _initPullToRefresh: function() {
            var that = this;
            that.dimensions.y.forceEnabled();
            that.pullTemplate = kendo.template(that.options.pullTemplate);
            that.releaseTemplate = kendo.template(that.options.releaseTemplate);
            that.refreshTemplate = kendo.template(that.options.refreshTemplate);
            that.scrollElement.prepend('<span class="km-scroller-pull"><span class="km-icon"></span><span class="km-template">' + that.pullTemplate({}) + "</span></span>");
            that.refreshHint = that.scrollElement.children().first();
            that.hintContainer = that.refreshHint.children(".km-template");
            that.pane.y.bind("change", proxy(that._paneChange, that));
            that.userEvents.bind("end", proxy(that._dragEnd, that));
        },
        _dragEnd: function() {
            var that = this;
            if (!that.pulled) {
                return;
            }
            that.pulled = false;
            that.refreshHint.removeClass(RELEASECLASS).addClass(REFRESHCLASS);
            that.hintContainer.html(that.refreshTemplate({}));
            that.yinertia.freeze(that.options.pullOffset / 2);
            that.trigger("pull");
        },
        _paneChange: function() {
            var that = this;
            if (that.movable.y / OUT_OF_BOUNDS_FRICTION > that.options.pullOffset) {
                if (!that.pulled) {
                    that.pulled = true;
                    that.refreshHint.removeClass(REFRESHCLASS).addClass(RELEASECLASS);
                    that.hintContainer.html(that.releaseTemplate({}));
                }
            } else if (that.pulled) {
                that.pulled = false;
                that.refreshHint.removeClass(RELEASECLASS);
                that.hintContainer.html(that.pullTemplate({}));
            }
        },
        _initAxis: function(axis) {
            var that = this, movable = that.movable, dimension = that.dimensions[axis], tapCapture = that.tapCapture, scrollBar = new ScrollBar({
                axis: axis,
                movable: movable,
                dimension: dimension,
                container: that.element
            }), inertia = new DragInertia({
                axis: axis,
                movable: movable,
                tapCapture: tapCapture,
                userEvents: that.userEvents,
                dimension: dimension,
                elastic: that.options.elastic,
                end: function() {
                    scrollBar.hide();
                }
            });
            that[axis + "inertia"] = inertia;
            that.pane[axis].bind(CHANGE, function() {
                scrollBar.show();
            });
        }
    });
    ui.plugin(Scroller);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, Widget = kendo.ui.Widget, proxy = $.proxy, NS = ".kendoGroupable", indicatorTmpl = kendo.template('<div class="k-group-indicator" data-#=data.ns#field="${data.field}" data-#=data.ns#title="${data.title || ""}" data-#=data.ns#dir="${data.dir || "asc"}">' + '<a href="\\#" class="k-link">' + '<span class="k-icon k-si-arrow-${(data.dir || "asc") == "asc" ? "n" : "s"}">(sorted ${(data.dir || "asc") == "asc" ? "ascending": "descending"})</span>' + "${data.title ? data.title: data.field}" + "</a>" + '<a class="k-button k-button-icon k-button-bare">' + '<span class="k-icon k-group-delete"></span>' + "</a>" + "</div>", {
        useWithBlock: false
    }), hint = function(target) {
        return $('<div class="k-header k-drag-clue" />').css({
            width: target.width(),
            paddingLeft: target.css("paddingLeft"),
            paddingRight: target.css("paddingRight"),
            lineHeight: target.height() + "px",
            paddingTop: target.css("paddingTop"),
            paddingBottom: target.css("paddingBottom")
        }).html(target.attr(kendo.attr("title")) || target.attr(kendo.attr("field"))).prepend('<span class="k-icon k-drag-status k-denied" />');
    }, dropCue = $('<div class="k-grouping-dropclue"/>'), nameSpecialCharRegExp = /("|'|\[|\]|\$|\.|\:|\+)/g;
    function dropCueOffsetTop(element) {
        return element.position().top + 3;
    }
    var Groupable = Widget.extend({
        init: function(element, options) {
            var that = this, groupContainer, group = kendo.guid(), intializePositions = proxy(that._intializePositions, that), draggable, dropCuePositions = that._dropCuePositions = [];
            Widget.fn.init.call(that, element, options);
            that.draggable = draggable = that.options.draggable || new kendo.ui.Draggable(that.element, {
                filter: that.options.draggableElements,
                hint: hint,
                group: group
            });
            groupContainer = that.groupContainer = $(that.options.groupContainer, that.element).kendoDropTarget({
                group: draggable.options.group,
                dragenter: function(e) {
                    if (that._canDrag(e.draggable.currentTarget)) {
                        e.draggable.hint.find(".k-drag-status").removeClass("k-denied").addClass("k-add");
                        dropCue.css({
                            top: dropCueOffsetTop(groupContainer),
                            left: 0
                        }).appendTo(groupContainer);
                    }
                },
                dragleave: function(e) {
                    e.draggable.hint.find(".k-drag-status").removeClass("k-add").addClass("k-denied");
                    dropCue.remove();
                },
                drop: function(e) {
                    var targetElement = e.draggable.currentTarget, field = targetElement.attr(kendo.attr("field")), title = targetElement.attr(kendo.attr("title")), sourceIndicator = that.indicator(field), dropCuePositions = that._dropCuePositions, lastCuePosition = dropCuePositions[dropCuePositions.length - 1], position;
                    if (!targetElement.hasClass("k-group-indicator") && !that._canDrag(targetElement)) {
                        return;
                    }
                    if (lastCuePosition) {
                        position = that._dropCuePosition(kendo.getOffset(dropCue).left + parseInt(lastCuePosition.element.css("marginLeft"), 10) + parseInt(lastCuePosition.element.css("marginRight"), 10));
                        if (position && that._canDrop($(sourceIndicator), position.element, position.left)) {
                            if (position.before) {
                                position.element.before(sourceIndicator || that.buildIndicator(field, title));
                            } else {
                                position.element.after(sourceIndicator || that.buildIndicator(field, title));
                            }
                            that._change();
                        }
                    } else {
                        that.groupContainer.append(that.buildIndicator(field, title));
                        that._change();
                    }
                }
            }).kendoDraggable({
                filter: "div.k-group-indicator",
                hint: hint,
                group: draggable.options.group,
                dragcancel: proxy(that._dragCancel, that),
                dragstart: function(e) {
                    var element = e.currentTarget, marginLeft = parseInt(element.css("marginLeft"), 10), left = element.position().left - marginLeft;
                    intializePositions();
                    dropCue.css({
                        top: dropCueOffsetTop(groupContainer),
                        left: left
                    }).appendTo(groupContainer);
                    this.hint.find(".k-drag-status").removeClass("k-denied").addClass("k-add");
                },
                dragend: function() {
                    that._dragEnd(this);
                },
                drag: proxy(that._drag, that)
            }).on("click" + NS, ".k-button", function(e) {
                e.preventDefault();
                that._removeIndicator($(this).parent());
            }).on("click" + NS, ".k-link", function(e) {
                var current = $(this).parent(), newIndicator = that.buildIndicator(current.attr(kendo.attr("field")), current.attr(kendo.attr("title")), current.attr(kendo.attr("dir")) == "asc" ? "desc" : "asc");
                current.before(newIndicator).remove();
                that._change();
                e.preventDefault();
            });
            draggable.bind([ "dragend", "dragcancel", "dragstart", "drag" ], {
                dragend: function() {
                    that._dragEnd(this);
                },
                dragcancel: proxy(that._dragCancel, that),
                dragstart: function(e) {
                    var element, marginRight, left;
                    if (!that.options.allowDrag && !that._canDrag(e.currentTarget)) {
                        e.preventDefault();
                        return;
                    }
                    intializePositions();
                    if (dropCuePositions.length) {
                        element = dropCuePositions[dropCuePositions.length - 1].element;
                        marginRight = parseInt(element.css("marginRight"), 10);
                        left = element.position().left + element.outerWidth() + marginRight;
                    } else {
                        left = 0;
                    }
                },
                drag: proxy(that._drag, that)
            });
            that.dataSource = that.options.dataSource;
            if (that.dataSource) {
                that._refreshHandler = proxy(that.refresh, that);
                that.dataSource.bind("change", that._refreshHandler);
            }
        },
        refresh: function() {
            var that = this, dataSource = that.dataSource;
            that.groupContainer.empty().append($.map(dataSource.group() || [], function(item) {
                var fieldName = item.field.replace(nameSpecialCharRegExp, "\\$1");
                var element = that.element.find(that.options.filter).filter("[" + kendo.attr("field") + "=" + fieldName + "]");
                return that.buildIndicator(item.field, element.attr(kendo.attr("title")), item.dir);
            }).join(""));
            that._invalidateGroupContainer();
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.groupContainer.off(NS).kendoDropTarget("destroy").kendoDraggable("destroy");
            if (!that.options.draggable) {
                that.draggable.destroy();
            }
            if (that.dataSource && that._refreshHandler) {
                that.dataSource.unbind("change", that._refreshHandler);
            }
        },
        options: {
            name: "Groupable",
            filter: "th",
            draggableElements: "th",
            messages: {
                empty: "Drag a column header and drop it here to group by that column"
            }
        },
        indicator: function(field) {
            var indicators = $(".k-group-indicator", this.groupContainer);
            return $.grep(indicators, function(item) {
                return $(item).attr(kendo.attr("field")) === field;
            })[0];
        },
        buildIndicator: function(field, title, dir) {
            return indicatorTmpl({
                field: field.replace(/"/g, "'"),
                dir: dir,
                title: title,
                ns: kendo.ns
            });
        },
        descriptors: function() {
            var that = this, indicators = $(".k-group-indicator", that.groupContainer), aggregates, names, field, idx, length;
            aggregates = that.element.find(that.options.filter).map(function() {
                var cell = $(this), aggregate = cell.attr(kendo.attr("aggregates")), member = cell.attr(kendo.attr("field"));
                if (aggregate && aggregate !== "") {
                    names = aggregate.split(",");
                    aggregate = [];
                    for (idx = 0, length = names.length; idx < length; idx++) {
                        aggregate.push({
                            field: member,
                            aggregate: names[idx]
                        });
                    }
                }
                return aggregate;
            }).toArray();
            return $.map(indicators, function(item) {
                item = $(item);
                field = item.attr(kendo.attr("field"));
                return {
                    field: field,
                    dir: item.attr(kendo.attr("dir")),
                    aggregates: aggregates || []
                };
            });
        },
        _removeIndicator: function(indicator) {
            var that = this;
            indicator.remove();
            that._invalidateGroupContainer();
            that._change();
        },
        _change: function() {
            var that = this;
            if (that.dataSource) {
                that.dataSource.group(that.descriptors());
            }
        },
        _dropCuePosition: function(position) {
            var dropCuePositions = this._dropCuePositions;
            if (!dropCue.is(":visible") || dropCuePositions.length === 0) {
                return;
            }
            position = Math.ceil(position);
            var lastCuePosition = dropCuePositions[dropCuePositions.length - 1], right = lastCuePosition.right, marginLeft = parseInt(lastCuePosition.element.css("marginLeft"), 10), marginRight = parseInt(lastCuePosition.element.css("marginRight"), 10);
            if (position >= right) {
                position = {
                    left: lastCuePosition.element.position().left + lastCuePosition.element.outerWidth() + marginRight,
                    element: lastCuePosition.element,
                    before: false
                };
            } else {
                position = $.grep(dropCuePositions, function(item) {
                    return item.left <= position && position <= item.right;
                })[0];
                if (position) {
                    position = {
                        left: position.element.position().left - marginLeft,
                        element: position.element,
                        before: true
                    };
                }
            }
            return position;
        },
        _drag: function(event) {
            var position = this._dropCuePosition(event.x.location);
            if (position) {
                dropCue.css({
                    left: position.left
                });
            }
        },
        _canDrag: function(element) {
            var field = element.attr(kendo.attr("field"));
            return element.attr(kendo.attr("groupable")) != "false" && field && (element.hasClass("k-group-indicator") || !this.indicator(field));
        },
        _canDrop: function(source, target, position) {
            var next = source.next();
            return source[0] !== target[0] && (!next[0] || target[0] !== next[0] || position > next.position().left);
        },
        _dragEnd: function(draggable) {
            var that = this, field = draggable.currentTarget.attr(kendo.attr("field")), sourceIndicator = that.indicator(field);
            if (draggable !== that.options.draggable && !draggable.dropped && sourceIndicator) {
                that._removeIndicator($(sourceIndicator));
            }
            that._dragCancel();
        },
        _dragCancel: function() {
            dropCue.remove();
            this._dropCuePositions = [];
        },
        _intializePositions: function() {
            var that = this, indicators = $(".k-group-indicator", that.groupContainer), left;
            that._dropCuePositions = $.map(indicators, function(item) {
                item = $(item);
                left = kendo.getOffset(item).left;
                return {
                    left: parseInt(left, 10),
                    right: parseInt(left + item.outerWidth(), 10),
                    element: item
                };
            });
        },
        _invalidateGroupContainer: function() {
            var groupContainer = this.groupContainer;
            if (groupContainer.is(":empty")) {
                groupContainer.html(this.options.messages.empty);
            }
        }
    });
    kendo.ui.plugin(Groupable);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, Widget = kendo.ui.Widget, CHANGE = "change", KREORDERABLE = "k-reorderable";
    function toggleHintClass(hint, denied) {
        hint = $(hint);
        if (denied) {
            hint.find(".k-drag-status").removeClass("k-add").addClass("k-denied");
        } else {
            hint.find(".k-drag-status").removeClass("k-denied").addClass("k-add");
        }
    }
    var Reorderable = Widget.extend({
        init: function(element, options) {
            var that = this, draggable, group = kendo.guid() + "-reorderable";
            Widget.fn.init.call(that, element, options);
            element = that.element.addClass(KREORDERABLE);
            options = that.options;
            that.draggable = draggable = options.draggable || new kendo.ui.Draggable(element, {
                group: group,
                filter: options.filter,
                hint: options.hint
            });
            that.reorderDropCue = $('<div class="k-reorder-cue"><div class="k-icon k-i-arrow-s"></div><div class="k-icon k-i-arrow-n"></div></div>');
            element.find(draggable.options.filter).kendoDropTarget({
                group: draggable.options.group,
                dragenter: function(e) {
                    if (!that._draggable) {
                        return;
                    }
                    var dropTarget = this.element, offset, same = dropTarget[0] === that._draggable[0];
                    toggleHintClass(e.draggable.hint, same);
                    if (!same) {
                        offset = kendo.getOffset(dropTarget);
                        that.reorderDropCue.css({
                            height: dropTarget.outerHeight(),
                            top: offset.top,
                            left: offset.left + (dropTarget.index() > that._draggable.index() ? dropTarget.outerWidth() : 0)
                        }).appendTo(document.body);
                    }
                },
                dragleave: function(e) {
                    toggleHintClass(e.draggable.hint, true);
                    that.reorderDropCue.remove();
                },
                drop: function() {
                    if (!that._draggable) {
                        return;
                    }
                    var draggableElement = that._draggable[0], dropTarget = this.element[0], container;
                    if (draggableElement !== dropTarget) {
                        container = element.find(draggable.options.filter);
                        that.trigger(CHANGE, {
                            element: that._draggable,
                            oldIndex: container.index(draggableElement),
                            newIndex: container.index(dropTarget)
                        });
                    }
                }
            });
            draggable.bind([ "dragcancel", "dragend", "dragstart" ], {
                dragcancel: function() {
                    that.reorderDropCue.remove();
                    that._draggable = null;
                },
                dragend: function() {
                    that.reorderDropCue.remove();
                    that._draggable = null;
                },
                dragstart: function(e) {
                    that._draggable = e.currentTarget;
                }
            });
        },
        options: {
            name: "Reorderable",
            filter: "*"
        },
        events: [ CHANGE ],
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            if (that.draggable) {
                that.draggable.destroy();
            }
            kendo.destroy(that.element);
        }
    });
    kendo.ui.plugin(Reorderable);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, Widget = ui.Widget, proxy = $.proxy, isFunction = $.isFunction, extend = $.extend, HORIZONTAL = "horizontal", VERTICAL = "vertical", START = "start", RESIZE = "resize", RESIZEEND = "resizeend";
    var Resizable = Widget.extend({
        init: function(element, options) {
            var that = this;
            Widget.fn.init.call(that, element, options);
            that.orientation = that.options.orientation.toLowerCase() != VERTICAL ? HORIZONTAL : VERTICAL;
            that._positionMouse = that.orientation == HORIZONTAL ? "x" : "y";
            that._position = that.orientation == HORIZONTAL ? "left" : "top";
            that._sizingDom = that.orientation == HORIZONTAL ? "outerWidth" : "outerHeight";
            that.draggable = new ui.Draggable(element, {
                distance: 0,
                filter: options.handle,
                drag: proxy(that._resize, that),
                dragcancel: proxy(that._cancel, that),
                dragstart: proxy(that._start, that),
                dragend: proxy(that._stop, that)
            });
            that.userEvents = that.draggable.userEvents;
        },
        events: [ RESIZE, RESIZEEND, START ],
        options: {
            name: "Resizable",
            orientation: HORIZONTAL
        },
        _max: function(e) {
            var that = this, hintSize = that.hint ? that.hint[that._sizingDom]() : 0, size = that.options.max;
            return isFunction(size) ? size(e) : size !== undefined ? that._initialElementPosition + size - hintSize : size;
        },
        _min: function(e) {
            var that = this, size = that.options.min;
            return isFunction(size) ? size(e) : size !== undefined ? that._initialElementPosition + size : size;
        },
        _start: function(e) {
            var that = this, hint = that.options.hint, el = $(e.currentTarget);
            that._initialElementPosition = el.position()[that._position];
            that._initialMousePosition = e[that._positionMouse].startLocation;
            if (hint) {
                that.hint = isFunction(hint) ? $(hint(el)) : hint;
                that.hint.css({
                    position: "absolute"
                }).css(that._position, that._initialElementPosition).appendTo(that.element);
            }
            that.trigger(START, e);
            that._maxPosition = that._max(e);
            that._minPosition = that._min(e);
            $(document.body).css("cursor", el.css("cursor"));
        },
        _resize: function(e) {
            var that = this, handle = $(e.currentTarget), maxPosition = that._maxPosition, minPosition = that._minPosition, currentPosition = that._initialElementPosition + (e[that._positionMouse].location - that._initialMousePosition), position;
            position = minPosition !== undefined ? Math.max(minPosition, currentPosition) : currentPosition;
            that.position = position = maxPosition !== undefined ? Math.min(maxPosition, position) : position;
            if (that.hint) {
                that.hint.toggleClass(that.options.invalidClass || "", position == maxPosition || position == minPosition).css(that._position, position);
            }
            that.resizing = true;
            that.trigger(RESIZE, extend(e, {
                position: position
            }));
        },
        _stop: function(e) {
            var that = this;
            if (that.hint) {
                that.hint.remove();
            }
            that.resizing = false;
            that.trigger(RESIZEEND, extend(e, {
                position: that.position
            }));
            $(document.body).css("cursor", "");
        },
        _cancel: function(e) {
            var that = this;
            if (that.hint) {
                that.position = undefined;
                that.hint.css(that._position, that._initialElementPosition);
                that._stop(e);
            }
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            if (that.draggable) {
                that.draggable.destroy();
            }
        },
        press: function(target) {
            if (!target) {
                return;
            }
            var position = target.position(), that = this;
            that.userEvents.press(position.left, position.top, target[0]);
            that.targetPosition = position;
            that.target = target;
        },
        move: function(delta) {
            var that = this, orientation = that._position, position = that.targetPosition, current = that.position;
            if (current === undefined) {
                current = position[orientation];
            }
            position[orientation] = current + delta;
            that.userEvents.move(position.left, position.top);
        },
        end: function() {
            this.userEvents.end();
            this.target = this.position = undefined;
        }
    });
    kendo.ui.plugin(Resizable);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, proxy = $.proxy, DIR = "dir", ASC = "asc", SINGLE = "single", FIELD = "field", DESC = "desc", NS = ".kendoSortable", TLINK = ".k-link", ARIASORT = "aria-sort", Widget = kendo.ui.Widget;
    var Sortable = Widget.extend({
        init: function(element, options) {
            var that = this, link;
            Widget.fn.init.call(that, element, options);
            that._refreshHandler = proxy(that.refresh, that);
            that.dataSource = that.options.dataSource.bind("change", that._refreshHandler);
            link = that.element.find(TLINK);
            if (!link[0]) {
                link = that.element.wrapInner('<a class="k-link" href="#"/>').find(TLINK);
            }
            that.link = link;
            that.element.on("click" + NS, proxy(that._click, that));
        },
        options: {
            name: "Sortable",
            mode: SINGLE,
            allowUnsort: true
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.element.off(NS);
            that.dataSource.unbind("change", that._refreshHandler);
        },
        refresh: function() {
            var that = this, sort = that.dataSource.sort() || [], idx, length, descriptor, dir, element = that.element, field = element.attr(kendo.attr(FIELD));
            element.removeAttr(kendo.attr(DIR));
            element.removeAttr(ARIASORT);
            for (idx = 0, length = sort.length; idx < length; idx++) {
                descriptor = sort[idx];
                if (field == descriptor.field) {
                    element.attr(kendo.attr(DIR), descriptor.dir);
                }
            }
            dir = element.attr(kendo.attr(DIR));
            element.find(".k-i-arrow-n,.k-i-arrow-s").remove();
            if (dir === ASC) {
                $('<span class="k-icon k-i-arrow-n" />').appendTo(that.link);
                element.attr(ARIASORT, "ascending");
            } else if (dir === DESC) {
                $('<span class="k-icon k-i-arrow-s" />').appendTo(that.link);
                element.attr(ARIASORT, "descending");
            }
        },
        _click: function(e) {
            var that = this, element = that.element, field = element.attr(kendo.attr(FIELD)), dir = element.attr(kendo.attr(DIR)), options = that.options, sort = that.dataSource.sort() || [], idx, length;
            if (dir === ASC) {
                dir = DESC;
            } else if (dir === DESC && options.allowUnsort) {
                dir = undefined;
            } else {
                dir = ASC;
            }
            if (options.mode === SINGLE) {
                sort = [ {
                    field: field,
                    dir: dir
                } ];
            } else if (options.mode === "multiple") {
                for (idx = 0, length = sort.length; idx < length; idx++) {
                    if (sort[idx].field === field) {
                        sort.splice(idx, 1);
                        break;
                    }
                }
                sort.push({
                    field: field,
                    dir: dir
                });
            }
            e.preventDefault();
            that.dataSource.sort(sort);
        }
    });
    kendo.ui.plugin(Sortable);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, Widget = kendo.ui.Widget, proxy = $.proxy, abs = Math.abs, ARIASELECTED = "aria-selected", SELECTED = "k-state-selected", ACTIVE = "k-state-selecting", SELECTABLE = "k-selectable", CHANGE = "change", NS = ".kendoSelectable", UNSELECTING = "k-state-unselecting", supportEventDelegation = false;
    (function($) {
        (function() {
            $('<div class="parent"><span /></div>').on("click", ">*", function() {
                supportEventDelegation = true;
            }).find("span").click().end().off();
        })();
    })($);
    var Selectable = Widget.extend({
        init: function(element, options) {
            var that = this, multiple;
            Widget.fn.init.call(that, element, options);
            that._marquee = $("<div class='k-marquee'></div>");
            that._lastActive = null;
            that.element.addClass(SELECTABLE);
            multiple = that.options.multiple;
            that.userEvents = new kendo.UserEvents(that.element, {
                global: true,
                allowSelection: true,
                filter: (!supportEventDelegation ? "." + SELECTABLE + " " : "") + that.options.filter,
                tap: proxy(that._tap, that)
            });
            if (multiple) {
                that.userEvents.bind("start", proxy(that._start, that)).bind("move", proxy(that._move, that)).bind("end", proxy(that._end, that)).bind("select", proxy(that._select, that));
            }
        },
        events: [ CHANGE ],
        options: {
            name: "Selectable",
            filter: ">*",
            multiple: false
        },
        _tap: function(e) {
            var target = $(e.target), that = this, ctrlKey = e.event.ctrlKey, multiple = that.options.multiple, shiftKey = multiple && e.event.shiftKey, selected, whichCode = e.event.which, buttonCode = e.event.button;
            //in case of hierarchy or right-click
            if (target.closest("." + SELECTABLE)[0] !== that.element[0] || whichCode && whichCode == 3 || buttonCode && buttonCode == 2) {
                return;
            }
            selected = target.hasClass(SELECTED);
            if (!multiple || !ctrlKey) {
                that.clear();
            }
            if (shiftKey) {
                that.selectRange(that._firstSelectee(), target);
            } else {
                if (selected && ctrlKey) {
                    that._unselect(target);
                    that._notify(CHANGE);
                } else {
                    that.value(target);
                }
                that._lastActive = that._downTarget = target;
            }
        },
        _start: function(e) {
            var that = this, target = $(e.target), selected = target.hasClass(SELECTED), ctrlKey = e.event.ctrlKey;
            that._downTarget = target;
            //in case of hierarchy
            if (target.closest("." + SELECTABLE)[0] !== that.element[0]) {
                that.userEvents.cancel();
                that._downTarget = null;
                return;
            }
            that._marquee.appendTo(document.body).css({
                left: e.x.client + 1,
                top: e.y.client + 1,
                width: 0,
                height: 0
            });
            if (!ctrlKey) {
                that.clear();
            }
            if (selected) {
                that._selectElement(target, true);
                if (ctrlKey) {
                    target.addClass(UNSELECTING);
                }
            }
        },
        _move: function(e) {
            var that = this, position = {
                left: e.x.startLocation > e.x.location ? e.x.location : e.x.startLocation,
                top: e.y.startLocation > e.y.location ? e.y.location : e.y.startLocation,
                width: abs(e.x.initialDelta),
                height: abs(e.y.initialDelta)
            }, items = that.element.find(that.options.filter);
            that._marquee.css(position);
            invalidateSelectables(items, that._downTarget[0], position, e.event.ctrlKey);
            e.preventDefault();
        },
        _end: function() {
            var that = this;
            that._marquee.remove();
            that._unselect(that.element.find(that.options.filter + "." + UNSELECTING)).removeClass(UNSELECTING);
            that.value(that.element.find(that.options.filter + "." + ACTIVE));
            that._lastActive = that._downTarget;
        },
        value: function(val) {
            var that = this, selectElement = proxy(that._selectElement, that);
            if (val) {
                val.each(function() {
                    selectElement(this);
                });
                that._notify(CHANGE);
                return;
            }
            return that.element.find(that.options.filter + "." + SELECTED);
        },
        _firstSelectee: function() {
            var that = this, selected;
            if (that._lastActive !== null) {
                return that._lastActive;
            }
            selected = that.value();
            return selected.length > 0 ? selected[0] : that.element.find(that.options.filter);
        },
        _selectElement: function(element, preventNotify) {
            var toSelect = $(element), isPrevented = !preventNotify && this._notify("select", {
                element: element
            });
            toSelect.removeClass(ACTIVE);
            if (!isPrevented) {
                toSelect.addClass(SELECTED);
                if (this.options.aria) {
                    toSelect.attr(ARIASELECTED, true);
                }
            }
        },
        _notify: function(name, args) {
            args = args || {};
            return this.trigger(name, args);
        },
        _unselect: function(element) {
            element.removeClass(SELECTED);
            if (this.options.aria) {
                element.attr(ARIASELECTED, false);
            }
            return element;
        },
        _select: function(e) {
            if ($(e.event.target).is("input,a,textarea")) {
                this.userEvents.cancel();
                this._downTarget = null;
            } else {
                e.preventDefault();
            }
        },
        clear: function() {
            var items = this.element.find(this.options.filter + "." + SELECTED);
            this._unselect(items);
        },
        selectRange: function(start, end) {
            var that = this, found = false, idx, length, tmp, toSelect, items = that.element.find(that.options.filter), selectElement = proxy(that._selectElement, that);
            start = $(start)[0];
            end = $(end)[0];
            for (idx = 0, length = items.length; idx < length; idx++) {
                toSelect = items[idx];
                if (found) {
                    selectElement(toSelect);
                    found = toSelect !== end;
                } else if (toSelect === start) {
                    found = start !== end;
                    selectElement(toSelect);
                } else if (toSelect === end) {
                    tmp = start;
                    start = end;
                    end = tmp;
                    found = true;
                    selectElement(toSelect);
                } else {
                    $(toSelect).removeClass(SELECTED);
                }
            }
            that._notify(CHANGE);
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.element.off(NS);
            that.userEvents.destroy();
        }
    });
    function collision(element, position) {
        var elementPosition = kendo.getOffset(element), right = position.left + position.width, bottom = position.top + position.height;
        elementPosition.right = elementPosition.left + element.outerWidth();
        elementPosition.bottom = elementPosition.top + element.outerHeight();
        return !(elementPosition.left > right || elementPosition.right < position.left || elementPosition.top > bottom || elementPosition.bottom < position.top);
    }
    function invalidateSelectables(items, target, position, ctrlKey) {
        var idx, length, toSelect;
        for (idx = 0, length = items.length; idx < length; idx++) {
            toSelect = items.eq(idx);
            if (collision(toSelect, position)) {
                if (toSelect.hasClass(SELECTED)) {
                    if (ctrlKey && target !== toSelect[0]) {
                        toSelect.removeClass(SELECTED).addClass(UNSELECTING);
                    }
                } else if (!toSelect.hasClass(ACTIVE) && !toSelect.hasClass(UNSELECTING)) {
                    toSelect.addClass(ACTIVE);
                }
            } else {
                if (toSelect.hasClass(ACTIVE)) {
                    toSelect.removeClass(ACTIVE);
                } else if (ctrlKey && toSelect.hasClass(UNSELECTING)) {
                    toSelect.removeClass(UNSELECTING).addClass(SELECTED);
                }
            }
        }
    }
    kendo.ui.plugin(Selectable);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, Widget = ui.Widget, proxy = $.proxy, FIRST = ".k-i-seek-w", LAST = ".k-i-seek-e", PREV = ".k-i-arrow-w", NEXT = ".k-i-arrow-e", CHANGE = "change", NS = ".kendoPager", CLICK = "click", KEYDOWN = "keydown", DISABLED = "disabled", iconTemplate = kendo.template('<a href="\\#" title="#=text#" class="k-link"><span class="k-icon #= className #">#=text#</span></a>');
    function button(template, idx, text, numeric) {
        return template({
            idx: idx,
            text: text,
            ns: kendo.ns,
            numeric: numeric
        });
    }
    function icon(className, text) {
        return iconTemplate({
            className: className.substring(1),
            text: text
        });
    }
    function update(element, selector, page, disabled) {
        element.find(selector).parent().attr(kendo.attr("page"), page).attr("tabindex", -1).toggleClass("k-state-disabled", disabled);
    }
    function first(element, page) {
        update(element, FIRST, 1, page <= 1);
    }
    function prev(element, page) {
        update(element, PREV, Math.max(1, page - 1), page <= 1);
    }
    function next(element, page, totalPages) {
        update(element, NEXT, Math.min(totalPages, page + 1), page >= totalPages);
    }
    function last(element, page, totalPages) {
        update(element, LAST, totalPages, page >= totalPages);
    }
    var Pager = Widget.extend({
        init: function(element, options) {
            var that = this, page, totalPages;
            Widget.fn.init.call(that, element, options);
            options = that.options;
            that.dataSource = kendo.data.DataSource.create(options.dataSource);
            that.linkTemplate = kendo.template(that.options.linkTemplate);
            that.selectTemplate = kendo.template(that.options.selectTemplate);
            page = that.page();
            totalPages = that.totalPages();
            that._refreshHandler = proxy(that.refresh, that);
            that.dataSource.bind(CHANGE, that._refreshHandler);
            if (options.previousNext) {
                if (!that.element.find(FIRST).length) {
                    that.element.append(icon(FIRST, options.messages.first));
                    first(that.element, page, totalPages);
                }
                if (!that.element.find(PREV).length) {
                    that.element.append(icon(PREV, options.messages.previous));
                    prev(that.element, page, totalPages);
                }
            }
            if (options.numeric) {
                that.list = that.element.find(".k-pager-numbers");
                if (!that.list.length) {
                    that.list = $('<ul class="k-pager-numbers k-reset" />').appendTo(that.element);
                }
            }
            if (options.input) {
                if (!that.element.find(".k-pager-input").length) {
                    that.element.append('<span class="k-pager-input k-label">' + options.messages.page + '<input class="k-textbox">' + kendo.format(options.messages.of, totalPages) + "</span>");
                }
                that.element.on(KEYDOWN + NS, ".k-pager-input input", proxy(that._keydown, that));
            }
            if (options.previousNext) {
                if (!that.element.find(NEXT).length) {
                    that.element.append(icon(NEXT, options.messages.next));
                    next(that.element, page, totalPages);
                }
                if (!that.element.find(LAST).length) {
                    that.element.append(icon(LAST, options.messages.last));
                    last(that.element, page, totalPages);
                }
            }
            if (options.pageSizes) {
                if (!that.element.find(".k-pager-sizes").length) {
                    $('<span class="k-pager-sizes k-label"><select/>' + options.messages.itemsPerPage + "</span>").appendTo(that.element).find("select").html($.map($.isArray(options.pageSizes) ? options.pageSizes : [ 5, 10, 20 ], function(page) {
                        return "<option>" + page + "</option>";
                    }).join("")).end().appendTo(that.element);
                }
                that.element.find(".k-pager-sizes select").val(that.pageSize());
                if (kendo.ui.DropDownList) {
                    that.element.find(".k-pager-sizes select").show().kendoDropDownList();
                }
                that.element.on(CHANGE + NS, ".k-pager-sizes select", proxy(that._change, that));
            }
            if (options.refresh) {
                if (!that.element.find(".k-pager-refresh").length) {
                    that.element.append('<a href="#" class="k-pager-refresh k-link"  title="' + options.messages.refresh + '"><span class="k-icon k-i-refresh">' + options.messages.refresh + "</span></a>");
                }
                that.element.on(CLICK + NS, ".k-pager-refresh", proxy(that._refreshClick, that));
            }
            if (options.info) {
                if (!that.element.find(".k-pager-info").length) {
                    that.element.append('<span class="k-pager-info k-label" />');
                }
            }
            that.element.on(CLICK + NS, "a", proxy(that._click, that)).addClass("k-pager-wrap k-widget");
            if (options.autoBind) {
                that.refresh();
            }
            kendo.notify(that);
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.element.off(NS);
            that.dataSource.unbind(CHANGE, that._refreshHandler);
        },
        events: [ CHANGE ],
        options: {
            name: "Pager",
            selectTemplate: '<li><span class="k-state-selected">#=text#</span></li>',
            linkTemplate: '<li><a tabindex="-1" href="\\#" class="k-link" data-#=ns#page="#=idx#">#=text#</a></li>',
            buttonCount: 10,
            autoBind: true,
            numeric: true,
            info: true,
            input: false,
            previousNext: true,
            pageSizes: false,
            refresh: false,
            messages: {
                display: "{0} - {1} of {2} items",
                empty: "No items to display",
                page: "Page",
                of: "of {0}",
                itemsPerPage: "items per page",
                first: "Go to the first page",
                previous: "Go to the previous page",
                next: "Go to the next page",
                last: "Go to the last page",
                refresh: "Refresh"
            }
        },
        setDataSource: function(dataSource) {
            var that = this;
            that.dataSource.unbind(CHANGE, that._refreshHandler);
            that.dataSource = that.options.dataSource = dataSource;
            dataSource.bind(CHANGE, that._refreshHandler);
            if (that.options.autoBind) {
                dataSource.fetch();
            }
        },
        refresh: function() {
            var that = this, idx, end, start = 1, html = "", reminder, page = that.page(), options = that.options, pageSize = that.pageSize(), total = that.dataSource.total(), totalPages = that.totalPages(), linkTemplate = that.linkTemplate, buttonCount = options.buttonCount;
            if (options.numeric) {
                if (page > buttonCount) {
                    reminder = page % buttonCount;
                    start = reminder === 0 ? page - buttonCount + 1 : page - reminder + 1;
                }
                end = Math.min(start + buttonCount - 1, totalPages);
                if (start > 1) {
                    html += button(linkTemplate, start - 1, "...", false);
                }
                for (idx = start; idx <= end; idx++) {
                    html += button(idx == page ? that.selectTemplate : linkTemplate, idx, idx, true);
                }
                if (end < totalPages) {
                    html += button(linkTemplate, idx, "...", false);
                }
                if (html === "") {
                    html = that.selectTemplate({
                        text: 0
                    });
                }
                that.list.html(html);
            }
            if (options.info) {
                if (total > 0) {
                    html = kendo.format(options.messages.display, (page - 1) * pageSize + 1, // first item in the page
                    Math.min(page * pageSize, total), // last item in the page
                    total);
                } else {
                    html = options.messages.empty;
                }
                that.element.find(".k-pager-info").html(html);
            }
            if (options.input) {
                that.element.find(".k-pager-input").html(that.options.messages.page + '<input class="k-textbox">' + kendo.format(options.messages.of, totalPages)).find("input").val(page).attr(DISABLED, total < 1).toggleClass("k-state-disabled", total < 1);
            }
            if (options.previousNext) {
                first(that.element, page, totalPages);
                prev(that.element, page, totalPages);
                next(that.element, page, totalPages);
                last(that.element, page, totalPages);
            }
            if (options.pageSizes) {
                that.element.find(".k-pager-sizes select").val(pageSize).filter("[" + kendo.attr("role") + "=dropdownlist]").kendoDropDownList("value", pageSize).kendoDropDownList("text", pageSize);
            }
        },
        _keydown: function(e) {
            if (e.keyCode === kendo.keys.ENTER) {
                var input = this.element.find(".k-pager-input").find("input"), page = parseInt(input.val(), 10);
                if (isNaN(page) || page < 1 || page > this.totalPages()) {
                    page = this.page();
                }
                input.val(page);
                this.page(page);
            }
        },
        _refreshClick: function(e) {
            e.preventDefault();
            this.dataSource.read();
        },
        _change: function(e) {
            var pageSize = parseInt(e.currentTarget.value, 10);
            if (!isNaN(pageSize)) {
                this.dataSource.pageSize(pageSize);
            }
        },
        _click: function(e) {
            var target = $(e.currentTarget);
            e.preventDefault();
            if (!target.is(".k-state-disabled")) {
                this.page(target.attr(kendo.attr("page")));
            }
        },
        totalPages: function() {
            return Math.ceil((this.dataSource.total() || 0) / this.pageSize());
        },
        pageSize: function() {
            return this.dataSource.pageSize() || this.dataSource.total();
        },
        page: function(page) {
            if (page !== undefined) {
                this.dataSource.page(page);
                this.trigger(CHANGE, {
                    index: page
                });
            } else {
                if (this.dataSource.total() > 0) {
                    return this.dataSource.page();
                } else {
                    return 0;
                }
            }
        }
    });
    ui.plugin(Pager);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, Widget = ui.Widget, support = kendo.support, getOffset = kendo.getOffset, activeElement = kendo._activeElement, OPEN = "open", CLOSE = "close", DEACTIVATE = "deactivate", ACTIVATE = "activate", CENTER = "center", LEFT = "left", RIGHT = "right", TOP = "top", BOTTOM = "bottom", ABSOLUTE = "absolute", HIDDEN = "hidden", BODY = "body", LOCATION = "location", POSITION = "position", VISIBLE = "visible", EFFECTS = "effects", ACTIVE = "k-state-active", ACTIVEBORDER = "k-state-border", ACTIVECHILDREN = ".k-picker-wrap, .k-dropdown-wrap, .k-link", MOUSEDOWN = "down", WINDOW = $(window), DOCUMENT_ELEMENT = $(document.documentElement), RESIZE_SCROLL = "resize scroll", cssPrefix = support.transitions.css, TRANSFORM = cssPrefix + "transform", extend = $.extend, NS = ".kendoPopup", styles = [ "font-family", "font-size", "font-stretch", "font-style", "font-weight", "line-height" ];
    function contains(container, target) {
        return container === target || $.contains(container, target);
    }
    var Popup = Widget.extend({
        init: function(element, options) {
            var that = this, parentPopup;
            options = options || {};
            if (options.isRtl) {
                options.origin = options.origin || BOTTOM + " " + RIGHT;
                options.position = options.position || TOP + " " + RIGHT;
            }
            Widget.fn.init.call(that, element, options);
            element = that.element;
            options = that.options;
            that.collisions = options.collision ? options.collision.split(" ") : [];
            if (that.collisions.length === 1) {
                that.collisions.push(that.collisions[0]);
            }
            parentPopup = $(that.options.anchor).closest(".k-popup,.k-group").filter(":not([class^=km-])");
            // When popup is in another popup, make it relative.
            options.appendTo = $($(options.appendTo)[0] || parentPopup[0] || BODY);
            that.element.hide().addClass("k-popup k-group k-reset").toggleClass("k-rtl", !!options.isRtl).css({
                position: ABSOLUTE
            }).appendTo(options.appendTo).on("mouseenter" + NS, function() {
                that._hovered = true;
            }).on("mouseleave" + NS, function() {
                that._hovered = false;
            });
            that.wrapper = $();
            if (options.animation === false) {
                options.animation = {
                    open: {
                        effects: {}
                    },
                    close: {
                        hide: true,
                        effects: {}
                    }
                };
            }
            extend(options.animation.open, {
                complete: function() {
                    that.wrapper.css({
                        overflow: VISIBLE
                    });
                    // Forcing refresh causes flickering in mobile.
                    that.trigger(ACTIVATE);
                }
            });
            extend(options.animation.close, {
                complete: function() {
                    that.wrapper.hide();
                    var location = that.wrapper.data(LOCATION), anchor = $(options.anchor), direction, dirClass;
                    if (location) {
                        that.wrapper.css(location);
                    }
                    if (options.anchor != BODY) {
                        direction = anchor.hasClass(ACTIVEBORDER + "-down") ? "down" : "up";
                        dirClass = ACTIVEBORDER + "-" + direction;
                        anchor.removeClass(dirClass).children(ACTIVECHILDREN).removeClass(ACTIVE).removeClass(dirClass);
                        element.removeClass(ACTIVEBORDER + "-" + kendo.directions[direction].reverse);
                    }
                    that._closing = false;
                    that.trigger(DEACTIVATE);
                }
            });
            that._mousedownProxy = function(e) {
                that._mousedown(e);
            };
            that._resizeProxy = function(e) {
                that._resize(e);
            };
            if (options.toggleTarget) {
                $(options.toggleTarget).on(options.toggleEvent + NS, $.proxy(that.toggle, that));
            }
        },
        events: [ OPEN, ACTIVATE, CLOSE, DEACTIVATE ],
        options: {
            name: "Popup",
            toggleEvent: "click",
            origin: BOTTOM + " " + LEFT,
            position: TOP + " " + LEFT,
            anchor: BODY,
            collision: "flip fit",
            viewport: window,
            copyAnchorStyles: true,
            animation: {
                open: {
                    effects: "slideIn:down",
                    transition: true,
                    duration: 200
                },
                close: {
                    // if close animation effects are defined, they will be used instead of open.reverse
                    duration: 100,
                    hide: true
                }
            }
        },
        destroy: function() {
            var that = this, options = that.options, element = that.element.off(NS), parent;
            Widget.fn.destroy.call(that);
            if (options.toggleTarget) {
                $(options.toggleTarget).off(NS);
            }
            DOCUMENT_ELEMENT.unbind(MOUSEDOWN, that._mousedownProxy);
            WINDOW.unbind(RESIZE_SCROLL, that._resizeProxy);
            if (options.appendTo[0] === document.body) {
                parent = element.parent(".k-animation-container");
                if (parent[0]) {
                    parent.remove();
                } else {
                    element.remove();
                }
            }
            kendo.destroy(that.element.children());
        },
        open: function(x, y) {
            var that = this, fixed = {
                isFixed: !isNaN(parseInt(y, 10)),
                x: x,
                y: y
            }, element = that.element, options = that.options, direction = "down", animation, wrapper, anchor = $(options.anchor);
            if (!that.visible()) {
                if (options.copyAnchorStyles) {
                    element.css(kendo.getComputedStyles(anchor[0], styles));
                }
                if (element.data("animating") || that.trigger(OPEN)) {
                    return;
                }
                DOCUMENT_ELEMENT.unbind(MOUSEDOWN, that._mousedownProxy).bind(MOUSEDOWN, that._mousedownProxy);
                // this binding hangs iOS in editor
                if (!(support.mobileOS.ios || support.mobileOS.android)) {
                    WINDOW.unbind(RESIZE_SCROLL, that._resizeProxy).bind(RESIZE_SCROLL, that._resizeProxy);
                }
                that.wrapper = wrapper = kendo.wrap(element).css({
                    overflow: HIDDEN,
                    display: "block",
                    position: ABSOLUTE
                });
                if (support.mobileOS.android) {
                    wrapper.add(anchor).css(TRANSFORM, "translatez(0)");
                }
                wrapper.css(POSITION);
                if ($(options.appendTo)[0] == document.body) {
                    wrapper.css(TOP, "-10000px");
                }
                animation = extend(true, {}, options.animation.open);
                that.flipped = that._position(fixed);
                animation.effects = kendo.parseEffects(animation.effects, that.flipped);
                direction = animation.effects.slideIn ? animation.effects.slideIn.direction : direction;
                if (options.anchor != BODY) {
                    var dirClass = ACTIVEBORDER + "-" + direction;
                    element.addClass(ACTIVEBORDER + "-" + kendo.directions[direction].reverse);
                    anchor.addClass(dirClass).children(ACTIVECHILDREN).addClass(ACTIVE).addClass(dirClass);
                }
                element.data(EFFECTS, animation.effects).kendoStop(true).kendoAnimate(animation);
            }
        },
        toggle: function() {
            var that = this;
            that[that.visible() ? CLOSE : OPEN]();
        },
        visible: function() {
            return this.element.is(":" + VISIBLE);
        },
        close: function() {
            var that = this, options = that.options, wrap, animation, openEffects, closeEffects;
            if (that.visible()) {
                wrap = that.wrapper[0] ? that.wrapper : kendo.wrap(that.element).hide();
                if (that._closing || that.trigger(CLOSE)) {
                    return;
                }
                // Close all inclusive popups.
                that.element.find(".k-popup").each(function() {
                    var that = $(this), popup = that.data("kendoPopup");
                    if (popup) {
                        popup.close();
                    }
                });
                DOCUMENT_ELEMENT.unbind(MOUSEDOWN, that._mousedownProxy);
                WINDOW.unbind(RESIZE_SCROLL, that._resizeProxy);
                animation = extend(true, {}, options.animation.close);
                openEffects = that.element.data(EFFECTS);
                closeEffects = animation.effects;
                if (!closeEffects && !kendo.size(closeEffects) && openEffects && kendo.size(openEffects)) {
                    animation.effects = openEffects;
                    animation.reverse = true;
                }
                that._closing = true;
                that.element.kendoStop(true);
                wrap.css({
                    overflow: HIDDEN
                });
                // stop callback will remove hidden overflow
                that.element.kendoAnimate(animation);
            }
        },
        _resize: function(e) {
            var that = this;
            if (e.type === "resize") {
                clearTimeout(that._resizeTimeout);
                that._resizeTimeout = setTimeout(function() {
                    that._position();
                    that._resizeTimeout = null;
                }, 50);
            } else {
                if (!that._hovered && !contains(that.element[0], activeElement())) {
                    that.close();
                }
            }
        },
        _mousedown: function(e) {
            var that = this, container = that.element[0], options = that.options, anchor = $(options.anchor)[0], toggleTarget = options.toggleTarget, target = kendo.eventTarget(e), popup = $(target).closest(".k-popup")[0];
            if (popup && popup !== that.element[0]) {
                return;
            }
            if (!contains(container, target) && !contains(anchor, target) && !(toggleTarget && contains($(toggleTarget)[0], target))) {
                that.close();
            }
        },
        _fit: function(position, size, viewPortSize) {
            var output = 0;
            if (position + size > viewPortSize) {
                output = viewPortSize - (position + size);
            }
            if (position < 0) {
                output = -position;
            }
            return output;
        },
        _flip: function(offset, size, anchorSize, viewPortSize, origin, position, boxSize) {
            var output = 0;
            boxSize = boxSize || size;
            if (position !== origin && position !== CENTER && origin !== CENTER) {
                if (offset + boxSize > viewPortSize) {
                    output += -(anchorSize + size);
                }
                if (offset + output < 0) {
                    output += anchorSize + size;
                }
            }
            return output;
        },
        _position: function(fixed) {
            var that = this, element = that.element.css(POSITION, ""), wrapper = that.wrapper, options = that.options, viewport = $(options.viewport), viewportOffset = $(viewport).offset(), anchor = $(options.anchor), origins = options.origin.toLowerCase().split(" "), positions = options.position.toLowerCase().split(" "), collisions = that.collisions, zoomLevel = support.zoomLevel(), siblingContainer, parents, parentZIndex, zIndex = 10002, idx = 0, length;
            siblingContainer = anchor.parents().filter(wrapper.siblings());
            if (siblingContainer[0]) {
                parentZIndex = Number($(siblingContainer).css("zIndex"));
                if (parentZIndex) {
                    zIndex = parentZIndex + 1;
                } else {
                    parents = anchor.parentsUntil(siblingContainer);
                    for (length = parents.length; idx < length; idx++) {
                        parentZIndex = Number($(parents[idx]).css("zIndex"));
                        if (parentZIndex && zIndex < parentZIndex) {
                            zIndex = parentZIndex + 1;
                        }
                    }
                }
            }
            wrapper.css("zIndex", zIndex);
            if (fixed && fixed.isFixed) {
                wrapper.css({
                    left: fixed.x,
                    top: fixed.y
                });
            } else {
                wrapper.css(that._align(origins, positions));
            }
            var pos = getOffset(wrapper, POSITION, anchor[0] === wrapper.offsetParent()[0]), offset = getOffset(wrapper), anchorParent = anchor.offsetParent().parent(".k-animation-container,.k-popup,.k-group");
            // If the parent is positioned, get the current positions
            if (anchorParent.length) {
                pos = getOffset(wrapper, POSITION, true);
                offset = getOffset(wrapper);
            }
            if (viewport[0] === window) {
                offset.top -= window.pageYOffset || document.documentElement.scrollTop || 0;
                offset.left -= window.pageXOffset || document.documentElement.scrollLeft || 0;
            } else {
                offset.top -= viewportOffset.top;
                offset.left -= viewportOffset.left;
            }
            if (!that.wrapper.data(LOCATION)) {
                // Needed to reset the popup location after every closure - fixes the resize bugs.
                wrapper.data(LOCATION, extend({}, pos));
            }
            var offsets = extend({}, offset), location = extend({}, pos);
            if (collisions[0] === "fit") {
                location.top += that._fit(offsets.top, wrapper.outerHeight(), viewport.height() / zoomLevel);
            }
            if (collisions[1] === "fit") {
                location.left += that._fit(offsets.left, wrapper.outerWidth(), viewport.width() / zoomLevel);
            }
            var flipPos = extend({}, location);
            if (collisions[0] === "flip") {
                location.top += that._flip(offsets.top, element.outerHeight(), anchor.outerHeight(), viewport.height() / zoomLevel, origins[0], positions[0], wrapper.outerHeight());
            }
            if (collisions[1] === "flip") {
                location.left += that._flip(offsets.left, element.outerWidth(), anchor.outerWidth(), viewport.width() / zoomLevel, origins[1], positions[1], wrapper.outerWidth());
            }
            element.css(POSITION, ABSOLUTE);
            wrapper.css(location);
            return location.left != flipPos.left || location.top != flipPos.top;
        },
        _align: function(origin, position) {
            var that = this, element = that.wrapper, anchor = $(that.options.anchor), verticalOrigin = origin[0], horizontalOrigin = origin[1], verticalPosition = position[0], horizontalPosition = position[1], anchorOffset = getOffset(anchor), appendTo = $(that.options.appendTo), appendToOffset, width = element.outerWidth(), height = element.outerHeight(), anchorWidth = anchor.outerWidth(), anchorHeight = anchor.outerHeight(), top = anchorOffset.top, left = anchorOffset.left, round = Math.round;
            if (appendTo[0] != document.body) {
                appendToOffset = getOffset(appendTo);
                top -= appendToOffset.top;
                left -= appendToOffset.left;
            }
            if (verticalOrigin === BOTTOM) {
                top += anchorHeight;
            }
            if (verticalOrigin === CENTER) {
                top += round(anchorHeight / 2);
            }
            if (verticalPosition === BOTTOM) {
                top -= height;
            }
            if (verticalPosition === CENTER) {
                top -= round(height / 2);
            }
            if (horizontalOrigin === RIGHT) {
                left += anchorWidth;
            }
            if (horizontalOrigin === CENTER) {
                left += round(anchorWidth / 2);
            }
            if (horizontalPosition === RIGHT) {
                left -= width;
            }
            if (horizontalPosition === CENTER) {
                left -= round(width / 2);
            }
            return {
                top: top,
                left: left
            };
        }
    });
    ui.plugin(Popup);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, Widget = kendo.ui.Widget, Popup = kendo.ui.Popup, isFunction = $.isFunction, isPlainObject = $.isPlainObject, extend = $.extend, proxy = $.proxy, DOCUMENT = $(document), isLocalUrl = kendo.isLocalUrl, ARIAIDSUFFIX = "_tt_active", DESCRIBEDBY = "aria-describedby", SHOW = "show", HIDE = "hide", ERROR = "error", CONTENTLOAD = "contentLoad", REQUESTSTART = "requestStart", KCONTENTFRAME = "k-content-frame", TEMPLATE = '<div role="tooltip" class="k-widget k-tooltip#if (!autoHide) {# k-tooltip-closable#}#">#if (!autoHide) {# <div class="k-tooltip-button"><a href="\\#" class="k-icon k-i-close">close</a></div> #}#' + '<div class="k-tooltip-content"></div>' + '#if (callout){ #<div class="k-callout k-callout-#=dir#"></div>#}#' + "</div>", IFRAMETEMPLATE = kendo.template("<iframe frameborder='0' class='" + KCONTENTFRAME + "' " + "src='#= content.url #'>" + "This page requires frames in order to show content" + "</iframe>"), NS = ".kendoTooltip", POSITIONS = {
        bottom: {
            origin: "bottom center",
            position: "top center"
        },
        top: {
            origin: "top center",
            position: "bottom center"
        },
        left: {
            origin: "center left",
            position: "center right",
            collision: "fit flip"
        },
        right: {
            origin: "center right",
            position: "center left",
            collision: "fit flip"
        },
        center: {
            position: "center center",
            origin: "center center"
        }
    }, REVERSE = {
        top: "bottom",
        bottom: "top",
        left: "right",
        right: "left",
        center: "center"
    }, DIRCLASSES = {
        bottom: "n",
        top: "s",
        left: "e",
        right: "w",
        center: "n"
    }, DIMENSIONS = {
        horizontal: {
            offset: "top",
            size: "height"
        },
        vertical: {
            offset: "left",
            size: "width"
        }
    }, DEFAULTCONTENT = function(e) {
        return e.target.data(kendo.ns + "title");
    };
    function restoreTitle(element) {
        while (element.length) {
            restoreTitleAttributeForElement(element);
            element = element.parent();
        }
    }
    function restoreTitleAttributeForElement(element) {
        var title = element.data(kendo.ns + "title");
        if (title) {
            element.attr("title", title);
            element.removeData(kendo.ns + "title");
        }
    }
    function saveTitleAttributeForElement(element) {
        var title = element.attr("title");
        if (title) {
            element.data(kendo.ns + "title", title);
            element.attr("title", "");
        }
    }
    function saveTitleAttributes(element) {
        while (element.length) {
            saveTitleAttributeForElement(element);
            element = element.parent();
        }
    }
    var Tooltip = Widget.extend({
        init: function(element, options) {
            var that = this, axis;
            Widget.fn.init.call(that, element, options);
            axis = that.options.position.match(/left|right/) ? "horizontal" : "vertical";
            that.dimensions = DIMENSIONS[axis];
            that._documentKeyDownHandler = proxy(that._documentKeyDown, that);
            that.element.on(that.options.showOn + NS, that.options.filter, proxy(that._showOn, that)).on("mouseenter" + NS, that.options.filter, proxy(that._mouseenter, that));
            if (this.options.autoHide) {
                that.element.on("mouseleave" + NS, that.options.filter, proxy(that._mouseleave, that));
            }
        },
        options: {
            name: "Tooltip",
            filter: "",
            content: DEFAULTCONTENT,
            showAfter: 100,
            callout: true,
            position: "bottom",
            showOn: "mouseenter",
            autoHide: true,
            animation: {
                open: {
                    effects: "fade:in",
                    duration: 0
                },
                close: {
                    effects: "fade:out",
                    duration: 40,
                    hide: true
                }
            }
        },
        events: [ SHOW, HIDE, CONTENTLOAD, ERROR, REQUESTSTART ],
        _mouseenter: function(e) {
            saveTitleAttributes($(e.currentTarget));
        },
        _showOn: function(e) {
            var that = this;
            if (that.options.showOn && that.options.showOn.match(/click|focus/)) {
                that._show($(e.currentTarget));
            } else {
                clearTimeout(that.timeout);
                that.timeout = setTimeout(function() {
                    that._show($(e.currentTarget));
                }, that.options.showAfter);
            }
        },
        _appendContent: function(target) {
            var that = this, contentOptions = that.options.content, element = that.content, showIframe = that.options.iframe, iframe;
            if (isPlainObject(contentOptions) && contentOptions.url) {
                if (!("iframe" in that.options)) {
                    showIframe = !isLocalUrl(contentOptions.url);
                }
                that.trigger(REQUESTSTART, {
                    options: contentOptions,
                    target: target
                });
                if (!showIframe) {
                    element.empty();
                    kendo.ui.progress(element, true);
                    // perform AJAX request
                    that._ajaxRequest(contentOptions);
                } else {
                    element.hide();
                    iframe = element.find("." + KCONTENTFRAME)[0];
                    if (iframe) {
                        // refresh existing iframe
                        iframe.src = contentOptions.url || iframe.src;
                    } else {
                        element.html(IFRAMETEMPLATE({
                            content: contentOptions
                        }));
                    }
                    element.find("." + KCONTENTFRAME).off("load" + NS).on("load" + NS, function() {
                        that.trigger(CONTENTLOAD);
                        element.show();
                    });
                }
            } else if (contentOptions && isFunction(contentOptions)) {
                contentOptions = contentOptions({
                    target: target
                });
                that.content.html(contentOptions);
            } else {
                that.content.html(contentOptions);
            }
        },
        _ajaxRequest: function(options) {
            var that = this;
            jQuery.ajax(extend({
                type: "GET",
                dataType: "html",
                cache: false,
                error: function(xhr, status) {
                    kendo.ui.progress(that.content, false);
                    that.trigger(ERROR, {
                        status: status,
                        xhr: xhr
                    });
                },
                success: proxy(function(data) {
                    kendo.ui.progress(that.content, false);
                    that.content.html(data);
                    that.trigger(CONTENTLOAD);
                }, that)
            }, options));
        },
        _documentKeyDown: function(e) {
            if (e.keyCode === kendo.keys.ESC) {
                this.hide();
            }
        },
        hide: function() {
            if (this.popup) {
                this.popup.close();
            }
        },
        show: function(target) {
            saveTitleAttributes(target);
            this._show(target);
        },
        _show: function(target) {
            var that = this, current = that.target();
            if (!that.popup) {
                that._initPopup();
            }
            if (current && current[0] != target[0]) {
                that.popup.close();
                that.popup.element.kendoStop(true, true);
            }
            if (!current || current[0] != target[0]) {
                that._appendContent(target);
                that.popup.options.anchor = target;
            }
            that.popup.one("deactivate", function() {
                restoreTitle(target);
                target.removeAttr(DESCRIBEDBY);
                this.element.removeAttr("id").attr("aria-hidden", true);
                DOCUMENT.off("keydown" + NS, that._documentKeyDownHandler);
            });
            that.popup.open();
        },
        _initPopup: function() {
            var that = this, options = that.options, wrapper = $(kendo.template(TEMPLATE)({
                callout: options.callout && options.position !== "center",
                dir: DIRCLASSES[options.position],
                autoHide: options.autoHide
            }));
            that.popup = new Popup(wrapper, extend({
                activate: function() {
                    var anchor = this.options.anchor, ariaId = anchor[0].id || that.element[0].id;
                    if (ariaId) {
                        anchor.attr(DESCRIBEDBY, ariaId + ARIAIDSUFFIX);
                        this.element.attr("id", ariaId + ARIAIDSUFFIX);
                    }
                    if (options.callout) {
                        that._positionCallout();
                    }
                    this.element.removeAttr("aria-hidden");
                    DOCUMENT.on("keydown" + NS, that._documentKeyDownHandler);
                    that.trigger(SHOW);
                },
                close: function() {
                    that.trigger(HIDE);
                },
                copyAnchorStyles: false,
                animation: options.animation
            }, POSITIONS[options.position]));
            wrapper.css({
                width: options.width,
                height: options.height
            });
            that.content = wrapper.find(".k-tooltip-content");
            that.arrow = wrapper.find(".k-callout");
            if (options.autoHide) {
                wrapper.on("mouseleave" + NS, proxy(that._mouseleave, that));
            } else {
                wrapper.on("click" + NS, ".k-tooltip-button", proxy(that._closeButtonClick, that));
            }
        },
        _closeButtonClick: function(e) {
            e.preventDefault();
            this.hide();
        },
        _mouseleave: function(e) {
            if (this.popup) {
                var element = $(e.currentTarget), offset = element.offset(), pageX = e.pageX, pageY = e.pageY;
                offset.right = offset.left + element.outerWidth();
                offset.bottom = offset.top + element.outerHeight();
                if (pageX > offset.left && pageX < offset.right && pageY > offset.top && pageY < offset.bottom) {
                    return;
                }
                this.popup.close();
            } else {
                restoreTitle($(e.currentTarget));
            }
            clearTimeout(this.timeout);
        },
        _positionCallout: function() {
            var that = this, position = that.options.position, dimensions = that.dimensions, offset = dimensions.offset, popup = that.popup, anchor = popup.options.anchor, anchorOffset = $(anchor).offset(), arrowBorder = parseInt(that.arrow.css("borderWidth"), 10), elementOffset = $(popup.element).offset(), cssClass = DIRCLASSES[popup.flipped ? REVERSE[position] : position], offsetAmount = anchorOffset[offset] - elementOffset[offset] + $(anchor)[dimensions.size]() / 2 - arrowBorder;
            that.arrow.removeClass("k-callout-n k-callout-s k-callout-w k-callout-e").addClass("k-callout-" + cssClass).css(offset, offsetAmount);
        },
        target: function() {
            if (this.popup) {
                return this.popup.options.anchor;
            }
            return null;
        },
        destroy: function() {
            var popup = this.popup;
            if (popup) {
                popup.element.off(NS);
                popup.destroy();
            }
            this.element.off(NS);
            DOCUMENT.off("keydown" + NS, this._documentKeyDownHandler);
            Widget.fn.destroy.call(this);
        }
    });
    kendo.ui.plugin(Tooltip);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, Widget = ui.Widget, keys = kendo.keys, support = kendo.support, htmlEncode = kendo.htmlEncode, activeElement = kendo._activeElement, ID = "id", LI = "li", CHANGE = "change", CHARACTER = "character", FOCUSED = "k-state-focused", HOVER = "k-state-hover", LOADING = "k-loading", OPEN = "open", CLOSE = "close", SELECT = "select", PROGRESS = "progress", REQUESTEND = "requestEnd", WIDTH = "width", extend = $.extend, proxy = $.proxy, browser = support.browser, isIE8 = browser.msie && browser.version < 9, quotRegExp = /"/g, alternativeNames = {
        ComboBox: "DropDownList",
        DropDownList: "ComboBox"
    };
    var List = Widget.extend({
        init: function(element, options) {
            var that = this, ns = that.ns, id;
            Widget.fn.init.call(that, element, options);
            element = that.element;
            that._isSelect = element.is(SELECT);
            that._template();
            that.ul = $('<ul unselectable="on" class="k-list k-reset"/>').css({
                overflow: support.kineticScrollNeeded ? "" : "auto"
            }).on("mouseenter" + ns, LI, function() {
                $(this).addClass(HOVER);
            }).on("mouseleave" + ns, LI, function() {
                $(this).removeClass(HOVER);
            }).on("click" + ns, LI, proxy(that._click, that)).attr({
                tabIndex: -1,
                role: "listbox",
                "aria-hidden": true
            });
            that.list = $("<div class='k-list-container'/>").append(that.ul).on("mousedown" + ns, function(e) {
                e.preventDefault();
            });
            id = element.attr(ID);
            if (id) {
                that.list.attr(ID, id + "-list");
                that.ul.attr(ID, id + "_listbox");
                that._optionID = id + "_option_selected";
            }
            that._initValue();
        },
        setOptions: function(options) {
            Widget.fn.setOptions.call(this, options);
            if (options && options.enable !== undefined) {
                options.enabled = options.enable;
            }
        },
        focus: function() {
            this._focused.focus();
        },
        readonly: function(readonly) {
            this._editable({
                readonly: readonly === undefined ? true : readonly,
                disable: false
            });
        },
        enable: function(enable) {
            this._editable({
                readonly: false,
                disable: !(enable = enable === undefined ? true : enable)
            });
        },
        _filterSource: function(filter) {
            var that = this, options = that.options, dataSource = that.dataSource, expression = dataSource.filter() || {};
            removeFiltersForField(expression, options.dataTextField);
            if (filter) {
                expression = expression.filters || [];
                expression.push(filter);
            }
            dataSource.filter(expression);
        },
        _initValue: function() {
            var that = this, value = that.options.value;
            if (value) {
                that.element.val(value);
            } else {
                value = that.element.val();
            }
            that._old = value;
        },
        _ignoreCase: function() {
            var that = this, model = that.dataSource.reader.model, field;
            if (model && model.fields) {
                field = model.fields[that.options.dataTextField];
                if (field && field.type && field.type !== "string") {
                    that.options.ignoreCase = false;
                }
            }
        },
        items: function() {
            return this.ul[0].children;
        },
        current: function(candidate) {
            var that = this, id = that._optionID;
            if (candidate !== undefined) {
                if (that._current) {
                    that._current.removeClass(FOCUSED).removeAttr("aria-selected").removeAttr(ID);
                    that._focused.removeAttr("aria-activedescendant");
                }
                if (candidate) {
                    candidate.addClass(FOCUSED);
                    that._scroll(candidate);
                    if (id) {
                        candidate.attr("id", id);
                        that._focused.attr("aria-activedescendant", id);
                    }
                }
                that._current = candidate;
            } else {
                return that._current;
            }
        },
        destroy: function() {
            var that = this, ns = that.ns;
            Widget.fn.destroy.call(that);
            that._unbindDataSource();
            that.ul.off(ns);
            that.list.off(ns);
            that.popup.destroy();
            if (that._form) {
                that._form.off("reset", that._resetHandler);
            }
        },
        dataItem: function(index) {
            var that = this;
            if (index === undefined) {
                index = that.selectedIndex;
            }
            return that._data()[index];
        },
        _accessors: function() {
            var that = this, element = that.element, options = that.options, getter = kendo.getter, textField = element.attr(kendo.attr("text-field")), valueField = element.attr(kendo.attr("value-field"));
            if (textField) {
                options.dataTextField = textField;
            }
            if (valueField) {
                options.dataValueField = valueField;
            }
            that._text = getter(options.dataTextField);
            that._value = getter(options.dataValueField);
        },
        _aria: function(id) {
            var that = this, options = that.options, element = that._focused;
            if (options.suggest !== undefined) {
                element.attr("aria-autocomplete", options.suggest ? "both" : "list");
            }
            id = id ? id + " " + that.ul[0].id : that.ul[0].id;
            element.attr("aria-owns", id);
            that.ul.attr("aria-live", !options.filter || options.filter === "none" ? "off" : "polite");
        },
        _blur: function() {
            var that = this;
            that._change();
            that.close();
        },
        _change: function() {
            var that = this, index = that.selectedIndex, optionValue = that.options.value, value = that.value(), trigger;
            if (that._isSelect && !that._bound && optionValue) {
                value = optionValue;
            }
            if (value !== that._old) {
                trigger = true;
            } else if (index !== undefined && index !== that._oldIndex) {
                trigger = true;
            }
            if (trigger) {
                that._old = value;
                that._oldIndex = index;
                that.trigger(CHANGE);
                // trigger the DOM change event so any subscriber gets notified
                that.element.trigger(CHANGE);
            }
        },
        _click: function(e) {
            if (!e.isDefaultPrevented()) {
                this._accept($(e.currentTarget));
            }
        },
        _data: function() {
            return this.dataSource.view();
        },
        _enable: function() {
            var that = this, options = that.options, disabled = that.element.is("[disabled]");
            if (options.enable !== undefined) {
                options.enabled = options.enable;
            }
            if (!options.enabled || disabled) {
                that.enable(false);
            } else {
                that.readonly(that.element.is("[readonly]"));
            }
        },
        _focus: function(li) {
            var that = this;
            if (that.popup.visible() && li && that.trigger(SELECT, {
                item: li
            })) {
                that.close();
                return;
            }
            that._select(li);
            that._triggerCascade();
            that._blur();
        },
        _index: function(value) {
            var that = this, idx, length, data = that._data();
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (that._dataValue(data[idx]) == value) {
                    return idx;
                }
            }
            return -1;
        },
        _dataValue: function(dataItem) {
            var value = this._value(dataItem);
            if (value === undefined) {
                value = this._text(dataItem);
            }
            return value;
        },
        _height: function(length) {
            if (length) {
                var that = this, list = that.list, visible = that.popup.visible(), height = that.options.height;
                list = list.add(list.parent(".k-animation-container")).show().height(that.ul[0].scrollHeight > height ? height : "auto");
                if (!visible) {
                    list.hide();
                }
            }
        },
        _adjustListWidth: function() {
            var list = this.list, width = list[0].style.width, wrapper = this.wrapper, computedStyle, computedWidth;
            if (!list.data(WIDTH) && width) {
                return;
            }
            computedStyle = window.getComputedStyle ? window.getComputedStyle(wrapper[0], null) : 0;
            computedWidth = computedStyle ? parseFloat(computedStyle.width) : wrapper.outerWidth();
            if (computedStyle && (browser.mozilla || browser.msie)) {
                // getComputedStyle returns different box in FF and IE.
                computedWidth += parseFloat(computedStyle.paddingLeft) + parseFloat(computedStyle.paddingRight) + parseFloat(computedStyle.borderLeftWidth) + parseFloat(computedStyle.borderRightWidth);
            }
            width = computedWidth - (list.outerWidth() - list.width());
            list.css({
                fontFamily: wrapper.css("font-family"),
                width: width
            }).data(WIDTH, width);
            return true;
        },
        _popup: function() {
            var that = this, list = that.list, focused = that._focused, options = that.options, wrapper = that.wrapper;
            that.popup = new ui.Popup(list, extend({}, options.popup, {
                anchor: wrapper,
                open: function(e) {
                    that._adjustListWidth();
                    if (that.trigger(OPEN)) {
                        e.preventDefault();
                    } else {
                        focused.attr("aria-expanded", true);
                        that.ul.attr("aria-hidden", false);
                    }
                },
                close: function(e) {
                    if (that.trigger(CLOSE)) {
                        e.preventDefault();
                    } else {
                        focused.attr("aria-expanded", false);
                        that.ul.attr("aria-hidden", true);
                    }
                },
                animation: options.animation,
                isRtl: support.isRtl(wrapper)
            }));
            that.popup.one(OPEN, function() {
                that._height(that._data().length);
            });
            that._touchScroller = kendo.touchScroller(that.popup.element);
        },
        _makeUnselectable: function() {
            if (isIE8) {
                this.list.find("*").attr("unselectable", "on");
            }
        },
        _toggleHover: function(e) {
            $(e.currentTarget).toggleClass(HOVER, e.type === "mouseenter");
        },
        _toggle: function(open) {
            var that = this;
            open = open !== undefined ? open : !that.popup.visible();
            if (!support.touch && that._focused[0] !== activeElement()) {
                that._focused.focus();
            }
            that[open ? OPEN : CLOSE]();
        },
        _scroll: function(item) {
            if (!item) {
                return;
            }
            if (item[0]) {
                item = item[0];
            }
            var ul = this.ul[0], itemOffsetTop = item.offsetTop, itemOffsetHeight = item.offsetHeight, ulScrollTop = ul.scrollTop, ulOffsetHeight = ul.clientHeight, bottomDistance = itemOffsetTop + itemOffsetHeight;
            ul.scrollTop = ulScrollTop > itemOffsetTop ? itemOffsetTop : bottomDistance > ulScrollTop + ulOffsetHeight ? bottomDistance - ulOffsetHeight : ulScrollTop;
        },
        _template: function() {
            var that = this, options = that.options, template = options.template, hasDataSource = options.dataSource;
            if (that._isSelect && that.element[0].length) {
                if (!hasDataSource) {
                    options.dataTextField = options.dataTextField || "text";
                    options.dataValueField = options.dataValueField || "value";
                }
            }
            if (!template) {
                that.template = kendo.template('<li tabindex="-1" role="option" unselectable="on" class="k-item">${' + kendo.expr(options.dataTextField, "data") + "}</li>", {
                    useWithBlock: false
                });
            } else {
                template = kendo.template(template);
                that.template = function(data) {
                    return '<li tabindex="-1" role="option" unselectable="on" class="k-item">' + template(data) + "</li>";
                };
            }
        },
        _triggerCascade: function() {
            var that = this, value = that.value();
            if (!that._bound && value || that._old !== value) {
                that.trigger("cascade");
            }
        },
        _unbindDataSource: function() {
            var that = this;
            that.dataSource.unbind(CHANGE, that._refreshHandler).unbind(PROGRESS, that._progressHandler).unbind(REQUESTEND, that._requestEndHandler);
        }
    });
    extend(List, {
        caret: function(element) {
            var caret, selection = element.ownerDocument.selection;
            if (selection) {
                caret = Math.abs(selection.createRange().moveStart(CHARACTER, -element.value.length));
            } else {
                caret = element.selectionStart;
            }
            return caret;
        },
        selectText: function(element, selectionStart, selectionEnd) {
            try {
                if (element.createTextRange) {
                    element.focus();
                    var textRange = element.createTextRange();
                    textRange.collapse(true);
                    textRange.moveStart(CHARACTER, selectionStart);
                    textRange.moveEnd(CHARACTER, selectionEnd - selectionStart);
                    textRange.select();
                } else {
                    element.setSelectionRange(selectionStart, selectionEnd);
                }
            } catch (e) {}
        },
        inArray: function(node, parentNode) {
            var idx, length, siblings = parentNode.children;
            if (!node || node.parentNode !== parentNode) {
                return -1;
            }
            for (idx = 0, length = siblings.length; idx < length; idx++) {
                if (node === siblings[idx]) {
                    return idx;
                }
            }
            return -1;
        }
    });
    kendo.ui.List = List;
    ui.Select = List.extend({
        init: function(element, options) {
            List.fn.init.call(this, element, options);
            this._initial = this.element.val();
        },
        setDataSource: function(dataSource) {
            this.options.dataSource = dataSource;
            this._dataSource();
            if (this.options.autoBind) {
                this.dataSource.fetch();
            }
        },
        close: function() {
            this.popup.close();
        },
        select: function(li) {
            var that = this;
            if (li === undefined) {
                return that.selectedIndex;
            } else {
                that._select(li);
                that._triggerCascade();
                that._old = that._accessor();
                that._oldIndex = that.selectedIndex;
            }
        },
        _accessor: function(value, idx) {
            var element = this.element, isSelect = this._isSelect, option, selectedIndex;
            element = element[0];
            if (value === undefined) {
                if (isSelect) {
                    selectedIndex = element.selectedIndex;
                    if (selectedIndex > -1) {
                        option = element.options[selectedIndex];
                        if (option) {
                            value = option.value;
                        }
                    }
                } else {
                    value = element.value;
                }
                return value;
            } else {
                if (isSelect) {
                    element.selectedIndex = idx;
                } else {
                    element.value = value;
                }
            }
        },
        _hideBusy: function() {
            var that = this;
            clearTimeout(that._busy);
            that._arrow.removeClass(LOADING);
            that._focused.attr("aria-busy", false);
            that._busy = null;
        },
        _showBusy: function() {
            var that = this;
            that._request = true;
            if (that._busy) {
                return;
            }
            that._busy = setTimeout(function() {
                that._focused.attr("aria-busy", true);
                that._arrow.addClass(LOADING);
            }, 100);
        },
        _requestEnd: function() {
            this._request = false;
        },
        _dataSource: function() {
            var that = this, element = that.element, options = that.options, dataSource = options.dataSource || {}, idx;
            dataSource = $.isArray(dataSource) ? {
                data: dataSource
            } : dataSource;
            if (that._isSelect) {
                idx = element[0].selectedIndex;
                if (idx > -1) {
                    options.index = idx;
                }
                dataSource.select = element;
                dataSource.fields = [ {
                    field: options.dataTextField
                }, {
                    field: options.dataValueField
                } ];
            }
            if (that.dataSource && that._refreshHandler) {
                that._unbindDataSource();
            } else {
                that._refreshHandler = proxy(that.refresh, that);
                that._progressHandler = proxy(that._showBusy, that);
                that._requestEndHandler = proxy(that._requestEnd, that);
            }
            that.dataSource = kendo.data.DataSource.create(dataSource).bind(CHANGE, that._refreshHandler).bind(PROGRESS, that._progressHandler).bind(REQUESTEND, that._requestEndHandler);
        },
        _get: function(li) {
            var that = this, data = that._data(), idx, length;
            if (typeof li === "function") {
                for (idx = 0, length = data.length; idx < length; idx++) {
                    if (li(data[idx])) {
                        li = idx;
                        break;
                    }
                }
            }
            if (typeof li === "number") {
                if (li < 0) {
                    return $();
                }
                li = $(that.ul[0].children[li]);
            }
            if (li && li.nodeType) {
                li = $(li);
            }
            return li;
        },
        _move: function(e) {
            var that = this, key = e.keyCode, ul = that.ul[0], methodName = that.popup.visible() ? "_select" : "_accept", current = that._current, down = key === keys.DOWN, pressed;
            if (key === keys.UP || down) {
                if (e.altKey) {
                    that.toggle(down);
                } else if (down) {
                    if (!current || that.selectedIndex === -1 && !that.value() && current[0] === ul.firstChild) {
                        current = ul.firstChild;
                    } else {
                        current = current[0].nextSibling;
                    }
                    that[methodName](current);
                } else {
                    that[methodName](current ? current[0].previousSibling : ul.lastChild);
                }
                e.preventDefault();
                pressed = true;
            } else if (key === keys.ENTER || key === keys.TAB) {
                if (that.popup.visible()) {
                    e.preventDefault();
                }
                that._accept(current);
                pressed = true;
            } else if (key === keys.ESC) {
                if (that.popup.visible()) {
                    e.preventDefault();
                }
                that.close();
                pressed = true;
            }
            return pressed;
        },
        _selectItem: function(value) {
            var that = this, options = that.options;
            value = that._selectedValue || options.value || that._accessor();
            if (value) {
                that.value(value);
            } else if (!that._bound) {
                that.select(options.index);
            }
        },
        _fetchItems: function(value) {
            var that = this, hasItems = that.ul[0].firstChild;
            //if request is started avoid datasource.fetch
            if (that._request) {
                return true;
            }
            if (!that._fetch && !hasItems) {
                if (that.options.cascadeFrom) {
                    return !hasItems;
                }
                that.dataSource.one(CHANGE, function() {
                    that.value(value);
                    that._fetch = false;
                });
                that._fetch = true;
                that.dataSource.fetch();
                return true;
            }
        },
        _options: function(data, optionLabel) {
            var that = this, element = that.element, selectedIndex = element[0].selectedIndex, length = data.length, options = "", option, dataItem, dataText, dataValue, idx = 0;
            if (optionLabel) {
                options = optionLabel;
                selectedIndex += 1;
                idx = 1;
            }
            for (;idx < length; idx++) {
                option = "<option";
                dataItem = data[idx];
                dataText = that._text(dataItem);
                dataValue = that._value(dataItem);
                if (dataValue !== undefined) {
                    dataValue += "";
                    if (dataValue.indexOf('"') !== -1) {
                        dataValue = dataValue.replace(quotRegExp, "&quot;");
                    }
                    option += ' value="' + dataValue + '"';
                }
                option += ">";
                if (dataText !== undefined) {
                    option += htmlEncode(dataText);
                }
                option += "</option>";
                options += option;
            }
            element.html(options);
            element[0].selectedIndex = selectedIndex;
        },
        _reset: function() {
            var that = this, element = that.element, form = element.closest("form");
            if (form[0]) {
                that._resetHandler = function() {
                    setTimeout(function() {
                        that.value(that._initial);
                    });
                };
                that._form = form.on("reset", that._resetHandler);
            }
        },
        _cascade: function() {
            var that = this, options = that.options, cascade = options.cascadeFrom, parent, parentElement, select, valueField, change;
            if (cascade) {
                that._selectedValue = options.value || that._accessor();
                parentElement = $("#" + cascade);
                parent = parentElement.data("kendo" + options.name);
                if (!parent) {
                    parent = parentElement.data("kendo" + alternativeNames[options.name]);
                }
                if (!parent) {
                    return;
                }
                valueField = parent.options.dataValueField;
                change = function() {
                    var value = that._selectedValue || that.value();
                    if (value) {
                        that.value(value);
                        if (!that.dataSource.view()[0] || that.selectedIndex === -1) {
                            that._clearSelection(parent, true);
                        }
                    } else {
                        that.select(options.index);
                    }
                    that.enable();
                };
                select = function() {
                    var dataItem = parent.dataItem(), filterValue = dataItem ? parent._value(dataItem) : null, expressions, filters;
                    if (filterValue) {
                        expressions = that.dataSource.filter() || {};
                        removeFiltersForField(expressions, valueField);
                        filters = expressions.filters || [];
                        filters.push({
                            field: valueField,
                            operator: "eq",
                            value: filterValue
                        });
                        that.dataSource.one(CHANGE, change).filter(filters);
                    } else {
                        that.enable(false);
                        that._clearSelection(parent);
                    }
                    that._triggerCascade();
                };
                parent.bind("cascade", function() {
                    select();
                });
                //refresh was called
                if (parent._bound) {
                    select();
                } else if (!parent.value()) {
                    that.enable(false);
                }
            }
        }
    });
    function removeFiltersForField(expression, field) {
        if (expression.filters) {
            expression.filters = $.grep(expression.filters, function(filter) {
                removeFiltersForField(filter, field);
                if (filter.filters) {
                    return filter.filters.length;
                } else {
                    return filter.field != field;
                }
            });
        }
    }
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, support = kendo.support, ui = kendo.ui, Widget = ui.Widget, parse = kendo.parseDate, adjustDate = kendo._adjustDate, keys = kendo.keys, extractFormat = kendo._extractFormat, template = kendo.template, getCulture = kendo.getCulture, transitions = kendo.support.transitions, transitionOrigin = transitions ? transitions.css + "transform-origin" : "", cellTemplate = template('<td#=data.cssClass# role="gridcell"><a tabindex="-1" class="k-link" href="\\#" data-#=data.ns#value="#=data.dateString#">#=data.value#</a></td>', {
        useWithBlock: false
    }), emptyCellTemplate = template('<td role="gridcell">&nbsp;</td>', {
        useWithBlock: false
    }), browser = kendo.support.browser, isIE8 = browser.msie && browser.version < 9, ns = ".kendoCalendar", CLICK = "click" + ns, KEYDOWN_NS = "keydown" + ns, ID = "id", MIN = "min", LEFT = "left", SLIDE = "slideIn", MONTH = "month", CENTURY = "century", CHANGE = "change", NAVIGATE = "navigate", VALUE = "value", HOVER = "k-state-hover", DISABLED = "k-state-disabled", FOCUSED = "k-state-focused", OTHERMONTH = "k-other-month", OTHERMONTHCLASS = ' class="' + OTHERMONTH + '"', TODAY = "k-nav-today", CELLSELECTOR = "td:has(.k-link)", BLUR = "blur" + ns, FOCUS = "focus", FOCUS_WITH_NS = FOCUS + ns, MOUSEENTER = support.touch ? "touchstart" : "mouseenter", MOUSEENTER_WITH_NS = support.touch ? "touchstart" + ns : "mouseenter" + ns, MOUSELEAVE = support.touch ? "touchend" + ns + " touchmove" + ns : "mouseleave" + ns, MS_PER_MINUTE = 6e4, MS_PER_DAY = 864e5, PREVARROW = "_prevArrow", NEXTARROW = "_nextArrow", ARIA_DISABLED = "aria-disabled", ARIA_SELECTED = "aria-selected", proxy = $.proxy, extend = $.extend, DATE = Date, views = {
        month: 0,
        year: 1,
        decade: 2,
        century: 3
    };
    var Calendar = Widget.extend({
        init: function(element, options) {
            var that = this, value, id;
            Widget.fn.init.call(that, element, options);
            element = that.wrapper = that.element;
            options = that.options;
            options.url = window.unescape(options.url);
            that._templates();
            that._header();
            that._footer(that.footer);
            id = element.addClass("k-widget k-calendar").on(MOUSEENTER_WITH_NS + " " + MOUSELEAVE, CELLSELECTOR, mousetoggle).on(KEYDOWN_NS, "table.k-content", proxy(that._move, that)).on(CLICK, CELLSELECTOR, function(e) {
                var link = e.currentTarget.firstChild;
                if (link.href.indexOf("#") != -1) {
                    e.preventDefault();
                }
                that._click($(link));
            }).on("mouseup" + ns, function() {
                that._focusView(that.options.focusOnNav !== false);
            }).attr(ID);
            if (id) {
                that._cellID = id + "_cell_selected";
            }
            value = options.value;
            normalize(options);
            that._index = views[options.start];
            that._current = new DATE(+restrictValue(value, options.min, options.max));
            that._addClassProxy = function() {
                that._active = true;
                that._cell.addClass(FOCUSED);
            };
            that._removeClassProxy = function() {
                that._active = false;
                that._cell.removeClass(FOCUSED);
            };
            that.value(value);
            kendo.notify(that);
        },
        options: {
            name: "Calendar",
            value: null,
            min: new DATE(1900, 0, 1),
            max: new DATE(2099, 11, 31),
            dates: [],
            url: "",
            culture: "",
            footer: "",
            format: "",
            month: {},
            start: MONTH,
            depth: MONTH,
            animation: {
                horizontal: {
                    effects: SLIDE,
                    reverse: true,
                    duration: 500,
                    divisor: 2
                },
                vertical: {
                    effects: "zoomIn",
                    duration: 400
                }
            }
        },
        events: [ CHANGE, NAVIGATE ],
        setOptions: function(options) {
            normalize(options);
            Widget.fn.setOptions.call(this, options);
        },
        destroy: function() {
            var that = this, today = that._today;
            that.element.off(ns);
            that._title.off(ns);
            that[PREVARROW].off(ns);
            that[NEXTARROW].off(ns);
            kendo.destroy(that._view);
            if (today) {
                kendo.destroy(today.off(ns));
            }
            Widget.fn.destroy.call(that);
        },
        current: function() {
            return this._current;
        },
        view: function() {
            return this._view;
        },
        focus: function(table) {
            table = table || this._table;
            this._bindTable(table);
            table.focus();
        },
        min: function(value) {
            return this._option(MIN, value);
        },
        max: function(value) {
            return this._option("max", value);
        },
        navigateToPast: function() {
            this._navigate(PREVARROW, -1);
        },
        navigateToFuture: function() {
            this._navigate(NEXTARROW, 1);
        },
        navigateUp: function() {
            var that = this, index = that._index;
            if (that._title.hasClass(DISABLED)) {
                return;
            }
            that.navigate(that._current, ++index);
        },
        navigateDown: function(value) {
            var that = this, index = that._index, depth = that.options.depth;
            if (!value) {
                return;
            }
            if (index === views[depth]) {
                if (+that._value != +value) {
                    that.value(value);
                    that.trigger(CHANGE);
                }
                return;
            }
            that.navigate(value, --index);
        },
        navigate: function(value, view) {
            view = isNaN(view) ? views[view] : view;
            var that = this, options = that.options, culture = options.culture, min = options.min, max = options.max, title = that._title, from = that._table, old = that._oldTable, selectedValue = that._value, currentValue = that._current, future = value && +value > +currentValue, vertical = view !== undefined && view !== that._index, to, currentView, compare, disabled;
            if (!value) {
                value = currentValue;
            } else {
                that._current = value = new DATE(+restrictValue(value, min, max));
            }
            if (view === undefined) {
                view = that._index;
            } else {
                that._index = view;
            }
            that._view = currentView = calendar.views[view];
            compare = currentView.compare;
            disabled = view === views[CENTURY];
            title.toggleClass(DISABLED, disabled).attr(ARIA_DISABLED, disabled);
            disabled = compare(value, min) < 1;
            that[PREVARROW].toggleClass(DISABLED, disabled).attr(ARIA_DISABLED, disabled);
            disabled = compare(value, max) > -1;
            that[NEXTARROW].toggleClass(DISABLED, disabled).attr(ARIA_DISABLED, disabled);
            if (from && old && old.data("animating")) {
                old.kendoStop(true, true);
                from.kendoStop(true, true);
            }
            that._oldTable = from;
            if (!from || that._changeView) {
                title.html(currentView.title(value, min, max, culture));
                that._table = to = $(currentView.content(extend({
                    min: min,
                    max: max,
                    date: value,
                    url: options.url,
                    dates: options.dates,
                    format: options.format,
                    culture: culture
                }, that[currentView.name])));
                makeUnselectable(to);
                that._animate({
                    from: from,
                    to: to,
                    vertical: vertical,
                    future: future
                });
                that._focus(value);
                that.trigger(NAVIGATE);
            }
            if (view === views[options.depth] && selectedValue) {
                that._class("k-state-selected", currentView.toDateString(selectedValue));
            }
            that._class(FOCUSED, currentView.toDateString(value));
            if (!from && that._cell) {
                that._cell.removeClass(FOCUSED);
            }
            that._changeView = true;
        },
        value: function(value) {
            var that = this, view = that._view, options = that.options, old = that._view, min = options.min, max = options.max;
            if (value === undefined) {
                return that._value;
            }
            value = parse(value, options.format, options.culture);
            if (value !== null) {
                value = new DATE(+value);
                if (!isInRange(value, min, max)) {
                    value = null;
                }
            }
            that._value = value;
            if (old && value === null && that._cell) {
                that._cell.removeClass("k-state-selected");
            } else {
                that._changeView = !value || view && view.compare(value, that._current) !== 0;
                that.navigate(value);
            }
        },
        _move: function(e) {
            var that = this, options = that.options, key = e.keyCode, view = that._view, index = that._index, currentValue = new DATE(+that._current), isRtl = kendo.support.isRtl(that.wrapper), value, prevent, method, temp;
            if (e.target === that._table[0]) {
                that._active = true;
            }
            if (e.ctrlKey) {
                if (key == keys.RIGHT && !isRtl || key == keys.LEFT && isRtl) {
                    that.navigateToFuture();
                    prevent = true;
                } else if (key == keys.LEFT && !isRtl || key == keys.RIGHT && isRtl) {
                    that.navigateToPast();
                    prevent = true;
                } else if (key == keys.UP) {
                    that.navigateUp();
                    prevent = true;
                } else if (key == keys.DOWN) {
                    that._click($(that._cell[0].firstChild));
                    prevent = true;
                }
            } else {
                if (key == keys.RIGHT && !isRtl || key == keys.LEFT && isRtl) {
                    value = 1;
                    prevent = true;
                } else if (key == keys.LEFT && !isRtl || key == keys.RIGHT && isRtl) {
                    value = -1;
                    prevent = true;
                } else if (key == keys.UP) {
                    value = index === 0 ? -7 : -4;
                    prevent = true;
                } else if (key == keys.DOWN) {
                    value = index === 0 ? 7 : 4;
                    prevent = true;
                } else if (key == keys.ENTER) {
                    that._click($(that._cell[0].firstChild));
                    prevent = true;
                } else if (key == keys.HOME || key == keys.END) {
                    method = key == keys.HOME ? "first" : "last";
                    temp = view[method](currentValue);
                    currentValue = new DATE(temp.getFullYear(), temp.getMonth(), temp.getDate(), currentValue.getHours(), currentValue.getMinutes(), currentValue.getSeconds(), currentValue.getMilliseconds());
                    prevent = true;
                } else if (key == keys.PAGEUP) {
                    prevent = true;
                    that.navigateToPast();
                } else if (key == keys.PAGEDOWN) {
                    prevent = true;
                    that.navigateToFuture();
                }
                if (value || method) {
                    if (!method) {
                        view.setDate(currentValue, value);
                    }
                    that._focus(restrictValue(currentValue, options.min, options.max));
                }
            }
            if (prevent) {
                e.preventDefault();
            }
            return that._current;
        },
        _animate: function(options) {
            var that = this, from = options.from, to = options.to, active = that._active;
            if (!from) {
                to.insertAfter(that.element[0].firstChild);
                that._bindTable(to);
            } else if (from.parent().data("animating")) {
                from.parent().kendoStop(true, true).remove();
                from.remove();
                to.insertAfter(that.element[0].firstChild);
                that._focusView(active);
            } else if (!from.is(":visible") || that.options.animation === false) {
                to.insertAfter(from);
                from.remove();
                that._focusView(active);
            } else {
                that[options.vertical ? "_vertical" : "_horizontal"](from, to, options.future);
            }
        },
        _horizontal: function(from, to, future) {
            var that = this, active = that._active, horizontal = that.options.animation.horizontal, effects = horizontal.effects, viewWidth = from.outerWidth();
            if (effects && effects.indexOf(SLIDE) != -1) {
                from.add(to).css({
                    width: viewWidth
                });
                from.wrap("<div/>");
                that._focusView(active, from);
                from.parent().css({
                    position: "relative",
                    width: viewWidth * 2,
                    "float": LEFT,
                    "margin-left": future ? 0 : -viewWidth
                });
                to[future ? "insertAfter" : "insertBefore"](from);
                extend(horizontal, {
                    effects: SLIDE + ":" + (future ? "right" : LEFT),
                    complete: function() {
                        from.remove();
                        to.unwrap();
                        that._focusView(active);
                        that._oldTable = undefined;
                    }
                });
                from.parent().kendoStop(true, true).kendoAnimate(horizontal);
            }
        },
        _vertical: function(from, to) {
            var that = this, vertical = that.options.animation.vertical, effects = vertical.effects, active = that._active, //active state before from's blur
            cell, position;
            if (effects && effects.indexOf("zoom") != -1) {
                to.css({
                    position: "absolute",
                    top: from.prev().outerHeight(),
                    left: 0
                }).insertBefore(from);
                if (transitionOrigin) {
                    cell = that._cellByDate(that._view.toDateString(that._current));
                    position = cell.position();
                    position = position.left + parseInt(cell.width() / 2, 10) + "px" + " " + (position.top + parseInt(cell.height() / 2, 10) + "px");
                    to.css(transitionOrigin, position);
                }
                from.kendoStop(true, true).kendoAnimate({
                    effects: "fadeOut",
                    duration: 600,
                    complete: function() {
                        from.remove();
                        to.css({
                            position: "static",
                            top: 0,
                            left: 0
                        });
                        that._focusView(active);
                        that._oldTable = undefined;
                    }
                });
                to.kendoStop(true, true).kendoAnimate(vertical);
            }
        },
        _cellByDate: function(value) {
            return this._table.find("td:not(." + OTHERMONTH + ")").filter(function() {
                return $(this.firstChild).attr(kendo.attr(VALUE)) === value;
            });
        },
        _class: function(className, value) {
            var that = this, id = that._cellID, cell = that._cell;
            if (cell) {
                cell.removeAttr(ARIA_SELECTED).removeAttr(ID);
            }
            cell = that._table.find("td:not(." + OTHERMONTH + ")").removeClass(className).filter(function() {
                return $(this.firstChild).attr(kendo.attr(VALUE)) === value;
            }).attr(ARIA_SELECTED, true);
            if (className === FOCUSED && !that._active && that.options.focusOnNav !== false) {
                className = "";
            }
            cell.addClass(className);
            if (cell[0]) {
                that._cell = cell;
            }
            if (id) {
                cell.attr(ID, id);
                that._table.removeAttr("aria-activedescendant").attr("aria-activedescendant", id);
            }
        },
        _bindTable: function(table) {
            table.on(FOCUS_WITH_NS, this._addClassProxy).on(BLUR, this._removeClassProxy);
        },
        _click: function(link) {
            var that = this, options = that.options, currentValue = new Date(+that._current), value = link.attr(kendo.attr(VALUE)).split("/");
            //Safari cannot create correctly date from "1/1/2090"
            value = new DATE(value[0], value[1], value[2]);
            adjustDate(value);
            that._view.setDate(currentValue, value);
            that.navigateDown(restrictValue(currentValue, options.min, options.max));
        },
        _focus: function(value) {
            var that = this, view = that._view;
            if (view.compare(value, that._current) !== 0) {
                that.navigate(value);
            } else {
                that._current = value;
                that._class(FOCUSED, view.toDateString(value));
            }
        },
        _focusView: function(active, table) {
            if (active) {
                this.focus(table);
            }
        },
        _footer: function(template) {
            var that = this, element = that.element, today = new DATE(), footer = element.find(".k-footer");
            if (!template) {
                that._toggle(false);
                footer.hide();
                return;
            }
            if (!footer[0]) {
                footer = $('<div class="k-footer"><a href="#" class="k-link k-nav-today"></a></div>').appendTo(element);
            }
            that._today = footer.show().find(".k-link").html(template(today)).attr("title", kendo.toString(today, "D", that.options.culture));
            that._toggle();
        },
        _header: function() {
            var that = this, element = that.element, active = that.options.focusOnNav !== false, links;
            if (!element.find(".k-header")[0]) {
                element.html('<div class="k-header">' + '<a href="#" role="button" class="k-link k-nav-prev"><span class="k-icon k-i-arrow-w"></span></a>' + '<a href="#" role="button" aria-live="assertive" aria-atomic="true" class="k-link k-nav-fast"></a>' + '<a href="#" role="button" class="k-link k-nav-next"><span class="k-icon k-i-arrow-e"></span></a>' + "</div>");
            }
            links = element.find(".k-link").on(MOUSEENTER_WITH_NS + " " + MOUSELEAVE + " " + FOCUS_WITH_NS + " " + BLUR, mousetoggle).click(false);
            that._title = links.eq(1).on(CLICK, function() {
                that._focusView(active);
                that.navigateUp();
            });
            that[PREVARROW] = links.eq(0).on(CLICK, function() {
                that._focusView(active);
                that.navigateToPast();
            });
            that[NEXTARROW] = links.eq(2).on(CLICK, function() {
                that._focusView(active);
                that.navigateToFuture();
            });
        },
        _navigate: function(arrow, modifier) {
            var that = this, index = that._index + 1, currentValue = new DATE(+that._current);
            arrow = that[arrow];
            if (!arrow.hasClass(DISABLED)) {
                if (index > 3) {
                    currentValue.setFullYear(currentValue.getFullYear() + 100 * modifier);
                } else {
                    calendar.views[index].setDate(currentValue, modifier);
                }
                that.navigate(currentValue);
            }
        },
        _option: function(option, value) {
            var that = this, options = that.options, selectedValue = +that._value, bigger, navigate, arrow = NEXTARROW;
            if (value === undefined) {
                return options[option];
            }
            value = parse(value, options.format, options.culture);
            if (!value) {
                return;
            }
            options[option] = new DATE(+value);
            navigate = that._view.compare(value, that._current);
            if (option === MIN) {
                bigger = +value > selectedValue;
                navigate = navigate > -1;
                arrow = PREVARROW;
            } else {
                bigger = selectedValue > +value;
                navigate = navigate < 1;
            }
            if (bigger) {
                that.value(null);
            } else if (navigate) {
                that.navigate();
            } else {
                that[arrow].toggleClass(DISABLED, false).attr(ARIA_DISABLED, false);
            }
            that._toggle();
        },
        _toggle: function(toggle) {
            var that = this, options = that.options, link = that._today;
            if (toggle === undefined) {
                toggle = isInRange(new DATE(), options.min, options.max);
            }
            if (link) {
                link.off(CLICK);
                if (toggle) {
                    link.addClass(TODAY).removeClass(DISABLED).on(CLICK, proxy(that._todayClick, that));
                } else {
                    link.removeClass(TODAY).addClass(DISABLED).on(CLICK, prevent);
                }
            }
        },
        _todayClick: function(e) {
            var that = this, depth = views[that.options.depth], today = new DATE();
            e.preventDefault();
            if (that._view.compare(that._current, today) === 0 && that._index == depth) {
                that._changeView = false;
            }
            that._value = today;
            that.navigate(today, depth);
            that.trigger(CHANGE);
        },
        _templates: function() {
            var that = this, options = that.options, footer = options.footer, month = options.month, content = month.content, empty = month.empty;
            that.month = {
                content: template('<td#=data.cssClass# role="gridcell"><a tabindex="-1" class="k-link#=data.linkClass#" href="#=data.url#" ' + kendo.attr("value") + '="#=data.dateString#" title="#=data.title#">' + (content || "#=data.value#") + "</a></td>", {
                    useWithBlock: !!content
                }),
                empty: template('<td role="gridcell">' + (empty || "&nbsp;") + "</td>", {
                    useWithBlock: !!empty
                })
            };
            if (footer !== false) {
                that.footer = template(footer || '#= kendo.toString(data,"D","' + options.culture + '") #', {
                    useWithBlock: false
                });
            }
        }
    });
    ui.plugin(Calendar);
    var calendar = {
        firstDayOfMonth: function(date) {
            return new DATE(date.getFullYear(), date.getMonth(), 1);
        },
        firstVisibleDay: function(date, calendarInfo) {
            calendarInfo = calendarInfo || kendo.culture().calendar;
            var firstDay = calendarInfo.firstDay, firstVisibleDay = new DATE(date.getFullYear(), date.getMonth(), 0, date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds());
            while (firstVisibleDay.getDay() != firstDay) {
                calendar.setTime(firstVisibleDay, -1 * MS_PER_DAY);
            }
            return firstVisibleDay;
        },
        setTime: function(date, time) {
            var tzOffsetBefore = date.getTimezoneOffset(), resultDATE = new DATE(date.getTime() + time), tzOffsetDiff = resultDATE.getTimezoneOffset() - tzOffsetBefore;
            date.setTime(resultDATE.getTime() + tzOffsetDiff * MS_PER_MINUTE);
        },
        views: [ {
            name: MONTH,
            title: function(date, min, max, culture) {
                return getCalendarInfo(culture).months.names[date.getMonth()] + " " + date.getFullYear();
            },
            content: function(options) {
                var that = this, idx = 0, min = options.min, max = options.max, date = options.date, dates = options.dates, format = options.format, culture = options.culture, navigateUrl = options.url, hasUrl = navigateUrl && dates[0], currentCalendar = getCalendarInfo(culture), firstDayIdx = currentCalendar.firstDay, days = currentCalendar.days, names = shiftArray(days.names, firstDayIdx), shortNames = shiftArray(days.namesShort, firstDayIdx), start = calendar.firstVisibleDay(date, currentCalendar), firstDayOfMonth = that.first(date), lastDayOfMonth = that.last(date), toDateString = that.toDateString, today = new DATE(), html = '<table tabindex="0" role="grid" class="k-content" cellspacing="0"><thead><tr role="row">';
                for (;idx < 7; idx++) {
                    html += '<th scope="col" title="' + names[idx] + '">' + shortNames[idx] + "</th>";
                }
                today = new DATE(today.getFullYear(), today.getMonth(), today.getDate());
                adjustDate(today);
                today = +today;
                return view({
                    cells: 42,
                    perRow: 7,
                    html: html += '</tr></thead><tbody><tr role="row">',
                    start: new DATE(start.getFullYear(), start.getMonth(), start.getDate()),
                    min: new DATE(min.getFullYear(), min.getMonth(), min.getDate()),
                    max: new DATE(max.getFullYear(), max.getMonth(), max.getDate()),
                    content: options.content,
                    empty: options.empty,
                    setter: that.setDate,
                    build: function(date) {
                        var cssClass = [], day = date.getDay(), linkClass = "", url = "#";
                        if (date < firstDayOfMonth || date > lastDayOfMonth) {
                            cssClass.push(OTHERMONTH);
                        }
                        if (+date === today) {
                            cssClass.push("k-today");
                        }
                        if (day === 0 || day === 6) {
                            cssClass.push("k-weekend");
                        }
                        if (hasUrl && inArray(+date, dates)) {
                            url = navigateUrl.replace("{0}", kendo.toString(date, format, culture));
                            linkClass = " k-action-link";
                        }
                        return {
                            date: date,
                            dates: dates,
                            ns: kendo.ns,
                            title: kendo.toString(date, "D", culture),
                            value: date.getDate(),
                            dateString: toDateString(date),
                            cssClass: cssClass[0] ? ' class="' + cssClass.join(" ") + '"' : "",
                            linkClass: linkClass,
                            url: url
                        };
                    }
                });
            },
            first: function(date) {
                return calendar.firstDayOfMonth(date);
            },
            last: function(date) {
                var last = new DATE(date.getFullYear(), date.getMonth() + 1, 0), first = calendar.firstDayOfMonth(date), timeOffset = Math.abs(last.getTimezoneOffset() - first.getTimezoneOffset());
                if (timeOffset) {
                    last.setHours(first.getHours() + timeOffset / 60);
                }
                return last;
            },
            compare: function(date1, date2) {
                var result, month1 = date1.getMonth(), year1 = date1.getFullYear(), month2 = date2.getMonth(), year2 = date2.getFullYear();
                if (year1 > year2) {
                    result = 1;
                } else if (year1 < year2) {
                    result = -1;
                } else {
                    result = month1 == month2 ? 0 : month1 > month2 ? 1 : -1;
                }
                return result;
            },
            setDate: function(date, value) {
                var hours = date.getHours();
                if (value instanceof DATE) {
                    date.setFullYear(value.getFullYear(), value.getMonth(), value.getDate());
                } else {
                    calendar.setTime(date, value * MS_PER_DAY);
                }
                adjustDate(date, hours);
            },
            toDateString: function(date) {
                return date.getFullYear() + "/" + date.getMonth() + "/" + date.getDate();
            }
        }, {
            name: "year",
            title: function(date) {
                return date.getFullYear();
            },
            content: function(options) {
                var namesAbbr = getCalendarInfo(options.culture).months.namesAbbr, toDateString = this.toDateString, min = options.min, max = options.max;
                return view({
                    min: new DATE(min.getFullYear(), min.getMonth(), 1),
                    max: new DATE(max.getFullYear(), max.getMonth(), 1),
                    start: new DATE(options.date.getFullYear(), 0, 1),
                    setter: this.setDate,
                    build: function(date) {
                        return {
                            value: namesAbbr[date.getMonth()],
                            ns: kendo.ns,
                            dateString: toDateString(date),
                            cssClass: ""
                        };
                    }
                });
            },
            first: function(date) {
                return new DATE(date.getFullYear(), 0, date.getDate());
            },
            last: function(date) {
                return new DATE(date.getFullYear(), 11, date.getDate());
            },
            compare: function(date1, date2) {
                return compare(date1, date2);
            },
            setDate: function(date, value) {
                var month, hours = date.getHours();
                if (value instanceof DATE) {
                    month = value.getMonth();
                    date.setFullYear(value.getFullYear(), month, date.getDate());
                    if (month !== date.getMonth()) {
                        date.setDate(0);
                    }
                } else {
                    month = date.getMonth() + value;
                    date.setMonth(month);
                    if (month > 11) {
                        month -= 12;
                    }
                    if (month > 0 && date.getMonth() != month) {
                        date.setDate(0);
                    }
                }
                adjustDate(date, hours);
            },
            toDateString: function(date) {
                return date.getFullYear() + "/" + date.getMonth() + "/1";
            }
        }, {
            name: "decade",
            title: function(date, min, max) {
                return title(date, min, max, 10);
            },
            content: function(options) {
                var year = options.date.getFullYear(), toDateString = this.toDateString;
                return view({
                    start: new DATE(year - year % 10 - 1, 0, 1),
                    min: new DATE(options.min.getFullYear(), 0, 1),
                    max: new DATE(options.max.getFullYear(), 0, 1),
                    setter: this.setDate,
                    build: function(date, idx) {
                        return {
                            value: date.getFullYear(),
                            ns: kendo.ns,
                            dateString: toDateString(date),
                            cssClass: idx === 0 || idx == 11 ? OTHERMONTHCLASS : ""
                        };
                    }
                });
            },
            first: function(date) {
                var year = date.getFullYear();
                return new DATE(year - year % 10, date.getMonth(), date.getDate());
            },
            last: function(date) {
                var year = date.getFullYear();
                return new DATE(year - year % 10 + 9, date.getMonth(), date.getDate());
            },
            compare: function(date1, date2) {
                return compare(date1, date2, 10);
            },
            setDate: function(date, value) {
                setDate(date, value, 1);
            },
            toDateString: function(date) {
                return date.getFullYear() + "/0/1";
            }
        }, {
            name: CENTURY,
            title: function(date, min, max) {
                return title(date, min, max, 100);
            },
            content: function(options) {
                var year = options.date.getFullYear(), min = options.min.getFullYear(), max = options.max.getFullYear(), toDateString = this.toDateString, minYear = min, maxYear = max;
                minYear = minYear - minYear % 10;
                maxYear = maxYear - maxYear % 10;
                if (maxYear - minYear < 10) {
                    maxYear = minYear + 9;
                }
                return view({
                    start: new DATE(year - year % 100 - 10, 0, 1),
                    min: new DATE(minYear, 0, 1),
                    max: new DATE(maxYear, 0, 1),
                    setter: this.setDate,
                    build: function(date, idx) {
                        var start = date.getFullYear(), end = start + 9;
                        if (start < min) {
                            start = min;
                        }
                        if (end > max) {
                            end = max;
                        }
                        return {
                            ns: kendo.ns,
                            value: start + " - " + end,
                            dateString: toDateString(date),
                            cssClass: idx === 0 || idx == 11 ? OTHERMONTHCLASS : ""
                        };
                    }
                });
            },
            first: function(date) {
                var year = date.getFullYear();
                return new DATE(year - year % 100, date.getMonth(), date.getDate());
            },
            last: function(date) {
                var year = date.getFullYear();
                return new DATE(year - year % 100 + 99, date.getMonth(), date.getDate());
            },
            compare: function(date1, date2) {
                return compare(date1, date2, 100);
            },
            setDate: function(date, value) {
                setDate(date, value, 10);
            },
            toDateString: function(date) {
                var year = date.getFullYear();
                return year - year % 10 + "/0/1";
            }
        } ]
    };
    function title(date, min, max, modular) {
        var start = date.getFullYear(), minYear = min.getFullYear(), maxYear = max.getFullYear(), end;
        start = start - start % modular;
        end = start + (modular - 1);
        if (start < minYear) {
            start = minYear;
        }
        if (end > maxYear) {
            end = maxYear;
        }
        return start + "-" + end;
    }
    function view(options) {
        var idx = 0, data, min = options.min, max = options.max, start = options.start, setter = options.setter, build = options.build, length = options.cells || 12, cellsPerRow = options.perRow || 4, content = options.content || cellTemplate, empty = options.empty || emptyCellTemplate, html = options.html || '<table tabindex="0" role="grid" class="k-content k-meta-view" cellspacing="0"><tbody><tr role="row">';
        for (;idx < length; idx++) {
            if (idx > 0 && idx % cellsPerRow === 0) {
                html += '</tr><tr role="row">';
            }
            data = build(start, idx);
            html += isInRange(start, min, max) ? content(data) : empty(data);
            setter(start, 1);
        }
        return html + "</tr></tbody></table>";
    }
    function compare(date1, date2, modifier) {
        var year1 = date1.getFullYear(), start = date2.getFullYear(), end = start, result = 0;
        if (modifier) {
            start = start - start % modifier;
            end = start - start % modifier + modifier - 1;
        }
        if (year1 > end) {
            result = 1;
        } else if (year1 < start) {
            result = -1;
        }
        return result;
    }
    function restrictValue(value, min, max) {
        var today = new DATE();
        today = new DATE(today.getFullYear(), today.getMonth(), today.getDate());
        if (value) {
            today = new DATE(+value);
        }
        if (min > today) {
            today = new DATE(+min);
        } else if (max < today) {
            today = new DATE(+max);
        }
        return today;
    }
    function isInRange(date, min, max) {
        return +date >= +min && +date <= +max;
    }
    function shiftArray(array, idx) {
        return array.slice(idx).concat(array.slice(0, idx));
    }
    function setDate(date, value, multiplier) {
        value = value instanceof DATE ? value.getFullYear() : date.getFullYear() + multiplier * value;
        date.setFullYear(value);
    }
    function mousetoggle(e) {
        $(this).toggleClass(HOVER, MOUSEENTER.indexOf(e.type) > -1 || e.type == FOCUS);
    }
    function prevent(e) {
        e.preventDefault();
    }
    function getCalendarInfo(culture) {
        return getCulture(culture).calendars.standard;
    }
    function normalize(options) {
        var start = views[options.start], depth = views[options.depth], culture = getCulture(options.culture);
        options.format = extractFormat(options.format || culture.calendars.standard.patterns.d);
        if (isNaN(start)) {
            start = 0;
            options.start = MONTH;
        }
        if (depth === undefined || depth > start) {
            options.depth = MONTH;
        }
        if (!options.dates) {
            options.dates = [];
        }
    }
    function makeUnselectable(element) {
        if (isIE8) {
            element.find("*").attr("unselectable", "on");
        }
    }
    function inArray(date, dates) {
        for (var i = 0, length = dates.length; i < length; i++) {
            if (date === +dates[i]) {
                return true;
            }
        }
        return false;
    }
    function isEqualDatePart(value1, value2) {
        if (value1) {
            return value1.getFullYear() === value2.getFullYear() && value1.getMonth() === value2.getMonth() && value1.getDate() === value2.getDate();
        }
        return false;
    }
    calendar.isEqualDatePart = isEqualDatePart;
    calendar.makeUnselectable = makeUnselectable;
    calendar.restrictValue = restrictValue;
    calendar.isInRange = isInRange;
    calendar.normalize = normalize;
    calendar.viewsEnum = views;
    kendo.calendar = calendar;
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, Widget = ui.Widget, parse = kendo.parseDate, keys = kendo.keys, template = kendo.template, activeElement = kendo._activeElement, DIV = "<div />", SPAN = "<span />", ns = ".kendoDatePicker", CLICK = "click" + ns, OPEN = "open", CLOSE = "close", CHANGE = "change", DATEVIEW = "dateView", DISABLED = "disabled", READONLY = "readonly", DEFAULT = "k-state-default", FOCUSED = "k-state-focused", SELECTED = "k-state-selected", STATEDISABLED = "k-state-disabled", HOVER = "k-state-hover", KEYDOWN = "keydown" + ns, HOVEREVENTS = "mouseenter" + ns + " mouseleave" + ns, MOUSEDOWN = "mousedown" + ns, ID = "id", MIN = "min", MAX = "max", MONTH = "month", ARIA_DISABLED = "aria-disabled", ARIA_EXPANDED = "aria-expanded", ARIA_HIDDEN = "aria-hidden", ARIA_READONLY = "aria-readonly", calendar = kendo.calendar, isInRange = calendar.isInRange, restrictValue = calendar.restrictValue, isEqualDatePart = calendar.isEqualDatePart, extend = $.extend, proxy = $.proxy, DATE = Date;
    function normalize(options) {
        var parseFormats = options.parseFormats, format = options.format;
        calendar.normalize(options);
        parseFormats = $.isArray(parseFormats) ? parseFormats : [ parseFormats ];
        if ($.inArray(format, parseFormats) === -1) {
            parseFormats.splice(0, 0, options.format);
        }
        options.parseFormats = parseFormats;
    }
    function preventDefault(e) {
        e.preventDefault();
    }
    var DateView = function(options) {
        var that = this, id, body = document.body, sharedCalendar = DatePicker.sharedCalendar, div = $(DIV).attr(ARIA_HIDDEN, "true").addClass("k-calendar-container").appendTo(body);
        if (!sharedCalendar) {
            sharedCalendar = DatePicker.sharedCalendar = new ui.Calendar($(DIV).attr(ID, kendo.guid()).hide().appendTo(body), {
                focusOnNav: false
            });
            calendar.makeUnselectable(sharedCalendar.element);
        }
        that.calendar = sharedCalendar;
        that.options = options = options || {};
        id = options.id;
        if (id) {
            id += "_dateview";
            div.attr(ID, id);
            that._dateViewID = id;
        }
        that.popup = new ui.Popup(div, extend(options.popup, options, {
            name: "Popup",
            isRtl: kendo.support.isRtl(options.anchor)
        }));
        that.div = div;
        that._templates();
        that.value(options.value);
    };
    DateView.prototype = {
        _calendar: function() {
            var that = this, popup = that.popup, options = that.options, calendar = that.calendar, element = calendar.element;
            if (element.data(DATEVIEW) !== that) {
                element.appendTo(popup.element).data(DATEVIEW, that).off(CLICK + " " + KEYDOWN).on(CLICK, "td:has(.k-link)", proxy(that._click, that)).on(MOUSEDOWN, preventDefault).show();
                calendar.unbind(CHANGE).bind(CHANGE, options);
                calendar.month = that.month;
                calendar.options.dates = options.dates;
                calendar.options.depth = options.depth;
                calendar.options.culture = options.culture;
                calendar._footer(that.footer);
                calendar.min(options.min);
                calendar.max(options.max);
                calendar.navigate(that._value || that._current, options.start);
                that.value(that._value);
            }
        },
        destroy: function() {
            var that = this, calendar = that.calendar, element = calendar.element, dv = element.data(DATEVIEW), popups;
            if (dv === undefined || dv === that) {
                popups = $(".k-calendar-container");
                if (popups.length > 1) {
                    element.hide().appendTo(document.body);
                } else {
                    element.off(ns);
                    calendar.destroy();
                    calendar.element.remove();
                    DatePicker.sharedCalendar = null;
                }
            }
            that.popup.destroy();
        },
        open: function() {
            var that = this;
            that._calendar();
            that.popup.open();
        },
        close: function() {
            this.popup.close();
        },
        min: function(value) {
            this._option(MIN, value);
        },
        max: function(value) {
            this._option(MAX, value);
        },
        toggle: function() {
            var that = this;
            that[that.popup.visible() ? CLOSE : OPEN]();
        },
        move: function(e) {
            var that = this, key = e.keyCode, calendar = that.calendar, selectIsClicked = e.ctrlKey && key == keys.DOWN || key == keys.ENTER;
            if (key == keys.ESC) {
                that.close();
                return;
            }
            if (e.altKey) {
                if (key == keys.DOWN) {
                    that.open();
                    e.preventDefault();
                } else if (key == keys.UP) {
                    that.close();
                    e.preventDefault();
                }
                return;
            }
            if (!that.popup.visible()) {
                return;
            }
            if (selectIsClicked && calendar._cell.hasClass(SELECTED)) {
                that.close();
                e.preventDefault();
                return;
            }
            that._current = calendar._move(e);
        },
        value: function(value) {
            var that = this, calendar = that.calendar, options = that.options;
            that._value = value;
            that._current = new DATE(+restrictValue(value, options.min, options.max));
            if (calendar.element.data(DATEVIEW) === that) {
                calendar.value(value);
            }
        },
        _click: function(e) {
            if (e.currentTarget.className.indexOf(SELECTED) !== -1) {
                this.close();
            }
        },
        _option: function(option, value) {
            var that = this, options = that.options, calendar = that.calendar;
            options[option] = value;
            if (calendar.element.data(DATEVIEW) === that) {
                calendar[option](value);
            }
        },
        _templates: function() {
            var that = this, options = that.options, footer = options.footer, month = options.month || {}, content = month.content, empty = month.empty;
            that.month = {
                content: template('<td#=data.cssClass#><a tabindex="-1" class="k-link" href="\\#" ' + kendo.attr("value") + '="#=data.dateString#" title="#=data.title#">' + (content || "#=data.value#") + "</a></td>", {
                    useWithBlock: !!content
                }),
                empty: template("<td>" + (empty || "&nbsp;") + "</td>", {
                    useWithBlock: !!empty
                })
            };
            if (footer !== false) {
                that.footer = template(footer || '#= kendo.toString(data,"D","' + options.culture + '") #', {
                    useWithBlock: false
                });
            }
        }
    };
    DateView.normalize = normalize;
    kendo.DateView = DateView;
    var DatePicker = Widget.extend({
        init: function(element, options) {
            var that = this, disabled, div;
            Widget.fn.init.call(that, element, options);
            element = that.element;
            options = that.options;
            normalize(options);
            that._wrapper();
            that.dateView = new DateView(extend({}, options, {
                id: element.attr(ID),
                anchor: that.wrapper,
                change: function() {
                    // calendar is the current scope
                    that._change(this.value());
                    that.close();
                },
                close: function(e) {
                    if (that.trigger(CLOSE)) {
                        e.preventDefault();
                    } else {
                        element.attr(ARIA_EXPANDED, false);
                        div.attr(ARIA_HIDDEN, true);
                    }
                },
                open: function(e) {
                    var options = that.options, date;
                    if (that.trigger(OPEN)) {
                        e.preventDefault();
                    } else {
                        if (that.element.val() !== that._oldText) {
                            date = parse(element.val(), options.parseFormats, options.culture);
                            if (!date) {
                                that.dateView.value(date);
                            } else {
                                that.dateView._current = date;
                                that.dateView.calendar._focus(date);
                            }
                        }
                        element.attr(ARIA_EXPANDED, true);
                        div.attr(ARIA_HIDDEN, false);
                    }
                }
            }));
            div = that.dateView.div;
            that._icon();
            element[0].type = "text";
            element.addClass("k-input").attr({
                role: "textbox",
                "aria-haspopup": true,
                "aria-expanded": false,
                "aria-owns": that.dateView._dateViewID
            });
            that._reset();
            that._template();
            disabled = element.is("[disabled]");
            if (disabled) {
                that.enable(false);
            } else {
                that.readonly(element.is("[readonly]"));
            }
            that.value(options.value || that.element.val());
            kendo.notify(that);
        },
        events: [ OPEN, CLOSE, CHANGE ],
        options: {
            name: "DatePicker",
            value: null,
            footer: "",
            format: "",
            culture: "",
            parseFormats: [],
            min: new Date(1900, 0, 1),
            max: new Date(2099, 11, 31),
            start: MONTH,
            depth: MONTH,
            animation: {},
            month: {},
            dates: [],
            ARIATemplate: 'Current focused date is #=kendo.toString(data.current, "D")#'
        },
        setOptions: function(options) {
            var that = this, dateView = that.dateView, dateViewOptions = dateView.options;
            Widget.fn.setOptions.call(that, options);
            normalize(that.options);
            dateView.options = extend(dateViewOptions, that.options, {
                change: dateViewOptions.change,
                close: dateViewOptions.close,
                open: dateViewOptions.open
            });
        },
        _editable: function(options) {
            var that = this, icon = that._dateIcon.off(ns), element = that.element.off(ns), wrapper = that._inputWrapper.off(ns), readonly = options.readonly, disable = options.disable;
            if (!readonly && !disable) {
                wrapper.addClass(DEFAULT).removeClass(STATEDISABLED).on(HOVEREVENTS, that._toggleHover);
                element.removeAttr(DISABLED).removeAttr(READONLY).attr(ARIA_DISABLED, false).attr(ARIA_READONLY, false).on("keydown" + ns, proxy(that._keydown, that)).on("blur" + ns, proxy(that._blur, that)).on("focus" + ns, function() {
                    that._inputWrapper.addClass(FOCUSED);
                });
                icon.on(CLICK, proxy(that._click, that)).on(MOUSEDOWN, preventDefault);
            } else {
                wrapper.addClass(disable ? STATEDISABLED : DEFAULT).removeClass(disable ? DEFAULT : STATEDISABLED);
                element.attr(DISABLED, disable).attr(READONLY, readonly).attr(ARIA_DISABLED, disable).attr(ARIA_READONLY, readonly);
            }
        },
        readonly: function(readonly) {
            this._editable({
                readonly: readonly === undefined ? true : readonly,
                disable: false
            });
        },
        enable: function(enable) {
            this._editable({
                readonly: false,
                disable: !(enable = enable === undefined ? true : enable)
            });
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.dateView.destroy();
            that.element.off(ns);
            that._dateIcon.off(ns);
            that._inputWrapper.off(ns);
            if (that._form) {
                that._form.off("reset", that._resetHandler);
            }
        },
        open: function() {
            this.dateView.open();
        },
        close: function() {
            this.dateView.close();
        },
        min: function(value) {
            return this._option(MIN, value);
        },
        max: function(value) {
            return this._option(MAX, value);
        },
        value: function(value) {
            var that = this;
            if (value === undefined) {
                return that._value;
            }
            that._old = that._update(value);
            if (that._old === null) {
                that.element.val("");
            }
            that._oldText = that.element.val();
        },
        _toggleHover: function(e) {
            $(e.currentTarget).toggleClass(HOVER, e.type === "mouseenter");
        },
        _blur: function() {
            var that = this, value = that.element.val();
            that.close();
            if (value !== that._oldText) {
                that._change(value);
            }
            that._inputWrapper.removeClass(FOCUSED);
        },
        _click: function() {
            var that = this, element = that.element;
            that.dateView.toggle();
            if (!kendo.support.touch && element[0] !== activeElement()) {
                element.focus();
            }
        },
        _change: function(value) {
            var that = this;
            value = that._update(value);
            if (+that._old != +value) {
                that._old = value;
                that._oldText = that.element.val();
                that.trigger(CHANGE);
                // trigger the DOM change event so any subscriber gets notified
                that.element.trigger(CHANGE);
            }
        },
        _keydown: function(e) {
            var that = this, dateView = that.dateView, value = that.element.val();
            if (!dateView.popup.visible() && e.keyCode == keys.ENTER && value !== that._oldText) {
                that._change(value);
            } else {
                dateView.move(e);
                that._updateARIA(dateView._current);
            }
        },
        _icon: function() {
            var that = this, element = that.element, icon;
            icon = element.next("span.k-select");
            if (!icon[0]) {
                icon = $('<span unselectable="on" class="k-select"><span unselectable="on" class="k-icon k-i-calendar">select</span></span>').insertAfter(element);
            }
            that._dateIcon = icon.attr({
                role: "button",
                "aria-controls": that.dateView._dateViewID
            });
        },
        _option: function(option, value) {
            var that = this, options = that.options;
            if (value === undefined) {
                return options[option];
            }
            value = parse(value, options.parseFormats, options.culture);
            if (!value) {
                return;
            }
            options[option] = new DATE(+value);
            that.dateView[option](value);
        },
        _update: function(value) {
            var that = this, options = that.options, min = options.min, max = options.max, date = parse(value, options.parseFormats, options.culture), formattedValue;
            if (+date === +that._value) {
                formattedValue = kendo.toString(date, options.format, options.culture);
                if (formattedValue !== value) {
                    that.element.val(date === null ? value : formattedValue);
                }
                return date;
            }
            if (date !== null && isEqualDatePart(date, min)) {
                date = restrictValue(date, min, max);
            } else if (!isInRange(date, min, max)) {
                date = null;
            }
            that._value = date;
            that.dateView.value(date);
            that.element.val(date ? kendo.toString(date, options.format, options.culture) : value);
            that._updateARIA(date);
            return date;
        },
        _wrapper: function() {
            var that = this, element = that.element, wrapper;
            wrapper = element.parents(".k-datepicker");
            if (!wrapper[0]) {
                wrapper = element.wrap(SPAN).parent().addClass("k-picker-wrap k-state-default");
                wrapper = wrapper.wrap(SPAN).parent();
            }
            wrapper[0].style.cssText = element[0].style.cssText;
            element.css({
                width: "100%",
                height: element[0].style.height
            });
            that.wrapper = wrapper.addClass("k-widget k-datepicker k-header").addClass(element[0].className);
            that._inputWrapper = $(wrapper[0].firstChild);
        },
        _reset: function() {
            var that = this, element = that.element, form = element.closest("form");
            if (form[0]) {
                that._resetHandler = function() {
                    that.value(element[0].defaultValue);
                };
                that._form = form.on("reset", that._resetHandler);
            }
        },
        _template: function() {
            this._ariaTemplate = template(this.options.ARIATemplate);
        },
        _updateARIA: function(date) {
            this.element.attr("aria-label", this._ariaTemplate({
                current: date
            }));
        }
    });
    ui.plugin(DatePicker);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, support = kendo.support, activeElement = kendo._activeElement, placeholderSupported = support.placeholder, ui = kendo.ui, keys = kendo.keys, DataSource = kendo.data.DataSource, List = ui.List, ARIA_DISABLED = "aria-disabled", ARIA_READONLY = "aria-readonly", DEFAULT = "k-state-default", DISABLED = "disabled", READONLY = "readonly", FOCUSED = "k-state-focused", SELECTED = "k-state-selected", STATEDISABLED = "k-state-disabled", HOVER = "k-state-hover", ns = ".kendoAutoComplete", HOVEREVENTS = "mouseenter" + ns + " mouseleave" + ns, caretPosition = List.caret, selectText = List.selectText, proxy = $.proxy;
    function indexOfWordAtCaret(caret, text, separator) {
        return separator ? text.substring(0, caret).split(separator).length - 1 : 0;
    }
    function wordAtCaret(caret, text, separator) {
        return text.split(separator)[indexOfWordAtCaret(caret, text, separator)];
    }
    function replaceWordAtCaret(caret, text, word, separator) {
        var words = text.split(separator);
        words.splice(indexOfWordAtCaret(caret, text, separator), 1, word);
        if (separator && words[words.length - 1] !== "") {
            words.push("");
        }
        return words.join(separator);
    }
    function moveCaretAtEnd(element) {
        var length = element.value.length;
        selectText(element, length, length);
    }
    var AutoComplete = List.extend({
        init: function(element, options) {
            var that = this, wrapper;
            that.ns = ns;
            options = $.isArray(options) ? {
                dataSource: options
            } : options;
            List.fn.init.call(that, element, options);
            element = that.element;
            options = that.options;
            options.placeholder = options.placeholder || element.attr("placeholder");
            if (placeholderSupported) {
                element.attr("placeholder", options.placeholder);
            }
            that._wrapper();
            that._loader();
            that._accessors();
            that._dataSource();
            that._ignoreCase();
            element[0].type = "text";
            wrapper = that.wrapper;
            that._popup();
            element.addClass("k-input").on("keydown" + ns, proxy(that._keydown, that)).on("paste" + ns, proxy(that._search, that)).on("focus" + ns, function() {
                that._prev = that._accessor();
                that._placeholder(false);
                wrapper.addClass(FOCUSED);
            }).on("blur" + ns, function() {
                that._change();
                that._placeholder();
                wrapper.removeClass(FOCUSED);
            }).attr({
                autocomplete: "off",
                role: "textbox",
                "aria-haspopup": true
            });
            that._enable();
            that._old = that._accessor();
            if (element[0].id) {
                element.attr("aria-owns", that.ul[0].id);
            }
            that._aria();
            that._placeholder();
            kendo.notify(that);
        },
        options: {
            name: "AutoComplete",
            enabled: true,
            suggest: false,
            template: "",
            dataTextField: "",
            minLength: 1,
            delay: 200,
            height: 200,
            filter: "startswith",
            ignoreCase: true,
            highlightFirst: false,
            separator: null,
            placeholder: "",
            animation: {}
        },
        _dataSource: function() {
            var that = this;
            if (that.dataSource && that._refreshHandler) {
                that._unbindDataSource();
            } else {
                that._refreshHandler = proxy(that.refresh, that);
                that._progressHandler = proxy(that._showBusy, that);
            }
            that.dataSource = DataSource.create(that.options.dataSource).bind("change", that._refreshHandler).bind("progress", that._progressHandler);
        },
        setDataSource: function(dataSource) {
            this.options.dataSource = dataSource;
            this._dataSource();
        },
        events: [ "open", "close", "change", "select", "dataBinding", "dataBound" ],
        setOptions: function(options) {
            List.fn.setOptions.call(this, options);
            this._template();
            this._accessors();
            this._aria();
        },
        _editable: function(options) {
            var that = this, element = that.element, wrapper = that.wrapper.off(ns), readonly = options.readonly, disable = options.disable;
            if (!readonly && !disable) {
                wrapper.addClass(DEFAULT).removeClass(STATEDISABLED).on(HOVEREVENTS, that._toggleHover);
                element.removeAttr(DISABLED).removeAttr(READONLY).attr(ARIA_DISABLED, false).attr(ARIA_READONLY, false);
            } else {
                wrapper.addClass(disable ? STATEDISABLED : DEFAULT).removeClass(disable ? DEFAULT : STATEDISABLED);
                element.attr(DISABLED, disable).attr(READONLY, readonly).attr(ARIA_DISABLED, disable).attr(ARIA_READONLY, readonly);
            }
        },
        close: function() {
            var that = this, current = that._current;
            if (current) {
                current.removeClass(SELECTED);
            }
            that.current(null);
            that.popup.close();
        },
        destroy: function() {
            var that = this;
            that.element.off(ns);
            that.wrapper.off(ns);
            List.fn.destroy.call(that);
        },
        refresh: function() {
            var that = this, ul = that.ul[0], popup = that.popup, options = that.options, data = that._data(), length = data.length, action;
            that.trigger("dataBinding");
            ul.innerHTML = kendo.render(that.template, data);
            that._height(length);
            if (popup.visible()) {
                popup._position();
            }
            if (length) {
                if (options.highlightFirst) {
                    that.current($(ul.firstChild));
                }
                if (options.suggest) {
                    that.suggest($(ul.firstChild));
                }
            }
            if (that._open) {
                that._open = false;
                action = length ? "open" : "close";
                if (that._typing && that.element[0] !== activeElement()) {
                    action = "close";
                }
                popup[action]();
                that._typing = undefined;
            }
            if (that._touchScroller) {
                that._touchScroller.reset();
            }
            that._makeUnselectable();
            that._hideBusy();
            that.trigger("dataBound");
        },
        select: function(li) {
            this._select(li);
        },
        search: function(word) {
            var that = this, options = that.options, ignoreCase = options.ignoreCase, separator = options.separator, length;
            word = word || that._accessor();
            that._current = null;
            clearTimeout(that._typing);
            if (separator) {
                word = wordAtCaret(caretPosition(that.element[0]), word, separator);
            }
            length = word.length;
            if (!length) {
                that.popup.close();
            } else if (length >= that.options.minLength) {
                that._open = true;
                that._filterSource({
                    value: ignoreCase ? word.toLowerCase() : word,
                    operator: options.filter,
                    field: options.dataTextField,
                    ignoreCase: ignoreCase
                });
            }
        },
        suggest: function(word) {
            var that = this, key = that._last, value = that._accessor(), element = that.element[0], caret = caretPosition(element), separator = that.options.separator, words = value.split(separator), wordIndex = indexOfWordAtCaret(caret, value, separator), selectionEnd = caret, idx;
            if (key == keys.BACKSPACE || key == keys.DELETE) {
                that._last = undefined;
                return;
            }
            word = word || "";
            if (typeof word !== "string") {
                idx = List.inArray(word[0], that.ul[0]);
                if (idx > -1) {
                    word = that._text(that._data()[idx]);
                } else {
                    word = "";
                }
            }
            if (caret <= 0) {
                caret = value.toLowerCase().indexOf(word.toLowerCase()) + 1;
            }
            idx = value.substring(0, caret).lastIndexOf(separator);
            idx = idx > -1 ? caret - (idx + separator.length) : caret;
            value = words[wordIndex].substring(0, idx);
            if (word) {
                idx = word.toLowerCase().indexOf(value.toLowerCase());
                if (idx > -1) {
                    word = word.substring(idx + value.length);
                    selectionEnd = caret + word.length;
                    value += word;
                }
                if (separator && words[words.length - 1] !== "") {
                    words.push("");
                }
            }
            words[wordIndex] = value;
            that._accessor(words.join(separator || ""));
            selectText(element, caret, selectionEnd);
        },
        value: function(value) {
            if (value !== undefined) {
                this._accessor(value);
                this._old = value;
            } else {
                return this._accessor();
            }
        },
        _accessor: function(value) {
            var that = this, element = that.element[0];
            if (value !== undefined) {
                element.value = value === null ? "" : value;
                that._placeholder();
            } else {
                value = element.value;
                if (element.className.indexOf("k-readonly") > -1) {
                    if (value === that.options.placeholder) {
                        return "";
                    } else {
                        return value;
                    }
                }
                return value;
            }
        },
        _accept: function(li) {
            var that = this;
            that._focus(li);
            moveCaretAtEnd(that.element[0]);
        },
        _keydown: function(e) {
            var that = this, ul = that.ul[0], key = e.keyCode, current = that._current, visible = that.popup.visible();
            that._last = key;
            if (key === keys.DOWN) {
                if (visible) {
                    that._move(current ? current.next() : $(ul.firstChild));
                }
                e.preventDefault();
            } else if (key === keys.UP) {
                if (visible) {
                    that._move(current ? current.prev() : $(ul.lastChild));
                }
                e.preventDefault();
            } else if (key === keys.ENTER || key === keys.TAB) {
                if (key === keys.ENTER && that.popup.visible()) {
                    e.preventDefault();
                }
                that._accept(current);
            } else if (key === keys.ESC) {
                if (that.popup.visible()) {
                    e.preventDefault();
                }
                that.close();
            } else {
                that._search();
            }
        },
        _move: function(li) {
            var that = this;
            li = li[0] ? li : null;
            that.current(li);
            if (that.options.suggest) {
                that.suggest(li);
            }
        },
        _hideBusy: function() {
            var that = this;
            clearTimeout(that._busy);
            that._loading.hide();
            that.element.attr("aria-busy", false);
            that._busy = null;
        },
        _showBusy: function() {
            var that = this;
            if (that._busy) {
                return;
            }
            that._busy = setTimeout(function() {
                that.element.attr("aria-busy", true);
                that._loading.show();
            }, 100);
        },
        _placeholder: function(show) {
            if (placeholderSupported) {
                return;
            }
            var that = this, element = that.element, placeholder = that.options.placeholder, value;
            if (placeholder) {
                value = element.val();
                if (show === undefined) {
                    show = !value;
                }
                if (!show) {
                    if (value !== placeholder) {
                        placeholder = value;
                    } else {
                        placeholder = "";
                    }
                }
                if (value === that._old && !show) {
                    return;
                }
                element.toggleClass("k-readonly", show).val(placeholder);
            }
        },
        _search: function() {
            var that = this;
            clearTimeout(that._typing);
            that._typing = setTimeout(function() {
                if (that._prev !== that._accessor()) {
                    that._prev = that._accessor();
                    that.search();
                }
            }, that.options.delay);
        },
        _select: function(li) {
            var that = this, separator = that.options.separator, data = that._data(), text, idx;
            li = $(li);
            if (li[0] && !li.hasClass(SELECTED)) {
                idx = List.inArray(li[0], that.ul[0]);
                if (idx > -1) {
                    data = data[idx];
                    text = that._text(data);
                    if (separator) {
                        text = replaceWordAtCaret(caretPosition(that.element[0]), that._accessor(), text, separator);
                    }
                    that._accessor(text);
                    that.current(li.addClass(SELECTED));
                }
            }
        },
        _loader: function() {
            this._loading = $('<span class="k-icon k-loading" style="display:none"></span>').insertAfter(this.element);
        },
        _toggleHover: function(e) {
            $(e.currentTarget).toggleClass(HOVER, e.type === "mouseenter");
        },
        _wrapper: function() {
            var that = this, element = that.element, DOMelement = element[0], wrapper;
            wrapper = element.parent();
            if (!wrapper.is("span.k-widget")) {
                wrapper = element.wrap("<span />").parent();
            }
            //aria
            wrapper.attr("tabindex", -1);
            wrapper.attr("role", "presentation");
            //end
            wrapper[0].style.cssText = DOMelement.style.cssText;
            element.css({
                width: "100%",
                height: DOMelement.style.height
            });
            that._focused = that.element;
            that.wrapper = wrapper.addClass("k-widget k-autocomplete k-header").addClass(DOMelement.className);
        }
    });
    ui.plugin(AutoComplete);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, Select = ui.Select, os = kendo.support.mobileOS, ns = ".kendoDropDownList", DISABLED = "disabled", READONLY = "readonly", CHANGE = "change", SELECT = "select", FOCUSED = "k-state-focused", DEFAULT = "k-state-default", STATEDISABLED = "k-state-disabled", ARIA_DISABLED = "aria-disabled", ARIA_READONLY = "aria-readonly", SELECTED = "k-state-selected", HOVEREVENTS = "mouseenter" + ns + " mouseleave" + ns, TABINDEX = "tabindex", proxy = $.proxy;
    var DropDownList = Select.extend({
        init: function(element, options) {
            var that = this, index = options && options.index, optionLabel, useOptionLabel, text;
            that.ns = ns;
            options = $.isArray(options) ? {
                dataSource: options
            } : options;
            Select.fn.init.call(that, element, options);
            that._focusHandler = function() {
                that.wrapper.focus();
            };
            options = that.options;
            element = that.element.on("focus" + ns, that._focusHandler);
            that._reset();
            that._word = "";
            that._wrapper();
            that._tabindex();
            that.wrapper.data(TABINDEX, that.wrapper.attr(TABINDEX));
            that._aria();
            that._span();
            that._popup();
            that._mobile();
            that._accessors();
            that._dataSource();
            that._ignoreCase();
            that._enable();
            that._cascade();
            that._oldIndex = that.selectedIndex = -1;
            if (index !== undefined) {
                options.index = index;
            }
            if (options.autoBind) {
                that.dataSource.fetch();
            } else {
                text = options.text || "";
                if (!text) {
                    optionLabel = that._optionLabelText(options.optionLabel), useOptionLabel = optionLabel && options.index === 0;
                    if (element.is(SELECT)) {
                        if (useOptionLabel) {
                            text = optionLabel;
                        } else {
                            text = element.children(":selected").text();
                        }
                    } else if (!element[0].value && useOptionLabel) {
                        text = optionLabel;
                    }
                }
                that.text(text);
            }
            kendo.notify(that);
        },
        options: {
            name: "DropDownList",
            enabled: true,
            autoBind: true,
            index: 0,
            text: null,
            value: null,
            template: "",
            delay: 500,
            height: 200,
            dataTextField: "",
            dataValueField: "",
            optionLabel: "",
            cascadeFrom: "",
            ignoreCase: true,
            animation: {}
        },
        events: [ "open", "close", CHANGE, "select", "dataBinding", "dataBound", "cascade" ],
        setOptions: function(options) {
            Select.fn.setOptions.call(this, options);
            this._template();
            this._accessors();
            this._aria();
        },
        destroy: function() {
            var that = this;
            that.wrapper.off(ns);
            that.element.off(ns);
            that._inputWrapper.off(ns);
            Select.fn.destroy.call(that);
        },
        open: function() {
            var that = this;
            if (!that.ul[0].firstChild) {
                that._open = true;
                if (!that._request) {
                    that.dataSource.fetch();
                }
            } else {
                that.popup.open();
                that._scroll(that._current);
            }
        },
        toggle: function(toggle) {
            this._toggle(toggle);
        },
        refresh: function() {
            var that = this, data = that._data(), length = data.length, optionLabel = that.options.optionLabel;
            that.trigger("dataBinding");
            if (that._current) {
                that.current(null);
            }
            that.ul[0].innerHTML = kendo.render(that.template, data);
            that._height(length);
            if (that.popup.visible()) {
                that.popup._position();
            }
            if (that.element.is(SELECT)) {
                if (optionLabel && length) {
                    optionLabel = that._optionLabelText(optionLabel);
                    optionLabel = '<option value="">' + optionLabel + "</option>";
                }
                that._options(data, optionLabel);
            }
            if (that._open) {
                that._open = false;
                that.toggle(!!length);
            }
            that._hideBusy();
            that._makeUnselectable();
            if (!that._fetch && length) {
                that._selectItem();
            }
            that._bound = true;
            that.trigger("dataBound");
        },
        search: function(word) {
            if (word) {
                var that = this, ignoreCase = that.options.ignoreCase;
                if (ignoreCase) {
                    word = word.toLowerCase();
                }
                that._select(function(dataItem) {
                    var text = that._text(dataItem);
                    if (text !== undefined) {
                        text = text + "";
                        if (ignoreCase) {
                            text = text.toLowerCase();
                        }
                        return text.indexOf(word) === 0;
                    }
                });
            }
        },
        text: function(text) {
            var span = this.span;
            if (text !== undefined) {
                span.text(text);
            } else {
                return span.text();
            }
        },
        value: function(value) {
            var that = this, idx, hasValue;
            if (value !== undefined) {
                if (value !== null) {
                    value = value.toString();
                }
                that._selectedValue = value;
                hasValue = value || that.options.optionLabel && !that.element[0].disabled && value === "";
                if (hasValue && that._fetchItems(value)) {
                    return;
                }
                idx = that._index(value);
                that.select(idx > -1 ? idx : 0);
            } else {
                return that._accessor();
            }
        },
        _editable: function(options) {
            var that = this, element = that.element, disable = options.disable, readonly = options.readonly, wrapper = that.wrapper.off(ns), dropDownWrapper = that._inputWrapper.off(HOVEREVENTS);
            if (!readonly && !disable) {
                element.removeAttr(DISABLED).removeAttr(READONLY);
                dropDownWrapper.addClass(DEFAULT).removeClass(STATEDISABLED).on(HOVEREVENTS, that._toggleHover);
                wrapper.attr(TABINDEX, wrapper.data(TABINDEX)).attr(ARIA_DISABLED, false).attr(ARIA_READONLY, false).on("click" + ns, function(e) {
                    that._blured = false;
                    e.preventDefault();
                    that.toggle();
                }).on("keydown" + ns, proxy(that._keydown, that)).on("keypress" + ns, proxy(that._keypress, that)).on("focusin" + ns, function() {
                    dropDownWrapper.addClass(FOCUSED);
                    that._blured = false;
                }).on("focusout" + ns, function() {
                    if (!that._blured) {
                        that._triggerCascade();
                        that._blur();
                        dropDownWrapper.removeClass(FOCUSED);
                        that._blured = true;
                        element.blur();
                    }
                });
            } else {
                if (disable) {
                    wrapper.removeAttr(TABINDEX);
                    dropDownWrapper.addClass(STATEDISABLED).removeClass(DEFAULT);
                } else {
                    dropDownWrapper.addClass(DEFAULT).removeClass(STATEDISABLED);
                }
                element.attr(DISABLED, disable).attr(READONLY, readonly);
                wrapper.attr(ARIA_DISABLED, disable).attr(ARIA_READONLY, readonly);
            }
        },
        _accept: function(li) {
            this._focus(li);
        },
        _optionLabelText: function() {
            var options = this.options, dataTextField = options.dataTextField, optionLabel = options.optionLabel;
            if (optionLabel && dataTextField && typeof optionLabel === "object") {
                return this._text(optionLabel);
            }
            return optionLabel;
        },
        _data: function() {
            var that = this, options = that.options, optionLabel = options.optionLabel, textField = options.dataTextField, valueField = options.dataValueField, data = that.dataSource.view(), length = data.length, first = optionLabel, idx = 0;
            if (optionLabel && length) {
                if (typeof optionLabel === "object") {
                    first = optionLabel;
                } else if (textField) {
                    first = {};
                    textField = textField.split(".");
                    valueField = valueField.split(".");
                    assign(first, valueField, "");
                    assign(first, textField, optionLabel);
                }
                first = new kendo.data.ObservableArray([ first ]);
                for (;idx < length; idx++) {
                    first.push(data[idx]);
                }
                data = first;
            }
            return data;
        },
        _keydown: function(e) {
            var that = this, key = e.keyCode, keys = kendo.keys, ul = that.ul[0];
            if (key === keys.LEFT) {
                key = keys.UP;
            } else if (key === keys.RIGHT) {
                key = keys.DOWN;
            }
            e.keyCode = key;
            that._move(e);
            if (key === keys.HOME) {
                e.preventDefault();
                that._select(ul.firstChild);
            } else if (key === keys.END) {
                e.preventDefault();
                that._select(ul.lastChild);
            }
        },
        _selectNext: function(character, index) {
            var that = this, ignoreCase = that.options.ignoreCase, data = that._data(), length = data.length, text;
            for (;index < length; index++) {
                text = that._text(data[index]);
                if (text) {
                    text = text + "";
                    if (ignoreCase) {
                        text = text.toLowerCase();
                    }
                    if (text.indexOf(character) === 0) {
                        that._select(index);
                        that._triggerEvents();
                        return true;
                    }
                }
            }
            return false;
        },
        _keypress: function(e) {
            var that = this;
            setTimeout(function() {
                var character = String.fromCharCode(e.keyCode || e.charCode), index = that.selectedIndex;
                if (that.options.ignoreCase) {
                    character = character.toLowerCase();
                }
                if (character === that._last && index > -1) {
                    that._word = character;
                    if (that._selectNext(character, index + 1)) {
                        return;
                    }
                } else {
                    that._word += character;
                }
                that._last = character;
                that._search();
            });
        },
        _popup: function() {
            Select.fn._popup.call(this);
            this.popup.one("open", function() {
                this.wrapper = kendo.wrap(this.element).addClass("km-popup");
            });
        },
        _search: function() {
            var that = this, dataSource = that.dataSource, word = that._word;
            clearTimeout(that._typing);
            that._typing = setTimeout(function() {
                that._word = "";
            }, that.options.delay);
            if (!that.ul[0].firstChild) {
                dataSource.one(CHANGE, function() {
                    if (dataSource.data()[0]) {
                        that.search(word);
                    }
                }).fetch();
                return;
            }
            that.search(word);
            that._triggerEvents();
        },
        _select: function(li) {
            var that = this, current = that._current, data = that._data(), value, text, idx;
            li = that._get(li);
            if (li && li[0] && !li.hasClass(SELECTED)) {
                if (current) {
                    current.removeClass(SELECTED);
                }
                idx = ui.List.inArray(li[0], that.ul[0]);
                if (idx > -1) {
                    data = data[idx];
                    text = that._text(data);
                    value = that._value(data);
                    that.selectedIndex = idx;
                    that.text(text);
                    that._accessor(value !== undefined ? value : text, idx);
                    that._selectedValue = that._accessor();
                    that.current(li.addClass(SELECTED));
                    if (that._optionID) {
                        that._current.attr("aria-selected", true);
                    }
                }
            }
        },
        _triggerEvents: function() {
            if (!this.popup.visible()) {
                this._triggerCascade();
                this._change();
            }
        },
        _mobile: function() {
            var that = this, popup = that.popup, root = popup.element.parents(".km-root").eq(0);
            if (root.length && os) {
                popup.options.animation.open.effects = os.android || os.meego ? "fadeIn" : os.ios || os.wp ? "slideIn:up" : popup.options.animation.open.effects;
            }
        },
        _span: function() {
            var that = this, wrapper = that.wrapper, SELECTOR = "span.k-input", span;
            span = wrapper.find(SELECTOR);
            if (!span[0]) {
                wrapper.append('<span unselectable="on" class="k-dropdown-wrap k-state-default"><span unselectable="on" class="k-input">&nbsp;</span><span unselectable="on" class="k-select"><span unselectable="on" class="k-icon k-i-arrow-s">select</span></span></span>').append(that.element);
                span = wrapper.find(SELECTOR);
            }
            that.span = span;
            that._inputWrapper = $(wrapper[0].firstChild);
            that._arrow = wrapper.find(".k-icon").mousedown(function(e) {
                e.preventDefault();
            });
        },
        _wrapper: function() {
            var that = this, element = that.element, DOMelement = element[0], wrapper;
            wrapper = element.parent();
            if (!wrapper.is("span.k-widget")) {
                wrapper = element.wrap("<span />").parent();
                wrapper[0].style.cssText = DOMelement.style.cssText;
            }
            element.hide();
            that._focused = that.wrapper = wrapper.addClass("k-widget k-dropdown k-header").addClass(DOMelement.className).css("display", "").attr({
                unselectable: "on",
                role: "listbox",
                "aria-haspopup": true,
                "aria-expanded": false
            });
        },
        _clearSelection: function() {
            var that = this, optionLabel = that.options.optionLabel;
            if (that.dataSource.view()[0] && optionLabel) {
                that.select(0);
                return;
            }
            that.text(optionLabel);
            that.element.val("");
            that.selectedIndex = -1;
        }
    });
    function assign(instance, fields, value) {
        var idx = 0, lastIndex = fields.length - 1, field;
        for (;idx < lastIndex; ++idx) {
            field = fields[idx];
            if (!(field in instance)) {
                instance[field] = {};
            }
            instance = instance[field];
        }
        instance[fields[lastIndex]] = value;
    }
    ui.plugin(DropDownList);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, List = ui.List, Select = ui.Select, support = kendo.support, placeholderSupported = support.placeholder, activeElement = kendo._activeElement, keys = kendo.keys, ns = ".kendoComboBox", CLICK = "click" + ns, MOUSEDOWN = "mousedown" + ns, DISABLED = "disabled", READONLY = "readonly", CHANGE = "change", DEFAULT = "k-state-default", FOCUSED = "k-state-focused", STATEDISABLED = "k-state-disabled", ARIA_DISABLED = "aria-disabled", ARIA_READONLY = "aria-readonly", STATE_SELECTED = "k-state-selected", STATE_FILTER = "filter", STATE_ACCEPT = "accept", STATE_REBIND = "rebind", HOVEREVENTS = "mouseenter" + ns + " mouseleave" + ns, NULL = null, proxy = $.proxy;
    var ComboBox = Select.extend({
        init: function(element, options) {
            var that = this, text;
            that.ns = ns;
            options = $.isArray(options) ? {
                dataSource: options
            } : options;
            Select.fn.init.call(that, element, options);
            that._focusHandler = function() {
                that.input.focus();
            };
            options = that.options;
            element = that.element.on("focus" + ns, that._focusHandler);
            options.placeholder = options.placeholder || element.attr("placeholder");
            that._reset();
            that._wrapper();
            that._input();
            that._tabindex(that.input);
            that._popup();
            that._accessors();
            that._dataSource();
            that._ignoreCase();
            that._enable();
            that._cascade();
            that._aria();
            that._oldIndex = that.selectedIndex = -1;
            if (options.autoBind) {
                that._filterSource();
            } else {
                text = options.text;
                if (!text && that._isSelect) {
                    text = element.children(":selected").text();
                }
                if (text) {
                    that.input.val(text);
                }
            }
            if (!text) {
                that._placeholder();
            }
            kendo.notify(that);
        },
        options: {
            name: "ComboBox",
            enabled: true,
            index: -1,
            text: null,
            value: null,
            autoBind: true,
            delay: 200,
            dataTextField: "",
            dataValueField: "",
            minLength: 0,
            height: 200,
            highlightFirst: true,
            template: "",
            filter: "none",
            placeholder: "",
            suggest: false,
            ignoreCase: true,
            animation: {}
        },
        events: [ "open", "close", CHANGE, "select", "dataBinding", "dataBound", "cascade" ],
        setOptions: function(options) {
            Select.fn.setOptions.call(this, options);
            this._template();
            this._accessors();
            this._aria();
        },
        current: function(li) {
            var that = this, current = that._current;
            if (li === undefined) {
                return current;
            }
            if (current) {
                current.removeClass(STATE_SELECTED);
            }
            Select.fn.current.call(that, li);
        },
        destroy: function() {
            var that = this;
            that.input.off(ns);
            that.element.off(ns);
            that._inputWrapper.off(ns);
            Select.fn.destroy.call(that);
        },
        _editable: function(options) {
            var that = this, disable = options.disable, readonly = options.readonly, wrapper = that._inputWrapper.off(ns), input = that.element.add(that.input.off(ns)), arrow = that._arrow.parent().off(CLICK + " " + MOUSEDOWN);
            if (!readonly && !disable) {
                wrapper.addClass(DEFAULT).removeClass(STATEDISABLED).on(HOVEREVENTS, that._toggleHover);
                input.removeAttr(DISABLED).removeAttr(READONLY).attr(ARIA_DISABLED, false).attr(ARIA_READONLY, false);
                arrow.on(CLICK, function() {
                    that.toggle();
                }).on(MOUSEDOWN, function(e) {
                    e.preventDefault();
                });
                that.input.on("keydown" + ns, proxy(that._keydown, that)).on("focus" + ns, function() {
                    wrapper.addClass(FOCUSED);
                    that._placeholder(false);
                }).on("blur" + ns, function() {
                    wrapper.removeClass(FOCUSED);
                    clearTimeout(that._typing);
                    if (that.options.text !== that.input.val()) {
                        that.text(that.text());
                    }
                    that._placeholder();
                    that._blur();
                    that.element.blur();
                });
            } else {
                wrapper.addClass(disable ? STATEDISABLED : DEFAULT).removeClass(disable ? DEFAULT : STATEDISABLED);
                input.attr(DISABLED, disable).attr(READONLY, readonly).attr(ARIA_DISABLED, disable).attr(ARIA_READONLY, readonly);
            }
        },
        open: function() {
            var that = this, serverFiltering = that.dataSource.options.serverFiltering;
            if (that.popup.visible()) {
                return;
            }
            if (!that.ul[0].firstChild || that._state === STATE_ACCEPT && !serverFiltering) {
                that._open = true;
                that._state = STATE_REBIND;
                that._filterSource();
            } else {
                that.popup.open();
                that._scroll(that._current);
            }
        },
        refresh: function() {
            var that = this, ul = that.ul[0], options = that.options, state = that._state, data = that._data(), length = data.length, value, open, custom;
            that.trigger("dataBinding");
            ul.innerHTML = kendo.render(that.template, data);
            that._height(length);
            if (that.popup.visible()) {
                that.popup._position();
            }
            if (that._isSelect) {
                if (state === STATE_REBIND) {
                    that._state = "";
                    value = that.value();
                }
                custom = that._option;
                that._option = undefined;
                that._options(data);
                if (custom && custom[0].selected) {
                    that._custom(custom.val());
                }
            }
            if (length) {
                if (options.highlightFirst) {
                    that.current($(ul.firstChild));
                }
                if (options.suggest && that.input.val() && that._request !== undefined) {
                    that.suggest($(ul.firstChild));
                }
            }
            if (state !== STATE_FILTER && !that._fetch) {
                that._selectItem();
            }
            if (that._open) {
                that._open = false;
                open = !!length;
                if (that._typing && that.input[0] !== activeElement()) {
                    open = false;
                }
                that.toggle(open);
                that._typing = undefined;
            }
            if (that._touchScroller) {
                that._touchScroller.reset();
            }
            that._makeUnselectable();
            that._hideBusy();
            that._bound = true;
            that.trigger("dataBound");
        },
        search: function(word) {
            word = typeof word === "string" ? word : this.text();
            var that = this, length = word.length, options = that.options, ignoreCase = options.ignoreCase, filter = options.filter, field = options.dataTextField;
            clearTimeout(that._typing);
            if (length >= options.minLength) {
                that._state = STATE_FILTER;
                if (filter === "none") {
                    that._filter(word);
                } else {
                    that._open = true;
                    that._filterSource({
                        value: ignoreCase ? word.toLowerCase() : word,
                        field: field,
                        operator: filter,
                        ignoreCase: ignoreCase
                    });
                }
            }
        },
        suggest: function(word) {
            var that = this, element = that.input[0], value = that.text(), caret = List.caret(element), key = that._last, idx;
            if (key == keys.BACKSPACE || key == keys.DELETE) {
                that._last = undefined;
                return;
            }
            word = word || "";
            if (typeof word !== "string") {
                idx = List.inArray(word[0], that.ul[0]);
                if (idx > -1) {
                    word = that._text(that.dataSource.view()[idx]);
                } else {
                    word = "";
                }
            }
            if (caret <= 0) {
                caret = value.toLowerCase().indexOf(word.toLowerCase()) + 1;
            }
            if (word) {
                idx = word.toLowerCase().indexOf(value.toLowerCase());
                if (idx > -1) {
                    value += word.substring(idx + value.length);
                }
            } else {
                value = value.substring(0, caret);
            }
            if (value.length !== caret || !word) {
                element.value = value;
                List.selectText(element, caret, value.length);
            }
        },
        text: function(text) {
            text = text === null ? "" : text;
            var that = this, textAccessor = that._text, input = that.input[0], ignoreCase = that.options.ignoreCase, loweredText = text, dataItem;
            if (text !== undefined) {
                dataItem = that.dataItem();
                if (dataItem && textAccessor(dataItem) === text) {
                    that._triggerCascade();
                    return;
                }
                if (ignoreCase) {
                    loweredText = loweredText.toLowerCase();
                }
                that._select(function(data) {
                    data = textAccessor(data);
                    if (ignoreCase) {
                        data = (data + "").toLowerCase();
                    }
                    return data === loweredText;
                });
                if (that.selectedIndex < 0) {
                    that._custom(text);
                    input.value = text;
                }
                that._triggerCascade();
            } else {
                return input.value;
            }
        },
        toggle: function(toggle) {
            var that = this;
            that._toggle(toggle);
        },
        value: function(value) {
            var that = this, idx;
            if (value !== undefined) {
                if (value !== null) {
                    value = value.toString();
                }
                that._selectedValue = value;
                if (!that._open && value && that._fetchItems(value)) {
                    return;
                }
                idx = that._index(value);
                if (idx > -1) {
                    that.select(idx);
                } else {
                    that.current(NULL);
                    that._custom(value);
                    that.text(value);
                    that._placeholder();
                }
                that._prev = that._old = that._accessor();
                that._oldIndex = that.selectedIndex;
            } else {
                return that._accessor();
            }
        },
        _accept: function(li) {
            var that = this;
            if (li) {
                that._focus(li);
            } else {
                that.text(that.text());
                that._change();
            }
        },
        _custom: function(value) {
            var that = this, element = that.element, custom = that._option;
            if (that._state === STATE_FILTER) {
                that._state = STATE_ACCEPT;
            }
            if (that._isSelect) {
                if (!custom) {
                    custom = that._option = $("<option/>");
                    element.append(custom);
                }
                custom.text(value);
                custom[0].selected = true;
            } else {
                element.val(value);
            }
            that._selectedValue = value;
        },
        _filter: function(word) {
            var that = this, options = that.options, dataSource = that.dataSource, ignoreCase = options.ignoreCase, predicate = function(dataItem) {
                var text = that._text(dataItem);
                if (text !== undefined) {
                    text = text + "";
                    if (text !== "" && word === "") {
                        return false;
                    }
                    if (ignoreCase) {
                        text = text.toLowerCase();
                    }
                    return text.indexOf(word) === 0;
                }
            };
            if (ignoreCase) {
                word = word.toLowerCase();
            }
            if (!that.ul[0].firstChild) {
                dataSource.one(CHANGE, function() {
                    if (dataSource.data()[0]) {
                        that.search(word);
                    }
                }).fetch();
                return;
            }
            if (that._highlight(predicate) !== -1) {
                if (options.suggest && that._current) {
                    that.suggest(that._current);
                }
                that.open();
            }
            that._hideBusy();
        },
        _highlight: function(li) {
            var that = this, idx;
            if (li === undefined || li === null) {
                return -1;
            }
            li = that._get(li);
            idx = List.inArray(li[0], that.ul[0]);
            if (idx == -1) {
                if (that.options.highlightFirst && !that.text()) {
                    li = $(that.ul[0].firstChild);
                } else {
                    li = NULL;
                }
            }
            that.current(li);
            return idx;
        },
        _input: function() {
            var that = this, element = that.element.removeClass("k-input")[0], accessKey = element.accessKey, wrapper = that.wrapper, SELECTOR = "input.k-input", name = element.name || "", input;
            if (name) {
                name = 'name="' + name + '_input" ';
            }
            input = wrapper.find(SELECTOR);
            if (!input[0]) {
                wrapper.append('<span tabindex="-1" unselectable="on" class="k-dropdown-wrap k-state-default"><input ' + name + 'class="k-input" type="text" autocomplete="off"/><span tabindex="-1" unselectable="on" class="k-select"><span unselectable="on" class="k-icon k-i-arrow-s">select</span></span></span>').append(that.element);
                input = wrapper.find(SELECTOR);
            }
            input[0].style.cssText = element.style.cssText;
            if (element.maxLength > -1) {
                input[0].maxLength = element.maxLength;
            }
            input.addClass(element.className).val(element.value).css({
                width: "100%",
                height: element.style.height
            }).attr({
                role: "combobox",
                "aria-expanded": false
            }).show();
            if (placeholderSupported) {
                input.attr("placeholder", that.options.placeholder);
            }
            if (accessKey) {
                element.accessKey = "";
                input[0].accessKey = accessKey;
            }
            that._focused = that.input = input;
            that._inputWrapper = $(wrapper[0].firstChild);
            that._arrow = wrapper.find(".k-icon").attr({
                role: "button",
                tabIndex: -1
            });
            if (element.id) {
                that._arrow.attr("aria-controls", that.ul[0].id);
            }
        },
        _keydown: function(e) {
            var that = this, key = e.keyCode;
            that._last = key;
            clearTimeout(that._typing);
            if (key != keys.TAB && !that._move(e)) {
                that._search();
            }
        },
        _placeholder: function(show) {
            if (placeholderSupported) {
                return;
            }
            var that = this, input = that.input, placeholder = that.options.placeholder, value;
            if (placeholder) {
                value = that.value();
                if (show === undefined) {
                    show = !value;
                }
                input.toggleClass("k-readonly", show);
                if (!show) {
                    if (!value) {
                        placeholder = "";
                    } else {
                        return;
                    }
                }
                input.val(placeholder);
            }
        },
        _search: function() {
            var that = this;
            that._typing = setTimeout(function() {
                var value = that.text();
                if (that._prev !== value) {
                    that._prev = value;
                    that.search(value);
                }
            }, that.options.delay);
        },
        _select: function(li) {
            var that = this, text, value, data = that._data(), idx = that._highlight(li);
            that.selectedIndex = idx;
            if (idx !== -1) {
                if (that._state === STATE_FILTER) {
                    that._state = STATE_ACCEPT;
                }
                that._current.addClass(STATE_SELECTED);
                data = data[idx];
                text = that._text(data);
                value = that._value(data);
                that._prev = that.input[0].value = text;
                that._accessor(value !== undefined ? value : text, idx);
                that._selectedValue = that._accessor();
                that._placeholder();
                if (that._optionID) {
                    that._current.attr("aria-selected", true);
                }
            }
        },
        _wrapper: function() {
            var that = this, element = that.element, wrapper = element.parent();
            if (!wrapper.is("span.k-widget")) {
                wrapper = element.hide().wrap("<span />").parent();
                wrapper[0].style.cssText = element[0].style.cssText;
            }
            that.wrapper = wrapper.addClass("k-widget k-combobox k-header").addClass(element[0].className).css("display", "");
        },
        _clearSelection: function(parent, isFiltered) {
            var that = this, hasValue = parent._selectedValue || parent.value(), custom = hasValue && parent.selectedIndex === -1;
            if (isFiltered || !hasValue || custom) {
                that.value("");
            }
        }
    });
    ui.plugin(ComboBox);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, List = ui.List, keys = kendo.keys, activeElement = kendo._activeElement, ObservableArray = kendo.data.ObservableArray, proxy = $.proxy, ID = "id", LI = "li", ACCEPT = "accept", FILTER = "filter", OPEN = "open", CLOSE = "close", CHANGE = "change", PROGRESS = "progress", SELECT = "select", NEXT = "nextSibling", PREV = "previousSibling", HIDE = ' style="display:none"', ARIA_DISABLED = "aria-disabled", ARIA_READONLY = "aria-readonly", FOCUSEDCLASS = "k-state-focused", HIDDENCLASS = "k-loading-hidden", HOVERCLASS = "k-state-hover", STATEDISABLED = "k-state-disabled", DISABLED = "disabled", READONLY = "readonly", ns = ".kendoMultiSelect", CLICK = "click" + ns, KEYDOWN = "keydown" + ns, MOUSEENTER = "mouseenter" + ns, MOUSELEAVE = "mouseleave" + ns, HOVEREVENTS = MOUSEENTER + " " + MOUSELEAVE, quotRegExp = /"/g, styles = [ "font-family", "font-size", "font-stretch", "font-style", "font-weight", "letter-spacing", "text-transform", "line-height" ];
    var MultiSelect = List.extend({
        init: function(element, options) {
            var that = this, id;
            that.ns = ns;
            List.fn.init.call(that, element, options);
            that._wrapper();
            that._tagList();
            that._input();
            that._textContainer();
            that._loader();
            that._tabindex(that.input);
            options = that.options;
            element = that.element.attr("multiple", "multiple").hide();
            if (!options.placeholder) {
                options.placeholder = element.data("placeholder");
            }
            id = element.attr(ID);
            if (id) {
                that._tagID = id + "_tag_active";
                id = id + "_taglist";
                that.tagList.attr(ID, id);
            }
            that._aria(id);
            that._dataSource();
            that._ignoreCase();
            that._accessors();
            that._popup();
            that._values = [];
            that._dataItems = [];
            that._reset();
            that._enable();
            that._placeholder();
            if (options.autoBind) {
                that.dataSource.fetch();
            }
            kendo.notify(that);
        },
        options: {
            name: "MultiSelect",
            enabled: true,
            autoBind: true,
            highlightFirst: true,
            dataTextField: "",
            dataValueField: "",
            filter: "startswith",
            ignoreCase: true,
            minLength: 0,
            delay: 100,
            value: null,
            maxSelectedItems: null,
            itemTemplate: "",
            tagTemplate: "",
            placeholder: "",
            height: 200,
            animation: {}
        },
        events: [ OPEN, CLOSE, CHANGE, SELECT, "dataBinding", "dataBound" ],
        setDataSource: function(dataSource) {
            this.options.dataSource = dataSource;
            this._dataSource();
            if (this.options.autoBind) {
                this.dataSource.fetch();
            }
        },
        setOptions: function(options) {
            List.fn.setOptions.call(this, options);
            this._template();
            this._accessors();
            this._aria(this.tagList.attr(ID));
        },
        current: function(candidate) {
            this.currentTag(null);
            return List.fn.current.call(this, candidate);
        },
        currentTag: function(candidate) {
            var that = this;
            if (candidate !== undefined) {
                if (that._currentTag) {
                    that._currentTag.removeClass(FOCUSEDCLASS).removeAttr(ID);
                    that.input.removeAttr("aria-activedescendant");
                }
                if (candidate) {
                    candidate.addClass(FOCUSEDCLASS).attr(ID, that._tagID);
                    that.input.attr("aria-activedescendant", that._tagID);
                }
                that._currentTag = candidate;
            } else {
                return that._currentTag;
            }
        },
        dataItems: function() {
            return this._dataItems;
        },
        destroy: function() {
            var that = this, ns = that.ns;
            that.wrapper.off(ns);
            that.tagList.off(ns);
            that.input.off(ns);
            List.fn.destroy.call(that);
        },
        _editable: function(options) {
            var that = this, disable = options.disable, readonly = options.readonly, wrapper = that.wrapper.off(ns), tagList = that.tagList.off(ns), input = that.element.add(that.input.off(ns));
            if (!readonly && !disable) {
                wrapper.removeClass(STATEDISABLED).on(HOVEREVENTS, that._toggleHover).on("mousedown" + ns, function(e) {
                    e.preventDefault();
                    if (e.target.className.indexOf("k-delete") == -1) {
                        that.open();
                    }
                    if (that.input[0] !== activeElement()) {
                        that.input.focus();
                    }
                });
                that.input.on(KEYDOWN, proxy(that._keydown, that)).on("paste" + ns, proxy(that._search, that)).on("focus" + ns, function() {
                    that._placeholder(false);
                }).on("blur" + ns, function() {
                    clearTimeout(that._typing);
                    that._placeholder();
                    that.close();
                    if (that._state === FILTER) {
                        that._state = ACCEPT;
                    }
                });
                input.removeAttr(DISABLED).removeAttr(READONLY).attr(ARIA_DISABLED, false).attr(ARIA_READONLY, false);
                tagList.on(MOUSEENTER, LI, function() {
                    $(this).addClass(HOVERCLASS);
                }).on(MOUSELEAVE, LI, function() {
                    $(this).removeClass(HOVERCLASS);
                }).on(CLICK, ".k-delete", function(e) {
                    that._unselect($(e.target).closest(LI));
                    that._change();
                    that.close();
                });
            } else {
                if (disable) {
                    wrapper.addClass(STATEDISABLED);
                } else {
                    wrapper.removeClass(STATEDISABLED);
                }
                input.attr(DISABLED, disable).attr(READONLY, readonly).attr(ARIA_DISABLED, disable).attr(ARIA_READONLY, readonly);
            }
        },
        close: function() {
            this.popup.close();
            this.current(null);
        },
        open: function() {
            var that = this;
            if (!that.ul[0].firstChild || that._state === ACCEPT) {
                that._state = "";
                that._open = true;
                that._filterSource();
            } else if (that._visibleItems && that._allowSelection()) {
                that.popup.open();
                that.current(that.options.highlightFirst ? $(first(that.ul[0])) : null);
            }
        },
        toggle: function(toggle) {
            this[toggle ? OPEN : CLOSE]();
        },
        refresh: function() {
            var that = this, li = null, length;
            that.trigger("dataBinding");
            length = that._render(that.dataSource.view());
            that._height(length);
            if (that._setInitialValues) {
                that._setInitialValues = false;
                that.value(that._initialValues);
            }
            if (that._open) {
                that._open = false;
                that.toggle(length);
            }
            if (that.popup.visible()) {
                that.popup._position();
                if (that.options.highlightFirst) {
                    li = $(first(that.ul[0]));
                }
            }
            that.current(li);
            if (that._touchScroller) {
                that._touchScroller.reset();
            }
            that._makeUnselectable();
            that._hideBusy();
            that.trigger("dataBound");
        },
        search: function(word) {
            var that = this, options = that.options, ignoreCase = options.ignoreCase, filter = options.filter, field = options.dataTextField;
            clearTimeout(that._typing);
            word = typeof word === "string" ? word : that.input.val();
            if (word.length >= options.minLength) {
                that._state = FILTER;
                that._open = true;
                that._filterSource({
                    value: ignoreCase ? word.toLowerCase() : word,
                    field: field,
                    operator: filter,
                    ignoreCase: ignoreCase
                });
            }
        },
        value: function(value) {
            var that = this, tags = $(that.tagList[0].children), length = tags.length, dataItemIndex, idx = 0;
            if (value === undefined) {
                return that._values;
            }
            if (that._fetchItems(value)) {
                return;
            }
            for (;idx < length; idx++) {
                that._unselect(tags.eq(idx));
            }
            if (value !== null) {
                value = $.isArray(value) || value instanceof ObservableArray ? value : [ value ];
                for (idx = 0, length = value.length; idx < length; idx++) {
                    dataItemIndex = that._index(value[idx]);
                    if (dataItemIndex > -1) {
                        that._select(dataItemIndex);
                    }
                }
                that._old = that._values.slice();
            }
        },
        _dataSource: function() {
            var that = this, element = that.element, options = that.options, dataSource = options.dataSource || {};
            dataSource = $.isArray(dataSource) ? {
                data: dataSource
            } : dataSource;
            dataSource.select = element;
            dataSource.fields = [ {
                field: options.dataTextField
            }, {
                field: options.dataValueField
            } ];
            if (that.dataSource && that._refreshHandler) {
                that._unbindDataSource();
            } else {
                that._refreshHandler = proxy(that.refresh, that);
                that._progressHandler = proxy(that._showBusy, that);
            }
            that.dataSource = kendo.data.DataSource.create(dataSource).bind(CHANGE, that._refreshHandler).bind(PROGRESS, that._progressHandler);
        },
        _fetchItems: function(value) {
            var that = this;
            if (!that._fetch && !that.ul[0].firstChild) {
                that.dataSource.one(CHANGE, function() {
                    that.value(value);
                    that._fetch = false;
                });
                that._fetch = true;
                that.dataSource.fetch();
                return true;
            }
        },
        _reset: function() {
            var that = this, element = that.element, form = element.closest("form");
            if (form[0]) {
                that._resetHandler = function() {
                    setTimeout(function() {
                        that.value(that._initialValues);
                    });
                };
                that._form = form.on("reset", that._resetHandler);
            }
        },
        _initValue: function() {
            var that = this, value = that.options.value || that.element.val();
            if (value === null) {
                value = [];
            }
            that._old = that._initialValues = value;
            that._setInitialValues = !!value[0];
        },
        _change: function() {
            var that = this, value = that.value();
            if (!compare(value, that._old)) {
                that._old = value.slice();
                that.trigger(CHANGE);
                // trigger the DOM change event so any subscriber gets notified
                that.element.trigger(CHANGE);
            }
        },
        _click: function(e) {
            var that = this, li = $(e.currentTarget);
            if (!e.isDefaultPrevented()) {
                if (that.trigger(SELECT, {
                    item: li
                })) {
                    that.close();
                    return;
                }
                that._select(li);
                that._change();
                that.close();
            }
        },
        _item: function(item, direction) {
            item = item[direction]();
            if (item[0] && !item.is(":visible")) {
                item = this._item(item, direction);
            }
            return item;
        },
        _keydown: function(e) {
            var that = this, key = e.keyCode, tag = that._currentTag, current = that._current, hasValue = that.input.val(), isRtl = kendo.support.isRtl(that.wrapper), visible = that.popup.visible();
            if (key === keys.DOWN) {
                e.preventDefault();
                if (!visible) {
                    that.open();
                    return;
                }
                if (current) {
                    current = sibling(current[0], NEXT);
                } else {
                    current = that.ul[0].firstChild;
                }
                if (current) {
                    that.current($(current));
                }
            } else if (key === keys.UP) {
                if (visible) {
                    if (current) {
                        current = sibling(current[0], PREV);
                    } else {
                        current = that.ul[0].lastChild;
                    }
                    that.current($(current));
                    if (!that._current[0]) {
                        that.close();
                    }
                }
                e.preventDefault();
            } else if (key === keys.LEFT && !isRtl || key === keys.RIGHT && isRtl) {
                if (!hasValue) {
                    tag = tag ? tag.prev() : $(that.tagList[0].lastChild);
                    if (tag[0]) {
                        that.currentTag(tag);
                    }
                }
            } else if (key === keys.RIGHT && !isRtl || key === keys.LEFT && isRtl) {
                if (!hasValue && tag) {
                    tag = tag.next();
                    that.currentTag(tag[0] ? tag : null);
                }
            } else if (key === keys.ENTER) {
                if (visible) {
                    if (current) {
                        that._select(current);
                    }
                    that._change();
                    that.close();
                    e.preventDefault();
                }
            } else if (key === keys.ESC) {
                if (visible) {
                    e.preventDefault();
                } else {
                    that.currentTag(null);
                }
                that.close();
            } else if (key === keys.HOME) {
                if (visible) {
                    that.current($(first(that.ul[0])));
                } else if (!hasValue) {
                    tag = that.tagList[0].firstChild;
                    if (tag) {
                        that.currentTag($(tag));
                    }
                }
            } else if (key === keys.END) {
                if (visible) {
                    that.current($(last(that.ul[0])));
                } else if (!hasValue) {
                    tag = that.tagList[0].lastChild;
                    if (tag) {
                        that.currentTag($(tag));
                    }
                }
            } else if ((key === keys.DELETE || key === keys.BACKSPACE) && !hasValue) {
                if (key === keys.BACKSPACE && !tag) {
                    tag = $(that.tagList[0].lastChild);
                }
                if (tag && tag[0]) {
                    that._unselect(tag);
                    that._change();
                    that.close();
                }
            } else {
                clearTimeout(that._typing);
                that._search();
            }
        },
        _hideBusy: function() {
            var that = this;
            clearTimeout(that._busy);
            that.input.attr("aria-busy", false);
            that._loading.addClass(HIDDENCLASS);
            that._busy = null;
        },
        _showBusy: function() {
            var that = this;
            if (that._busy) {
                return;
            }
            that._busy = setTimeout(function() {
                that.input.attr("aria-busy", true);
                that._loading.removeClass(HIDDENCLASS);
            }, 100);
        },
        _placeholder: function(show) {
            var that = this, input = that.input;
            if (show === undefined) {
                show = false;
                if (input[0] !== activeElement()) {
                    show = !that._dataItems[0];
                }
                that.wrapper.removeClass(FOCUSEDCLASS);
            } else {
                that.wrapper.addClass(FOCUSEDCLASS);
            }
            input.toggleClass("k-readonly", show).val(show ? that.options.placeholder : "");
            that._scale();
        },
        _scale: function() {
            var that = this, wrapperWidth = that.wrapper.width(), span = that._span.text(that.input.val()), textWidth;
            if (!wrapperWidth) {
                span.appendTo(document.documentElement);
                wrapperWidth = textWidth = span.width() + 25;
                span.appendTo(this.wrapper);
            } else {
                textWidth = span.width() + 25;
            }
            that.input.width(textWidth > wrapperWidth ? wrapperWidth : textWidth);
        },
        _option: function(dataItem, selected) {
            var option = "<option", dataText = this._text(dataItem), dataValue = this._value(dataItem);
            if (dataValue !== undefined) {
                dataValue += "";
                if (dataValue.indexOf('"') !== -1) {
                    dataValue = dataValue.replace(quotRegExp, "&quot;");
                }
                option += ' value="' + dataValue + '"';
            }
            if (selected) {
                option += ' selected="selected"';
            }
            option += ">";
            if (dataText !== undefined) {
                option += kendo.htmlEncode(dataText);
            }
            return option += "</option>";
        },
        _render: function(data) {
            var that = this, length = data.length, template = that.itemTemplate, values = that._dataItems.slice(0), visibleItems = 0, idx = 0, options = "", html = "", dataItem, selected;
            for (;idx < length; idx++) {
                dataItem = data[idx];
                selected = that._selected(values, dataItem);
                html += template(dataItem, idx, selected);
                options += that._option(dataItem, selected);
                if (!selected) {
                    visibleItems += 1;
                }
            }
            length = values.length;
            if (length) {
                for (idx = 0; idx < length; idx++) {
                    options += that._option(values[idx], true);
                }
            }
            that.ul[0].innerHTML = html;
            that.element.html(options);
            that._visibleItems = visibleItems;
            return visibleItems;
        },
        _selected: function(values, dataItem) {
            var that = this, textAccessor = that._text, valueAccessor = that._value, value = valueAccessor(dataItem), length = values.length, selected = false, dataValue, idx = 0;
            if (value === undefined) {
                value = textAccessor(dataItem);
            }
            for (;idx < length; idx++) {
                dataItem = values[idx];
                dataValue = valueAccessor(dataItem);
                if (dataValue === undefined) {
                    dataValue = textAccessor(dataItem);
                }
                if (dataValue !== undefined && dataValue === value) {
                    selected = true;
                    break;
                }
            }
            if (selected) {
                values.splice(idx, 1);
            }
            return selected;
        },
        _search: function() {
            var that = this;
            that._typing = setTimeout(function() {
                var value = that.input.val();
                if (that._prev !== value) {
                    that._scale();
                    that._prev = value;
                    that.search(value);
                }
            }, that.options.delay);
        },
        _allowSelection: function() {
            var max = this.options.maxSelectedItems;
            return max === null || max > this._values.length;
        },
        _select: function(li) {
            var that = this, values = that._values, dataItem, idx;
            if (!that._allowSelection()) {
                return;
            }
            if (!isNaN(li)) {
                idx = li;
                that.ul[0].children[idx].style.display = "none";
            } else {
                idx = li.hide().data("idx");
            }
            that.element[0].children[idx].selected = true;
            dataItem = that.dataSource.view()[idx];
            that.tagList.append(that.tagTemplate(dataItem));
            that._dataItems.push(dataItem);
            values.push(that._dataValue(dataItem));
            that._visibleItems -= 1;
            that.currentTag(null);
            that._placeholder();
            that._height(that._visibleItems);
            if (that._state === FILTER) {
                that._state = ACCEPT;
            }
        },
        _unselect: function(tag) {
            var that = this, index = tag.index(), dataItem, value, options, option, length;
            tag.remove();
            that.currentTag(null);
            that._values.splice(index, 1);
            dataItem = that._dataItems.splice(index, 1)[0];
            value = that._dataValue(dataItem);
            index = that._index(value);
            if (index !== -1) {
                $(that.ul[0].children[index]).show();
                that.element[0].children[index].selected = false;
                that._visibleItems += 1;
                that._height(that._visibleItems);
            } else {
                index = that.dataSource.view().length;
                options = that.element[0].children;
                length = options.length;
                for (;index < length; index++) {
                    option = options[index];
                    if (option.value == value) {
                        option.selected = false;
                        break;
                    }
                }
            }
            that._placeholder();
        },
        _template: function() {
            var that = this, options = that.options, itemTemplate = options.itemTemplate, tagTemplate = options.tagTemplate, hasDataSource = options.dataSource, textTemplate;
            if (that.element[0].length && !hasDataSource) {
                options.dataTextField = options.dataTextField || "text";
                options.dataValueField = options.dataValueField || "value";
            }
            textTemplate = kendo.template("#:" + kendo.expr(options.dataTextField, "data") + "#", {
                useWithBlock: false
            });
            itemTemplate = itemTemplate ? kendo.template(itemTemplate) : textTemplate;
            tagTemplate = tagTemplate ? kendo.template(tagTemplate) : textTemplate;
            that.itemTemplate = function(data, idx, hide) {
                return '<li tabindex="-1" role="option" data-idx="' + idx + '" unselectable="on" class="k-item"' + (hide ? HIDE : "") + ">" + itemTemplate(data) + "</li>";
            };
            that.tagTemplate = function(data) {
                return '<li class="k-button"><span>' + tagTemplate(data) + '</span><span class="k-icon k-delete">delete</span></li>';
            };
        },
        _input: function() {
            var that = this, accessKey = that.element[0].accessKey, input = that._innerWrapper.children("input.k-input");
            if (!input[0]) {
                input = $('<input class="k-input" style="width: 25px" />').appendTo(that._innerWrapper);
            }
            that.element.removeAttr("accesskey");
            that._focused = that.input = input.attr({
                accesskey: accessKey,
                role: "listbox",
                "aria-expanded": false
            });
        },
        _tagList: function() {
            var that = this, tagList = that._innerWrapper.children("ul");
            if (!tagList[0]) {
                tagList = $('<ul role="listbox" unselectable="on" class="k-reset"/>').appendTo(that._innerWrapper);
            }
            that.tagList = tagList;
        },
        _loader: function() {
            this._loading = $('<span class="k-icon k-loading ' + HIDDENCLASS + '"></span>').insertAfter(this.input);
        },
        _textContainer: function() {
            var computedStyles = kendo.getComputedStyles(this.input[0], styles);
            computedStyles.position = "absolute";
            computedStyles.visibility = "hidden";
            this._span = $("<span/>").css(computedStyles).appendTo(this.wrapper);
        },
        _wrapper: function() {
            var that = this, element = that.element, wrapper = element.parent("span.k-multiselect");
            if (!wrapper[0]) {
                wrapper = element.wrap('<div class="k-widget k-multiselect k-header" />').parent();
                wrapper[0].style.cssText = element[0].style.cssText;
                $('<div class="k-multiselect-wrap k-floatwrap" />').insertBefore(element);
            }
            that.wrapper = wrapper.addClass(element[0].className).css("display", "");
            that._innerWrapper = $(wrapper[0].firstChild);
        }
    });
    function compare(a, b) {
        var length;
        if (a === null && b !== null || a !== null && b === null) {
            return false;
        }
        length = a.length;
        if (length !== b.length) {
            return false;
        }
        while (length--) {
            if (a[length] !== b[length]) {
                return false;
            }
        }
        return true;
    }
    function first(ul) {
        var item = ul.firstChild;
        if (item && item.style.display === "none") {
            item = sibling(item, NEXT);
        }
        return item;
    }
    function last(ul) {
        var item = ul.lastChild;
        if (item && item.style.display === "none") {
            item = sibling(item, PREV);
        }
        return item;
    }
    function sibling(item, direction) {
        item = item[direction];
        if (item && item.style.display === "none") {
            item = sibling(item, direction);
        }
        return item;
    }
    ui.plugin(MultiSelect);
})(window.kendo.jQuery);

(function($, parseInt, undefined) {
    // WARNING: removing the following jshint declaration and turning
    // == into === to make JSHint happy will break functionality.
    /*jshint eqnull:true  */
    var kendo = window.kendo, Class = kendo.Class, ui = kendo.ui, Widget = ui.Widget, KEYS = kendo.keys, BACKGROUNDCOLOR = "background-color", UNSELECTABLE = "unselectable", ITEMSELECTEDCLASS = "k-state-selected", SIMPLEPALETTE = "000000,7f7f7f,880015,ed1c24,ff7f27,fff200,22b14c,00a2e8,3f48cc,a349a4,ffffff,c3c3c3,b97a57,ffaec9,ffc90e,efe4b0,b5e61d,99d9ea,7092be,c8bfe7", WEBPALETTE = "FFFFFF,FFCCFF,FF99FF,FF66FF,FF33FF,FF00FF,CCFFFF,CCCCFF,CC99FF,CC66FF,CC33FF,CC00FF,99FFFF,99CCFF,9999FF,9966FF,9933FF,9900FF,FFFFCC,FFCCCC,FF99CC,FF66CC,FF33CC,FF00CC,CCFFCC,CCCCCC,CC99CC,CC66CC,CC33CC,CC00CC,99FFCC,99CCCC,9999CC,9966CC,9933CC,9900CC,FFFF99,FFCC99,FF9999,FF6699,FF3399,FF0099,CCFF99,CCCC99,CC9999,CC6699,CC3399,CC0099,99FF99,99CC99,999999,996699,993399,990099,FFFF66,FFCC66,FF9966,FF6666,FF3366,FF0066,CCFF66,CCCC66,CC9966,CC6666,CC3366,CC0066,99FF66,99CC66,999966,996666,993366,990066,FFFF33,FFCC33,FF9933,FF6633,FF3333,FF0033,CCFF33,CCCC33,CC9933,CC6633,CC3333,CC0033,99FF33,99CC33,999933,996633,993333,990033,FFFF00,FFCC00,FF9900,FF6600,FF3300,FF0000,CCFF00,CCCC00,CC9900,CC6600,CC3300,CC0000,99FF00,99CC00,999900,996600,993300,990000,66FFFF,66CCFF,6699FF,6666FF,6633FF,6600FF,33FFFF,33CCFF,3399FF,3366FF,3333FF,3300FF,00FFFF,00CCFF,0099FF,0066FF,0033FF,0000FF,66FFCC,66CCCC,6699CC,6666CC,6633CC,6600CC,33FFCC,33CCCC,3399CC,3366CC,3333CC,3300CC,00FFCC,00CCCC,0099CC,0066CC,0033CC,0000CC,66FF99,66CC99,669999,666699,663399,660099,33FF99,33CC99,339999,336699,333399,330099,00FF99,00CC99,009999,006699,003399,000099,66FF66,66CC66,669966,666666,663366,660066,33FF66,33CC66,339966,336666,333366,330066,00FF66,00CC66,009966,006666,003366,000066,66FF33,66CC33,669933,666633,663333,660033,33FF33,33CC33,339933,336633,333333,330033,00FF33,00CC33,009933,006633,003333,000033,66FF00,66CC00,669900,666600,663300,660000,33FF00,33CC00,339900,336600,333300,330000,00FF00,00CC00,009900,006600,003300,000000", APPLY_CANCEL = {
        apply: "Apply",
        cancel: "Cancel"
    }, NS = ".kendoColorTools", CLICK_NS = "click" + NS, KEYDOWN_NS = "keydown" + NS, browser = kendo.support.browser, isIE8 = browser.msie && browser.version < 9;
    var ColorSelector = Widget.extend({
        init: function(element, options) {
            var that = this, ariaId;
            Widget.fn.init.call(that, element, options);
            element = that.element;
            options = that.options;
            that._value = options.value = parse(options.value);
            ariaId = that._ariaId = options.ariaId;
            if (ariaId) {
                element.attr("aria-labelledby", ariaId);
            }
            if (options._standalone) {
                that._triggerSelect = that._triggerChange;
            }
        },
        options: {
            value: null,
            _standalone: true
        },
        events: [ "change", "select", "cancel" ],
        color: function(value) {
            if (value !== undefined) {
                this._updateUI(this._value = parse(value));
            }
            return this._value;
        },
        value: function(color) {
            color = this.color(color);
            if (color) {
                if (this.options.opacity) {
                    color = color.toCssRgba();
                } else {
                    color = color.toCss();
                }
            }
            return color || null;
        },
        enable: function(enable) {
            if (arguments.length === 0) {
                enable = true;
            }
            if (enable) {
                $(".k-disabled-overlay", this.wrapper).remove();
            } else {
                this.wrapper.append("<div class='k-disabled-overlay'></div>");
            }
            this._onEnable(enable);
        },
        _select: function(color, nohooks) {
            var prev = this._value;
            color = this.color(color);
            if (!nohooks) {
                if (!color.equals(prev)) {
                    this.trigger("change", {
                        value: this.value()
                    });
                } else if (!this._standalone) {
                    this.trigger("cancel");
                }
            }
        },
        _triggerSelect: function(color) {
            triggerEvent(this, "select", color);
        },
        _triggerChange: function(color) {
            triggerEvent(this, "change", color);
        },
        destroy: function() {
            if (this.element) {
                this.element.off(NS);
            }
            if (this.wrapper) {
                this.wrapper.off(NS).find("*").off(NS);
            }
            this.wrapper = null;
            Widget.fn.destroy.call(this);
        },
        _updateUI: $.noop,
        _selectOnHide: function() {
            return null;
        },
        _cancel: function() {
            this.trigger("cancel");
        }
    });
    function triggerEvent(self, type, color) {
        color = parse(color);
        if (color && !color.equals(self.color())) {
            if (type == "change") {
                // UI is already updated.  setting _value directly
                // rather than calling self.color(color) to avoid an
                // endless loop.
                self._value = color;
            }
            if (color.a != 1) {
                color = color.toCssRgba();
            } else {
                color = color.toCss();
            }
            self.trigger(type, {
                value: color
            });
        }
    }
    var ColorPalette = ColorSelector.extend({
        init: function(element, options) {
            var that = this;
            ColorSelector.fn.init.call(that, element, options);
            element = that.wrapper = that.element;
            options = that.options;
            var colors = options.palette;
            if (colors == "websafe") {
                colors = WEBPALETTE;
                options.columns = 18;
            } else if (colors == "basic") {
                colors = SIMPLEPALETTE;
            }
            if (typeof colors == "string") {
                colors = colors.split(",");
            }
            if ($.isArray(colors)) {
                colors = $.map(colors, function(x) {
                    return parse(x);
                });
            }
            element.addClass("k-widget k-colorpalette").append($(that._template({
                colors: colors,
                tileSize: options.tileSize,
                value: that._value,
                id: options.ariaId
            }))).on(CLICK_NS, ".k-item", function(ev) {
                that._select($(ev.currentTarget).find("div").css(BACKGROUNDCOLOR));
            }).find("*").attr(UNSELECTABLE, "on").end().attr("tabIndex", 0).on(KEYDOWN_NS, bind(that._keydown, that));
            var tileSize = options.tileSize, width, height;
            if (tileSize) {
                if (/number|string/.test(typeof tileSize)) {
                    width = height = parseFloat(tileSize);
                } else if (typeof tileSize == "object") {
                    width = parseFloat(tileSize.width);
                    height = parseFloat(tileSize.height);
                } else {
                    throw new Error("Unsupported value for the 'tileSize' argument");
                }
                element.find(".k-item").css({
                    width: width,
                    height: height
                });
            }
            if (options.columns) {
                element.css("width", options.columns * (width || 14));
            }
        },
        focus: function() {
            this.wrapper.focus();
        },
        options: {
            name: "ColorPalette",
            columns: 10,
            tileSize: null,
            palette: "basic"
        },
        _onEnable: function(enable) {
            if (enable) {
                this.wrapper.removeAttr("tabIndex");
            } else {
                this.wrapper.attr("tabIndex", 0);
            }
        },
        _keydown: function(e) {
            var selected, that = this, wrapper = that.wrapper, items = wrapper.find(".k-item"), current = items.filter("." + ITEMSELECTEDCLASS).get(0), keyCode = e.keyCode;
            if (keyCode == KEYS.LEFT) {
                selected = relative(items, current, -1);
            } else if (keyCode == KEYS.RIGHT) {
                selected = relative(items, current, 1);
            } else if (keyCode == KEYS.DOWN) {
                selected = relative(items, current, that.options.columns);
            } else if (keyCode == KEYS.UP) {
                selected = relative(items, current, -that.options.columns);
            } else if (keyCode == KEYS.ENTER) {
                preventDefault(e);
                if (current) {
                    this._select($("div", current).css(BACKGROUNDCOLOR));
                }
            } else if (keyCode == KEYS.ESC) {
                this._cancel();
            }
            if (selected) {
                preventDefault(e);
                selected = $(selected);
                $(current).removeClass(ITEMSELECTEDCLASS).removeAttr("aria-selected");
                selected.addClass(ITEMSELECTEDCLASS).attr("aria-selected", true);
                try {
                    var color = parse(selected.find("div").css(BACKGROUNDCOLOR));
                    that._triggerSelect(color);
                } catch (ex) {}
            }
        },
        _updateUI: function(color) {
            var that = this, el = null;
            that.wrapper.find(".k-item." + ITEMSELECTEDCLASS).removeClass(ITEMSELECTEDCLASS).removeAttr("aria-selected");
            that.wrapper.find(".k-item div").each(function() {
                var c = parse($(this).css(BACKGROUNDCOLOR));
                if (c && c.equals(color)) {
                    el = this.parentNode;
                }
            });
            $(el).addClass(ITEMSELECTEDCLASS).attr("aria-selected", true);
        },
        _template: kendo.template('<ul class="k-palette k-reset">' + "# for (var i = 0; i < colors.length; i++) { #" + '<li #=(id && i === 0) ? "id=\\""+id+"\\" aria-selected=\\"true\\"" : "" # class="k-item #= colors[i].equals(value) ? "' + ITEMSELECTEDCLASS + '" : "" #" aria-label="#= colors[i].toCss() #">' + '<div style="background-color:#= colors[i].toCss() #"></div>' + "</li>" + "# } #" + "</ul>")
    });
    var FlatColorPicker = ColorSelector.extend({
        init: function(element, options) {
            var that = this;
            ColorSelector.fn.init.call(that, element, options);
            options = that.options;
            element = that.element;
            that.wrapper = element.addClass("k-widget k-flatcolorpicker").append(that._template(options)).find("*").attr(UNSELECTABLE, "on").end();
            if (isIE8) {
                // IE filters require absolute URLs
                that._applyIEFilter();
            }
            that._hueElements = $(".k-hsv-rectangle, .k-transparency-slider .k-slider-track", element);
            that._selectedColor = $(".k-selected-color-display", element);
            that._colorAsText = $("input.k-color-value", element);
            that._sliders();
            that._hsvArea();
            that._updateUI(that._value || new _RGB(1, 0, 0, 1));
            element.find("input.k-color-value").on(KEYDOWN_NS, function(ev) {
                if (ev.keyCode == KEYS.ENTER) {
                    try {
                        var color = parse(this.value);
                        var val = that.color();
                        $(this).removeClass("k-state-error");
                        that._select(color, !color.equals(val));
                    } catch (ex) {
                        $(this).addClass("k-state-error");
                    }
                }
            }).end().on(CLICK_NS, ".k-controls button.apply", function() {
                // calling select for the currently displayed
                // color will trigger the "change" event.
                that._select(that._getHSV());
            }).on(CLICK_NS, ".k-controls button.cancel", function() {
                // but on cancel, we simply select the previous
                // value (again, triggers "change" event).
                that._updateUI(that.color());
                that._cancel();
            });
        },
        destroy: function() {
            this._hueSlider.destroy();
            if (this._opacitySlider) {
                this._opacitySlider.destroy();
            }
            this._hueSlider = this._opacitySlider = this._hsvRect = this._hsvHandle = this._hueElements = this._selectedColor = this._colorAsText = null;
            ColorSelector.fn.destroy.call(this);
        },
        options: {
            name: "FlatColorPicker",
            opacity: false,
            buttons: false,
            input: true,
            preview: true,
            messages: APPLY_CANCEL
        },
        _applyIEFilter: function() {
            var track = this.element.find(".k-hue-slider .k-slider-track")[0], url = track.currentStyle.backgroundImage;
            url = url.replace(/^url\([\'\"]?|[\'\"]?\)$/g, "");
            track.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + url + "', sizingMethod='scale')";
        },
        _sliders: function() {
            var that = this, element = that.element;
            function hueChange(e) {
                that._updateUI(that._getHSV(e.value, null, null, null));
            }
            that._hueSlider = element.find(".k-hue-slider").kendoSlider({
                min: 0,
                max: 359,
                tickPlacement: "none",
                showButtons: false,
                slide: hueChange,
                change: hueChange
            }).data("kendoSlider");
            function opacityChange(e) {
                that._updateUI(that._getHSV(null, null, null, e.value / 100));
            }
            that._opacitySlider = element.find(".k-transparency-slider").kendoSlider({
                min: 0,
                max: 100,
                tickPlacement: "none",
                showButtons: false,
                slide: opacityChange,
                change: opacityChange
            }).data("kendoSlider");
        },
        _hsvArea: function() {
            var that = this, element = that.element, hsvRect = element.find(".k-hsv-rectangle"), hsvHandle = hsvRect.find(".k-draghandle").attr("tabIndex", 0).on(KEYDOWN_NS, bind(that._keydown, that));
            function update(x, y) {
                var offset = this.offset, dx = x - offset.left, dy = y - offset.top, rw = this.width, rh = this.height;
                dx = dx < 0 ? 0 : dx > rw ? rw : dx;
                dy = dy < 0 ? 0 : dy > rh ? rh : dy;
                that._svChange(dx / rw, 1 - dy / rh);
            }
            that._hsvEvents = new kendo.UserEvents(hsvRect, {
                global: true,
                press: function(e) {
                    this.offset = kendo.getOffset(hsvRect);
                    this.width = hsvRect.width();
                    this.height = hsvRect.height();
                    hsvHandle.focus();
                    update.call(this, e.x.location, e.y.location);
                },
                start: function() {
                    hsvRect.addClass("k-dragging");
                    hsvHandle.focus();
                },
                move: function(e) {
                    e.preventDefault();
                    update.call(this, e.x.location, e.y.location);
                },
                end: function() {
                    hsvRect.removeClass("k-dragging");
                }
            });
            that._hsvRect = hsvRect;
            that._hsvHandle = hsvHandle;
        },
        _onEnable: function(enable) {
            this._hueSlider.enable(enable);
            if (this._opacitySlider) {
                this._opacitySlider.enable(enable);
            }
            this.wrapper.find("input").attr("disabled", !enable);
            var handle = this._hsvRect.find(".k-draghandle");
            if (enable) {
                handle.attr("tabIndex", 0);
            } else {
                handle.removeAttr("tabIndex");
            }
        },
        _keydown: function(ev) {
            var that = this;
            function move(prop, d) {
                var c = that._getHSV();
                c[prop] += d * (ev.shiftKey ? .01 : .05);
                if (c[prop] < 0) {
                    c[prop] = 0;
                }
                if (c[prop] > 1) {
                    c[prop] = 1;
                }
                that._updateUI(c);
                preventDefault(ev);
            }
            function hue(d) {
                var c = that._getHSV();
                c.h += d * (ev.shiftKey ? 1 : 5);
                if (c.h < 0) {
                    c.h = 0;
                }
                if (c.h > 359) {
                    c.h = 359;
                }
                that._updateUI(c);
                preventDefault(ev);
            }
            switch (ev.keyCode) {
              case KEYS.LEFT:
                if (ev.ctrlKey) {
                    hue(-1);
                } else {
                    move("s", -1);
                }
                break;

              case KEYS.RIGHT:
                if (ev.ctrlKey) {
                    hue(1);
                } else {
                    move("s", 1);
                }
                break;

              case KEYS.UP:
                move(ev.ctrlKey && that._opacitySlider ? "a" : "v", 1);
                break;

              case KEYS.DOWN:
                move(ev.ctrlKey && that._opacitySlider ? "a" : "v", -1);
                break;

              case KEYS.ENTER:
                that._select(that._getHSV());
                break;

              case KEYS.F2:
                that.wrapper.find("input.k-color-value").focus().select();
                break;

              case KEYS.ESC:
                that._cancel();
                break;
            }
        },
        focus: function() {
            this._hsvHandle.focus();
        },
        _getHSV: function(h, s, v, a) {
            var rect = this._hsvRect, width = rect.width(), height = rect.height(), handlePosition = this._hsvHandle.position();
            if (h == null) {
                h = this._hueSlider.value();
            }
            if (s == null) {
                s = handlePosition.left / width;
            }
            if (v == null) {
                v = 1 - handlePosition.top / height;
            }
            if (a == null) {
                a = this._opacitySlider ? this._opacitySlider.value() / 100 : 1;
            }
            return new _HSV(h, s, v, a);
        },
        _svChange: function(s, v) {
            var color = this._getHSV(null, s, v, null);
            this._updateUI(color);
        },
        _updateUI: function(color) {
            var that = this, rect = that._hsvRect;
            if (!color) {
                return;
            }
            that._selectedColor.css(BACKGROUNDCOLOR, color.toDisplay());
            that._colorAsText.val(that._opacitySlider ? color.toCssRgba() : color.toCss());
            that._triggerSelect(color);
            color = color.toHSV();
            that._hsvHandle.css({
                // saturation is 0 on the left side, full (1) on the right
                left: color.s * rect.width() + "px",
                // value is 0 on the bottom, full on the top.
                top: (1 - color.v) * rect.height() + "px"
            });
            that._hueElements.css(BACKGROUNDCOLOR, new _HSV(color.h, 1, 1, 1).toCss());
            that._hueSlider.value(color.h);
            if (that._opacitySlider) {
                that._opacitySlider.value(100 * color.a);
            }
        },
        _selectOnHide: function() {
            return this.options.buttons ? null : this._getHSV();
        },
        _template: kendo.template("# if (preview) { #" + '<div class="k-selected-color"><div class="k-selected-color-display"><input spellcheck="false" class="k-color-value" #= !data.input ? \'style="visibility: hidden;"\' : "" #></div></div>' + "# } #" + '<div class="k-hsv-rectangle"><div class="k-hsv-gradient"></div><div class="k-draghandle"></div></div>' + '<input class="k-hue-slider" />' + "# if (opacity) { #" + '<input class="k-transparency-slider" />' + "# } #" + "# if (buttons) { #" + '<div class="k-controls"><button class="k-button apply">#: messages.apply #</button> <button class="k-button cancel">#: messages.cancel #</button></div>' + "# } #")
    });
    /* -----[ color utils ]----- */
    function hex(n, width, pad) {
        if (!pad) {
            pad = "0";
        }
        n = n.toString(16);
        while (width > n.length) {
            n = "0" + n;
        }
        return n;
    }
    function fixed(n) {
        return parseFloat((+n).toFixed(3));
    }
    var Color = Class.extend({
        toHSV: function() {
            return this;
        },
        toRGB: function() {
            return this;
        },
        toHex: function() {
            return this.toBytes().toHex();
        },
        toBytes: function() {
            return this;
        },
        toCss: function() {
            return "#" + this.toHex();
        },
        toCssRgba: function() {
            var rgb = this.toBytes();
            return "rgba(" + rgb.r + ", " + rgb.g + ", " + rgb.b + ", " + fixed(this.a) + ")";
        },
        toDisplay: function() {
            if (isIE8) {
                return this.toCss();
            }
            return this.toCssRgba();
        },
        equals: function(c) {
            return c === this || c !== null && this.toHex() == parse(c).toHex();
        },
        diff: function(c2) {
            if (c2 == null) {
                return NaN;
            }
            var c1 = this.toBytes();
            c2 = c2.toBytes();
            return Math.sqrt(Math.pow((c1.r - c2.r) * .3, 2) + Math.pow((c1.g - c2.g) * .59, 2) + Math.pow((c1.b - c2.b) * .11, 2));
        },
        clone: function() {
            var c = this.toBytes();
            if (c === this) {
                c = new _Bytes(c.r, c.g, c.b, c.a);
            }
            return c;
        }
    });
    var _RGB = Color.extend({
        init: function(r, g, b, a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        },
        toHSV: function() {
            var min, max, delta, h, s, v;
            var r = this.r, g = this.g, b = this.b;
            min = Math.min(r, g, b);
            max = Math.max(r, g, b);
            v = max;
            delta = max - min;
            if (delta === 0) {
                return new _HSV(0, 0, v, this.a);
            }
            if (max !== 0) {
                s = delta / max;
                if (r == max) {
                    h = (g - b) / delta;
                } else if (g == max) {
                    h = 2 + (b - r) / delta;
                } else {
                    h = 4 + (r - g) / delta;
                }
                h *= 60;
                if (h < 0) {
                    h += 360;
                }
            } else {
                s = 0;
                h = -1;
            }
            return new _HSV(h, s, v, this.a);
        },
        toBytes: function() {
            return new _Bytes(this.r * 255, this.g * 255, this.b * 255, this.a);
        }
    });
    var _Bytes = _RGB.extend({
        init: function(r, g, b, a) {
            this.r = Math.round(r);
            this.g = Math.round(g);
            this.b = Math.round(b);
            this.a = a;
        },
        toRGB: function() {
            return new _RGB(this.r / 255, this.g / 255, this.b / 255, this.a);
        },
        toHSV: function() {
            return this.toRGB().toHSV();
        },
        toHex: function() {
            return hex(this.r, 2) + hex(this.g, 2) + hex(this.b, 2);
        },
        toBytes: function() {
            return this;
        }
    });
    var _HSV = Color.extend({
        init: function(h, s, v, a) {
            this.h = h;
            this.s = s;
            this.v = v;
            this.a = a;
        },
        toRGB: function() {
            var h = this.h, s = this.s, v = this.v;
            var i, r, g, b, f, p, q, t;
            if (s === 0) {
                r = g = b = v;
            } else {
                h /= 60;
                i = Math.floor(h);
                f = h - i;
                p = v * (1 - s);
                q = v * (1 - s * f);
                t = v * (1 - s * (1 - f));
                switch (i) {
                  case 0:
                    r = v;
                    g = t;
                    b = p;
                    break;

                  case 1:
                    r = q;
                    g = v;
                    b = p;
                    break;

                  case 2:
                    r = p;
                    g = v;
                    b = t;
                    break;

                  case 3:
                    r = p;
                    g = q;
                    b = v;
                    break;

                  case 4:
                    r = t;
                    g = p;
                    b = v;
                    break;

                  default:
                    r = v;
                    g = p;
                    b = q;
                    break;
                }
            }
            return new _RGB(r, g, b, this.a);
        },
        toBytes: function() {
            return this.toRGB().toBytes();
        }
    });
    function parse(color, nothrow) {
        if (color == null || color == "transparent") {
            return null;
        }
        if (color instanceof Color) {
            return color;
        }
        var m = /^#?([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i.exec(color);
        if (m) {
            return new _Bytes(parseInt(m[1], 16), parseInt(m[2], 16), parseInt(m[3], 16), 1);
        }
        m = /^#?([0-9a-f])([0-9a-f])([0-9a-f])$/i.exec(color);
        if (m) {
            return new _Bytes(parseInt(m[1] + m[1], 16), parseInt(m[2] + m[2], 16), parseInt(m[3] + m[3], 16), 1);
        }
        m = /^rgb\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*\)/.exec(color);
        if (m) {
            return new _Bytes(parseInt(m[1], 10), parseInt(m[2], 10), parseInt(m[3], 10), 1);
        }
        m = /^rgba\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9.]+)\s*\)/.exec(color);
        if (m) {
            return new _Bytes(parseInt(m[1], 10), parseInt(m[2], 10), parseInt(m[3], 10), parseFloat(m[4]));
        }
        m = /^rgb\(\s*([0-9]*\.?[0-9]+)%\s*,\s*([0-9]*\.?[0-9]+)%\s*,\s*([0-9]*\.?[0-9]+)%\s*\)/.exec(color);
        if (m) {
            return new _RGB(parseFloat(m[1]) / 100, parseFloat(m[2]) / 100, parseFloat(m[3]) / 100, 1);
        }
        m = /^rgba\(\s*([0-9]*\.?[0-9]+)%\s*,\s*([0-9]*\.?[0-9]+)%\s*,\s*([0-9]*\.?[0-9]+)%\s*,\s*([0-9.]+)\s*\)/.exec(color);
        if (m) {
            return new _RGB(parseFloat(m[1]) / 100, parseFloat(m[2]) / 100, parseFloat(m[3]) / 100, parseFloat(m[4]));
        }
        if (!nothrow) {
            throw new Error("Cannot parse color: " + color);
        }
        return undefined;
    }
    function relative(array, element, delta) {
        array = Array.prototype.slice.call(array);
        var n = array.length;
        var pos = array.indexOf(element);
        if (pos < 0) {
            return delta < 0 ? array[n - 1] : array[0];
        }
        pos += delta;
        if (pos < 0) {
            pos += n;
        } else {
            pos %= n;
        }
        return array[pos];
    }
    /* -----[ The ColorPicker widget ]----- */
    var ColorPicker = Widget.extend({
        init: function(element, options) {
            var that = this;
            Widget.fn.init.call(that, element, options);
            options = that.options;
            element = that.element;
            var value;
            if (element.val()) {
                value = parse(element.val(), true);
            } else {
                value = parse(options.value, true);
            }
            that._value = options.value = value;
            var content = that.wrapper = $(that._template(options));
            element.hide().after(content);
            if (element.is("input")) {
                element.appendTo(content);
            }
            that.enable(!element.attr("disabled"));
            var accesskey = element.attr("accesskey");
            if (accesskey) {
                element.attr("accesskey", null);
                content.attr("accesskey", accesskey);
            }
            that.bind("activate", function(ev) {
                if (!ev.isDefaultPrevented()) {
                    that.toggle();
                }
            });
            that._updateUI(value);
        },
        destroy: function() {
            this.wrapper.add("*").off(NS);
            if (this._popup) {
                this._selector.destroy();
                this._popup.destroy();
            }
            this._selector = this._popup = this.wrapper = null;
            Widget.fn.destroy.call(this);
        },
        enable: function(enable) {
            var that = this, wrapper = that.wrapper, innerWrapper = wrapper.children(".k-picker-wrap"), icon = innerWrapper.find(".k-select");
            if (arguments.length === 0) {
                enable = true;
            }
            that.element.attr("disabled", !enable);
            wrapper.attr("disabled", !enable);
            icon.off(NS).on("mousedown" + NS, preventDefault);
            if (enable) {
                wrapper.removeClass("k-state-disabled").attr("tabIndex", 0).on("mouseenter" + NS, function() {
                    innerWrapper.addClass("k-state-hover");
                }).on("mouseleave" + NS, function() {
                    innerWrapper.removeClass("k-state-hover");
                }).on("focus" + NS, function() {
                    innerWrapper.addClass("k-state-focused");
                }).on("blur" + NS, function() {
                    innerWrapper.removeClass("k-state-focused");
                }).on(KEYDOWN_NS, bind(that._keydown, that)).on(CLICK_NS, ".k-icon", bind(that.toggle, that)).on(CLICK_NS, that.options.toolIcon ? ".k-tool-icon" : ".k-selected-color", function() {
                    that.trigger("activate");
                });
            } else {
                wrapper.addClass("k-state-disabled").removeAttr("tabIndex").add("*", wrapper).off(NS);
            }
        },
        _template: kendo.template('<span class="k-widget k-colorpicker k-header">' + '<span class="k-picker-wrap k-state-default">' + "# if (toolIcon) { #" + '<span class="k-tool-icon #= toolIcon #">' + '<span class="k-selected-color"></span>' + "</span>" + "# } else { #" + '<span class="k-selected-color"></span>' + "# } #" + '<span class="k-select" unselectable="on">' + '<span class="k-icon k-i-arrow-s" unselectable="on"></span>' + "</span>" + "</span>" + "</span>"),
        options: {
            name: "ColorPicker",
            palette: null,
            columns: 10,
            toolIcon: null,
            value: null,
            messages: APPLY_CANCEL,
            opacity: false,
            buttons: true,
            preview: true
        },
        events: [ "activate", "change", "select", "open", "close" ],
        open: function() {
            this._getPopup().open();
        },
        close: function() {
            this._getPopup().close();
        },
        toggle: function() {
            this._getPopup().toggle();
        },
        color: ColorSelector.fn.color,
        value: ColorSelector.fn.value,
        _select: ColorSelector.fn._select,
        _triggerSelect: ColorSelector.fn._triggerSelect,
        _isInputTypeColor: function() {
            var el = this.element[0];
            return /^input$/i.test(el.tagName) && /^color$/i.test(el.type);
        },
        _updateUI: function(value) {
            if (value) {
                if (this._isInputTypeColor() || value.a == 1) {
                    // seems that input type="color" doesn't support opacity
                    // in colors; the only accepted format is hex #RRGGBB
                    this.element.val(value.toCss());
                } else {
                    this.element.val(value.toCssRgba());
                }
            }
            this._triggerSelect(value);
            this.wrapper.find(".k-selected-color").css(BACKGROUNDCOLOR, value ? value.toDisplay() : "transparent");
        },
        _keydown: function(ev) {
            var key = ev.keyCode;
            if (this._getPopup().visible()) {
                if (key == KEYS.ESC) {
                    this._selector._cancel();
                } else {
                    this._selector._keydown(ev);
                }
                preventDefault(ev);
            } else if (key == KEYS.ENTER || key == KEYS.DOWN) {
                this.open();
                preventDefault(ev);
            }
        },
        _getPopup: function() {
            var that = this, popup = that._popup;
            if (!popup) {
                var options = this.options;
                var selectorType;
                if (options.palette) {
                    selectorType = ColorPalette;
                } else {
                    selectorType = FlatColorPicker;
                }
                options._standalone = false;
                var selector = this._selector = new selectorType($("<div />").appendTo(document.body), options);
                that._popup = popup = selector.wrapper.kendoPopup({
                    anchor: that.wrapper
                }).data("kendoPopup");
                selector.bind({
                    select: function(ev) {
                        that._updateUI(parse(ev.value));
                    },
                    change: function() {
                        that._select(selector.color());
                        that.close();
                    },
                    cancel: function() {
                        that.close();
                    }
                });
                popup.bind({
                    close: function(ev) {
                        if (that.trigger("close")) {
                            ev.preventDefault();
                            return;
                        }
                        var color = selector._selectOnHide();
                        if (!color) {
                            that.wrapper.focus();
                            that._updateUI(that.color());
                        } else {
                            that._select(color);
                        }
                    },
                    open: function(ev) {
                        if (that.trigger("open")) {
                            ev.preventDefault();
                        }
                    },
                    activate: function() {
                        selector._select(that.color(), true);
                        selector.focus();
                    }
                });
            }
            return popup;
        }
    });
    function preventDefault(ev) {
        ev.preventDefault();
    }
    function bind(callback, obj) {
        return function() {
            return callback.apply(obj, arguments);
        };
    }
    ui.plugin(ColorPalette);
    ui.plugin(FlatColorPicker);
    ui.plugin(ColorPicker);
    kendo.parseColor = parse;
    kendo.Color = {
        fromBytes: function(r, g, b, a) {
            return new _Bytes(r, g, b, a != null ? a : 1);
        },
        fromRGB: function(r, g, b, a) {
            return new _RGB(r, g, b, a != null ? a : 1);
        },
        fromHSV: function(h, s, v, a) {
            return new _HSV(h, s, v, a != null ? a : 1);
        }
    };
})(jQuery, parseInt);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, proxy = $.proxy, extend = $.extend, grep = $.grep, map = $.map, inArray = $.inArray, ACTIVE = "k-state-selected", ASC = "asc", DESC = "desc", CHANGE = "change", INIT = "init", POPUP = "kendoPopup", FILTERMENU = "kendoFilterMenu", MENU = "kendoMenu", NS = ".kendoColumnMenu", nameSpecialCharRegExp = /(\[|\]|\$|\.|\:|\+)/g, Widget = ui.Widget;
    function trim(text) {
        return $.trim(text).replace(/&nbsp;/gi, "");
    }
    var ColumnMenu = Widget.extend({
        init: function(element, options) {
            var that = this, link;
            Widget.fn.init.call(that, element, options);
            element = that.element;
            options = that.options;
            that.owner = options.owner;
            that.dataSource = options.dataSource;
            that.field = element.attr(kendo.attr("field"));
            link = element.find(".k-header-column-menu");
            if (!link[0]) {
                link = element.prepend('<a class="k-header-column-menu" href="#"><span class="k-icon k-i-arrowhead-s"/></a>').find(".k-header-column-menu");
            }
            that.link = link.attr("tabindex", -1).on("click" + NS, proxy(that._click, that));
            that.wrapper = $('<div class="k-column-menu"/>');
        },
        _init: function() {
            var that = this, options = that.options;
            that.wrapper.html(kendo.template(template)({
                ns: kendo.ns,
                messages: options.messages,
                sortable: options.sortable,
                filterable: options.filterable,
                columns: that._ownerColumns(),
                showColumns: options.columns
            }));
            that.popup = that.wrapper[POPUP]({
                anchor: that.link,
                open: proxy(that._open, that),
                activate: proxy(that._activate, that),
                close: that.options.closeCallback
            }).data(POPUP);
            that._menu();
            that._sort();
            that._columns();
            that._filter();
            that.trigger(INIT, {
                field: that.field,
                container: that.wrapper
            });
        },
        events: [ INIT ],
        options: {
            name: "ColumnMenu",
            messages: {
                sortAscending: "Sort Ascending",
                sortDescending: "Sort Descending",
                filter: "Filter",
                columns: "Columns"
            },
            columns: true,
            sortable: true,
            filterable: true
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            if (that.filterMenu) {
                that.filterMenu.destroy();
            }
            that.dataSource.unbind("refresh", that._refreshHandler);
            if (that.options.columns) {
                that.owner.unbind("columnShow", that._updateColumnsMenuHandler);
                that.owner.unbind("columnHide", that._updateColumnsMenuHandler);
            }
            if (that.menu) {
                that.menu.element.off(NS);
                that.menu.destroy();
            }
            that.wrapper.off(NS);
            if (that.popup) {
                that.popup.destroy();
            }
            that.link.off(NS);
        },
        close: function() {
            this.menu.close();
            this.popup.close();
            this.popup.element.off("keydown" + NS);
        },
        _click: function(e) {
            e.preventDefault();
            e.stopPropagation();
            if (!this.popup) {
                this._init();
            }
            this.popup.toggle();
        },
        _open: function() {
            var that = this;
            $(".k-column-menu").not(that.wrapper).each(function() {
                $(this).data(POPUP).close();
            });
            that.popup.element.on("keydown" + NS, function(e) {
                if (e.keyCode == kendo.keys.ESC) {
                    that.close();
                }
            });
        },
        _activate: function() {
            this.menu.element.focus();
        },
        _ownerColumns: function() {
            var columns = this.owner.columns, menuColumns = grep(columns, function(col) {
                var result = true, title = trim(col.title || "");
                if (col.menu === false || !col.field && !title.length) {
                    result = false;
                }
                return result;
            });
            return map(menuColumns, function(col) {
                return {
                    field: col.field || col.title,
                    title: col.title || col.field,
                    hidden: col.hidden,
                    index: inArray(col, columns)
                };
            });
        },
        _menu: function() {
            this.menu = this.wrapper.children()[MENU]({
                orientation: "vertical",
                closeOnClick: false
            }).data(MENU);
        },
        _sort: function() {
            var that = this;
            if (that.options.sortable) {
                that.refresh();
                that._refreshHandler = proxy(that.refresh, that);
                that.dataSource.bind(CHANGE, that._refreshHandler);
                that.menu.bind("select", function(e) {
                    var item = $(e.item), dir;
                    if (item.hasClass("k-sort-asc")) {
                        dir = ASC;
                    } else if (item.hasClass("k-sort-desc")) {
                        dir = DESC;
                    }
                    if (!dir) {
                        return;
                    }
                    item.parent().find(".k-sort-" + (dir == ASC ? DESC : ASC)).removeClass(ACTIVE);
                    that._sortDataSource(item, dir);
                    that.close();
                });
            }
        },
        _sortDataSource: function(item, dir) {
            var that = this, sortable = that.options.sortable, dataSource = that.dataSource, idx, length, sort = dataSource.sort() || [];
            if (item.hasClass(ACTIVE) && sortable && sortable.allowUnsort !== false) {
                item.removeClass(ACTIVE);
                dir = undefined;
            } else {
                item.addClass(ACTIVE);
            }
            if (sortable === true || sortable.mode === "single") {
                sort = [ {
                    field: that.field,
                    dir: dir
                } ];
            } else {
                for (idx = 0, length = sort.length; idx < length; idx++) {
                    if (sort[idx].field === that.field) {
                        sort.splice(idx, 1);
                        break;
                    }
                }
                sort.push({
                    field: that.field,
                    dir: dir
                });
            }
            dataSource.sort(sort);
        },
        _columns: function() {
            var that = this;
            if (that.options.columns) {
                that._updateColumnsMenu();
                that._updateColumnsMenuHandler = proxy(that._updateColumnsMenu, that);
                that.owner.bind([ "columnHide", "columnShow" ], that._updateColumnsMenuHandler);
                that.menu.bind("select", function(e) {
                    var item = $(e.item), input, index, column, columns = that.owner.columns, field;
                    if (!item.parent().closest("li.k-columns-item")[0]) {
                        return;
                    }
                    input = item.find(":checkbox");
                    if (input.attr("disabled")) {
                        return;
                    }
                    field = input.attr(kendo.attr("field"));
                    column = grep(columns, function(column) {
                        return column.field == field || column.title == field;
                    })[0];
                    index = inArray(column, columns);
                    if (column.hidden === true) {
                        that.owner.showColumn(index);
                    } else {
                        that.owner.hideColumn(index);
                    }
                });
            }
        },
        _updateColumnsMenu: function() {
            var attr = "[" + kendo.attr("field") + "=", columns = this._ownerColumns(), allselector = map(columns, function(col) {
                return attr + '"' + col.field.replace(nameSpecialCharRegExp, "\\$1") + '"]';
            }).join(","), visible = grep(columns, function(field) {
                return !field.hidden;
            }), selector = map(visible, function(col) {
                return attr + '"' + col.field.replace(nameSpecialCharRegExp, "\\$1") + '"]';
            }).join(",");
            this.wrapper.find(allselector).prop("checked", false);
            this.wrapper.find(selector).prop("checked", true).prop("disabled", visible.length == 1);
        },
        _filter: function() {
            var that = this, options = that.options;
            if (options.filterable !== false) {
                that.filterMenu = that.wrapper.find(".k-filterable")[FILTERMENU](extend(true, {}, {
                    appendToElement: true,
                    dataSource: options.dataSource,
                    values: options.values,
                    field: that.field
                }, options.filterable)).data(FILTERMENU);
            }
        },
        refresh: function() {
            var that = this, sort = that.options.dataSource.sort() || [], descriptor, field = that.field, idx, length;
            that.wrapper.find(".k-sort-asc, .k-sort-desc").removeClass(ACTIVE);
            for (idx = 0, length = sort.length; idx < length; idx++) {
                descriptor = sort[idx];
                if (field == descriptor.field) {
                    that.wrapper.find(".k-sort-" + descriptor.dir).addClass(ACTIVE);
                }
            }
        }
    });
    var template = "<ul>" + "#if(sortable){#" + '<li class="k-item k-sort-asc"><span class="k-link"><span class="k-sprite k-i-sort-asc"></span>${messages.sortAscending}</span></li>' + '<li class="k-item k-sort-desc"><span class="k-link"><span class="k-sprite k-i-sort-desc"></span>${messages.sortDescending}</span></li>' + "#if(showColumns || filterable){#" + '<li class="k-separator"></li>' + "#}#" + "#}#" + "#if(showColumns){#" + '<li class="k-item k-columns-item"><span class="k-link"><span class="k-sprite k-i-columns"></span>${messages.columns}</span><ul>' + "#for (var col in columns) {#" + '<li><input type="checkbox" data-#=ns#field="#=columns[col].field#" data-#=ns#index="#=columns[col].index#"/>#=columns[col].title#</li>' + "#}#" + "</ul></li>" + "#if(filterable){#" + '<li class="k-separator"></li>' + "#}#" + "#}#" + "#if(filterable){#" + '<li class="k-item k-filter-item"><span class="k-link"><span class="k-sprite k-filter"></span>${messages.filter}</span><ul>' + '<li><div class="k-filterable"></div></li>' + "</ul></li>" + "#}#" + "</ul>";
    ui.plugin(ColumnMenu);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, ui = kendo.ui, DataSource = kendo.data.DataSource, Groupable = ui.Groupable, tbodySupportsInnerHtml = kendo.support.tbodyInnerHtml, activeElement = kendo._activeElement, Widget = ui.Widget, keys = kendo.keys, isPlainObject = $.isPlainObject, extend = $.extend, map = $.map, grep = $.grep, isArray = $.isArray, inArray = $.inArray, proxy = $.proxy, isFunction = $.isFunction, isEmptyObject = $.isEmptyObject, math = Math, PROGRESS = "progress", ERROR = "error", DATA_CELL = ":not(.k-group-cell):not(.k-hierarchy-cell):visible", SELECTION_CELL_SELECTOR = "tbody>tr:not(.k-grouping-row):not(.k-detail-row):not(.k-group-footer) > td:not(.k-group-cell):not(.k-hierarchy-cell)", NAVROW = "tr:not(.k-footer-template):visible", NAVCELL = ":not(.k-group-cell):not(.k-hierarchy-cell):visible", FIRSTNAVITEM = NAVROW + ":first>" + NAVCELL + ":first", HEADERCELLS = "th.k-header:not(.k-group-cell,.k-hierarchy-cell)", GROUPINGDRAGGABLES = HEADERCELLS + ":visible[" + kendo.attr("field") + "]", GROUPINGFILTER = HEADERCELLS + "[" + kendo.attr("field") + "]", NS = ".kendoGrid", EDIT = "edit", SAVE = "save", REMOVE = "remove", DETAILINIT = "detailInit", FILTERMENUINIT = "filterMenuInit", COLUMNMENUINIT = "columnMenuInit", CHANGE = "change", COLUMNHIDE = "columnHide", COLUMNSHOW = "columnShow", SAVECHANGES = "saveChanges", DATABOUND = "dataBound", DETAILEXPAND = "detailExpand", DETAILCOLLAPSE = "detailCollapse", FOCUSED = "k-state-focused", SELECTED = "k-state-selected", COLUMNRESIZE = "columnResize", COLUMNREORDER = "columnReorder", CLICK = "click", HEIGHT = "height", TABINDEX = "tabIndex", FUNCTION = "function", STRING = "string", DELETECONFIRM = "Are you sure you want to delete this record?", formatRegExp = /(\}|\#)/gi, indicatorWidth = 3, templateHashRegExp = /#/gi, whitespaceRegExp = "[\\x20\\t\\r\\n\\f]", nonDataCellsRegExp = new RegExp("(^|" + whitespaceRegExp + ")" + "(k-group-cell|k-hierarchy-cell)" + "(" + whitespaceRegExp + "|$)"), COMMANDBUTTONTMPL = '<a class="k-button k-button-icontext #=className#" #=attr# href="\\#"><span class="#=iconClass# #=imageClass#"></span>#=text#</a>', isRtl = false;
    var VirtualScrollable = Widget.extend({
        init: function(element, options) {
            var that = this;
            Widget.fn.init.call(that, element, options);
            that._refreshHandler = proxy(that.refresh, that);
            that.setDataSource(options.dataSource);
            that.wrap();
        },
        setDataSource: function(dataSource) {
            var that = this;
            if (that.dataSource) {
                that.dataSource.unbind(CHANGE, that._refreshHandler);
            }
            that.dataSource = dataSource;
            that.dataSource.bind(CHANGE, that._refreshHandler);
        },
        options: {
            name: "VirtualScrollable",
            itemHeight: $.noop
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.dataSource.unbind(CHANGE, that._refreshHandler);
            that.wrapper.add(that.verticalScrollbar).off(NS);
            if (that.drag) {
                that.drag.destroy();
            }
        },
        wrap: function() {
            var that = this, // workaround for IE issue where scroll is not raised if container is same width as the scrollbar
            scrollbar = kendo.support.scrollbar() + 1, element = that.element, wrapper;
            element.css({
                width: "auto",
                overflow: "hidden"
            }).css(isRtl ? "padding-left" : "padding-right", scrollbar);
            that.content = element.children().first();
            wrapper = that.wrapper = that.content.wrap('<div class="k-virtual-scrollable-wrap"/>').parent().bind("DOMMouseScroll" + NS + " mousewheel" + NS, proxy(that._wheelScroll, that));
            if (kendo.support.kineticScrollNeeded) {
                that.drag = new kendo.UserEvents(that.wrapper, {
                    global: true,
                    move: function(e) {
                        that.verticalScrollbar.scrollTop(that.verticalScrollbar.scrollTop() - e.y.delta);
                        wrapper.scrollLeft(wrapper.scrollLeft() - e.x.delta);
                        e.preventDefault();
                    }
                });
            }
            that.verticalScrollbar = $('<div class="k-scrollbar k-scrollbar-vertical" />').css({
                width: scrollbar
            }).appendTo(element).bind("scroll" + NS, proxy(that._scroll, that));
        },
        _wheelScroll: function(e) {
            var that = this, scrollTop = that.verticalScrollbar.scrollTop(), originalEvent = e.originalEvent, deltaY = originalEvent.wheelDeltaY, delta;
            if (originalEvent.wheelDelta) {
                // Webkit and IE
                if (deltaY === undefined || deltaY) {
                    // IE does not have deltaY, thus always scroll (horizontal scrolling is treated as vertical)
                    delta = originalEvent.wheelDelta;
                }
            } else if (originalEvent.detail && originalEvent.axis === originalEvent.VERTICAL_AXIS) {
                // Firefox and Opera
                delta = -originalEvent.detail * 10;
            }
            if (delta) {
                e.preventDefault();
                that.verticalScrollbar.scrollTop(scrollTop + -delta);
            }
        },
        _scroll: function(e) {
            var that = this, scrollTop = e.currentTarget.scrollTop, dataSource = that.dataSource, rowHeight = that.itemHeight, skip = dataSource.skip() || 0, start = that._rangeStart || skip, height = that.element.innerHeight(), isScrollingUp = !!(that._scrollbarTop && that._scrollbarTop > scrollTop), firstItemIndex = math.max(math.floor(scrollTop / rowHeight), 0), lastItemIndex = math.max(firstItemIndex + math.floor(height / rowHeight), 0);
            that._scrollTop = scrollTop - start * rowHeight;
            that._scrollbarTop = scrollTop;
            if (!that._fetch(firstItemIndex, lastItemIndex, isScrollingUp)) {
                that.wrapper[0].scrollTop = that._scrollTop;
            }
        },
        _fetch: function(firstItemIndex, lastItemIndex, scrollingUp) {
            var that = this, dataSource = that.dataSource, itemHeight = that.itemHeight, take = dataSource.take(), rangeStart = that._rangeStart || dataSource.skip() || 0, currentSkip = math.floor(firstItemIndex / take) * take, fetching = false, prefetchAt = .33;
            if (firstItemIndex < rangeStart) {
                fetching = true;
                rangeStart = math.max(0, lastItemIndex - take);
                that._scrollTop = (firstItemIndex - rangeStart) * itemHeight;
                that._page(rangeStart, take);
            } else if (lastItemIndex >= rangeStart + take && !scrollingUp) {
                fetching = true;
                rangeStart = firstItemIndex;
                that._scrollTop = itemHeight;
                that._page(rangeStart, take);
            } else if (!that._fetching) {
                if (firstItemIndex < currentSkip + take - take * prefetchAt && firstItemIndex > take) {
                    dataSource.prefetch(currentSkip - take, take);
                }
                if (lastItemIndex > currentSkip + take * prefetchAt) {
                    dataSource.prefetch(currentSkip + take, take);
                }
            }
            return fetching;
        },
        _page: function(skip, take) {
            var that = this, dataSource = that.dataSource;
            clearTimeout(that._timeout);
            that._fetching = true;
            that._rangeStart = skip;
            if (dataSource.inRange(skip, take)) {
                dataSource.range(skip, take);
            } else {
                kendo.ui.progress(that.wrapper.parent(), true);
                that._timeout = setTimeout(function() {
                    dataSource.range(skip, take);
                }, 100);
            }
        },
        refresh: function() {
            var that = this, html = "", maxHeight = 25e4, dataSource = that.dataSource, rangeStart = that._rangeStart, scrollbar = !kendo.support.kineticScrollNeeded ? kendo.support.scrollbar() : 0, wrapperElement = that.wrapper[0], totalHeight, idx, itemHeight;
            kendo.ui.progress(that.wrapper.parent(), false);
            clearTimeout(that._timeout);
            itemHeight = that.itemHeight = that.options.itemHeight() || 0;
            var addScrollBarHeight = wrapperElement.scrollWidth > wrapperElement.offsetWidth ? scrollbar : 0;
            totalHeight = dataSource.total() * itemHeight + addScrollBarHeight;
            for (idx = 0; idx < math.floor(totalHeight / maxHeight); idx++) {
                html += '<div style="width:1px;height:' + maxHeight + 'px"></div>';
            }
            if (totalHeight % maxHeight) {
                html += '<div style="width:1px;height:' + totalHeight % maxHeight + 'px"></div>';
            }
            that.verticalScrollbar.html(html);
            wrapperElement.scrollTop = that._scrollTop;
            if (that.drag) {
                that.drag.cancel();
            }
            if (rangeStart && !that._fetching) {
                // we are rebound from outside local range should be reset
                that._rangeStart = dataSource.skip();
            }
            that._fetching = false;
        }
    });
    function groupCells(count) {
        return new Array(count + 1).join('<td class="k-group-cell">&nbsp;</td>');
    }
    function stringifyAttributes(attributes) {
        var attr, result = " ";
        if (attributes) {
            if (typeof attributes === STRING) {
                return attributes;
            }
            for (attr in attributes) {
                result += attr + '="' + attributes[attr] + '"';
            }
        }
        return result;
    }
    var defaultCommands = {
        create: {
            text: "Add new record",
            imageClass: "k-add",
            className: "k-grid-add",
            iconClass: "k-icon"
        },
        cancel: {
            text: "Cancel changes",
            imageClass: "k-cancel",
            className: "k-grid-cancel-changes",
            iconClass: "k-icon"
        },
        save: {
            text: "Save changes",
            imageClass: "k-update",
            className: "k-grid-save-changes",
            iconClass: "k-icon"
        },
        destroy: {
            text: "Delete",
            imageClass: "k-delete",
            className: "k-grid-delete",
            iconClass: "k-icon"
        },
        edit: {
            text: "Edit",
            imageClass: "k-edit",
            className: "k-grid-edit",
            iconClass: "k-icon"
        },
        update: {
            text: "Update",
            imageClass: "k-update",
            className: "k-grid-update",
            iconClass: "k-icon"
        },
        canceledit: {
            text: "Cancel",
            imageClass: "k-cancel",
            className: "k-grid-cancel",
            iconClass: "k-icon"
        }
    };
    function heightAboveHeader(context) {
        var top = 0;
        $("> .k-grouping-header, > .k-grid-toolbar", context).each(function() {
            top += this.offsetHeight;
        });
        return top;
    }
    function cursor(context, value) {
        $("th, th .k-grid-filter, th .k-link", context).add(document.body).css("cursor", value);
    }
    function buildEmptyAggregatesObject(aggregates) {
        var idx, length, aggregate = {}, fieldsMap = {};
        if (!isEmptyObject(aggregates)) {
            if (!isArray(aggregates)) {
                aggregates = [ aggregates ];
            }
            for (idx = 0, length = aggregates.length; idx < length; idx++) {
                aggregate[aggregates[idx].aggregate] = 0;
                fieldsMap[aggregates[idx].field] = aggregate;
            }
        }
        return fieldsMap;
    }
    function reorder(selector, sourceIndex, destIndex) {
        var source = selector.eq(sourceIndex), dest = selector.eq(destIndex);
        source[sourceIndex > destIndex ? "insertBefore" : "insertAfter"](dest);
    }
    function attachCustomCommandEvent(context, container, commands) {
        var idx, length, command, commandName;
        commands = !isArray(commands) ? [ commands ] : commands;
        for (idx = 0, length = commands.length; idx < length; idx++) {
            command = commands[idx];
            if (isPlainObject(command) && command.click) {
                commandName = command.name || command.text;
                container.on(CLICK + NS, "a.k-grid-" + (commandName || "").replace(/\s/g, ""), {
                    commandName: commandName
                }, proxy(command.click, context));
            }
        }
    }
    function visibleColumns(columns) {
        return grep(columns, function(column) {
            return !column.hidden;
        });
    }
    function addHiddenStyle(attr) {
        attr = attr || {};
        var style = attr.style;
        if (!style) {
            style = "display:none";
        } else {
            style = style.replace(/((.*)?display)(.*)?:([^;]*)/i, "$1:none");
            if (style === attr.style) {
                style = style.replace(/(.*)?/i, "display:none;$1");
            }
        }
        return extend({}, attr, {
            style: style
        });
    }
    function removeHiddenStyle(attr) {
        attr = attr || {};
        var style = attr.style;
        if (style) {
            attr.style = style.replace(/(display\s*:\s*none\s*;?)*/gi, "");
        }
        return attr;
    }
    function normalizeCols(table, visibleColumns, hasDetails, groups) {
        var colgroup = table.find(">colgroup"), width, browser = kendo.support.browser, cols = map(visibleColumns, function(column) {
            width = column.width;
            if (width && parseInt(width, 10) !== 0) {
                return kendo.format('<col style="width:{0}"/>', typeof width === STRING ? width : width + "px");
            }
            return "<col />";
        });
        if (hasDetails || colgroup.find(".k-hierarchy-col").length) {
            cols.splice(0, 0, '<col class="k-hierarchy-col" />');
        }
        if (colgroup.length) {
            colgroup.remove();
        }
        colgroup = $("<colgroup/>").append($(new Array(groups + 1).join('<col class="k-group-col">') + cols.join("")));
        table.prepend(colgroup);
        // fill gap after column hiding
        if (browser.msie && browser.version == 8) {
            table.css("display", "inline-table");
            window.setTimeout(function() {
                table.css("display", "");
            }, 1);
        }
    }
    function convertToObject(array) {
        var result = {}, item, idx, length;
        for (idx = 0, length = array.length; idx < length; idx++) {
            item = array[idx];
            result[item.value] = item.text;
        }
        return result;
    }
    function formatGroupValue(value, format, columnValues) {
        var isForiegnKey = columnValues && columnValues.length && isPlainObject(columnValues[0]) && "value" in columnValues[0], groupValue = isForiegnKey ? convertToObject(columnValues)[value] : value;
        groupValue = groupValue != null ? groupValue : "";
        return format ? kendo.format(format, groupValue) : groupValue;
    }
    function setCellVisibility(cells, index, visible) {
        var pad = 0, state, cell = cells[pad];
        while (cell) {
            state = visible ? true : cell.style.display !== "none";
            if (state && !nonDataCellsRegExp.test(cell.className) && --index < 0) {
                cell.style.display = visible ? "" : "none";
                break;
            }
            cell = cells[++pad];
        }
    }
    var Grid = Widget.extend({
        init: function(element, options) {
            var that = this;
            options = isArray(options) ? {
                dataSource: options
            } : options;
            Widget.fn.init.call(that, element, options);
            isRtl = kendo.support.isRtl(element);
            that._element();
            that._aria();
            that._columns(that.options.columns);
            that._dataSource();
            that._tbody();
            that._pageable();
            that._thead();
            that._groupable();
            that._toolbar();
            that._setContentHeight();
            that._templates();
            that._navigatable();
            that._selectable();
            that._details();
            that._editable();
            that._attachCustomCommandsEvent();
            if (that.options.autoBind) {
                that.dataSource.fetch();
            } else {
                that._footer();
            }
            kendo.notify(that);
        },
        events: [ CHANGE, "dataBinding", "cancel", DATABOUND, DETAILEXPAND, DETAILCOLLAPSE, DETAILINIT, FILTERMENUINIT, COLUMNMENUINIT, EDIT, SAVE, REMOVE, SAVECHANGES, COLUMNRESIZE, COLUMNREORDER, COLUMNSHOW, COLUMNHIDE ],
        setDataSource: function(dataSource) {
            var that = this;
            that.options.dataSource = dataSource;
            that._dataSource();
            that._pageable();
            if (that.options.groupable) {
                that._groupable();
            }
            that._thead();
            if (that.virtualScrollable) {
                that.virtualScrollable.setDataSource(that.options.dataSource);
            }
            if (that.options.autoBind) {
                dataSource.fetch();
            }
        },
        options: {
            name: "Grid",
            columns: [],
            toolbar: null,
            autoBind: true,
            filterable: false,
            scrollable: true,
            sortable: false,
            selectable: false,
            navigatable: false,
            pageable: false,
            editable: false,
            groupable: false,
            rowTemplate: "",
            altRowTemplate: "",
            dataSource: {},
            height: null,
            resizable: false,
            reorderable: false,
            columnMenu: false,
            detailTemplate: null
        },
        destroy: function() {
            var that = this, element;
            Widget.fn.destroy.call(that);
            if (that.pager) {
                that.pager.destroy();
            }
            if (that.groupable) {
                that.groupable.destroy();
            }
            if (that.virtualScrollable) {
                that.virtualScrollable.destroy();
            }
            that._destroyColumnAttachments();
            that._destroyEditable();
            that.dataSource.unbind(CHANGE, that._refreshHandler).unbind(PROGRESS, that._progressHandler).unbind(ERROR, that._errorHandler);
            element = that.element.add(that.wrapper).add(that.table).add(that.thead).add(that.wrapper.find(">.k-grid-toolbar"));
            if (that.content) {
                element = element.add(that.content).add(that.content.find(">.k-virtual-scrollable-wrap"));
            }
            element.off(NS);
            kendo.destroy(that.wrapper);
        },
        setOptions: function(options) {
            var that = this;
            Widget.fn.setOptions.call(this, options);
            that._templates();
        },
        items: function() {
            return this.tbody.children(":not(.k-grouping-row,.k-detail-row,.k-group-footer)");
        },
        _destroyColumnAttachments: function() {
            var that = this;
            that.thead.find("th").each(function() {
                var th = $(this), filterMenu = th.data("kendoFilterMenu"), sortable = th.data("kendoSortable"), columnMenu = th.data("kendoColumnMenu");
                if (filterMenu) {
                    filterMenu.destroy();
                }
                if (sortable) {
                    sortable.destroy();
                }
                if (columnMenu) {
                    columnMenu.destroy();
                }
            });
        },
        _attachCustomCommandsEvent: function() {
            var that = this, columns = that.columns || [], command, idx, length;
            for (idx = 0, length = columns.length; idx < length; idx++) {
                command = columns[idx].command;
                if (command) {
                    attachCustomCommandEvent(that, that.wrapper, command);
                }
            }
        },
        _aria: function() {
            var id = this.element.attr("id") || "aria";
            if (id) {
                this._cellId = id + "_active_cell";
            }
        },
        _element: function() {
            var that = this, table = that.element;
            if (!table.is("table")) {
                if (that.options.scrollable) {
                    table = that.element.find("> .k-grid-content > table");
                } else {
                    table = that.element.children("table");
                }
                if (!table.length) {
                    table = $("<table />").appendTo(that.element);
                }
            }
            that.table = table.attr("cellspacing", 0).attr("role", that._hasDetails() ? "treegrid" : "grid");
            that._wrapper();
        },
        _positionColumnResizeHandle: function(container) {
            var that = this, scrollable = that.options.scrollable, resizeHandle = that.resizeHandle, left;
            that.thead.on("mousemove" + NS, "th:not(.k-group-cell,.k-hierarchy-cell)", function(e) {
                var th = $(this), clientX = e.clientX, winScrollLeft = $(window).scrollLeft(), position = th.offset().left + (!isRtl ? this.offsetWidth : 0);
                if (clientX + winScrollLeft > position - indicatorWidth && clientX + winScrollLeft < position + indicatorWidth) {
                    if (!resizeHandle) {
                        resizeHandle = that.resizeHandle = $('<div class="k-resize-handle"/>');
                        container.append(resizeHandle);
                    }
                    if (!isRtl) {
                        left = this.offsetWidth;
                        th.prevAll(":visible").each(function() {
                            left += this.offsetWidth;
                        });
                    } else {
                        var headerWrap = th.closest(".k-grid-header-wrap"), ieCorrection = kendo.support.browser.msie ? headerWrap.scrollLeft() : 0, webkitCorrection = kendo.support.browser.webkit ? headerWrap[0].scrollWidth - headerWrap[0].offsetWidth - headerWrap.scrollLeft() : 0, firefoxCorrection = kendo.support.browser.mozilla ? headerWrap[0].scrollWidth - headerWrap[0].offsetWidth - (headerWrap[0].scrollWidth - headerWrap[0].offsetWidth - headerWrap.scrollLeft()) : 0;
                        left = th.position().left - webkitCorrection + firefoxCorrection - ieCorrection;
                    }
                    resizeHandle.css({
                        top: scrollable ? 0 : heightAboveHeader(that.wrapper),
                        left: left - indicatorWidth,
                        height: th.outerHeight(),
                        width: indicatorWidth * 3
                    }).data("th", th).show();
                } else {
                    if (resizeHandle) {
                        resizeHandle.hide();
                    } else {
                        cursor(that.wrapper, "");
                    }
                }
            });
        },
        _resizable: function() {
            var that = this, options = that.options, container, columnStart, columnWidth, gridWidth, col;
            if (options.resizable) {
                container = options.scrollable ? that.wrapper.find(".k-grid-header-wrap:first") : that.wrapper;
                that._positionColumnResizeHandle(container);
                container.kendoResizable({
                    handle: ".k-resize-handle",
                    hint: function(handle) {
                        return $('<div class="k-grid-resize-indicator" />').css({
                            height: handle.data("th").outerHeight() + that.tbody.attr("clientHeight")
                        });
                    },
                    start: function(e) {
                        var th = $(e.currentTarget).data("th"), index = $.inArray(th[0], th.parent().children(":visible")), contentTable = that.tbody.parent(), footer = that.footer || $();
                        cursor(that.wrapper, "col-resize");
                        if (options.scrollable) {
                            col = that.thead.parent().find("col:eq(" + index + ")").add(contentTable.children("colgroup").find("col:eq(" + index + ")")).add(footer.find("colgroup").find("col:eq(" + index + ")"));
                        } else {
                            col = contentTable.children("colgroup").find("col:eq(" + index + ")");
                        }
                        columnStart = e.x.location;
                        columnWidth = th.outerWidth();
                        gridWidth = that.tbody.outerWidth();
                    },
                    resize: function(e) {
                        var rtlMultiplier = isRtl ? -1 : 1, width = columnWidth + e.x.location * rtlMultiplier - columnStart * rtlMultiplier, footer = that.footer || $();
                        if (width > 10) {
                            col.css("width", width);
                            if (options.scrollable) {
                                that._footerWidth = gridWidth + e.x.location * rtlMultiplier - columnStart * rtlMultiplier;
                                that.tbody.parent().add(that.thead.parent()).add(footer.find("table")).css("width", that._footerWidth);
                            }
                        }
                    },
                    resizeend: function(e) {
                        var th = $(e.currentTarget).data("th"), newWidth = th.outerWidth(), column;
                        cursor(that.wrapper, "");
                        if (columnWidth != newWidth) {
                            column = that.columns[th.parent().find("th:not(.k-group-cell,.k-hierarchy-cell)").index(th)];
                            column.width = newWidth;
                            that.trigger(COLUMNRESIZE, {
                                column: column,
                                oldWidth: columnWidth,
                                newWidth: newWidth
                            });
                        }
                        that.resizeHandle.hide();
                    }
                });
            }
        },
        _draggable: function() {
            var that = this;
            if (that.options.reorderable) {
                if (that._draggableInstance) {
                    that._draggableInstance.destroy();
                }
                that._draggableInstance = that.wrapper.kendoDraggable({
                    group: kendo.guid(),
                    filter: that.content ? ">.k-grid-header " + HEADERCELLS : ">table>.k-grid-header " + HEADERCELLS,
                    hint: function(target) {
                        return $('<div class="k-header k-drag-clue" />').css({
                            width: target.width(),
                            paddingLeft: target.css("paddingLeft"),
                            paddingRight: target.css("paddingRight"),
                            lineHeight: target.height() + "px",
                            paddingTop: target.css("paddingTop"),
                            paddingBottom: target.css("paddingBottom")
                        }).html(target.attr(kendo.attr("title")) || target.attr(kendo.attr("field")) || target.text()).prepend('<span class="k-icon k-drag-status k-denied" />');
                    }
                }).data("kendoDraggable");
            }
        },
        _reorderable: function() {
            var that = this;
            if (that.options.reorderable) {
                that.wrapper.kendoReorderable({
                    draggable: that._draggableInstance,
                    change: function(e) {
                        var newIndex = inArray(that.columns[e.newIndex], that.columns), column = that.columns[e.oldIndex];
                        that.trigger(COLUMNREORDER, {
                            newIndex: newIndex,
                            oldIndex: inArray(column, that.columns),
                            column: column
                        });
                        that.reorderColumn(newIndex, column);
                    }
                });
            }
        },
        reorderColumn: function(destIndex, column) {
            var that = this, sourceIndex = inArray(column, that.columns), colSourceIndex = inArray(column, visibleColumns(that.columns)), colDestIndex = inArray(that.columns[destIndex], visibleColumns(that.columns)), rows, idx, length, footer = that.footer || that.wrapper.find(".k-grid-footer");
            if (sourceIndex === destIndex) {
                return;
            }
            that.columns.splice(sourceIndex, 1);
            that.columns.splice(destIndex, 0, column);
            that._templates();
            reorder(that.thead.prev().find("col:not(.k-group-col,.k-hierarchy-col)"), colSourceIndex, colDestIndex);
            if (that.options.scrollable) {
                reorder(that.tbody.prev().find("col:not(.k-group-col,.k-hierarchy-col)"), colSourceIndex, colDestIndex);
            }
            reorder(that.thead.find(".k-header:not(.k-group-cell,.k-hierarchy-cell)"), sourceIndex, destIndex);
            if (footer && footer.length) {
                reorder(footer.find(".k-grid-footer-wrap>table>colgroup>col:not(.k-group-col,.k-hierarchy-col)"), colSourceIndex, colDestIndex);
                reorder(footer.find(".k-footer-template>td:not(.k-group-cell,.k-hierarchy-cell)"), sourceIndex, destIndex);
            }
            rows = that.tbody.children(":not(.k-grouping-row,.k-detail-row)");
            for (idx = 0, length = rows.length; idx < length; idx += 1) {
                reorder(rows.eq(idx).find(">td:not(.k-group-cell,.k-hierarchy-cell)"), sourceIndex, destIndex);
            }
        },
        cellIndex: function(td) {
            return $(td).parent().children("td:not(.k-group-cell,.k-hierarchy-cell)").index(td);
        },
        _modelForContainer: function(container) {
            container = $(container);
            if (!container.is("tr") && this._editMode() !== "popup") {
                container = container.closest("tr");
            }
            var id = container.attr(kendo.attr("uid"));
            return this.dataSource.getByUid(id);
        },
        _editable: function() {
            var that = this, selectable = that.selectable && that.selectable.options.multiple, editable = that.options.editable, handler = function() {
                var target = activeElement(), cell = that._editContainer;
                if (cell && !$.contains(cell[0], target) && cell[0] !== target && !$(target).closest(".k-animation-container").length) {
                    if (that.editable.end()) {
                        that.closeCell();
                    }
                }
            };
            if (editable) {
                var mode = that._editMode();
                if (mode === "incell") {
                    if (editable.update !== false) {
                        that.wrapper.on(CLICK + NS, "tr:not(.k-grouping-row) > td", function(e) {
                            var td = $(this);
                            if (td.hasClass("k-hierarchy-cell") || td.hasClass("k-detail-cell") || td.hasClass("k-group-cell") || td.hasClass("k-edit-cell") || td.has("a.k-grid-delete").length || td.has("button.k-grid-delete").length || td.closest("tbody")[0] !== that.tbody[0] || $(e.target).is(":input")) {
                                return;
                            }
                            if (that.editable) {
                                if (that.editable.end()) {
                                    if (selectable) {
                                        $(activeElement()).blur();
                                    }
                                    that.closeCell();
                                    that.editCell(td);
                                }
                            } else {
                                that.editCell(td);
                            }
                        }).on("focusin" + NS, function() {
                            clearTimeout(that.timer);
                            that.timer = null;
                        }).on("focusout" + NS, function() {
                            that.timer = setTimeout(handler, 1);
                        });
                    }
                } else {
                    if (editable.update !== false) {
                        that.wrapper.on(CLICK + NS, "tbody>tr:not(.k-detail-row,.k-grouping-row):visible a.k-grid-edit", function(e) {
                            e.preventDefault();
                            that.editRow($(this).closest("tr"));
                        });
                    }
                }
                if (editable.destroy !== false) {
                    that.wrapper.on(CLICK + NS, "tbody>tr:not(.k-detail-row,.k-grouping-row):visible .k-grid-delete", function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        that.removeRow($(this).closest("tr"));
                    });
                } else {
                    //Required for the MVC server wrapper delete button
                    that.wrapper.on(CLICK + NS, "tbody>tr:not(.k-detail-row,.k-grouping-row):visible button.k-grid-delete", function(e) {
                        if (!that._confirmation()) {
                            e.preventDefault();
                        }
                    });
                }
            }
        },
        editCell: function(cell) {
            var that = this, column = that.columns[that.cellIndex(cell)], model = that._modelForContainer(cell);
            if (model && (!model.editable || model.editable(column.field)) && !column.command && column.field) {
                that._attachModelChange(model);
                that._editContainer = cell;
                that.editable = cell.addClass("k-edit-cell").kendoEditable({
                    fields: {
                        field: column.field,
                        format: column.format,
                        editor: column.editor,
                        values: column.values
                    },
                    model: model,
                    change: function(e) {
                        if (that.trigger(SAVE, {
                            values: e.values,
                            container: cell,
                            model: model
                        })) {
                            e.preventDefault();
                        }
                    }
                }).data("kendoEditable");
                cell.parent().addClass("k-grid-edit-row");
                that.trigger(EDIT, {
                    container: cell,
                    model: model
                });
            }
        },
        _destroyEditable: function() {
            var that = this;
            var destroy = function() {
                if (that.editable) {
                    that._detachModelChange();
                    that.editable.destroy();
                    that.editable = null;
                    that._editContainer = null;
                }
            };
            if (that.editable) {
                if (that._editMode() === "popup") {
                    that._editContainer.data("kendoWindow").bind("deactivate", destroy).close();
                } else {
                    destroy();
                }
            }
        },
        _attachModelChange: function(model) {
            var that = this;
            that._modelChangeHandler = function(e) {
                that._modelChange({
                    field: e.field,
                    model: this
                });
            };
            model.bind("change", that._modelChangeHandler);
        },
        _detachModelChange: function() {
            var that = this, container = that._editContainer, model = that._modelForContainer(container);
            if (model) {
                model.unbind(CHANGE, that._modelChangeHandler);
            }
        },
        closeCell: function() {
            var that = this, cell, id, column, model;
            if (!that._editContainer) {
                return;
            }
            cell = that._editContainer.removeClass("k-edit-cell");
            id = cell.closest("tr").attr(kendo.attr("uid"));
            column = that.columns[that.cellIndex(cell)];
            model = that.dataSource.getByUid(id);
            cell.parent().removeClass("k-grid-edit-row");
            that._destroyEditable();
            // editable should be destoryed before content of the container is changed
            that._displayCell(cell, column, model);
            if (cell.hasClass("k-dirty-cell")) {
                $('<span class="k-dirty"/>').prependTo(cell);
            }
        },
        _displayCell: function(cell, column, dataItem) {
            var that = this, state = {
                storage: {},
                count: 0
            }, settings = extend({}, kendo.Template, that.options.templateSettings), tmpl = kendo.template(that._cellTmpl(column, state), settings);
            if (state.count > 0) {
                tmpl = proxy(tmpl, state.storage);
            }
            cell.empty().html(tmpl(dataItem));
        },
        removeRow: function(row) {
            var that = this, model, mode;
            if (!that._confirmation()) {
                return;
            }
            row = $(row).hide();
            model = that._modelForContainer(row);
            if (model && !that.trigger(REMOVE, {
                row: row,
                model: model
            })) {
                mode = that._editMode();
                if (mode !== "incell") {
                    that.cancelRow();
                }
                that.dataSource.remove(model);
                if (mode === "inline" || mode === "popup") {
                    that.dataSource.sync();
                }
            }
        },
        _editMode: function() {
            var mode = "incell", editable = this.options.editable;
            if (editable !== true) {
                if (typeof editable == "string") {
                    mode = editable;
                } else {
                    mode = editable.mode || mode;
                }
            }
            return mode;
        },
        editRow: function(row) {
            var that = this, model = that._modelForContainer(row), mode = that._editMode(), navigatable = that.options.navigatable, container;
            that.cancelRow();
            if (model) {
                that._attachModelChange(model);
                if (mode === "popup") {
                    that._createPopupEditor(model);
                } else if (mode === "inline") {
                    that._createInlineEditor(row, model);
                } else if (mode === "incell") {
                    $(row).children(DATA_CELL).each(function() {
                        var cell = $(this);
                        var column = that.columns[cell.index()];
                        model = that._modelForContainer(cell);
                        if (model && (!model.editable || model.editable(column.field)) && column.field) {
                            that.editCell(cell);
                            return false;
                        }
                    });
                }
                container = that._editContainer;
                container.on(CLICK + NS, "a.k-grid-cancel", function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    if (that.trigger("cancel", {
                        container: container,
                        model: model
                    })) {
                        return;
                    }
                    var currentIndex = that.items().index($(that.current()).parent());
                    that.cancelRow();
                    if (navigatable) {
                        that.current(that.items().eq(currentIndex).children().filter(NAVCELL).first());
                        focusTable(that.table, true);
                    }
                });
                container.on(CLICK + NS, "a.k-grid-update", function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    that.saveRow();
                });
            }
        },
        _createPopupEditor: function(model) {
            var that = this, html = "<div " + kendo.attr("uid") + '="' + model.uid + '"><div class="k-edit-form-container">', column, command, fields = [], idx, length, tmpl, updateText, cancelText, tempCommand, attr, editable = that.options.editable, template = editable.template, options = isPlainObject(editable) ? editable.window : {}, settings = extend({}, kendo.Template, that.options.templateSettings);
            if (template) {
                if (typeof template === STRING) {
                    template = window.unescape(template);
                }
                html += kendo.template(template, settings)(model);
                for (idx = 0, length = that.columns.length; idx < length; idx++) {
                    column = that.columns[idx];
                    if (column.command) {
                        tempCommand = getCommand(column.command, "edit");
                        if (tempCommand) {
                            command = tempCommand;
                        }
                    }
                }
            } else {
                for (idx = 0, length = that.columns.length; idx < length; idx++) {
                    column = that.columns[idx];
                    if (!column.command) {
                        html += '<div class="k-edit-label"><label for="' + column.field + '">' + (column.title || column.field || "") + "</label></div>";
                        if ((!model.editable || model.editable(column.field)) && column.field) {
                            fields.push({
                                field: column.field,
                                format: column.format,
                                editor: column.editor,
                                values: column.values
                            });
                            html += "<div " + kendo.attr("container-for") + '="' + column.field + '" class="k-edit-field"></div>';
                        } else {
                            var state = {
                                storage: {},
                                count: 0
                            };
                            tmpl = kendo.template(that._cellTmpl(column, state), settings);
                            if (state.count > 0) {
                                tmpl = proxy(tmpl, state.storage);
                            }
                            html += '<div class="k-edit-field">' + tmpl(model) + "</div>";
                        }
                    } else if (column.command) {
                        tempCommand = getCommand(column.command, "edit");
                        if (tempCommand) {
                            command = tempCommand;
                        }
                    }
                }
            }
            if (command) {
                if (isPlainObject(command)) {
                    if (command.text && isPlainObject(command.text)) {
                        updateText = command.text.update;
                        cancelText = command.text.cancel;
                    }
                    if (command.attr) {
                        attr = command.attr;
                    }
                }
            }
            html += that._createButton({
                name: "update",
                text: updateText,
                attr: attr
            }) + that._createButton({
                name: "canceledit",
                text: cancelText,
                attr: attr
            });
            html += "</div></div>";
            var container = that._editContainer = $(html).appendTo(that.wrapper).eq(0).kendoWindow(extend({
                modal: true,
                resizable: false,
                draggable: true,
                title: "Edit",
                visible: false,
                close: function(e) {
                    if (e.userTriggered) {
                        if (that.trigger("cancel", {
                            container: container,
                            model: model
                        })) {
                            e.preventDefault();
                            return;
                        }
                        var currentIndex = that.items().index($(that.current()).parent());
                        that.cancelRow();
                        if (that.options.navigatable) {
                            that.current(that.items().eq(currentIndex).children().filter(NAVCELL).first());
                            focusTable(that.table, true);
                        }
                    }
                }
            }, options));
            that.editable = that._editContainer.kendoEditable({
                fields: fields,
                model: model,
                clearContainer: false
            }).data("kendoEditable");
            container.data("kendoWindow").center().open();
            that.trigger(EDIT, {
                container: container,
                model: model
            });
        },
        _createInlineEditor: function(row, model) {
            var that = this, column, cell, command, fields = [];
            row.children(":not(.k-group-cell,.k-hierarchy-cell)").each(function() {
                cell = $(this);
                column = that.columns[that.cellIndex(cell)];
                if (!column.command && column.field && (!model.editable || model.editable(column.field))) {
                    fields.push({
                        field: column.field,
                        format: column.format,
                        editor: column.editor,
                        values: column.values
                    });
                    cell.attr(kendo.attr("container-for"), column.field);
                    cell.empty();
                } else if (column.command) {
                    command = getCommand(column.command, "edit");
                    if (command) {
                        cell.empty();
                        var updateText, cancelText, attr;
                        if (isPlainObject(command)) {
                            if (command.text && isPlainObject(command.text)) {
                                updateText = command.text.update;
                                cancelText = command.text.cancel;
                            }
                            if (command.attr) {
                                attr = command.attr;
                            }
                        }
                        $(that._createButton({
                            name: "update",
                            text: updateText,
                            attr: attr
                        }) + that._createButton({
                            name: "canceledit",
                            text: cancelText,
                            attr: attr
                        })).appendTo(cell);
                    }
                }
            });
            that._editContainer = row;
            that.editable = row.addClass("k-grid-edit-row").kendoEditable({
                fields: fields,
                model: model,
                clearContainer: false
            }).data("kendoEditable");
            that.trigger(EDIT, {
                container: row,
                model: model
            });
        },
        cancelRow: function() {
            var that = this, container = that._editContainer, model;
            if (container) {
                model = that._modelForContainer(container);
                that.dataSource.cancelChanges(model);
                if (that._editMode() !== "popup") {
                    that._displayRow(container);
                } else {
                    that._displayRow(that.items().filter("[" + kendo.attr("uid") + "=" + model.uid + "]"));
                }
                that._destroyEditable();
            }
        },
        saveRow: function() {
            var that = this, container = that._editContainer, model = that._modelForContainer(container), editable = that.editable;
            if (container && editable && editable.end() && !that.trigger(SAVE, {
                container: container,
                model: model
            })) {
                that.dataSource.sync();
            }
        },
        _displayRow: function(row) {
            var that = this, model = that._modelForContainer(row);
            if (model) {
                row.replaceWith($((row.hasClass("k-alt") ? that.altRowTemplate : that.rowTemplate)(model)));
            }
        },
        _showMessage: function(text) {
            return window.confirm(text);
        },
        _confirmation: function() {
            var that = this, editable = that.options.editable, confirmation = editable === true || typeof editable === STRING ? DELETECONFIRM : editable.confirmation;
            return confirmation !== false && confirmation != null ? that._showMessage(confirmation) : true;
        },
        cancelChanges: function() {
            this.dataSource.cancelChanges();
        },
        saveChanges: function() {
            var that = this;
            if ((that.editable && that.editable.end() || !that.editable) && !that.trigger(SAVECHANGES)) {
                that.dataSource.sync();
            }
        },
        addRow: function() {
            var that = this, index, dataSource = that.dataSource, mode = that._editMode(), createAt = that.options.editable.createAt || "", pageSize = dataSource.pageSize(), view = dataSource.view() || [];
            if (that.editable && that.editable.end() || !that.editable) {
                if (mode != "incell") {
                    that.cancelRow();
                }
                index = dataSource.indexOf(view[0]);
                if (createAt.toLowerCase() == "bottom") {
                    index += view.length;
                    if (pageSize && !dataSource.options.serverPaging && pageSize <= view.length) {
                        index -= 1;
                    }
                }
                if (index < 0) {
                    if (dataSource.page() > dataSource.totalPages()) {
                        index = (dataSource.page() - 1) * pageSize;
                    } else {
                        index = 0;
                    }
                }
                var model = dataSource.insert(index, {}), id = model.uid, row = that.table.find("tr[" + kendo.attr("uid") + "=" + id + "]"), cell = row.children("td:not(.k-group-cell,.k-hierarchy-cell)").eq(that._firstEditableColumnIndex(row));
                if ((mode === "inline" || mode === "popup") && row.length) {
                    that.editRow(row);
                } else if (cell.length) {
                    that.editCell(cell);
                }
            }
        },
        _firstEditableColumnIndex: function(container) {
            var that = this, column, columns = that.columns, idx, length, model = that._modelForContainer(container);
            for (idx = 0, length = columns.length; idx < length; idx++) {
                column = columns[idx];
                if (model && (!model.editable || model.editable(column.field)) && !column.command && column.field) {
                    return idx;
                }
            }
            return -1;
        },
        _toolbar: function() {
            var that = this, wrapper = that.wrapper, toolbar = that.options.toolbar, editable = that.options.editable, container;
            if (toolbar) {
                container = that.wrapper.find(".k-grid-toolbar");
                if (!container.length) {
                    if (!isFunction(toolbar)) {
                        toolbar = typeof toolbar === STRING ? toolbar : that._toolbarTmpl(toolbar).replace(templateHashRegExp, "\\#");
                        toolbar = proxy(kendo.template(toolbar), that);
                    }
                    container = $('<div class="k-toolbar k-grid-toolbar" />').html(toolbar({})).prependTo(wrapper);
                }
                if (editable && editable.create !== false) {
                    container.on(CLICK + NS, ".k-grid-add", function(e) {
                        e.preventDefault();
                        that.addRow();
                    }).on(CLICK + NS, ".k-grid-cancel-changes", function(e) {
                        e.preventDefault();
                        that.cancelChanges();
                    }).on(CLICK + NS, ".k-grid-save-changes", function(e) {
                        e.preventDefault();
                        that.saveChanges();
                    });
                }
            }
        },
        _toolbarTmpl: function(commands) {
            var that = this, idx, length, html = "";
            if (isArray(commands)) {
                for (idx = 0, length = commands.length; idx < length; idx++) {
                    html += that._createButton(commands[idx]);
                }
            }
            return html;
        },
        _createButton: function(command) {
            var template = command.template || COMMANDBUTTONTMPL, commandName = typeof command === STRING ? command : command.name || command.text, options = {
                className: "k-grid-" + (commandName || "").replace(/\s/g, ""),
                text: commandName,
                imageClass: "",
                attr: "",
                iconClass: ""
            };
            if (!commandName && !(isPlainObject(command) && command.template)) {
                throw new Error("Custom commands should have name specified");
            }
            if (isPlainObject(command)) {
                if (command.className) {
                    command.className += " " + options.className;
                }
                if (commandName === "edit" && isPlainObject(command.text)) {
                    command = extend(true, {}, command);
                    command.text = command.text.edit;
                }
                if (command.attr && isPlainObject(command.attr)) {
                    command.attr = stringifyAttributes(command.attr);
                }
                options = extend(true, options, defaultCommands[commandName], command);
            } else {
                options = extend(true, options, defaultCommands[commandName]);
            }
            return kendo.template(template)(options);
        },
        _groupable: function() {
            var that = this;
            that.table.on(CLICK + NS, ".k-grouping-row .k-i-collapse, .k-grouping-row .k-i-expand", function(e) {
                var element = $(this), group = element.closest("tr");
                if (element.hasClass("k-i-collapse")) {
                    that.collapseGroup(group);
                } else {
                    that.expandGroup(group);
                }
                e.preventDefault();
                e.stopPropagation();
            });
            that._attachGroupable();
        },
        _attachGroupable: function() {
            var that = this, wrapper = that.wrapper, groupable = that.options.groupable;
            if (groupable) {
                if (!wrapper.has("div.k-grouping-header")[0]) {
                    $("<div>&nbsp;</div>").addClass("k-grouping-header").prependTo(wrapper);
                }
                if (that.groupable) {
                    that.groupable.destroy();
                }
                that.groupable = new Groupable(wrapper, extend({}, groupable, {
                    draggable: that._draggableInstance,
                    groupContainer: ">div.k-grouping-header",
                    dataSource: that.dataSource,
                    draggableElements: that.content ? ">.k-grid-header " + GROUPINGDRAGGABLES : ">table>.k-grid-header " + GROUPINGDRAGGABLES,
                    filter: that.content ? ">.k-grid-header " + GROUPINGFILTER : ">table>.k-grid-header " + GROUPINGFILTER,
                    allowDrag: that.options.reorderable
                }));
            }
        },
        _selectable: function() {
            var that = this, multi, cell, selectable = that.options.selectable;
            if (selectable) {
                multi = typeof selectable === STRING && selectable.toLowerCase().indexOf("multiple") > -1;
                cell = typeof selectable === STRING && selectable.toLowerCase().indexOf("cell") > -1;
                that.selectable = new kendo.ui.Selectable(that.table, {
                    filter: ">" + (cell ? SELECTION_CELL_SELECTOR : "tbody>tr:not(.k-grouping-row,.k-detail-row,.k-group-footer)"),
                    aria: true,
                    multiple: multi,
                    change: function() {
                        that.trigger(CHANGE);
                    }
                });
                if (that.options.navigatable) {
                    that.table.on("keydown" + NS, function(e) {
                        var current = that.current();
                        if (e.keyCode === keys.SPACEBAR && e.target == that.table[0] && !current.is(".k-edit-cell,.k-header") && current.parent().is(":not(.k-grouping-row,.k-detail-row,.k-group-footer)")) {
                            e.preventDefault();
                            e.stopPropagation();
                            current = cell ? current : current.parent();
                            if (multi) {
                                if (!e.ctrlKey) {
                                    that.selectable.clear();
                                } else {
                                    if (current.hasClass(SELECTED)) {
                                        current.removeClass(SELECTED);
                                        that.trigger(CHANGE);
                                        return;
                                    }
                                }
                            } else {
                                that.selectable.clear();
                            }
                            that.selectable.value(current);
                        }
                    });
                }
            }
        },
        clearSelection: function() {
            var that = this;
            that.selectable.clear();
            that.trigger(CHANGE);
        },
        select: function(items) {
            var that = this, selectable = that.selectable;
            items = $(items);
            if (items.length) {
                if (!selectable.options.multiple) {
                    selectable.clear();
                    items = items.first();
                }
                selectable.value(items);
                return;
            }
            return selectable.value();
        },
        current: function(element) {
            var that = this, scrollable = that.options.scrollable, current = that._current, table = that.table.add(that.thead.parent());
            if (element !== undefined && element.length) {
                if (!current || current[0] !== element[0]) {
                    if (current) {
                        current.removeClass(FOCUSED).removeAttr("id");
                        table.removeAttr("aria-activedescendant");
                    }
                    element.attr("id", that._cellId);
                    that._current = element.addClass(FOCUSED);
                    table.attr("aria-activedescendant", that._cellId);
                    if (element.length && scrollable) {
                        if ($.contains(that.content[0], element[0])) {
                            that._scrollTo(element.parent()[0], that.content[0]);
                        }
                        if (scrollable.virtual) {
                            that._scrollTo(element[0], that.content.find(">.k-virtual-scrollable-wrap")[0]);
                        } else {
                            that._scrollTo(element[0], that.content[0]);
                        }
                    }
                }
            }
            return that._current;
        },
        _removeCurrent: function() {
            if (this._current) {
                this._current.removeClass(FOCUSED);
                this._current = null;
            }
        },
        _scrollTo: function(element, container) {
            var elementToLowercase = element.tagName.toLowerCase(), isHorizontal = elementToLowercase === "td" || elementToLowercase === "th", elementOffset = element[isHorizontal ? "offsetLeft" : "offsetTop"], elementOffsetDir = element[isHorizontal ? "offsetWidth" : "offsetHeight"], containerScroll = container[isHorizontal ? "scrollLeft" : "scrollTop"], containerOffsetDir = container[isHorizontal ? "clientWidth" : "clientHeight"], bottomDistance = elementOffset + elementOffsetDir, result = 0;
            if (containerScroll > elementOffset) {
                result = elementOffset;
            } else if (bottomDistance > containerScroll + containerOffsetDir) {
                if (elementOffsetDir <= containerOffsetDir) {
                    result = bottomDistance - containerOffsetDir;
                } else {
                    result = elementOffset;
                }
            } else {
                result = containerScroll;
            }
            container[isHorizontal ? "scrollLeft" : "scrollTop"] = result;
        },
        _navigatable: function() {
            var that = this, currentProxy = proxy(that.current, that), table = that.table, headerTable = that.thead.parent(), dataTable = table, isRtl = kendo.support.isRtl(that.element);
            if (!that.options.navigatable) {
                return;
            }
            if (that.options.scrollable) {
                dataTable = table.add(headerTable);
                headerTable.attr(TABINDEX, -1);
            }
            headerTable.on("keydown" + NS, function(e) {
                if (e.altKey && e.keyCode == keys.DOWN) {
                    currentProxy().find(".k-grid-filter, .k-header-column-menu").click();
                    e.stopImmediatePropagation();
                }
            }).find("a.k-link").attr("tabIndex", -1);
            table.attr(TABINDEX, math.max(table.attr(TABINDEX) || 0, 0)).on("mousedown" + NS + " keydown" + NS, ".k-detail-cell", function(e) {
                if (e.target !== e.currentTarget) {
                    e.stopImmediatePropagation();
                }
            });
            dataTable.on(kendo.support.touch ? "touchstart" + NS : "mousedown" + NS, NAVROW + ">" + NAVCELL, proxy(tableClick, that)).on("focus" + NS, function() {
                var current = currentProxy();
                if (current && current.is(":visible")) {
                    current.addClass(FOCUSED);
                } else {
                    currentProxy($(this).find(FIRSTNAVITEM));
                }
                if (this == table[0]) {
                    headerTable.attr(TABINDEX, -1);
                    table.attr(TABINDEX, 0);
                } else {
                    table.attr(TABINDEX, -1);
                    headerTable.attr(TABINDEX, 0);
                }
            }).on("focusout" + NS, function() {
                var current = currentProxy();
                if (current) {
                    current.removeClass(FOCUSED);
                }
            }).on("keydown" + NS, function(e) {
                var key = e.keyCode, handled = false, canHandle = !e.isDefaultPrevented() && !$(e.target).is(":button,a,:input,a>.k-icon"), pageable = that.options.pageable, dataSource = that.dataSource, isInCell = that._editMode() == "incell", active, currentIndex, row, index, tableToFocus, shiftKey = e.shiftKey, browser = kendo.support.browser, current = currentProxy();
                if (current && current.is("th")) {
                    canHandle = true;
                }
                if (canHandle && key == keys.UP) {
                    if (current) {
                        row = current.parent().prevAll(NAVROW).first();
                        if (!row[0]) {
                            tableToFocus = that.thead.parent();
                            focusTable(tableToFocus, true);
                            row = tableToFocus.find(NAVROW).first();
                        }
                        index = current.index();
                        current = row.children().eq(index);
                        if (!current[0] || !current.is(NAVCELL)) {
                            current = row.children(NAVCELL).first();
                        }
                    } else {
                        current = table.find(FIRSTNAVITEM);
                    }
                    handled = true;
                    currentProxy(current);
                } else if (canHandle && key == keys.DOWN) {
                    if (current) {
                        row = current.parent().nextAll(NAVROW).first();
                        if (!row[0] && current.is("th")) {
                            focusTable(that.tbody.parent());
                            row = that.tbody.find(NAVROW).first();
                        }
                        index = current.index();
                        current = row.children().eq(index);
                        if (!current[0] || !current.is(NAVCELL)) {
                            current = row.children(NAVCELL).first();
                        }
                    } else {
                        current = table.find(FIRSTNAVITEM);
                    }
                    handled = true;
                    currentProxy(current);
                } else if (canHandle && key == (isRtl ? keys.RIGHT : keys.LEFT)) {
                    currentProxy(current ? current.prevAll(DATA_CELL + ":first") : table.find(FIRSTNAVITEM));
                    handled = true;
                } else if (canHandle && key == (isRtl ? keys.LEFT : keys.RIGHT)) {
                    if (current) {
                        if (current.next()[0]) {
                            current = current.nextAll(DATA_CELL + ":first");
                        }
                    } else {
                        current = table.find(FIRSTNAVITEM);
                    }
                    handled = true;
                    currentProxy(current);
                } else if (canHandle && pageable && keys.PAGEDOWN == key) {
                    dataSource.page(dataSource.page() + 1);
                    handled = true;
                } else if (canHandle && pageable && keys.PAGEUP == key) {
                    dataSource.page(dataSource.page() - 1);
                    handled = true;
                } else if (key == keys.ENTER || keys.F2 == key) {
                    current = current ? current : table.find(FIRSTNAVITEM);
                    if (current.is("th")) {
                        current.find(".k-link").click();
                        handled = true;
                    } else if (current.parent().is(".k-master-row,.k-grouping-row")) {
                        current.parent().find(".k-icon:first").click();
                        handled = true;
                    } else {
                        var focusable = current.find(":focusable:first");
                        if (!current.hasClass("k-edit-cell") && focusable[0] && current.hasClass("k-state-focused")) {
                            focusable.focus();
                            handled = true;
                        } else if (that.options.editable && !$(e.target).is(":button,.k-button")) {
                            that._handleEditing(current);
                            handled = true;
                        }
                    }
                } else if (keys.ESC == key) {
                    active = activeElement();
                    if (current && $.contains(current[0], active) && !current.hasClass("k-edit-cell") && !current.parent().hasClass("k-grid-edit-row")) {
                        focusTable(that.table[0], true);
                        handled = true;
                    } else if (that._editContainer && (!current || that._editContainer.has(current[0]) || current[0] === that._editContainer[0])) {
                        if (isInCell) {
                            that.closeCell();
                        } else {
                            currentIndex = that.items().index($(current).parent());
                            if (active) {
                                active.blur();
                            }
                            that.cancelRow();
                            if (currentIndex >= 0) {
                                that.current(that.items().eq(currentIndex).children().filter(NAVCELL).first());
                            }
                        }
                        if (browser.msie && browser.version < 9) {
                            document.body.focus();
                        }
                        focusTable(table, true);
                        handled = true;
                    }
                } else if (keys.TAB == key) {
                    var cell;
                    current = $(current);
                    if (that.options.editable && isInCell) {
                        cell = $(activeElement()).closest(".k-edit-cell");
                        if (cell[0] && cell[0] !== current[0]) {
                            current = cell;
                        }
                    }
                    cell = shiftKey ? current.prevAll(DATA_CELL + ":first") : current.nextAll(":visible:first");
                    if (!cell.length) {
                        cell = current.parent()[shiftKey ? "prevAll" : "nextAll"]("tr:not(.k-grouping-row):not(.k-detail-row):visible:first").children(DATA_CELL + (shiftKey ? ":last" : ":first"));
                    }
                    if (!current.is("th") && cell.length && that.options.editable && isInCell) {
                        that._handleEditing(current, cell);
                        handled = true;
                    }
                }
                if (handled) {
                    //prevent browser scrolling
                    e.preventDefault();
                    //required in hierarchy
                    e.stopPropagation();
                }
            });
        },
        _handleEditing: function(current, next) {
            var that = this, active = $(activeElement()), mode = that._editMode(), editContainer = that._editContainer, focusable, isEdited;
            if (mode == "incell") {
                isEdited = current.hasClass("k-edit-cell");
            } else {
                isEdited = current.parent().hasClass("k-grid-edit-row");
            }
            if (that.editable) {
                if ($.contains(editContainer[0], active[0])) {
                    active.blur();
                    if (kendo.support.browser.opera) {
                        active.change();
                    }
                }
                if (!that.editable) {
                    focusTable(that.table);
                    return;
                }
                if (that.editable.end()) {
                    if (mode == "incell") {
                        that.closeCell();
                    } else {
                        that.saveRow();
                        isEdited = true;
                    }
                } else {
                    if (mode == "incell") {
                        that.current(editContainer);
                    } else {
                        that.current(editContainer.children().filter(DATA_CELL).first());
                    }
                    focusable = editContainer.find(":focusable:first")[0];
                    if (focusable) {
                        focusable.focus();
                    }
                    return;
                }
            }
            if (next) {
                that.current(next);
            }
            focusTable(that.table, true);
            if (!isEdited && !next || next) {
                if (mode == "incell") {
                    that.editCell(that.current());
                } else {
                    that.editRow(that.current().parent());
                }
            }
        },
        _wrapper: function() {
            var that = this, table = that.table, height = that.options.height, wrapper = that.element;
            if (!wrapper.is("div")) {
                wrapper = wrapper.wrap("<div/>").parent();
            }
            that.wrapper = wrapper.addClass("k-grid k-widget");
            /*
                                  .attr(TABINDEX, math.max(table.attr(TABINDEX) || 0, 0));

            table.removeAttr(TABINDEX);
            */
            if (height) {
                that.wrapper.css(HEIGHT, height);
                table.css(HEIGHT, "auto");
            }
        },
        _tbody: function() {
            var that = this, table = that.table, tbody;
            tbody = table.find(">tbody");
            if (!tbody.length) {
                tbody = $("<tbody/>").appendTo(table);
            }
            that.tbody = tbody;
        },
        _scrollable: function() {
            var that = this, header, table, options = that.options, scrollable = options.scrollable, hasVirtualScroll = scrollable !== true && scrollable.virtual && !that.virtualScrollable, scrollbar = !kendo.support.kineticScrollNeeded || hasVirtualScroll ? kendo.support.scrollbar() : 0;
            if (scrollable) {
                header = that.wrapper.children(".k-grid-header");
                if (!header[0]) {
                    header = $('<div class="k-grid-header" />').insertBefore(that.table);
                }
                // workaround for IE issue where scroll is not raised if container is same width as the scrollbar
                header.css(isRtl ? "padding-left" : "padding-right", scrollable.virtual ? scrollbar + 1 : scrollbar);
                table = $('<table role="grid" cellspacing="0" />');
                table.append(that.thead);
                header.empty().append($('<div class="k-grid-header-wrap" />').append(table));
                that.content = that.table.parent();
                if (that.content.is(".k-virtual-scrollable-wrap")) {
                    that.content = that.content.parent();
                }
                if (!that.content.is(".k-grid-content, .k-virtual-scrollable-wrap")) {
                    that.content = that.table.wrap('<div class="k-grid-content" />').parent();
                }
                if (hasVirtualScroll) {
                    that.virtualScrollable = new VirtualScrollable(that.content, {
                        dataSource: that.dataSource,
                        itemHeight: proxy(that._averageRowHeight, that)
                    });
                }
                that.scrollables = header.children(".k-grid-header-wrap");
                // the footer may exists if rendered from the server
                var footer = that.wrapper.find(".k-grid-footer"), webKitRtlCorrection = isRtl && kendo.support.browser.webkit ? scrollbar : 0;
                if (footer.length) {
                    that.scrollables = that.scrollables.add(footer.children(".k-grid-footer-wrap"));
                }
                if (scrollable.virtual) {
                    that.content.find(">.k-virtual-scrollable-wrap").bind("scroll" + NS, function() {
                        that.scrollables.scrollLeft(this.scrollLeft + webKitRtlCorrection);
                    });
                } else {
                    that.content.bind("scroll" + NS, function() {
                        that.scrollables.scrollLeft(this.scrollLeft + webKitRtlCorrection);
                    });
                    var touchScroller = kendo.touchScroller(that.content);
                    if (touchScroller && touchScroller.movable) {
                        touchScroller.movable.bind("change", function(e) {
                            that.scrollables.scrollLeft(-e.sender.x);
                        });
                    }
                }
            }
        },
        _setContentHeight: function() {
            var that = this, options = that.options, height = that.wrapper.innerHeight(), header = that.wrapper.children(".k-grid-header"), scrollbar = kendo.support.scrollbar();
            if (options.scrollable) {
                height -= header.outerHeight();
                if (that.pager) {
                    height -= that.pager.element.outerHeight();
                }
                if (options.groupable) {
                    height -= that.wrapper.children(".k-grouping-header").outerHeight();
                }
                if (options.toolbar) {
                    height -= that.wrapper.children(".k-grid-toolbar").outerHeight();
                }
                if (that.footerTemplate) {
                    height -= that.wrapper.children(".k-grid-footer").outerHeight();
                }
                var isGridHeightSet = function(el) {
                    var initialHeight, newHeight;
                    if (el[0].style.height) {
                        return true;
                    } else {
                        initialHeight = el.height();
                    }
                    el.height("auto");
                    newHeight = el.height();
                    if (initialHeight != newHeight) {
                        el.height("");
                        return true;
                    }
                    el.height("");
                    return false;
                };
                if (isGridHeightSet(that.wrapper)) {
                    // set content height only if needed
                    if (height > scrollbar * 2) {
                        // do not set height if proper scrollbar cannot be displayed
                        that.content.height(height);
                    } else {
                        that.content.height(scrollbar * 2 + 1);
                    }
                }
            }
        },
        _averageRowHeight: function() {
            var that = this, rowHeight = that._rowHeight;
            if (!that._rowHeight) {
                that._rowHeight = rowHeight = that.table.outerHeight() / that.items().length;
                that._sum = rowHeight;
                that._measures = 1;
            }
            var currentRowHeight = that.table.outerHeight() / that.items().length;
            if (rowHeight !== currentRowHeight) {
                that._measures++;
                that._sum += currentRowHeight;
                that._rowHeight = that._sum / that._measures;
            }
            return rowHeight;
        },
        _dataSource: function() {
            var that = this, options = that.options, pageable, dataSource = options.dataSource;
            dataSource = isArray(dataSource) ? {
                data: dataSource
            } : dataSource;
            if (isPlainObject(dataSource)) {
                extend(dataSource, {
                    table: that.table,
                    fields: that.columns
                });
                pageable = options.pageable;
                if (isPlainObject(pageable) && pageable.pageSize !== undefined) {
                    dataSource.pageSize = pageable.pageSize;
                }
            }
            if (that.dataSource && that._refreshHandler) {
                that.dataSource.unbind(CHANGE, that._refreshHandler).unbind(PROGRESS, that._progressHandler).unbind(ERROR, that._errorHandler);
            } else {
                that._refreshHandler = proxy(that.refresh, that);
                that._progressHandler = proxy(that._requestStart, that);
                that._errorHandler = proxy(that._error, that);
            }
            that.dataSource = DataSource.create(dataSource).bind(CHANGE, that._refreshHandler).bind(PROGRESS, that._progressHandler).bind(ERROR, that._errorHandler);
        },
        _error: function() {
            this._progress(false);
        },
        _requestStart: function() {
            this._progress(true);
        },
        _modelChange: function(e) {
            var that = this, model = e.model, row = that.tbody.find("tr[" + kendo.attr("uid") + "=" + model.uid + "]"), cell, column, isAlt = row.hasClass("k-alt"), tmp, idx = that.items().index(row), length;
            if (row.children(".k-edit-cell").length && !that.options.rowTemplate) {
                row.children(":not(.k-group-cell,.k-hierarchy-cell)").each(function() {
                    cell = $(this);
                    column = that.columns[that.cellIndex(cell)];
                    if (column.field === e.field) {
                        if (!cell.hasClass("k-edit-cell")) {
                            that._displayCell(cell, column, model);
                            $('<span class="k-dirty"/>').prependTo(cell);
                        } else {
                            cell.addClass("k-dirty-cell");
                        }
                    }
                });
            } else if (!row.hasClass("k-grid-edit-row")) {
                tmp = (isAlt ? that.altRowTemplate : that.rowTemplate)(model);
                row.replaceWith(tmp);
                tmp = that.items().eq(idx);
                for (idx = 0, length = that.columns.length; idx < length; idx++) {
                    column = that.columns[idx];
                    if (column.field === e.field) {
                        cell = tmp.children(":not(.k-group-cell,.k-hierarchy-cell)").eq(idx);
                        $('<span class="k-dirty"/>').prependTo(cell);
                    }
                }
                that.trigger("itemChange", {
                    item: tmp,
                    data: model,
                    ns: ui
                });
            }
        },
        _pageable: function() {
            var that = this, wrapper, pageable = that.options.pageable;
            if (pageable) {
                wrapper = that.wrapper.children("div.k-grid-pager");
                if (!wrapper.length) {
                    wrapper = $('<div class="k-pager-wrap k-grid-pager"/>').appendTo(that.wrapper);
                }
                if (that.pager) {
                    that.pager.destroy();
                }
                if (typeof pageable === "object" && pageable instanceof kendo.ui.Pager) {
                    that.pager = pageable;
                } else {
                    that.pager = new kendo.ui.Pager(wrapper, extend({}, pageable, {
                        dataSource: that.dataSource
                    }));
                }
            }
        },
        _footer: function() {
            var that = this, aggregates = that.dataSource.aggregates(), html = "", footerTemplate = that.footerTemplate, options = that.options, footerWrap, footer = that.footer || that.wrapper.find(".k-grid-footer");
            if (footerTemplate) {
                aggregates = !isEmptyObject(aggregates) ? aggregates : buildEmptyAggregatesObject(that.dataSource.aggregate());
                html = $(that._wrapFooter(footerTemplate(aggregates)));
                if (footer.length) {
                    var tmp = html;
                    footer.replaceWith(tmp);
                    footer = that.footer = tmp;
                } else {
                    if (options.scrollable) {
                        footer = that.footer = options.pageable ? html.insertBefore(that.wrapper.children("div.k-grid-pager")) : html.appendTo(that.wrapper);
                    } else {
                        footer = that.footer = html.insertBefore(that.tbody);
                    }
                }
            } else if (footer && !that.footer) {
                that.footer = footer;
            }
            if (footer.length) {
                if (options.scrollable) {
                    footerWrap = footer.attr("tabindex", -1).children(".k-grid-footer-wrap");
                    that.scrollables = that.scrollables.not(".k-grid-footer-wrap").add(footerWrap);
                }
                if (that._footerWidth) {
                    footer.find("table").css("width", that._footerWidth);
                }
                if (footerWrap) {
                    footerWrap.scrollLeft(that.content.scrollLeft());
                }
            }
        },
        _wrapFooter: function(footerRow) {
            var that = this, html = "", scrollbar = !kendo.support.mobileOS ? kendo.support.scrollbar() : 0;
            if (that.options.scrollable) {
                html = $('<div class="k-grid-footer"><div class="k-grid-footer-wrap"><table cellspacing="0"><tbody>' + footerRow + "</tbody></table></div></div>");
                that._appendCols(html.find("table"));
                html.css(isRtl ? "padding-left" : "padding-right", scrollbar);
                // Update inner fix.
                return html;
            }
            return '<tfoot class="k-grid-footer">' + footerRow + "</tfoot>";
        },
        _columnMenu: function() {
            var that = this, menu, columns = that.columns, column, options = that.options, columnMenu = options.columnMenu, menuOptions, sortable, filterable, closeCallback = function() {
                focusTable(that.thead.parent(), true);
            }, initCallback = function(e) {
                that.trigger(COLUMNMENUINIT, {
                    field: e.field,
                    container: e.container
                });
            }, cell;
            if (columnMenu) {
                if (typeof columnMenu == "boolean") {
                    columnMenu = {};
                }
                that.thead.find("th:not(.k-hierarchy-cell,.k-group-cell)").each(function(index) {
                    column = columns[index];
                    cell = $(this);
                    if (!column.command && (column.field || cell.attr("data-" + kendo.ns + "field"))) {
                        menu = cell.data("kendoColumnMenu");
                        if (menu) {
                            menu.destroy();
                        }
                        sortable = column.sortable !== false && columnMenu.sortable !== false ? options.sortable : false;
                        filterable = options.filterable && column.filterable !== false && columnMenu.filterable !== false ? extend({}, column.filterable, options.filterable) : false;
                        menuOptions = {
                            dataSource: that.dataSource,
                            values: column.values,
                            columns: columnMenu.columns,
                            sortable: sortable,
                            filterable: filterable,
                            messages: columnMenu.messages,
                            owner: that,
                            closeCallback: closeCallback,
                            init: initCallback
                        };
                        cell.kendoColumnMenu(menuOptions);
                    }
                });
            }
        },
        _filterable: function() {
            var that = this, columns = that.columns, cell, filterMenu, closeCallback = function() {
                focusTable(that.thead.parent(), true);
            }, filterable = that.options.filterable;
            if (filterable && !that.options.columnMenu) {
                that.thead.find("th:not(.k-hierarchy-cell,.k-group-cell)").each(function(index) {
                    cell = $(this);
                    if (columns[index].filterable !== false && !columns[index].command && (columns[index].field || cell.attr("data-" + kendo.ns + "field"))) {
                        filterMenu = cell.data("kendoFilterMenu");
                        if (filterMenu) {
                            filterMenu.destroy();
                        }
                        cell.kendoFilterMenu(extend(true, {}, filterable, columns[index].filterable, {
                            dataSource: that.dataSource,
                            values: columns[index].values,
                            closeCallback: closeCallback,
                            init: function(e) {
                                that.trigger(FILTERMENUINIT, {
                                    field: e.field,
                                    container: e.container
                                });
                            }
                        }));
                    }
                });
            }
        },
        _sortable: function() {
            var that = this, columns = that.columns, column, cell, sortableInstance, sortable = that.options.sortable;
            if (sortable) {
                that.thead.find("th:not(.k-hierarchy-cell,.k-group-cell)").each(function(index) {
                    column = columns[index];
                    if (column.sortable !== false && !column.command && column.field) {
                        cell = $(this);
                        sortableInstance = cell.data("kendoSortable");
                        if (sortableInstance) {
                            sortableInstance.destroy();
                        }
                        cell.attr("data-" + kendo.ns + "field", column.field).kendoSortable(extend({}, sortable, {
                            dataSource: that.dataSource,
                            aria: true
                        }));
                    }
                });
            }
        },
        _columns: function(columns) {
            var that = this, table = that.table, encoded, cols = table.find("col"), dataSource = that.options.dataSource;
            // using HTML5 data attributes as a configuration option e.g. <th data-field="foo">Foo</foo>
            columns = columns.length ? columns : map(table.find("th"), function(th, idx) {
                th = $(th);
                var sortable = th.attr(kendo.attr("sortable")), filterable = th.attr(kendo.attr("filterable")), type = th.attr(kendo.attr("type")), groupable = th.attr(kendo.attr("groupable")), field = th.attr(kendo.attr("field")), menu = th.attr(kendo.attr("menu"));
                if (!field) {
                    field = th.text().replace(/\s|[^A-z0-9]/g, "");
                }
                return {
                    field: field,
                    type: type,
                    sortable: sortable !== "false",
                    filterable: filterable !== "false",
                    groupable: groupable !== "false",
                    menu: menu,
                    template: th.attr(kendo.attr("template")),
                    width: cols.eq(idx).css("width")
                };
            });
            encoded = !(that.table.find("tbody tr").length > 0 && (!dataSource || !dataSource.transport));
            that.columns = map(columns, function(column) {
                column = typeof column === STRING ? {
                    field: column
                } : column;
                if (column.hidden) {
                    column.attributes = addHiddenStyle(column.attributes);
                    column.footerAttributes = addHiddenStyle(column.footerAttributes);
                    column.headerAttributes = addHiddenStyle(column.headerAttributes);
                }
                return extend({
                    encoded: encoded
                }, column);
            });
        },
        _groups: function() {
            var group = this.dataSource.group();
            return group ? group.length : 0;
        },
        _tmpl: function(rowTemplate, alt) {
            var that = this, settings = extend({}, kendo.Template, that.options.templateSettings), idx, length = that.columns.length, template, state = {
                storage: {},
                count: 0
            }, column, type, hasDetails = that._hasDetails(), className = [], groups = that._groups();
            if (!rowTemplate) {
                rowTemplate = "<tr";
                if (alt) {
                    className.push("k-alt");
                }
                if (hasDetails) {
                    className.push("k-master-row");
                }
                if (className.length) {
                    rowTemplate += ' class="' + className.join(" ") + '"';
                }
                if (length) {
                    // data item is an object
                    rowTemplate += " " + kendo.attr("uid") + '="#=' + kendo.expr("uid", settings.paramName) + '#"';
                }
                rowTemplate += " role='row'>";
                if (groups > 0) {
                    rowTemplate += groupCells(groups);
                }
                if (hasDetails) {
                    rowTemplate += '<td class="k-hierarchy-cell"><a class="k-icon k-plus" href="\\#" tabindex="-1"></a></td>';
                }
                for (idx = 0; idx < length; idx++) {
                    column = that.columns[idx];
                    template = column.template;
                    type = typeof template;
                    rowTemplate += "<td" + stringifyAttributes(column.attributes) + " role='gridcell'>";
                    rowTemplate += that._cellTmpl(column, state);
                    rowTemplate += "</td>";
                }
                rowTemplate += "</tr>";
            }
            rowTemplate = kendo.template(rowTemplate, settings);
            if (state.count > 0) {
                return proxy(rowTemplate, state.storage);
            }
            return rowTemplate;
        },
        _headerCellText: function(column) {
            var that = this, settings = extend({}, kendo.Template, that.options.templateSettings), template = column.headerTemplate, type = typeof template, text = column.title || column.field || "";
            if (type === FUNCTION) {
                text = kendo.template(template, settings)({});
            } else if (type === STRING) {
                text = template;
            }
            return text;
        },
        _cellTmpl: function(column, state) {
            var that = this, settings = extend({}, kendo.Template, that.options.templateSettings), template = column.template, paramName = settings.paramName, field = column.field, html = "", idx, length, format = column.format, type = typeof template, columnValues = column.values;
            if (column.command) {
                if (isArray(column.command)) {
                    for (idx = 0, length = column.command.length; idx < length; idx++) {
                        html += that._createButton(column.command[idx]);
                    }
                    return html.replace(templateHashRegExp, "\\#");
                }
                return that._createButton(column.command).replace(templateHashRegExp, "\\#");
            }
            if (type === FUNCTION) {
                state.storage["tmpl" + state.count] = template;
                html += "#=this.tmpl" + state.count + "(" + paramName + ")#";
                state.count++;
            } else if (type === STRING) {
                html += template;
            } else if (columnValues && columnValues.length && isPlainObject(columnValues[0]) && "value" in columnValues[0] && field) {
                html += "#var v =" + kendo.stringify(convertToObject(columnValues)) + "#";
                html += "#var f = v[";
                if (!settings.useWithBlock) {
                    html += paramName + ".";
                }
                html += field + "]#";
                html += "${f != null ? f : ''}";
            } else {
                html += column.encoded ? "#:" : "#=";
                if (format) {
                    html += 'kendo.format("' + format.replace(formatRegExp, "\\$1") + '",';
                }
                if (field) {
                    field = kendo.expr(field, paramName);
                    html += field + "==null?'':" + field;
                } else {
                    html += "''";
                }
                if (format) {
                    html += ")";
                }
                html += "#";
            }
            return html;
        },
        _templates: function() {
            var that = this, options = that.options, dataSource = that.dataSource, groups = dataSource.group(), footer = that.footer || that.wrapper.find(".k-grid-footer"), aggregates = dataSource.aggregate();
            that.rowTemplate = that._tmpl(options.rowTemplate);
            that.altRowTemplate = that._tmpl(options.altRowTemplate || options.rowTemplate, true);
            if (that._hasDetails()) {
                that.detailTemplate = that._detailTmpl(options.detailTemplate || "");
            }
            if (that._group && !isEmptyObject(aggregates) || !isEmptyObject(aggregates) && !footer.length || grep(that.columns, function(column) {
                return column.footerTemplate;
            }).length) {
                that.footerTemplate = that._footerTmpl(aggregates, "footerTemplate", "k-footer-template");
            }
            if (groups && grep(that.columns, function(column) {
                return column.groupFooterTemplate;
            }).length) {
                aggregates = $.map(groups, function(g) {
                    return g.aggregates;
                });
                that.groupFooterTemplate = that._footerTmpl(aggregates, "groupFooterTemplate", "k-group-footer");
            }
        },
        _footerTmpl: function(aggregates, templateName, rowClass) {
            var that = this, settings = extend({}, kendo.Template, that.options.templateSettings), paramName = settings.paramName, html = "", idx, length, columns = that.columns, template, type, storage = {}, count = 0, scope = {}, groups = that._groups(), fieldsMap = buildEmptyAggregatesObject(aggregates), column;
            html += '<tr class="' + rowClass + '">';
            if (groups > 0) {
                html += groupCells(groups);
            }
            if (that._hasDetails()) {
                html += '<td class="k-hierarchy-cell">&nbsp;</td>';
            }
            for (idx = 0, length = that.columns.length; idx < length; idx++) {
                column = columns[idx];
                template = column[templateName];
                type = typeof template;
                html += "<td" + stringifyAttributes(column.footerAttributes) + ">";
                if (template) {
                    if (type !== FUNCTION) {
                        scope = fieldsMap[column.field] ? extend({}, settings, {
                            paramName: paramName + "." + column.field
                        }) : {};
                        template = kendo.template(template, scope);
                    }
                    storage["tmpl" + count] = template;
                    html += "#=this.tmpl" + count + "(" + paramName + ")#";
                    count++;
                } else {
                    html += "&nbsp;";
                }
                html += "</td>";
            }
            html += "</tr>";
            html = kendo.template(html, settings);
            if (count > 0) {
                return proxy(html, storage);
            }
            return html;
        },
        _detailTmpl: function(template) {
            var that = this, html = "", settings = extend({}, kendo.Template, that.options.templateSettings), paramName = settings.paramName, templateFunctionStorage = {}, templateFunctionCount = 0, groups = that._groups(), colspan = visibleColumns(that.columns).length, type = typeof template;
            html += '<tr class="k-detail-row">';
            if (groups > 0) {
                html += groupCells(groups);
            }
            html += '<td class="k-hierarchy-cell"></td><td class="k-detail-cell"' + (colspan ? ' colspan="' + colspan + '"' : "") + ">";
            if (type === FUNCTION) {
                templateFunctionStorage["tmpl" + templateFunctionCount] = template;
                html += "#=this.tmpl" + templateFunctionCount + "(" + paramName + ")#";
                templateFunctionCount++;
            } else {
                html += template;
            }
            html += "</td></tr>";
            html = kendo.template(html, settings);
            if (templateFunctionCount > 0) {
                return proxy(html, templateFunctionStorage);
            }
            return html;
        },
        _hasDetails: function() {
            var that = this;
            return that.options.detailTemplate !== null || (that._events[DETAILINIT] || []).length;
        },
        _details: function() {
            var that = this;
            that.table.on(CLICK + NS, ".k-hierarchy-cell .k-plus, .k-hierarchy-cell .k-minus", function(e) {
                var button = $(this), expanding = button.hasClass("k-plus"), masterRow = button.closest("tr.k-master-row"), detailRow, detailTemplate = that.detailTemplate, data, hasDetails = that._hasDetails();
                button.toggleClass("k-plus", !expanding).toggleClass("k-minus", expanding);
                if (hasDetails && !masterRow.next().hasClass("k-detail-row")) {
                    data = that.dataItem(masterRow);
                    $(detailTemplate(data)).addClass(masterRow.hasClass("k-alt") ? "k-alt" : "").insertAfter(masterRow);
                    that.trigger(DETAILINIT, {
                        masterRow: masterRow,
                        detailRow: masterRow.next(),
                        data: data,
                        detailCell: masterRow.next().find(".k-detail-cell")
                    });
                }
                detailRow = masterRow.next();
                that.trigger(expanding ? DETAILEXPAND : DETAILCOLLAPSE, {
                    masterRow: masterRow,
                    detailRow: detailRow
                });
                detailRow.toggle(expanding);
                if (that._current) {
                    that._current.attr("aria-expanded", expanding);
                }
                e.preventDefault();
                return false;
            });
        },
        dataItem: function(tr) {
            return this._data[this.tbody.find("> tr:not(.k-grouping-row,.k-detail-row,.k-group-footer)").index($(tr))];
        },
        expandRow: function(tr) {
            $(tr).find("> td .k-plus, > td .k-i-expand").click();
        },
        collapseRow: function(tr) {
            $(tr).find("> td .k-minus, > td .k-i-collapse").click();
        },
        _thead: function() {
            var that = this, columns = that.columns, hasDetails = that._hasDetails() && columns.length, idx, length, html = "", thead = that.table.find(">thead"), tr, text, th;
            if (!thead.length) {
                thead = $("<thead/>").insertBefore(that.tbody);
            }
            tr = that.element.find("tr:has(th):first");
            if (!tr.length) {
                tr = thead.children().first();
                if (!tr.length) {
                    tr = $("<tr/>");
                }
            }
            if (!tr.children().length) {
                if (hasDetails) {
                    html += '<th class="k-hierarchy-cell">&nbsp;</th>';
                }
                for (idx = 0, length = columns.length; idx < length; idx++) {
                    th = columns[idx];
                    text = that._headerCellText(th);
                    if (!th.command) {
                        html += "<th role='columnheader' " + kendo.attr("field") + "='" + (th.field || "") + "' ";
                        if (th.title) {
                            html += kendo.attr("title") + '="' + th.title.replace(/'/g, "'") + '" ';
                        }
                        if (th.groupable !== undefined) {
                            html += kendo.attr("groupable") + "='" + th.groupable + "' ";
                        }
                        if (th.aggregates) {
                            html += kendo.attr("aggregates") + "='" + th.aggregates + "'";
                        }
                        html += stringifyAttributes(th.headerAttributes);
                        html += ">" + text + "</th>";
                    } else {
                        html += "<th" + stringifyAttributes(th.headerAttributes) + ">" + text + "</th>";
                    }
                }
                tr.html(html);
            } else if (hasDetails && !tr.find(".k-hierarchy-cell")[0]) {
                tr.prepend('<th class="k-hierarchy-cell">&nbsp;</th>');
            }
            tr.find("th").addClass("k-header");
            if (!that.options.scrollable) {
                thead.addClass("k-grid-header");
            }
            tr.find("script").remove().end().appendTo(thead);
            if (that.thead) {
                that._destroyColumnAttachments();
            }
            that.thead = thead;
            that._sortable();
            that._filterable();
            that._scrollable();
            that._updateCols();
            that._resizable();
            that._draggable();
            that._reorderable();
            if (that.groupable) {
                that._attachGroupable();
            }
            that._columnMenu();
        },
        _updateCols: function() {
            var that = this;
            that._appendCols(that.thead.parent().add(that.table));
        },
        _appendCols: function(table) {
            var that = this;
            normalizeCols(table, visibleColumns(that.columns), that._hasDetails(), that._groups());
        },
        _autoColumns: function(schema) {
            if (schema && schema.toJSON) {
                var that = this, field;
                schema = schema.toJSON();
                for (field in schema) {
                    that.columns.push({
                        field: field
                    });
                }
                that._thead();
                that._templates();
            }
        },
        _rowsHtml: function(data) {
            var that = this, html = "", idx, length, rowTemplate = that.rowTemplate, altRowTemplate = that.altRowTemplate;
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (idx % 2) {
                    html += altRowTemplate(data[idx]);
                } else {
                    html += rowTemplate(data[idx]);
                }
                that._data.push(data[idx]);
            }
            return html;
        },
        _groupRowHtml: function(group, colspan, level) {
            var that = this, html = "", idx, length, field = group.field, column = grep(that.columns, function(column) {
                return column.field == field;
            })[0] || {}, template = column.groupHeaderTemplate, text = (column.title || field) + ": " + formatGroupValue(group.value, column.format, column.values), data = extend({}, {
                field: group.field,
                value: group.value
            }, group.aggregates[group.field]), footerDefaults = that._groupAggregatesDefaultObject || {}, groupItems = group.items;
            if (template) {
                text = typeof template === FUNCTION ? template(data) : kendo.template(template)(data);
            }
            html += '<tr class="k-grouping-row">' + groupCells(level) + '<td colspan="' + colspan + '" aria-expanded="true">' + '<p class="k-reset">' + '<a class="k-icon k-i-collapse" href="#" tabindex="-1"></a>' + text + "</p></td></tr>";
            if (group.hasSubgroups) {
                for (idx = 0, length = groupItems.length; idx < length; idx++) {
                    html += that._groupRowHtml(groupItems[idx], colspan - 1, level + 1);
                }
            } else {
                html += that._rowsHtml(groupItems);
            }
            if (that.groupFooterTemplate) {
                html += that.groupFooterTemplate(extend(footerDefaults, group.aggregates));
            }
            return html;
        },
        collapseGroup: function(group) {
            group = $(group).find(".k-icon").addClass("k-i-expand").removeClass("k-i-collapse").end();
            var level = group.find(".k-group-cell").length, footerCount = 1, offset, tr;
            group.find("td:first").attr("aria-expanded", false);
            group.nextAll("tr").each(function() {
                tr = $(this);
                offset = tr.find(".k-group-cell").length;
                if (tr.hasClass("k-grouping-row")) {
                    footerCount++;
                } else if (tr.hasClass("k-group-footer")) {
                    footerCount--;
                }
                if (offset <= level || tr.hasClass("k-group-footer") && footerCount < 0) {
                    return false;
                }
                tr.hide();
            });
        },
        expandGroup: function(group) {
            group = $(group).find(".k-icon").addClass("k-i-collapse").removeClass("k-i-expand").end();
            var that = this, level = group.find(".k-group-cell").length, tr, offset, groupsCount = 1;
            group.find("td:first").attr("aria-expanded", true);
            group.nextAll("tr").each(function() {
                tr = $(this);
                offset = tr.find(".k-group-cell").length;
                if (offset <= level) {
                    return false;
                }
                if (offset == level + 1 && !tr.hasClass("k-detail-row")) {
                    tr.show();
                    if (tr.hasClass("k-grouping-row") && tr.find(".k-icon").hasClass("k-i-collapse")) {
                        that.expandGroup(tr);
                    }
                    if (tr.hasClass("k-master-row") && tr.find(".k-icon").hasClass("k-minus")) {
                        tr.next().show();
                    }
                }
                if (tr.hasClass("k-grouping-row")) {
                    groupsCount++;
                }
                if (tr.hasClass("k-group-footer")) {
                    if (groupsCount == 1) {
                        tr.show();
                    } else {
                        groupsCount--;
                    }
                }
            });
        },
        _updateHeader: function(groups) {
            var that = this, cells = that.thead.find("th.k-group-cell"), length = cells.length;
            if (groups > length) {
                $(new Array(groups - length + 1).join('<th class="k-group-cell k-header">&nbsp;</th>')).prependTo(that.thead.find("tr"));
            } else if (groups < length) {
                length = length - groups;
                $(grep(cells, function(item, index) {
                    return length > index;
                })).remove();
            }
        },
        _firstDataItem: function(data, grouped) {
            if (data && grouped) {
                if (data.hasSubgroups) {
                    data = this._firstDataItem(data.items[0], grouped);
                } else {
                    data = data.items[0];
                }
            }
            return data;
        },
        hideColumn: function(column) {
            var that = this, rows, row, cell, tables, idx, cols, colWidth, width = 0, length, footer = that.footer || that.wrapper.find(".k-grid-footer"), columns = that.columns, columnIndex, browser = kendo.support.browser;
            if (typeof column == "number") {
                column = columns[column];
            } else {
                column = grep(columns, function(item) {
                    return item.field === column;
                })[0];
            }
            if (!column || column.hidden) {
                return;
            }
            columnIndex = inArray(column, visibleColumns(columns));
            column.hidden = true;
            column.attributes = addHiddenStyle(column.attributes);
            column.footerAttributes = addHiddenStyle(column.footerAttributes);
            column.headerAttributes = addHiddenStyle(column.headerAttributes);
            that._templates();
            that._updateCols();
            that.thead.find(">tr>th:not(.k-hierarchy-cell,.k-group-cell):visible").eq(columnIndex).hide();
            if (footer) {
                that._appendCols(footer.find("table:first"));
                footer.find(".k-footer-template>td:not(.k-hierarchy-cell,.k-group-cell):visible").eq(columnIndex).hide();
            }
            rows = that.tbody.children();
            for (idx = 0, length = rows.length; idx < length; idx += 1) {
                row = rows.eq(idx);
                if (row.is(".k-grouping-row,.k-detail-row")) {
                    cell = row.children(":not(.k-group-cell):first,.k-detail-cell").last();
                    cell.attr("colspan", parseInt(cell.attr("colspan"), 10) - 1);
                } else {
                    if (row.hasClass("k-grid-edit-row") && (cell = row.children(".k-edit-container")[0])) {
                        cell = $(cell);
                        cell.attr("colspan", parseInt(cell.attr("colspan"), 10) - 1);
                        cell.find("col").eq(columnIndex).remove();
                        row = cell.find("tr:first");
                    }
                    setCellVisibility(row[0].cells, columnIndex, false);
                }
            }
            cols = that.thead.prev().find("col");
            for (idx = 0, length = cols.length; idx < length; idx += 1) {
                colWidth = cols[idx].style.width;
                if (colWidth && colWidth.indexOf("%") == -1) {
                    width += parseInt(colWidth, 10);
                } else {
                    width = 0;
                    break;
                }
            }
            tables = $(">.k-grid-header table:first,>.k-grid-footer table:first", that.wrapper).add(that.table);
            that._footerWidth = null;
            if (width) {
                tables.width(width);
                that._footerWidth = width;
            }
            if (browser.msie && browser.version == 8) {
                tables.css("display", "inline-table");
                setTimeout(function() {
                    tables.css("display", "table");
                }, 1);
            }
            that.trigger(COLUMNHIDE, {
                column: column
            });
        },
        showColumn: function(column) {
            var that = this, rows, idx, length, row, cell, tables, width, colWidth, cols, columns = that.columns, footer = that.footer || that.wrapper.find(".k-grid-footer"), columnIndex;
            if (typeof column == "number") {
                column = columns[column];
            } else {
                column = grep(columns, function(item) {
                    return item.field === column;
                })[0];
            }
            if (!column || !column.hidden) {
                return;
            }
            columnIndex = inArray(column, columns);
            column.hidden = false;
            column.attributes = removeHiddenStyle(column.attributes);
            column.footerAttributes = removeHiddenStyle(column.footerAttributes);
            column.headerAttributes = removeHiddenStyle(column.headerAttributes);
            that._templates();
            that._updateCols();
            that.thead.find(">tr>th:not(.k-hierarchy-cell,.k-group-cell)").eq(columnIndex).show();
            if (footer) {
                that._appendCols(footer.find("table:first"));
                footer.find(".k-footer-template>td:not(.k-hierarchy-cell,.k-group-cell)").eq(columnIndex).show();
            }
            rows = that.tbody.children();
            for (idx = 0, length = rows.length; idx < length; idx += 1) {
                row = rows.eq(idx);
                if (row.is(".k-grouping-row,.k-detail-row")) {
                    cell = row.children(":not(.k-group-cell):first,.k-detail-cell").last();
                    cell.attr("colspan", parseInt(cell.attr("colspan"), 10) + 1);
                } else {
                    if (row.hasClass("k-grid-edit-row") && (cell = row.children(".k-edit-container")[0])) {
                        cell = $(cell);
                        cell.attr("colspan", parseInt(cell.attr("colspan"), 10) + 1);
                        normalizeCols(cell.find(">form>table"), visibleColumns(columns), false, 0);
                        row = cell.find("tr:first");
                    }
                    setCellVisibility(row[0].cells, columnIndex, true);
                }
            }
            tables = $(">.k-grid-header table:first,>.k-grid-footer table:first", that.wrapper).add(that.table);
            if (!column.width) {
                tables.width("");
            } else {
                width = 0;
                cols = that.thead.prev().find("col");
                for (idx = 0, length = cols.length; idx < length; idx += 1) {
                    colWidth = cols[idx].style.width;
                    if (colWidth.indexOf("%") > -1) {
                        width = 0;
                        break;
                    }
                    width += parseInt(colWidth, 10);
                }
                that._footerWidth = null;
                if (width) {
                    tables.width(width);
                    that._footerWidth = width;
                }
            }
            that.trigger(COLUMNSHOW, {
                column: column
            });
        },
        _progress: function(toggle) {
            var that = this, element = that.element.is("table") ? that.element.parent() : that.content && that.content.length ? that.content : that.element;
            kendo.ui.progress(element, toggle);
        },
        refresh: function(e) {
            var that = this, length, idx, html = "", data = that.dataSource.view(), navigatable = that.options.navigatable, tbody, placeholder, currentIndex, current = $(that.current()), isCurrentInHeader = false, groups = (that.dataSource.group() || []).length, colspan = groups + visibleColumns(that.columns).length, active;
            if (e && e.action === "itemchange" && that.editable) {
                // skip rebinding if editing is in progress
                return;
            }
            e = e || {};
            if (that.trigger("dataBinding", {
                action: e.action || "rebind",
                index: e.index,
                items: e.items
            })) {
                return;
            }
            active = activeElement();
            if (navigatable && (that.table[0] === active || $.contains(that.table[0], active) || that._editContainer && that._editContainer.data("kendoWindow"))) {
                isCurrentInHeader = current.is("th");
                currentIndex = 0;
                if (isCurrentInHeader) {
                    currentIndex = that.thead.find("th:not(.k-group-cell)").index(current);
                }
            }
            that._destroyEditable();
            that._progress(false);
            that._data = [];
            if (!that.columns.length) {
                that._autoColumns(that._firstDataItem(data[0], groups));
                colspan = groups + that.columns.length;
            }
            that._group = groups > 0 || that._group;
            if (that._group) {
                that._templates();
                that._updateCols();
                that._updateHeader(groups);
                that._group = groups > 0;
            }
            if (groups > 0) {
                if (that.detailTemplate) {
                    colspan++;
                }
                if (that.groupFooterTemplate) {
                    that._groupAggregatesDefaultObject = buildEmptyAggregatesObject(that.dataSource.aggregate());
                }
                for (idx = 0, length = data.length; idx < length; idx++) {
                    html += that._groupRowHtml(data[idx], colspan, 0);
                }
            } else {
                html += that._rowsHtml(data);
            }
            if (tbodySupportsInnerHtml) {
                that.tbody[0].innerHTML = html;
            } else {
                placeholder = document.createElement("div");
                placeholder.innerHTML = "<table><tbody>" + html + "</tbody></table>";
                tbody = placeholder.firstChild.firstChild;
                that.table[0].replaceChild(tbody, that.tbody[0]);
                that.tbody = $(tbody);
            }
            that._footer();
            that._setContentHeight();
            if (currentIndex >= 0) {
                that._removeCurrent();
                if (!isCurrentInHeader) {
                    that.current(that.items().eq(currentIndex).children().filter(DATA_CELL).first());
                } else {
                    that.current(that.thead.find("th:not(.k-group-cell)").eq(currentIndex));
                }
                if (that._current) {
                    focusTable(that._current.closest("table")[0], true);
                }
            }
            that.trigger(DATABOUND);
        }
    });
    function getCommand(commands, name) {
        var idx, length, command;
        if (typeof commands === STRING && commands === name) {
            return commands;
        }
        if (isPlainObject(commands) && commands.name === name) {
            return commands;
        }
        if (isArray(commands)) {
            for (idx = 0, length = commands.length; idx < length; idx++) {
                command = commands[idx];
                if (typeof command === STRING && command === name || command.name === name) {
                    return command;
                }
            }
        }
        return null;
    }
    function focusTable(table, direct) {
        var msie = kendo.support.browser.msie;
        if (direct === true) {
            table = $(table);
            var condition = msie && table.parent().is(".k-grid-content,.k-grid-header-wrap"), scrollTop, scrollLeft;
            if (condition) {
                scrollTop = table.parent().scrollTop();
                scrollLeft = table.parent().scrollLeft();
            }
            if (msie) {
                try {
                    //The setActive method does not cause the document to scroll to the active object in the current page
                    table[0].setActive();
                } catch (e) {
                    table[0].focus();
                }
            } else {
                table[0].focus();
            }
            if (condition) {
                table.parent().scrollTop(scrollTop);
                table.parent().scrollLeft(scrollLeft);
            }
        } else {
            $(table).one("focusin", function(e) {
                e.preventDefault();
            }).focus();
        }
    }
    function tableClick(e) {
        var currentTarget = $(e.currentTarget), isHeader = currentTarget.is("th"), currentTable = currentTarget.closest("table")[0];
        if (currentTable !== this.table[0] && currentTable !== this.thead.parent()[0]) {
            return;
        }
        this.current(currentTarget);
        if (isHeader || !$(e.target).is(":button,a,:input,a>.k-icon,textarea,span.k-icon,.k-input")) {
            setTimeout(function() {
                //DOMElement.focus() only for header, because IE doesn't really focus the table
                focusTable(currentTable, true);
            });
        }
        if (isHeader) {
            e.preventDefault();
        }
    }
    ui.plugin(Grid);
    ui.plugin(VirtualScrollable);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, CHANGE = "change", CANCEL = "cancel", DATABOUND = "dataBound", DATABINDING = "dataBinding", Widget = kendo.ui.Widget, keys = kendo.keys, FOCUSSELECTOR = ">*", PROGRESS = "progress", ERROR = "error", FOCUSED = "k-state-focused", SELECTED = "k-state-selected", KEDITITEM = "k-edit-item", STRING = "string", EDIT = "edit", REMOVE = "remove", SAVE = "save", CLICK = "click", NS = ".kendoListView", proxy = $.proxy, activeElement = kendo._activeElement, progress = kendo.ui.progress, DataSource = kendo.data.DataSource;
    var ListView = Widget.extend({
        init: function(element, options) {
            var that = this;
            options = $.isArray(options) ? {
                dataSource: options
            } : options;
            Widget.fn.init.call(that, element, options);
            options = that.options;
            that.wrapper = element = that.element;
            if (element[0].id) {
                that._itemId = element[0].id + "_lv_active";
            }
            that._element();
            that._dataSource();
            that.template = kendo.template(options.template || "");
            that.altTemplate = kendo.template(options.altTemplate || options.template);
            that.editTemplate = kendo.template(options.editTemplate || "");
            that._navigatable();
            that._selectable();
            that._pageable();
            that._crudHandlers();
            if (that.options.autoBind) {
                that.dataSource.fetch();
            }
            kendo.notify(that);
        },
        events: [ CHANGE, CANCEL, DATABINDING, DATABOUND, EDIT, REMOVE, SAVE ],
        options: {
            name: "ListView",
            autoBind: true,
            selectable: false,
            navigatable: false,
            template: "",
            altTemplate: "",
            editTemplate: ""
        },
        _item: function(action) {
            return this.element.children()[action]();
        },
        items: function() {
            return this.element.children();
        },
        setDataSource: function(dataSource) {
            this.options.dataSource = dataSource;
            this._dataSource();
            if (this.options.autoBind) {
                dataSource.fetch();
            }
        },
        _unbindDataSource: function() {
            var that = this;
            that.dataSource.unbind(CHANGE, that._refreshHandler).unbind(PROGRESS, that._progressHandler).unbind(ERROR, that._errorHandler);
        },
        _dataSource: function() {
            var that = this;
            if (that.dataSource && that._refreshHandler) {
                that._unbindDataSource();
            } else {
                that._refreshHandler = proxy(that.refresh, that);
                that._progressHandler = proxy(that._progress, that);
                that._errorHandler = proxy(that._error, that);
            }
            that.dataSource = DataSource.create(that.options.dataSource).bind(CHANGE, that._refreshHandler).bind(PROGRESS, that._progressHandler).bind(ERROR, that._errorHandler);
        },
        _progress: function() {
            progress(this.element, true);
        },
        _error: function() {
            progress(this.element, false);
        },
        _element: function() {
            this.element.addClass("k-widget k-listview").attr("role", "listbox");
        },
        refresh: function(e) {
            var that = this, view = that.dataSource.view(), data, items, item, html = "", idx, length, template = that.template, altTemplate = that.altTemplate, active = activeElement();
            if (e && e.action === "itemchange") {
                if (!that.editable) {
                    data = e.items[0];
                    idx = $.inArray(data, view);
                    if (idx >= 0) {
                        that.items().eq(idx).replaceWith(template(data));
                        item = that.items().eq(idx);
                        item.attr(kendo.attr("uid"), data.uid);
                        that.trigger("itemChange", {
                            item: item,
                            data: data
                        });
                    }
                }
                return;
            }
            e = e || {};
            if (that.trigger(DATABINDING, {
                action: e.action || "rebind",
                items: e.items,
                index: e.index
            })) {
                return;
            }
            that._destroyEditable();
            for (idx = 0, length = view.length; idx < length; idx++) {
                if (idx % 2) {
                    html += altTemplate(view[idx]);
                } else {
                    html += template(view[idx]);
                }
            }
            that.element.html(html);
            items = that.items();
            for (idx = 0, length = view.length; idx < length; idx++) {
                items.eq(idx).attr(kendo.attr("uid"), view[idx].uid).attr("role", "option").attr("aria-selected", "false");
            }
            if (that.element[0] === active && that.options.navigatable) {
                that.current(items.eq(0));
            }
            that.trigger(DATABOUND);
        },
        _pageable: function() {
            var that = this, pageable = that.options.pageable, settings, pagerId;
            if ($.isPlainObject(pageable)) {
                pagerId = pageable.pagerId;
                settings = $.extend({}, pageable, {
                    dataSource: that.dataSource,
                    pagerId: null
                });
                that.pager = new kendo.ui.Pager($("#" + pagerId), settings);
            }
        },
        _selectable: function() {
            var that = this, multi, current, selectable = that.options.selectable, navigatable = that.options.navigatable;
            if (selectable) {
                multi = typeof selectable === STRING && selectable.toLowerCase().indexOf("multiple") > -1;
                if (multi) {
                    that.element.attr("aria-multiselectable", true);
                }
                that.selectable = new kendo.ui.Selectable(that.element, {
                    aria: true,
                    multiple: multi,
                    filter: FOCUSSELECTOR,
                    change: function() {
                        that.trigger(CHANGE);
                    }
                });
                if (navigatable) {
                    that.element.on("keydown" + NS, function(e) {
                        if (e.keyCode === keys.SPACEBAR) {
                            current = that.current();
                            if (e.target == e.currentTarget) {
                                e.preventDefault();
                            }
                            if (multi) {
                                if (!e.ctrlKey) {
                                    that.selectable.clear();
                                } else {
                                    if (current && current.hasClass(SELECTED)) {
                                        current.removeClass(SELECTED);
                                        return;
                                    }
                                }
                            } else {
                                that.selectable.clear();
                            }
                            that.selectable.value(current);
                        }
                    });
                }
            }
        },
        current: function(candidate) {
            var that = this, element = that.element, current = that._current, id = that._itemId;
            if (candidate === undefined) {
                return current;
            }
            if (current) {
                if (current[0].id === id) {
                    current.removeAttr("id");
                }
                current.removeClass(FOCUSED);
                element.removeAttr("aria-activedescendant");
            }
            if (candidate && candidate[0]) {
                id = candidate[0].id || id;
                that._scrollTo(candidate[0]);
                element.attr("aria-activedescendant", id);
                candidate.addClass(FOCUSED).attr("id", id);
            }
            that._current = candidate;
        },
        _scrollTo: function(element) {
            var that = this, container, UseJQueryoffset = false, SCROLL = "scroll";
            if (that.wrapper.css("overflow") == "auto" || that.wrapper.css("overflow") == SCROLL) {
                container = that.wrapper[0];
            } else {
                container = window;
                UseJQueryoffset = true;
            }
            var scrollDirectionFunc = function(direction, dimension) {
                var elementOffset = UseJQueryoffset ? $(element).offset()[direction.toLowerCase()] : element["offset" + direction], elementDimension = element["client" + dimension], containerScrollAmount = $(container)[SCROLL + direction](), containerDimension = $(container)[dimension.toLowerCase()]();
                if (elementOffset + elementDimension > containerScrollAmount + containerDimension) {
                    $(container)[SCROLL + direction](elementOffset + elementDimension - containerDimension);
                } else if (elementOffset < containerScrollAmount) {
                    $(container)[SCROLL + direction](elementOffset);
                }
            };
            scrollDirectionFunc("Top", "Height");
            scrollDirectionFunc("Left", "Width");
        },
        _navigatable: function() {
            var that = this, navigatable = that.options.navigatable, element = that.element, clickCallback = function(e) {
                that.current($(e.currentTarget));
                if (!$(e.target).is(":button,a,:input,a>.k-icon,textarea")) {
                    element.focus();
                }
            };
            if (navigatable) {
                that._tabindex();
                element.on("focus" + NS, function() {
                    var current = that._current;
                    if (!current || !current.is(":visible")) {
                        current = that._item("first");
                    }
                    that.current(current);
                }).on("focusout" + NS, function() {
                    if (that._current) {
                        that._current.removeClass(FOCUSED);
                    }
                }).on("keydown" + NS, function(e) {
                    var key = e.keyCode, current = that.current(), target = $(e.target), canHandle = !target.is(":button,textarea,a,a>.t-icon,input"), isTextBox = target.is(":text"), preventDefault = kendo.preventDefault, editItem = element.find("." + KEDITITEM), active = activeElement(), idx;
                    if (!canHandle && !isTextBox && keys.ESC != key || isTextBox && keys.ESC != key && keys.ENTER != key) {
                        return;
                    }
                    if (keys.UP === key || keys.LEFT === key) {
                        if (current) {
                            current = current.prev();
                        }
                        that.current(!current || !current[0] ? that._item("last") : current);
                        preventDefault(e);
                    } else if (keys.DOWN === key || keys.RIGHT === key) {
                        if (current) {
                            current = current.next();
                        }
                        that.current(!current || !current[0] ? that._item("first") : current);
                        preventDefault(e);
                    } else if (keys.PAGEUP === key) {
                        that.current(null);
                        that.dataSource.page(that.dataSource.page() - 1);
                        preventDefault(e);
                    } else if (keys.PAGEDOWN === key) {
                        that.current(null);
                        that.dataSource.page(that.dataSource.page() + 1);
                        preventDefault(e);
                    } else if (keys.HOME === key) {
                        that.current(that._item("first"));
                        preventDefault(e);
                    } else if (keys.END === key) {
                        that.current(that._item("last"));
                        preventDefault(e);
                    } else if (keys.ENTER === key) {
                        if (editItem.length !== 0 && (canHandle || isTextBox)) {
                            idx = that.items().index(editItem);
                            if (active) {
                                active.blur();
                            }
                            that.save();
                            var focusAgain = function() {
                                that.element.trigger("focus");
                                that.current(that.items().eq(idx));
                            };
                            that.one("dataBound", focusAgain);
                        } else if (that.options.editTemplate !== "") {
                            that.edit(current);
                        }
                    } else if (keys.ESC === key) {
                        editItem = element.find("." + KEDITITEM);
                        if (editItem.length === 0) {
                            return;
                        }
                        idx = that.items().index(editItem);
                        that.cancel();
                        that.element.trigger("focus");
                        that.current(that.items().eq(idx));
                    }
                });
                element.on("mousedown" + NS + " touchstart" + NS, FOCUSSELECTOR, proxy(clickCallback, that));
            }
        },
        clearSelection: function() {
            var that = this;
            that.selectable.clear();
            that.trigger(CHANGE);
        },
        select: function(items) {
            var that = this, selectable = that.selectable;
            items = $(items);
            if (items.length) {
                if (!selectable.options.multiple) {
                    selectable.clear();
                    items = items.first();
                }
                selectable.value(items);
                return;
            }
            return selectable.value();
        },
        _destroyEditable: function() {
            var that = this;
            if (that.editable) {
                that.editable.destroy();
                delete that.editable;
            }
        },
        _modelFromElement: function(element) {
            var uid = element.attr(kendo.attr("uid"));
            return this.dataSource.getByUid(uid);
        },
        _closeEditable: function(validate) {
            var that = this, editable = that.editable, data, index, template = that.template, valid = true;
            if (editable) {
                if (validate) {
                    valid = editable.end();
                }
                if (valid) {
                    if (editable.element.index() % 2) {
                        template = that.altTemplate;
                    }
                    data = that._modelFromElement(editable.element);
                    that._destroyEditable();
                    index = editable.element.index();
                    editable.element.replaceWith(template(data));
                    that.items().eq(index).attr(kendo.attr("uid"), data.uid);
                }
            }
            return valid;
        },
        edit: function(item) {
            var that = this, data = that._modelFromElement(item), container, index = item.index();
            that.cancel();
            item.replaceWith(that.editTemplate(data));
            container = that.items().eq(index).addClass(KEDITITEM).attr(kendo.attr("uid"), data.uid);
            that.editable = container.kendoEditable({
                model: data,
                clearContainer: false,
                errorTemplate: false
            }).data("kendoEditable");
            that.trigger(EDIT, {
                model: data,
                item: container
            });
        },
        save: function() {
            var that = this, editable = that.editable, model;
            if (!editable) {
                return;
            }
            editable = editable.element;
            model = that._modelFromElement(editable);
            if (!that.trigger(SAVE, {
                model: model,
                item: editable
            }) && that._closeEditable(true)) {
                that.dataSource.sync();
            }
        },
        remove: function(item) {
            var that = this, dataSource = that.dataSource, data = that._modelFromElement(item);
            if (!that.trigger(REMOVE, {
                model: data,
                item: item
            })) {
                item.hide();
                dataSource.remove(data);
                dataSource.sync();
            }
        },
        add: function() {
            var that = this, dataSource = that.dataSource, index = dataSource.indexOf((dataSource.view() || [])[0]);
            if (index < 0) {
                index = 0;
            }
            that.cancel();
            dataSource.insert(index, {});
            that.edit(that.element.children().first());
        },
        cancel: function() {
            var that = this, dataSource = that.dataSource;
            if (that.editable) {
                var container = that.editable.element;
                var model = that._modelFromElement(container);
                if (!that.trigger(CANCEL, {
                    model: model,
                    container: container
                })) {
                    dataSource.cancelChanges(model);
                    that._closeEditable(false);
                }
            }
        },
        _crudHandlers: function() {
            var that = this, clickNS = CLICK + NS;
            that.element.on(clickNS, ".k-edit-button", function(e) {
                var item = $(this).closest("[" + kendo.attr("uid") + "]");
                that.edit(item);
                e.preventDefault();
            });
            that.element.on(clickNS, ".k-delete-button", function(e) {
                var item = $(this).closest("[" + kendo.attr("uid") + "]");
                that.remove(item);
                e.preventDefault();
            });
            that.element.on(clickNS, ".k-update-button", function(e) {
                that.save();
                e.preventDefault();
            });
            that.element.on(clickNS, ".k-cancel-button", function(e) {
                that.cancel();
                e.preventDefault();
            });
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that._unbindDataSource();
            that._destroyEditable();
            that.element.off(NS);
            if (that.pager) {
                that.pager.destroy();
            }
            if (that.selectable) {
                that.selectable.destroy();
            }
            kendo.destroy(that.element);
        }
    });
    kendo.ui.plugin(ListView);
})(window.kendo.jQuery);

(function($, undefined) {
    var kendo = window.kendo, Widget = kendo.ui.Widget, isPlainObject = $.isPlainObject, proxy = $.proxy, extend = $.extend, placeholderSupported = kendo.support.placeholder, browser = kendo.support.browser, isFunction = $.isFunction, trimSlashesRegExp = /(^\/|\/$)/g, CHANGE = "change", APPLY = "apply", ERROR = "error", CLICK = "click", NS = ".kendoImageBrowser", BREADCRUBMSNS = ".kendoBreadcrumbs", SEARCHBOXNS = ".kendoSearchBox", NAMEFIELD = "name", SIZEFIELD = "size", TYPEFIELD = "type", DEFAULTSORTORDER = {
        field: TYPEFIELD,
        dir: "asc"
    }, ARRANGEBYTMPL = kendo.template('<li data-#=ns#value="#=value#" class="k-item">${text}</li>'), EMPTYTILE = kendo.template('<li class="k-tile-empty"><strong>${text}</strong></li>'), TOOLBARTMPL = '<div class="k-widget k-toolbar k-floatwrap">' + '<div class="k-toolbar-wrap">' + "#if(showUpload) { # " + '<div class="k-widget k-upload"><div class="k-button k-button-icontext k-button-bare k-upload-button">' + '<span class="k-icon k-add"></span>#=messages.uploadFile#<input type="file" name="file" /></div></div>' + "#}#" + "#if(showCreate) {#" + '<button type="button" class="k-button k-button-icon k-button-bare"><span class="k-icon k-addfolder"></span></button>' + "#}#" + "#if(showDelete) {#" + '<button type="button" class="k-button k-button-icon k-button-bare k-state-disabled"><span class="k-icon k-delete"></span></button>&nbsp;' + "#}#" + "</div>" + '<div class="k-tiles-arrange">#=messages.orderBy#: <a href="\\#" class="k-link"><span>#=messages.orderByName#</span><span class="k-icon k-i-arrow-s"></span></a>' + "</div>" + "</div>";
    extend(true, kendo.data, {
        schemas: {
            imagebrowser: {
                data: function(data) {
                    return data.items || data || [];
                },
                model: {
                    id: "name",
                    fields: {
                        name: "name",
                        size: "size",
                        type: "type"
                    }
                }
            }
        }
    });
    extend(true, kendo.data, {
        transports: {
            imagebrowser: kendo.data.RemoteTransport.extend({
                init: function(options) {
                    kendo.data.RemoteTransport.fn.init.call(this, $.extend(true, {}, this.options, options));
                },
                _call: function(type, options) {
                    options.data = $.extend({}, options.data, {
                        path: this.options.path()
                    });
                    if (isFunction(this.options[type])) {
                        this.options[type].call(this, options);
                    } else {
                        kendo.data.RemoteTransport.fn[type].call(this, options);
                    }
                },
                read: function(options) {
                    this._call("read", options);
                },
                create: function(options) {
                    this._call("create", options);
                },
                destroy: function(options) {
                    this._call("destroy", options);
                },
                update: function() {},
                options: {
                    read: {
                        type: "POST"
                    },
                    update: {
                        type: "POST"
                    },
                    create: {
                        type: "POST"
                    },
                    destroy: {
                        type: "POST"
                    }
                }
            })
        }
    });
    function bindDragEventWrappers(element, onDragEnter, onDragLeave) {
        var hideInterval, lastDrag;
        element.on("dragenter" + NS, function() {
            onDragEnter();
            lastDrag = new Date();
            if (!hideInterval) {
                hideInterval = setInterval(function() {
                    var sinceLastDrag = new Date() - lastDrag;
                    if (sinceLastDrag > 100) {
                        onDragLeave();
                        clearInterval(hideInterval);
                        hideInterval = null;
                    }
                }, 100);
            }
        }).on("dragover" + NS, function() {
            lastDrag = new Date();
        });
    }
    var offsetTop;
    if (browser.msie && browser.version < 8) {
        offsetTop = function(element) {
            return element.offsetTop;
        };
    } else {
        offsetTop = function(element) {
            return element.offsetTop - $(element).height();
        };
    }
    function fieldName(fields, name) {
        var descriptor = fields[name];
        if (isPlainObject(descriptor)) {
            return descriptor.field || name;
        }
        return descriptor;
    }
    function concatPaths(path, name) {
        if (path === undefined || !path.match(/\/$/)) {
            path = (path || "") + "/";
        }
        return path + name;
    }
    function sizeFormatter(value) {
        if (!value) {
            return "";
        }
        var suffix = " bytes";
        if (value >= 1073741824) {
            suffix = " GB";
            value /= 1073741824;
        } else if (value >= 1048576) {
            suffix = " MB";
            value /= 1048576;
        } else if (value >= 1024) {
            suffix = " KB";
            value /= 1024;
        }
        return Math.round(value * 100) / 100 + suffix;
    }
    var ImageBrowser = Widget.extend({
        init: function(element, options) {
            var that = this;
            options = options || {};
            Widget.fn.init.call(that, element, options);
            that.element.addClass("k-imagebrowser");
            that.element.on(CLICK + NS, ".k-toolbar button:not(.k-state-disabled):has(.k-delete)", proxy(that._deleteClick, that)).on(CLICK + NS, ".k-toolbar button:not(.k-state-disabled):has(.k-addfolder)", proxy(that._addClick, that)).on("keydown" + NS, "li.k-state-selected input", proxy(that._directoryKeyDown, that)).on("blur" + NS, "li.k-state-selected input", proxy(that._directoryBlur, that));
            that._dataSource();
            that.refresh();
            that.path(that.options.path);
        },
        options: {
            name: "ImageBrowser",
            messages: {
                uploadFile: "Upload",
                orderBy: "Arrange by",
                orderByName: "Name",
                orderBySize: "Size",
                directoryNotFound: "A directory with this name was not found.",
                emptyFolder: "Empty Folder",
                deleteFile: 'Are you sure you want to delete "{0}"?',
                invalidFileType: 'The selected file "{0}" is not valid. Supported file types are {1}.',
                overwriteFile: 'A file with name "{0}" already exists in the current directory. Do you want to overwrite it?',
                dropFilesHere: "drop files here to upload",
                search: "Search"
            },
            transport: {},
            path: "/",
            fileTypes: "*.png,*.gif,*.jpg,*.jpeg"
        },
        events: [ ERROR, CHANGE, APPLY ],
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.dataSource.unbind(ERROR, that._errorHandler);
            that.element.add(that.list).add(that.toolbar).off(NS);
            if (that.arrangeByPopup) {
                that.arrangeByPopup.destroy();
            }
            kendo.destroy(that.element);
        },
        value: function() {
            var that = this, selected = that._selectedItem(), path, imageUrl = that.options.transport.imageUrl;
            if (selected && selected.get(that._getFieldName(TYPEFIELD)) === "f") {
                path = concatPaths(that.path(), selected.get(that._getFieldName(NAMEFIELD))).replace(trimSlashesRegExp, "");
                if (imageUrl) {
                    path = isFunction(imageUrl) ? imageUrl(path) : kendo.format(imageUrl, path);
                }
                return path;
            }
        },
        _selectedItem: function() {
            var listView = this.listView, selected = listView.select();
            if (selected.length) {
                return this.dataSource.getByUid(selected.attr(kendo.attr("uid")));
            }
        },
        _toolbar: function() {
            var that = this, template = kendo.template(TOOLBARTMPL), messages = that.options.messages, link, popup, arrangeBy = [ {
                text: messages.orderByName,
                value: "name",
                ns: kendo.ns
            }, {
                text: messages.orderBySize,
                value: "size",
                ns: kendo.ns
            } ];
            that.toolbar = $(template({
                messages: messages,
                showUpload: that.options.transport.uploadUrl,
                showCreate: that.options.transport.create,
                showDelete: that.options.transport.destroy
            })).appendTo(that.element).find(".k-upload input").kendoUpload({
                multiple: false,
                localization: {
                    dropFilesHere: messages.dropFilesHere
                },
                async: {
                    saveUrl: that.options.transport.uploadUrl,
                    autoUpload: true
                },
                upload: proxy(that._fileUpload, that)
            }).end();
            that.upload = that.toolbar.find(".k-upload input").data("kendoUpload");
            link = that.toolbar.find(".k-tiles-arrange a");
            that.arrangeByPopup = popup = $("<ul>" + kendo.render(ARRANGEBYTMPL, arrangeBy) + "</ul>").kendoPopup({
                anchor: link
            }).on(CLICK + NS, "li", function() {
                var item = $(this), field = item.attr(kendo.attr("value"));
                that.toolbar.find(".k-tiles-arrange a span:first").html(item.text());
                popup.close();
                that.orderBy(field);
            }).data("kendoPopup");
            link.on(CLICK + NS, function(e) {
                e.preventDefault();
                popup.toggle();
            });
            that._attachDropzoneEvents();
        },
        _attachDropzoneEvents: function() {
            var that = this;
            if (that.options.transport.uploadUrl) {
                bindDragEventWrappers($(document.documentElement), $.proxy(that._dropEnter, that), $.proxy(that._dropLeave, that));
                that._scrollHandler = proxy(that._positionDropzone, that);
            }
        },
        _dropEnter: function() {
            this._positionDropzone();
            $(document).on("scroll" + NS, this._scrollHandler);
        },
        _dropLeave: function() {
            this._removeDropzone();
            $(document).off("scroll" + NS, this._scrollHandler);
        },
        _positionDropzone: function() {
            var that = this, element = that.element, offset = element.offset();
            that.toolbar.find(".k-dropzone").addClass("k-imagebrowser-dropzone").offset(offset).css({
                width: element[0].clientWidth,
                height: element[0].clientHeight,
                lineHeight: element[0].clientHeight + "px"
            });
        },
        _removeDropzone: function() {
            this.toolbar.find(".k-dropzone").removeClass("k-imagebrowser-dropzone").css({
                width: "",
                height: "",
                lineHeight: "",
                top: "",
                left: ""
            });
        },
        _deleteClick: function() {
            var that = this, item = that.listView.select(), message = kendo.format(that.options.messages.deleteFile, item.find("strong").text());
            if (item.length && that._showMessage(message, "confirm")) {
                that.listView.remove(item);
            }
        },
        _addClick: function() {
            this.createDirectory();
        },
        _fileUpload: function(e) {
            var that = this, options = that.options, fileTypes = options.fileTypes, filterRegExp = new RegExp(("(" + fileTypes.split(",").join(")|(") + ")").replace(/\*\./g, ".*."), "i"), fileName = e.files[0].name, fileNameField = that._getFieldName(NAMEFIELD), sizeField = that._getFieldName(SIZEFIELD), model;
            if (filterRegExp.test(fileName)) {
                e.data = {
                    path: that.path()
                };
                model = that._createFile(fileName);
                if (!model) {
                    e.preventDefault();
                } else {
                    that.upload.one("success", function(e) {
                        model.set(fileNameField, e.response[fileNameField]);
                        model.set(sizeField, e.response[sizeField]);
                        that._tiles = that.listView.items().filter("[" + kendo.attr("type") + "=f]");
                        that._scroll();
                    });
                }
            } else {
                e.preventDefault();
                that._showMessage(kendo.format(options.messages.invalidFileType, fileName, fileTypes));
            }
        },
        _findFile: function(name) {
            var data = this.dataSource.data(), idx, result, typeField = this._getFieldName(TYPEFIELD), nameField = this._getFieldName(NAMEFIELD), length;
            name = name.toLowerCase();
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx].get(typeField) === "f" && data[idx].get(nameField).toLowerCase() === name) {
                    result = data[idx];
                    break;
                }
            }
            return result;
        },
        _createFile: function(fileName) {
            var that = this, idx, length, index = 0, model = {}, typeField = that._getFieldName(TYPEFIELD), view = that.dataSource.view(), file = that._findFile(fileName);
            if (file && !that._showMessage(kendo.format(that.options.messages.overwriteFile, fileName), "confirm")) {
                return null;
            }
            if (file) {
                return file;
            }
            for (idx = 0, length = view.length; idx < length; idx++) {
                if (view[idx].get(typeField) === "f") {
                    index = idx;
                    break;
                }
            }
            model[typeField] = "f";
            model[that._getFieldName(NAMEFIELD)] = fileName;
            model[that._getFieldName(SIZEFIELD)] = 0;
            return that.dataSource.insert(++index, model);
        },
        createDirectory: function() {
            var that = this, idx, length, lastDirectoryIdx = 0, typeField = that._getFieldName(TYPEFIELD), nameField = that._getFieldName(NAMEFIELD), view = that.dataSource.data(), name = that._nameDirectory(), model = new that.dataSource.reader.model();
            for (idx = 0, length = view.length; idx < length; idx++) {
                if (view[idx].get(typeField) === "d") {
                    lastDirectoryIdx = idx;
                }
            }
            model.set(typeField, "d");
            model.set(nameField, name);
            that.listView.one("dataBound", function() {
                var selected = that.listView.items().filter("[" + kendo.attr("uid") + "=" + model.uid + "]"), input = selected.find("input");
                if (selected.length) {
                    this.edit(selected);
                }
                this.element.scrollTop(selected.attr("offsetTop") - this.element[0].offsetHeight);
                setTimeout(function() {
                    input.select();
                });
            }).one("save", function(e) {
                var value = e.model.get(nameField);
                if (!value) {
                    e.model.set(nameField, name);
                } else {
                    e.model.set(nameField, that._nameExists(value, model.uid) ? that._nameDirectory() : value);
                }
            });
            that.dataSource.insert(++lastDirectoryIdx, model);
        },
        _directoryKeyDown: function(e) {
            if (e.keyCode == 13) {
                e.currentTarget.blur();
            }
        },
        _directoryBlur: function() {
            this.listView.save();
        },
        _nameExists: function(name, uid) {
            var data = this.dataSource.data(), typeField = this._getFieldName(TYPEFIELD), nameField = this._getFieldName(NAMEFIELD), idx, length;
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx].get(typeField) === "d" && data[idx].get(nameField).toLowerCase() === name.toLowerCase() && data[idx].uid !== uid) {
                    return true;
                }
            }
            return false;
        },
        _nameDirectory: function() {
            var name = "New folder", data = this.dataSource.data(), directoryNames = [], typeField = this._getFieldName(TYPEFIELD), nameField = this._getFieldName(NAMEFIELD), candidate, idx, length;
            for (idx = 0, length = data.length; idx < length; idx++) {
                if (data[idx].get(typeField) === "d" && data[idx].get(nameField).toLowerCase().indexOf(name.toLowerCase()) > -1) {
                    directoryNames.push(data[idx].get(nameField));
                }
            }
            if ($.inArray(name, directoryNames) > -1) {
                idx = 2;
                do {
                    candidate = name + " (" + idx + ")";
                    idx++;
                } while ($.inArray(candidate, directoryNames) > -1);
                name = candidate;
            }
            return name;
        },
        orderBy: function(field) {
            this.dataSource.sort([ {
                field: this._getFieldName(TYPEFIELD),
                dir: "asc"
            }, {
                field: this._getFieldName(field),
                dir: "asc"
            } ]);
        },
        search: function(name) {
            this.dataSource.filter({
                field: this._getFieldName(NAMEFIELD),
                operator: "contains",
                value: name
            });
        },
        _content: function() {
            var that = this;
            that.list = $('<ul class="k-reset k-floats k-tiles" />').appendTo(that.element).on("scroll" + NS, proxy(that._scroll, that)).on("dblclick" + NS, "li", proxy(that._dblClick, that));
            that.listView = new kendo.ui.ListView(that.list, {
                dataSource: that.dataSource,
                template: that._itemTmpl(),
                editTemplate: that._editTmpl(),
                selectable: true,
                autoBind: false,
                dataBinding: function(e) {
                    that.toolbar.find(".k-delete").parent().addClass("k-state-disabled");
                    if (e.action === "remove" || e.action === "sync") {
                        e.preventDefault();
                    }
                },
                dataBound: function() {
                    if (that.dataSource.view().length) {
                        that._tiles = this.items().filter("[" + kendo.attr("type") + "=f]");
                        that._scroll();
                    } else {
                        this.wrapper.append(EMPTYTILE({
                            text: that.options.messages.emptyFolder
                        }));
                    }
                },
                change: proxy(that._listViewChange, that)
            });
        },
        _dblClick: function(e) {
            var that = this, li = $(e.currentTarget);
            if (li.filter("[" + kendo.attr("type") + "=d]").length) {
                var folder = that.dataSource.getByUid(li.attr(kendo.attr("uid")));
                if (folder) {
                    that.path(concatPaths(that.path(), folder.get(that._getFieldName(NAMEFIELD))));
                    that.breadcrumbs.value(that.path());
                }
            } else if (li.filter("[" + kendo.attr("type") + "=f]").length) {
                that.trigger(APPLY);
            }
        },
        _listViewChange: function() {
            var selected = this._selectedItem();
            if (selected) {
                this.toolbar.find(".k-delete").parent().removeClass("k-state-disabled");
                if (selected.get(this._getFieldName(TYPEFIELD)) === "f") {
                    this.trigger(CHANGE);
                }
            }
        },
        _dataSource: function() {
            var that = this, options = that.options, transport = options.transport, typeSortOrder = extend({}, DEFAULTSORTORDER), nameSortOrder = {
                field: NAMEFIELD,
                dir: "asc"
            }, schema, dataSource = {
                type: transport.type || "imagebrowser",
                sort: [ typeSortOrder, nameSortOrder ]
            };
            if (isPlainObject(transport)) {
                transport.path = proxy(that.path, that);
                dataSource.transport = transport;
            }
            if (isPlainObject(options.schema)) {
                dataSource.schema = options.schema;
                if (isPlainObject(options.schema.model) && options.schema.model.fields) {
                    typeSortOrder.field = fieldName(options.schema.model.fields, TYPEFIELD);
                    nameSortOrder.field = fieldName(options.schema.model.fields, NAMEFIELD);
                }
            } else if (transport.type && isPlainObject(kendo.data.schemas[transport.type])) {
                schema = kendo.data.schemas[transport.type];
                if (isPlainObject(schema.model) && schema.model.fields) {
                    typeSortOrder.field = fieldName(schema.model.fields, TYPEFIELD);
                    nameSortOrder.field = fieldName(schema.model.fields, NAMEFIELD);
                }
            }
            if (that.dataSource && that._errorHandler) {
                that.dataSource.unbind(ERROR, that._errorHandler);
            } else {
                that._errorHandler = proxy(that._error, that);
            }
            that.dataSource = kendo.data.DataSource.create(dataSource).bind(ERROR, that._errorHandler);
        },
        _navigation: function() {
            var that = this, navigation = $('<div class="k-floatwrap"><input/><input/></div>').appendTo(this.element);
            that.breadcrumbs = navigation.find("input:first").kendoBreadcrumbs({
                value: that.options.path,
                change: function() {
                    that.path(this.value());
                }
            }).data("kendoBreadcrumbs");
            that.searchBox = navigation.parent().find("input:last").kendoSearchBox({
                label: that.options.messages.search,
                change: function() {
                    that.search(this.value());
                }
            }).data("kendoSearchBox");
        },
        _error: function(e) {
            var that = this, status;
            if (!that.trigger(ERROR, e)) {
                status = e.xhr.status;
                if (e.status == "error") {
                    if (status == "404") {
                        that._showMessage(that.options.messages.directoryNotFound);
                    } else if (status != "0") {
                        that._showMessage("Error! The requested URL returned " + status + " - " + e.xhr.statusText);
                    }
                } else if (status == "timeout") {
                    that._showMessage("Error! Server timeout.");
                }
            }
        },
        _showMessage: function(message, type) {
            return window[type || "alert"](message);
        },
        refresh: function() {
            var that = this;
            that._navigation();
            that._toolbar();
            that._content();
        },
        _loadImage: function(li) {
            var that = this, element = $(li), dataItem = that.dataSource.getByUid(element.attr(kendo.attr("uid"))), name = dataItem.get(that._getFieldName(NAMEFIELD)), thumbnailUrl = that.options.transport.thumbnailUrl, img = $("<img />", {
                alt: name
            }).hide().on("load" + NS, function() {
                $(this).prev().remove().end().addClass("k-image").fadeIn();
            }), urlJoin = "?";
            element.find(".k-loading").after(img);
            if (isFunction(thumbnailUrl)) {
                thumbnailUrl = thumbnailUrl(that.path(), encodeURIComponent(name));
            } else {
                if (thumbnailUrl.indexOf("?") >= 0) {
                    urlJoin = "&";
                }
                thumbnailUrl = thumbnailUrl + urlJoin + "path=" + that.path() + encodeURIComponent(name);
            }
            // IE8 will trigger the load event immediately when the src is assign
            // if the image is loaded from the cache
            img.attr("src", thumbnailUrl);
            li.loaded = true;
        },
        _scroll: function() {
            var that = this;
            if (that.options.transport && that.options.transport.thumbnailUrl) {
                clearTimeout(that._timeout);
                that._timeout = setTimeout(function() {
                    var height = that.list.outerHeight(), viewTop = that.list.scrollTop(), viewBottom = viewTop + height;
                    that._tiles.each(function() {
                        var top = offsetTop(this), bottom = top + this.offsetHeight;
                        if (top >= viewTop && top < viewBottom || bottom >= viewTop && bottom < viewBottom) {
                            that._loadImage(this);
                        }
                        if (top > viewBottom) {
                            return false;
                        }
                    });
                    that._tiles = that._tiles.filter(function() {
                        return !this.loaded;
                    });
                }, 250);
            }
        },
        _editTmpl: function() {
            var that = this, html = '<li class="k-tile k-state-selected" ' + kendo.attr("uid") + '="#=uid#" ';
            html += kendo.attr("type") + '="${' + that._getFieldName(TYPEFIELD) + '}">';
            html += "#if(" + that._getFieldName(TYPEFIELD) + ' == "d") { #';
            html += '<div class="k-thumb"><span class="k-icon k-folder"></span></div>';
            html += "#}else{#";
            html += '<div class="k-thumb"><span class="k-icon k-loading"></span></div>';
            html += "#}#";
            html += "#if(" + that._getFieldName(TYPEFIELD) + ' == "d") { #';
            html += '<input class="k-input" ' + kendo.attr("bind") + '="value:' + that._getFieldName(NAMEFIELD) + '"/>';
            html += "#}#";
            html += "</li>";
            return proxy(kendo.template(html), {
                sizeFormatter: sizeFormatter
            });
        },
        _itemTmpl: function() {
            var that = this, html = '<li class="k-tile" ' + kendo.attr("uid") + '="#=uid#" ';
            html += kendo.attr("type") + '="${' + that._getFieldName(TYPEFIELD) + '}">';
            html += "#if(" + that._getFieldName(TYPEFIELD) + ' == "d") { #';
            html += '<div class="k-thumb"><span class="k-icon k-folder"></span></div>';
            html += "#}else{#";
            if (that.options.transport && that.options.transport.thumbnailUrl) {
                html += '<div class="k-thumb"><span class="k-icon k-loading"></span></div>';
            } else {
                html += '<div class="k-thumb"><span class="k-icon k-file"></span></div>';
            }
            html += "#}#";
            html += "<strong>${" + that._getFieldName(NAMEFIELD) + "}</strong>";
            html += "#if(" + that._getFieldName(TYPEFIELD) + ' == "f") { # <span class="k-filesize">${this.sizeFormatter(' + that._getFieldName(SIZEFIELD) + ")}</span> #}#";
            html += "</li>";
            return proxy(kendo.template(html), {
                sizeFormatter: sizeFormatter
            });
        },
        _getFieldName: function(name) {
            return fieldName(this.dataSource.reader.model.fields, name);
        },
        path: function(value) {
            var that = this, path = that._path || "";
            if (value !== undefined) {
                that._path = value.replace(trimSlashesRegExp, "") + "/";
                that.dataSource.read({
                    path: that._path
                });
                return;
            }
            if (path) {
                path = path.replace(trimSlashesRegExp, "");
            }
            return path === "/" || path === "" ? "" : path + "/";
        }
    });
    var SearchBox = Widget.extend({
        init: function(element, options) {
            var that = this;
            options = options || {};
            Widget.fn.init.call(that, element, options);
            if (placeholderSupported) {
                that.element.attr("placeholder", that.options.label);
            }
            that._wrapper();
            that.element.on("keydown" + SEARCHBOXNS, proxy(that._keydown, that)).on("change" + SEARCHBOXNS, proxy(that._updateValue, that));
            that.wrapper.on(CLICK + SEARCHBOXNS, "a", proxy(that._click, that));
            if (!placeholderSupported) {
                that.element.on("focus" + SEARCHBOXNS, proxy(that._focus, that)).on("blur" + SEARCHBOXNS, proxy(that._blur, that));
            }
        },
        options: {
            name: "SearchBox",
            label: "Search",
            value: ""
        },
        events: [ CHANGE ],
        destroy: function() {
            var that = this;
            that.wrapper.add(that.element).add(that.label).off(SEARCHBOXNS);
            Widget.fn.destroy.call(that);
        },
        _keydown: function(e) {
            if (e.keyCode === 13) {
                this._updateValue();
            }
        },
        _click: function(e) {
            e.preventDefault();
            this._updateValue();
        },
        _updateValue: function() {
            var that = this, value = that.element.val();
            if (value !== that.value()) {
                that.value(value);
                that.trigger(CHANGE);
            }
        },
        _blur: function() {
            this._updateValue();
            this._toggleLabel();
        },
        _toggleLabel: function() {
            if (!placeholderSupported) {
                this.label.toggle(!this.element.val());
            }
        },
        _focus: function() {
            this.label.hide();
        },
        _wrapper: function() {
            var element = this.element, wrapper = element.parents(".k-search-wrap");
            element[0].style.width = "";
            element.addClass("k-input k-textbox");
            if (!wrapper.length) {
                wrapper = element.wrap($('<div class="k-widget k-search-wrap k-textbox"/>')).parent();
                if (!placeholderSupported) {
                    $('<label style="display:block">' + this.options.label + "</label>").insertBefore(element);
                }
                $('<a href="#" class="k-icon k-i-search k-search"/>').appendTo(wrapper);
            }
            this.wrapper = wrapper;
            this.label = wrapper.find(">label");
        },
        value: function(value) {
            var that = this;
            if (value !== undefined) {
                that.options.value = value;
                that.element.val(value);
                that._toggleLabel();
                return;
            }
            return that.options.value;
        }
    });
    var Breadcrumbs = Widget.extend({
        init: function(element, options) {
            var that = this;
            options = options || {};
            Widget.fn.init.call(that, element, options);
            that._wrapper();
            that.wrapper.on("focus" + BREADCRUBMSNS, "input", proxy(that._focus, that)).on("blur" + BREADCRUBMSNS, "input", proxy(that._blur, that)).on("keydown" + BREADCRUBMSNS, "input", proxy(that._keydown, that)).on(CLICK + BREADCRUBMSNS, "a.k-i-arrow-n:first", proxy(that._rootClick, that)).on(CLICK + BREADCRUBMSNS, "a:not(.k-i-arrow-n)", proxy(that._click, that));
            that.value(that.options.value);
        },
        options: {
            name: "Breadcrumbs",
            gap: 50
        },
        events: [ CHANGE ],
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            that.wrapper.add(that.wrapper.find("input")).add(that.wrapper.find("a")).off(BREADCRUBMSNS);
        },
        _update: function(val) {
            val = (val || "").charAt(0) === "/" ? val : "/" + (val || "");
            if (val !== this.value()) {
                this.value(val);
                this.trigger(CHANGE);
            }
        },
        _click: function(e) {
            e.preventDefault();
            this._update(this._path($(e.target).prevAll("a:not(.k-i-arrow-n)").andSelf()));
        },
        _rootClick: function(e) {
            e.preventDefault();
            this._update("");
        },
        _focus: function() {
            var that = this, element = that.element;
            that.overlay.hide();
            that.element.val(that.value());
            setTimeout(function() {
                element.select();
            });
        },
        _blur: function() {
            if (this.overlay.is(":visible")) {
                return;
            }
            var that = this, element = that.element, val = element.val().replace(/\/{2,}/g, "/");
            that.overlay.show();
            element.val("");
            that._update(val);
        },
        _keydown: function(e) {
            var that = this;
            if (e.keyCode === 13) {
                that._blur();
                setTimeout(function() {
                    that.overlay.find("a:first").focus();
                });
            }
        },
        _wrapper: function() {
            var element = this.element, wrapper = element.parents(".k-breadcrumbs"), overlay;
            element[0].style.width = "";
            element.addClass("k-input");
            if (!wrapper.length) {
                wrapper = element.wrap($('<div class="k-widget k-breadcrumbs k-header k-state-default"/>')).parent();
            }
            overlay = wrapper.find(".k-breadcrumbs-wrap");
            if (!overlay.length) {
                overlay = $('<div class="k-breadcrumbs-wrap"/>').appendTo(wrapper);
            }
            this.wrapper = wrapper;
            this.overlay = overlay;
        },
        refresh: function() {
            var html = "", value = this.value(), segments, segment, idx, length;
            if (value === undefined || !value.match(/^\//)) {
                value = "/" + (value || "");
            }
            segments = value.split("/");
            for (idx = 0, length = segments.length; idx < length; idx++) {
                segment = segments[idx];
                if (segment) {
                    if (!html) {
                        html += '<a href="#" class="k-icon k-i-arrow-n">root</a>';
                    }
                    html += '<a class="k-link" href="#">' + segments[idx] + "</a>";
                    html += '<span class="k-icon k-i-arrow-e">&gt;</span>';
                }
            }
            this.overlay.empty().append($(html));
            this._adjustSectionWidth();
        },
        _adjustSectionWidth: function() {
            var that = this, wrapper = that.wrapper, width = wrapper.width() - that.options.gap, links = that.overlay.find("a"), a;
            links.each(function(index) {
                a = $(this);
                if (a.parent().width() > width) {
                    if (index == links.length - 1) {
                        a.width(width);
                    } else {
                        a.prev().andSelf().hide();
                    }
                }
            });
        },
        value: function(val) {
            if (val !== undefined) {
                this._value = val.replace(/\/{2,}/g, "/");
                this.refresh();
                return;
            }
            return this._value;
        },
        _path: function(trail) {
            return "/" + $.map(trail, function(b) {
                return $(b).text();
            }).join("/");
        }
    });
    kendo.ui.plugin(ImageBrowser);
    kendo.ui.plugin(Breadcrumbs);
    kendo.ui.plugin(SearchBox);
})(window.kendo.jQuery);

(function($, undefined) {
    // Imports ================================================================
    var kendo = window.kendo, Class = kendo.Class, Widget = kendo.ui.Widget, os = kendo.support.mobileOS, browser = kendo.support.browser, extend = $.extend, deepExtend = kendo.deepExtend, NS = ".kendoEditor", keys = kendo.keys;
    // options can be: template (as string), cssClass, title, defaultValue
    var ToolTemplate = Class.extend({
        init: function(options) {
            this.options = options;
        },
        getHtml: function() {
            var options = this.options;
            return kendo.template(options.template)({
                cssClass: options.cssClass,
                tooltip: options.title,
                initialValue: options.initialValue
            });
        }
    });
    var EditorUtils = {
        select: function(editor) {
            editor.trigger("select", {});
        },
        editorWrapperTemplate: '<table cellspacing="4" cellpadding="0" class="k-widget k-editor k-header" role="presentation"><tbody>' + '<tr role="presentation"><td class="k-editor-toolbar-wrap" role="presentation"><ul class="k-editor-toolbar" role="toolbar"></ul></td></tr>' + '<tr><td class="k-editable-area"></td></tr>' + "</tbody></table>",
        buttonTemplate: '<li class="k-editor-button" role="presentation">' + '<a href="" role="button" class="k-tool-icon #= cssClass #" unselectable="on" title="#= tooltip #">#= tooltip #</a>' + "</li>",
        colorPickerTemplate: '<li class="k-editor-colorpicker" role="presentation"><div class="k-colorpicker #= cssClass #"></div></li>',
        comboBoxTemplate: '<li class="k-editor-combobox">' + '<select title="#= tooltip #" class="#= cssClass #"></select>' + "</li>",
        dropDownListTemplate: '<li class="k-editor-selectbox">' + '<select title="#= tooltip #" class="#= cssClass #"></select>' + "</li>",
        separatorTemplate: '<li class="k-separator"></li>',
        focusable: ".k-colorpicker,a.k-tool-icon:not(.k-state-disabled),.k-selectbox, .k-combobox .k-input",
        wrapTextarea: function(textarea) {
            var w = textarea[0].style.width, h = textarea[0].style.height, template = EditorUtils.editorWrapperTemplate, editorWrap = $(template).insertBefore(textarea).width(w).height(h), editArea = editorWrap.find(".k-editable-area");
            textarea.appendTo(editArea).addClass("k-content k-raw-content").hide();
            return textarea.closest(".k-editor");
        },
        renderTools: function(editor, tools) {
            var editorTools = {}, currentTool, tool, i, nativeTools = editor._nativeTools, template, options, toolsArea = $(editor.element).closest(".k-editor").find(".k-editor-toolbar");
            if (tools) {
                for (i = 0; i < tools.length; i++) {
                    currentTool = tools[i];
                    options = null;
                    if ($.isPlainObject(currentTool)) {
                        if (currentTool.name && editor.tools[currentTool.name]) {
                            $.extend(editor.tools[currentTool.name].options, currentTool);
                            editorTools[currentTool.name] = editor.tools[currentTool.name];
                            options = editorTools[currentTool.name].options;
                        } else {
                            options = extend({
                                cssClass: "k-i-custom",
                                type: "button",
                                tooltip: ""
                            }, currentTool);
                            if (options.name) {
                                options.cssClass = "k-" + (options.name == "custom" ? "i-custom" : options.name);
                            }
                            if (!options.template) {
                                if (options.type == "button") {
                                    options.template = EditorUtils.buttonTemplate;
                                }
                            }
                        }
                    } else if (editor.tools[currentTool]) {
                        editorTools[currentTool] = editor.tools[currentTool];
                        options = editorTools[currentTool].options;
                    }
                    if (!options) {
                        continue;
                    }
                    template = options.template;
                    if (template) {
                        if (template.getHtml) {
                            template = template.getHtml();
                        } else {
                            if (!$.isFunction(template)) {
                                template = kendo.template(template);
                            }
                            template = template(options);
                        }
                        if (template.indexOf("<li") !== 0) {
                            template = "<li class='k-editor-template'>" + template + "</li>";
                        }
                        tool = $(template).appendTo(toolsArea);
                        if (options.type == "button" && options.exec) {
                            tool.find(".k-tool-icon").click($.proxy(options.exec, editor.element[0]));
                        }
                    }
                }
            }
            for (i = 0; i < nativeTools.length; i++) {
                if (!editorTools[nativeTools[i]]) {
                    editorTools[nativeTools[i]] = editor.tools[nativeTools[i]];
                }
            }
            editor.options.tools = editorTools;
        },
        decorateStyleToolItems: function(textarea) {
            var selectBox = textarea.data.closest(".k-editor").find(".k-style").data("kendoSelectBox");
            if (!selectBox) {
                return;
            }
            var classes = selectBox.dataSource.view();
            selectBox.list.find(".k-item").each(function(idx, element) {
                var item = $(element), text = item.text(), style = kendo.ui.editor.Dom.inlineStyle(textarea.data.data("kendoEditor").document, "span", {
                    className: classes[idx].value
                });
                item.html('<span unselectable="on" style="display:block;' + style + '">' + text + "</span>");
            });
        },
        createContentElement: function(textarea, stylesheets) {
            var iframe, wnd, doc, rtlStyle = kendo.support.isRtl(textarea) ? "direction:rtl;" : "";
            textarea.hide();
            iframe = $("<iframe />", {
                src: 'javascript:""',
                frameBorder: "0"
            }).css("display", "").addClass("k-content").insertBefore(textarea)[0];
            wnd = iframe.contentWindow || iframe;
            if (stylesheets.length > 0) {
                $(iframe).one("load", textarea, EditorUtils.decorateStyleToolItems);
            }
            doc = wnd.document || iframe.contentDocument;
            doc.open();
            doc.write("<!DOCTYPE html><html><head>" + "<meta charset='utf-8' />" + "<style>" + "html,body{padding:0;margin:0;background:#fff;height:100%;min-height:100%;}" + "body{font: 12px/1.5 Verdana,Geneva,sans-serif;padding-top:1px;margin-top:-1px;" + "word-wrap: break-word;-webkit-nbsp-mode: space;-webkit-line-break: after-white-space;" + rtlStyle + "}" + "h1{font-size:2em;margin:.67em 0}h2{font-size:1.5em}h3{font-size:1.16em}h4{font-size:1em}h5{font-size:.83em}h6{font-size:.7em}" + "p{margin:0 0 1em;padding:0 .2em}.k-marker{display:none;}.k-paste-container,.Apple-style-span{position:absolute;left:-10000px;width:1px;height:1px;overflow:hidden}" + "ul,ol{padding-left:2.5em}" + "a{color:#00a}" + "code{font-size:1.23em}" + "</style>" + $.map(stylesheets, function(href) {
                return "<link rel='stylesheet' href='" + href + "'>";
            }).join("") + "</head><body contenteditable='true'></body></html>");
            doc.close();
            return wnd;
        },
        initializeContentElement: function(editor) {
            var isFirstKeyDown = true;
            editor.window = EditorUtils.createContentElement($(editor.textarea), editor.options.stylesheets);
            editor.document = editor.window.contentDocument || editor.window.document;
            editor.body = editor.document.body;
            $(editor.document).on("keydown" + NS, function(e) {
                var range;
                if (e.keyCode === keys.F10) {
                    // Handling with timeout to avoid the default IE menu
                    setTimeout(function() {
                        var TABINDEX = "tabIndex", element = editor.wrapper, tabIndex = element.attr(TABINDEX);
                        // Chrome can't focus something which has already been focused
                        element.attr(TABINDEX, tabIndex || 0).focus().find("li:has(" + focusable + ")").first().focus();
                        if (!tabIndex && tabIndex !== 0) {
                            element.removeAttr(TABINDEX);
                        }
                    }, 100);
                    e.preventDefault();
                    return;
                } else if (e.keyCode === keys.BACKSPACE) {
                    range = editor.getRange();
                    var ancestor, emptyParagraphContent = kendo.support.browser.msie ? "" : '<br _moz_dirty="" />', dom = kendo.ui.editor.Dom;
                    range.deleteContents();
                    ancestor = range.commonAncestorContainer;
                    if (dom.name(ancestor) === "p" && ancestor.innerHTML === "") {
                        ancestor.innerHTML = emptyParagraphContent;
                        range.setStart(ancestor, 0);
                        range.collapse(true);
                        editor.selectRange(range);
                    }
                }
                var toolName = editor.keyboard.toolFromShortcut(editor.options.tools, e);
                if (toolName) {
                    e.preventDefault();
                    if (!/undo|redo/.test(toolName)) {
                        editor.keyboard.endTyping(true);
                    }
                    editor.exec(toolName);
                    return false;
                }
                if (editor.keyboard.isTypingKey(e) && editor.pendingFormats.hasPending()) {
                    if (isFirstKeyDown) {
                        isFirstKeyDown = false;
                    } else {
                        range = editor.getRange();
                        editor.pendingFormats.apply(range);
                        editor.selectRange(range);
                    }
                }
                editor.keyboard.clearTimeout();
                editor.keyboard.keydown(e);
            }).on("keyup" + NS, function(e) {
                var selectionCodes = [ 8, 9, 33, 34, 35, 36, 37, 38, 39, 40, 40, 45, 46 ];
                if ($.inArray(e.keyCode, selectionCodes) > -1 || e.keyCode == 65 && e.ctrlKey && !e.altKey && !e.shiftKey) {
                    editor.pendingFormats.clear();
                    select(editor);
                }
                if (editor.keyboard.isTypingKey(e)) {
                    if (editor.pendingFormats.hasPending()) {
                        var range = editor.getRange();
                        editor.pendingFormats.apply(range);
                        editor.selectRange(range);
                    }
                } else {
                    isFirstKeyDown = true;
                }
                editor.keyboard.keyup(e);
            }).on("mousedown" + NS, function(e) {
                editor.pendingFormats.clear();
                var target = $(e.target);
                if (!browser.gecko && e.which == 2 && target.is("a[href]")) {
                    window.open(target.attr("href"), "_new");
                }
            }).on("mouseup" + NS, function() {
                select(editor);
            }).on("click" + NS, function(e) {
                var dom = kendo.ui.editor.Dom, range;
                if (dom.name(e.target) === "img") {
                    range = editor.createRange();
                    range.selectNode(e.target);
                    editor.selectRange(range);
                }
            });
            $(editor.window).on("blur" + NS, function() {
                var old = editor.textarea.value, value = editor.encodedValue();
                editor.update();
                if (value != old) {
                    editor.trigger("change");
                }
            });
            $(editor.body).on("cut" + NS + " paste" + NS, function(e) {
                editor.clipboard["on" + e.type](e);
            });
        },
        formatByName: function(name, format) {
            for (var i = 0; i < format.length; i++) {
                if ($.inArray(name, format[i].tags) >= 0) {
                    return format[i];
                }
            }
        },
        registerTool: function(toolName, tool) {
            if (tool.options && tool.options.template) {
                tool.options.template.options.cssClass = "k-" + toolName;
            }
            Editor.fn._tools[toolName] = tool;
        },
        registerFormat: function(formatName, format) {
            Editor.fn.options.formats[formatName] = format;
        },
        createDialog: function(windowContent, editor, initOptions) {
            var isRtl = kendo.support.isRtl(editor.wrapper), win = $(windowContent).appendTo(document.body).kendoWindow(initOptions);
            if (isRtl) {
                win.closest(".k-window").addClass("k-rtl");
            }
            return win;
        }
    };
    var select = EditorUtils.select, focusable = EditorUtils.focusable, wrapTextarea = EditorUtils.wrapTextarea, renderTools = EditorUtils.renderTools, initializeContentElement = EditorUtils.initializeContentElement;
    var messages = {
        bold: "Bold",
        italic: "Italic",
        underline: "Underline",
        strikethrough: "Strikethrough",
        superscript: "Superscript",
        subscript: "Subscript",
        justifyCenter: "Center text",
        justifyLeft: "Align text left",
        justifyRight: "Align text right",
        justifyFull: "Justify",
        insertUnorderedList: "Insert unordered list",
        insertOrderedList: "Insert ordered list",
        indent: "Indent",
        outdent: "Outdent",
        createLink: "Insert hyperlink",
        unlink: "Remove hyperlink",
        insertImage: "Insert image",
        insertHtml: "Insert HTML",
        viewHtml: "View HTML",
        fontName: "Select font family",
        fontNameInherit: "(inherited font)",
        fontSize: "Select font size",
        fontSizeInherit: "(inherited size)",
        formatBlock: "Format",
        foreColor: "Color",
        backColor: "Background color",
        style: "Styles",
        emptyFolder: "Empty Folder",
        uploadFile: "Upload",
        orderBy: "Arrange by:",
        orderBySize: "Size",
        orderByName: "Name",
        invalidFileType: 'The selected file "{0}" is not valid. Supported file types are {1}.',
        deleteFile: 'Are you sure you want to delete "{0}"?',
        overwriteFile: 'A file with name "{0}" already exists in the current directory. Do you want to overwrite it?',
        directoryNotFound: "A directory with this name was not found.",
        imageWebAddress: "Web address",
        imageAltText: "Alternate text",
        linkWebAddress: "Web address",
        linkText: "Text",
        linkToolTip: "ToolTip",
        linkOpenInNewWindow: "Open link in new window",
        dialogInsert: "Insert",
        dialogButtonSeparator: "or",
        dialogCancel: "Cancel"
    };
    var supportedBrowser = !os || os.ios && os.flatVersion >= 500 || !os.ios && typeof document.documentElement.contentEditable != "undefined";
    var Editor = Widget.extend({
        init: function(element, options) {
            /* suppress initialization in mobile webkit devices (w/o proper contenteditable support) */
            if (!supportedBrowser) {
                return;
            }
            var that = this, wrapper, value, editorNS = kendo.ui.editor;
            Widget.fn.init.call(that, element, options);
            that.tools = deepExtend({}, kendo.ui.Editor.fn._tools);
            that.options = deepExtend({}, that.options, options);
            element = $(element);
            element.closest("form").on("submit" + NS, function() {
                that.update();
            });
            for (var id in that.tools) {
                that.tools[id].name = id.toLowerCase();
            }
            that.textarea = element.attr("autocomplete", "off")[0];
            wrapper = that.wrapper = wrapTextarea(element);
            if (that.textarea.id) {
                wrapper.find(".k-editor-toolbar").attr("aria-controls", that.textarea.id);
            }
            renderTools(that, that.options.tools);
            initializeContentElement(that);
            that.keyboard = new editorNS.Keyboard([ new editorNS.TypingHandler(that), new editorNS.SystemHandler(that) ]);
            that.clipboard = new editorNS.Clipboard(this);
            that.pendingFormats = new editorNS.PendingFormats(this);
            that.undoRedoStack = new editorNS.UndoRedoStack();
            if (options && options.value) {
                value = options.value;
            } else {
                // indented HTML introduces problematic ranges in IE
                value = element.val().replace(/[\r\n\v\f\t ]+/gi, " ");
            }
            that.value(value);
            function toolFromClassName(element) {
                var tool = $.grep(element.className.split(" "), function(x) {
                    return !/^k-(widget|tool-icon|state-hover|header|combobox|dropdown|selectbox|colorpicker)$/i.test(x);
                });
                return tool[0] ? tool[0].substring(tool[0].lastIndexOf("-") + 1) : "custom";
            }
            function appendShortcutSequence(localizedText, tool) {
                if (!tool.key) {
                    return localizedText;
                }
                var res = localizedText + " (";
                if (tool.ctrl) {
                    res += "Ctrl + ";
                }
                if (tool.shift) {
                    res += "Shift + ";
                }
                if (tool.alt) {
                    res += "Alt + ";
                }
                res += tool.key + ")";
                return res;
            }
            var toolbarItems = ".k-editor-toolbar > li > *, .k-editor-toolbar > li select", buttons = ".k-editor-button .k-tool-icon", enabledButtons = buttons + ":not(.k-state-disabled)", disabledButtons = buttons + ".k-state-disabled";
            wrapper.find(".k-combobox .k-input").keydown(function(e) {
                var combobox = $(this).closest(".k-combobox").data("kendoComboBox"), key = e.keyCode;
                if (key == keys.RIGHT || key == keys.LEFT) {
                    combobox.close();
                } else if (key == keys.DOWN) {
                    if (!combobox.dropDown.isOpened()) {
                        e.stopImmediatePropagation();
                        combobox.open();
                    }
                }
            });
            wrapper.on("mouseenter" + NS, enabledButtons, function() {
                $(this).addClass("k-state-hover");
            }).on("mouseleave" + NS, enabledButtons, function() {
                $(this).removeClass("k-state-hover");
            }).on("mousedown" + NS, buttons, false).on("keydown" + NS, focusable, function(e) {
                var closestLi = $(this).closest("li"), focusableTool = "li:has(" + focusable + ")", focusElement, keyCode = e.keyCode;
                if (keyCode == keys.RIGHT) {
                    focusElement = closestLi.nextAll(focusableTool).first().find(focusable);
                } else if (keyCode == keys.LEFT) {
                    focusElement = closestLi.prevAll(focusableTool).first().find(focusable);
                } else if (keyCode == keys.ESC) {
                    focusElement = that;
                } else if (keyCode == keys.TAB && !(e.ctrlKey || e.altKey)) {
                    // skip tabbing to disabled tools, and focus the editing area when running out of tools
                    if (e.shiftKey) {
                        focusElement = closestLi.prevAll(focusableTool).first().find(focusable);
                        if (focusElement.length) {
                            e.preventDefault();
                        } else {
                            return;
                        }
                    } else {
                        e.preventDefault();
                        focusElement = closestLi.nextAll(focusableTool).first().find(focusable);
                        if (!focusElement.length) {
                            focusElement = that;
                        }
                    }
                }
                if (focusElement) {
                    focusElement.focus();
                }
            }).on("click" + NS, enabledButtons, function(e) {
                e.preventDefault();
                e.stopPropagation();
                that.exec(toolFromClassName(this));
            }).on("click" + NS, disabledButtons, function(e) {
                e.preventDefault();
            }).find(toolbarItems).each(function() {
                var toolName = toolFromClassName(this), options = that.options, tool = options.tools[toolName], description = options.messages[toolName], $this = $(this);
                if (!tool) {
                    return;
                }
                if (toolName == "fontSize" || toolName == "fontName") {
                    var inheritText = options.messages[toolName + "Inherit"] || messages[toolName + "Inherit"];
                    $this.find("input").val(inheritText).end().find("span.k-input").text(inheritText).end();
                }
                tool.initialize($this, {
                    title: appendShortcutSequence(description, tool),
                    editor: that
                });
            });
            that.bind("select", function() {
                var range = that.getRange();
                var nodes = editorNS.RangeUtils.textNodes(range);
                if (!nodes.length) {
                    nodes = [ range.startContainer ];
                }
                wrapper.find(toolbarItems).each(function() {
                    var tool = that.options.tools[toolFromClassName(this)];
                    if (tool) {
                        tool.update($(this), nodes, that.pendingFormats);
                    }
                });
            });
            that._DOMNodeInsertedHandler = function(e) {
                that._DOMNodeInserted(e);
            };
            that._endTypingHandler = function() {
                that._endTyping();
            };
            $(document).on("DOMNodeInserted", that._DOMNodeInsertedHandler).on("mousedown", that._endTypingHandler);
            kendo.notify(that);
        },
        _endTyping: function() {
            var that = this;
            try {
                if (that.keyboard.isTypingInProgress()) {
                    that.keyboard.endTyping(true);
                }
                if (!that.selectionRestorePoint) {
                    that.selectionRestorePoint = new kendo.ui.editor.RestorePoint(that.getRange());
                }
            } catch (e) {}
        },
        _DOMNodeInserted: function(e) {
            var that = this, wrapper = that.wrapper;
            if ($.contains(e.target, wrapper[0]) || wrapper[0] == e.target) {
                // preserve updated value before re-initializing
                // don't use update() to prevent the editor from encoding the content too early
                that.textarea.value = that.value();
                wrapper.find("iframe").remove();
                initializeContentElement(that);
                that.value(that.textarea.value);
            }
        },
        events: [ "select", "change", "execute", "error", "paste", "keydown", "keyup" ],
        options: {
            name: "Editor",
            messages: messages,
            formats: {},
            encoded: true,
            stylesheets: [],
            dialogOptions: {
                modal: true,
                resizable: false,
                draggable: true,
                animation: false
            },
            fontName: [ {
                text: "Arial",
                value: "Arial,Helvetica,sans-serif"
            }, {
                text: "Courier New",
                value: "'Courier New',Courier,monospace"
            }, {
                text: "Georgia",
                value: "Georgia,serif"
            }, {
                text: "Impact",
                value: "Impact,Charcoal,sans-serif"
            }, {
                text: "Lucida Console",
                value: "'Lucida Console',Monaco,monospace"
            }, {
                text: "Tahoma",
                value: "Tahoma,Geneva,sans-serif"
            }, {
                text: "Times New Roman",
                value: "'Times New Roman',Times,serif"
            }, {
                text: "Trebuchet MS",
                value: "'Trebuchet MS',Helvetica,sans-serif"
            }, {
                text: "Verdana",
                value: "Verdana,Geneva,sans-serif"
            } ],
            fontSize: [ {
                text: "1 (8pt)",
                value: "xx-small"
            }, {
                text: "2 (10pt)",
                value: "x-small"
            }, {
                text: "3 (12pt)",
                value: "small"
            }, {
                text: "4 (14pt)",
                value: "medium"
            }, {
                text: "5 (18pt)",
                value: "large"
            }, {
                text: "6 (24pt)",
                value: "x-large"
            }, {
                text: "7 (36pt)",
                value: "xx-large"
            } ],
            formatBlock: [ {
                text: "Paragraph",
                value: "p"
            }, {
                text: "Quotation",
                value: "blockquote"
            }, {
                text: "Heading 1",
                value: "h1"
            }, {
                text: "Heading 2",
                value: "h2"
            }, {
                text: "Heading 3",
                value: "h3"
            }, {
                text: "Heading 4",
                value: "h4"
            }, {
                text: "Heading 5",
                value: "h5"
            }, {
                text: "Heading 6",
                value: "h6"
            } ],
            tools: [ "bold", "italic", "underline", "strikethrough", "fontName", "fontSize", "foreColor", "backColor", "justifyLeft", "justifyCenter", "justifyRight", "justifyFull", "insertUnorderedList", "insertOrderedList", "indent", "outdent", "formatBlock", "createLink", "unlink", "insertImage" ]
        },
        destroy: function() {
            var that = this;
            Widget.fn.destroy.call(that);
            $(that.window).add(that.document).add(that.wrapper).add(that.element.closest("form")).off(NS);
            $(document).off("DOMNodeInserted", that._DOMNodeInsertedHandler).off("mousedown", that._endTypingHandler);
            kendo.destroy(that.wrapper);
        },
        _nativeTools: [ "insertLineBreak", "insertParagraph", "redo", "undo", "insertHtml" ],
        _tools: {
            undo: {
                options: {
                    key: "Z",
                    ctrl: true
                }
            },
            redo: {
                options: {
                    key: "Y",
                    ctrl: true
                }
            }
        },
        tools: {},
        // tools collection is copied from _tools during initialization
        value: function(html) {
            var body = this.body, dom = kendo.ui.editor.Dom, currentHtml = kendo.ui.editor.Serializer.domToXhtml(body);
            if (html === undefined) {
                return currentHtml;
            }
            if (html == currentHtml) {
                return;
            }
            this.pendingFormats.clear();
            var onerrorRe = /onerror\s*=\s*(?:'|")?([^'">\s]*)(?:'|")?/i;
            // handle null value passed as a parameter
            html = (html || "").replace(/<!\[CDATA\[(.*)?\]\]>/g, "<!--[CDATA[$1]]-->").replace(/<script([^>]*)>(.*)?<\/script>/gi, "<telerik:script $1>$2</telerik:script>").replace(/<img([^>]*)>/gi, function(match) {
                return match.replace(onerrorRe, "");
            }).replace(/(<\/?img[^>]*>)[\r\n\v\f\t ]+/gi, "$1");
            if (!browser.msie) {
                // Add <br/>s to empty paragraphs in mozilla/chrome, to make them focusable
                html = html.replace(/<p([^>]*)>(\s*)?<\/p>/gi, '<p $1><br _moz_dirty="" /></p>');
            }
            if (browser.msie && browser.version < 9) {
                // Internet Explorer removes comments from the beginning of the html
                html = "<br/>" + html;
                var originalSrc = "originalsrc", originalHref = "originalhref";
                // IE < 8 makes href and src attributes absolute
                html = html.replace(/href\s*=\s*(?:'|")?([^'">\s]*)(?:'|")?/, originalHref + '="$1"');
                html = html.replace(/src\s*=\s*(?:'|")?([^'">\s]*)(?:'|")?/, originalSrc + '="$1"');
                body.innerHTML = html;
                dom.remove(body.firstChild);
                $(body).find("telerik\\:script,script,link,img,a").each(function() {
                    var node = this;
                    if (node[originalHref]) {
                        node.setAttribute("href", node[originalHref]);
                        node.removeAttribute(originalHref);
                    }
                    if (node[originalSrc]) {
                        node.setAttribute("src", node[originalSrc]);
                        node.removeAttribute(originalSrc);
                    }
                });
            } else {
                body.innerHTML = html;
                if (browser.msie) {
                    // having unicode characters creates denormalized DOM tree in IE9
                    dom.normalize(body);
                    setTimeout(function() {
                        // fix for IE9 OL bug -- https://connect.microsoft.com/IE/feedback/details/657695/ordered-list-numbering-changes-from-correct-to-0-0
                        var ols = body.getElementsByTagName("ol"), i, ol, originalStart;
                        for (i = 0; i < ols.length; i++) {
                            ol = ols[i];
                            originalStart = ol.getAttribute("start");
                            ol.setAttribute("start", 1);
                            if (originalStart) {
                                ol.setAttribute("start", originalStart);
                            } else {
                                ol.removeAttribute(originalStart);
                            }
                        }
                    }, 1);
                }
            }
            this.selectionRestorePoint = null;
            this.update();
        },
        focus: function() {
            this.window.focus();
        },
        update: function(value) {
            this.textarea.value = value || this.options.encoded ? this.encodedValue() : this.value();
        },
        encodedValue: function() {
            return kendo.ui.editor.Dom.encode(this.value());
        },
        createRange: function(document) {
            return kendo.ui.editor.RangeUtils.createRange(document || this.document);
        },
        getSelection: function() {
            return kendo.ui.editor.SelectionUtils.selectionFromDocument(this.document);
        },
        selectRange: function(range) {
            this.focus();
            var selection = this.getSelection();
            selection.removeAllRanges();
            selection.addRange(range);
        },
        getRange: function() {
            var selection = this.getSelection(), range = selection.rangeCount > 0 ? selection.getRangeAt(0) : this.createRange(), doc = this.document;
            if (range.startContainer == doc && range.endContainer == doc && !range.startOffset && !range.endOffset) {
                range.setStart(this.body, 0);
                range.collapse(true);
            }
            return range;
        },
        selectedHtml: function() {
            return kendo.ui.editor.Serializer.domToXhtml(this.getRange().cloneContents());
        },
        paste: function(html) {
            this.clipboard.paste(html);
        },
        exec: function(name, params) {
            var that = this, range, body, id, tool = "", pendingTool;
            name = name.toLowerCase();
            // restore selection
            if (!that.keyboard.isTypingInProgress()) {
                that.focus();
                range = that.getRange();
                body = that.document.body;
            }
            // exec tool
            for (id in that.options.tools) {
                if (id.toLowerCase() == name) {
                    tool = that.options.tools[id];
                    break;
                }
            }
            if (tool) {
                range = that.getRange();
                if (!/undo|redo/i.test(name) && tool.willDelayExecution(range)) {
                    // clone our tool to apply params only once
                    pendingTool = $.extend({}, tool);
                    $.extend(pendingTool.options, {
                        params: params
                    });
                    that.pendingFormats.toggle(pendingTool);
                    select(that);
                    return;
                }
                var command = tool.command ? tool.command(extend({
                    range: range
                }, params)) : null;
                that.trigger("execute", {
                    name: name,
                    command: command
                });
                if (/undo|redo/i.test(name)) {
                    that.undoRedoStack[name]();
                } else if (command) {
                    if (!command.managesUndoRedo) {
                        that.undoRedoStack.push(command);
                    }
                    command.editor = that;
                    command.exec();
                    if (command.async) {
                        command.change = $.proxy(function() {
                            select(that);
                        }, that);
                        return;
                    }
                }
                select(that);
            }
        }
    });
    kendo.ui.plugin(Editor);
    var Tool = Class.extend({
        init: function(options) {
            this.options = options;
        },
        initialize: function(ui, options) {
            ui.attr({
                unselectable: "on",
                title: options.title
            });
        },
        command: function(commandArguments) {
            return new this.options.command(commandArguments);
        },
        update: function() {},
        willDelayExecution: function() {
            return false;
        }
    });
    Tool.exec = function(editor, name, value) {
        editor.exec(name, {
            value: value
        });
    };
    var FormatTool = Tool.extend({
        init: function(options) {
            Tool.fn.init.call(this, options);
        },
        command: function(commandArguments) {
            var that = this;
            return new kendo.ui.editor.FormatCommand(extend(commandArguments, {
                formatter: that.options.formatter
            }));
        },
        update: function($ui, nodes, pendingFormats) {
            var isPending = pendingFormats.isPending(this.name), isFormatted = this.options.finder.isFormatted(nodes), isActive = isPending ? !isFormatted : isFormatted;
            $ui.toggleClass("k-state-active", isActive);
            $ui.attr("aria-pressed", isActive);
        }
    });
    EditorUtils.registerTool("separator", new Tool({
        template: new ToolTemplate({
            template: EditorUtils.separatorTemplate
        })
    }));
    // Exports ================================================================
    extend(kendo.ui, {
        editor: {
            ToolTemplate: ToolTemplate,
            EditorUtils: EditorUtils,
            Tool: Tool,
            FormatTool: FormatTool
        }
    });
})(window.jQuery);

(function($) {
    var kendo = window.kendo, map = $.map, extend = $.extend, browser = kendo.support.browser, STYLE = "style", FLOAT = "float", CSSFLOAT = "cssFloat", STYLEFLOAT = "styleFloat", CLASS = "class", KMARKER = "k-marker";
    function makeMap(items) {
        var obj = {}, i, len;
        for (i = 0, len = items.length; i < len; i++) {
            obj[items[i]] = true;
        }
        return obj;
    }
    var empty = makeMap("area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed".split(",")), blockElements = "div,p,h1,h2,h3,h4,h5,h6,address,applet,blockquote,button,center,dd,dir,dl,dt,fieldset,form,frameset,hr,iframe,isindex,li,map,menu,noframes,noscript,object,ol,pre,script,table,tbody,td,tfoot,th,thead,tr,ul".split(","), block = makeMap(blockElements), inlineElements = "span,em,a,abbr,acronym,applet,b,basefont,bdo,big,br,button,cite,code,del,dfn,font,i,iframe,img,input,ins,kbd,label,map,object,q,s,samp,script,select,small,strike,strong,sub,sup,textarea,tt,u,var".split(","), inline = makeMap(inlineElements), fillAttrs = makeMap("checked,compact,declare,defer,disabled,ismap,multiple,nohref,noresize,noshade,nowrap,readonly,selected".split(","));
    var normalize = function(node) {
        if (node.nodeType == 1) {
            node.normalize();
        }
    };
    if (browser.msie && browser.version >= 8) {
        normalize = function(parent) {
            if (parent.nodeType == 1 && parent.firstChild) {
                var prev = parent.firstChild, node = prev;
                while (true) {
                    node = node.nextSibling;
                    if (!node) {
                        break;
                    }
                    if (node.nodeType == 3 && prev.nodeType == 3) {
                        node.nodeValue = prev.nodeValue + node.nodeValue;
                        Dom.remove(prev);
                    }
                    prev = node;
                }
            }
        };
    }
    var whitespace = /^\s+$/, rgb = /rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/i, amp = /&/g, openTag = /</g, closeTag = />/g, nbsp = /\u00a0/g, bom = /\ufeff/g, persistedScrollTop;
    var cssAttributes = ("color,padding-left,padding-right,padding-top,padding-bottom," + "background-color,background-attachment,background-image,background-position,background-repeat," + "border-top-style,border-top-width,border-top-color," + "border-bottom-style,border-bottom-width,border-bottom-color," + "border-left-style,border-left-width,border-left-color," + "border-right-style,border-right-width,border-right-color," + "font-family,font-size,font-style,font-variant,font-weight,line-height").split(",");
    var Dom = {
        findNodeIndex: function(node) {
            var i = 0;
            while (true) {
                node = node.previousSibling;
                if (!node) {
                    break;
                }
                i++;
            }
            return i;
        },
        isDataNode: function(node) {
            return node && node.nodeValue !== null && node.data !== null;
        },
        isAncestorOf: function(parent, node) {
            try {
                return !Dom.isDataNode(parent) && ($.contains(parent, Dom.isDataNode(node) ? node.parentNode : node) || node.parentNode == parent);
            } catch (e) {
                return false;
            }
        },
        isAncestorOrSelf: function(root, node) {
            return Dom.isAncestorOf(root, node) || root == node;
        },
        findClosestAncestor: function(root, node) {
            if (Dom.isAncestorOf(root, node)) {
                while (node && node.parentNode != root) {
                    node = node.parentNode;
                }
            }
            return node;
        },
        getNodeLength: function(node) {
            return Dom.isDataNode(node) ? node.length : node.childNodes.length;
        },
        splitDataNode: function(node, offset) {
            var newNode = node.cloneNode(false), denormalizedText = "", iterator = node;
            while (iterator.nextSibling && iterator.nextSibling.nodeType == 3 && iterator.nextSibling.nodeValue) {
                denormalizedText += iterator.nextSibling.nodeValue;
                iterator = iterator.nextSibling;
            }
            node.deleteData(offset, node.length);
            newNode.deleteData(0, offset);
            newNode.nodeValue += denormalizedText;
            Dom.insertAfter(newNode, node);
        },
        attrEquals: function(node, attributes) {
            for (var key in attributes) {
                var value = node[key];
                if (key == FLOAT) {
                    value = node[$.support.cssFloat ? CSSFLOAT : STYLEFLOAT];
                }
                if (typeof value == "object") {
                    if (!Dom.attrEquals(value, attributes[key])) {
                        return false;
                    }
                } else if (value != attributes[key]) {
                    return false;
                }
            }
            return true;
        },
        blockParentOrBody: function(node) {
            return Dom.parentOfType(node, blockElements) || node.ownerDocument.body;
        },
        blockParents: function(nodes) {
            var blocks = [], i, len;
            for (i = 0, len = nodes.length; i < len; i++) {
                var block = Dom.parentOfType(nodes[i], Dom.blockElements);
                if (block && $.inArray(block, blocks) < 0) {
                    blocks.push(block);
                }
            }
            return blocks;
        },
        windowFromDocument: function(document) {
            return document.defaultView || document.parentWindow;
        },
        normalize: normalize,
        blockElements: blockElements,
        inlineElements: inlineElements,
        empty: empty,
        fillAttrs: fillAttrs,
        toHex: function(color) {
            var matches = rgb.exec(color);
            if (!matches) {
                return color;
            }
            return "#" + map(matches.slice(1), function(x) {
                x = parseInt(x, 10).toString(16);
                return x.length > 1 ? x : "0" + x;
            }).join("");
        },
        encode: function(value) {
            return value.replace(amp, "&amp;").replace(openTag, "&lt;").replace(closeTag, "&gt;").replace(nbsp, "&nbsp;");
        },
        name: function(node) {
            return node.nodeName.toLowerCase();
        },
        significantChildNodes: function(node) {
            return $.grep(node.childNodes, function(child) {
                return child.nodeType != 3 || !Dom.isWhitespace(child);
            });
        },
        lastTextNode: function(node) {
            var result = null;
            if (node.nodeType == 3) {
                return node;
            }
            for (var child = node.lastChild; child; child = child.previousSibling) {
                result = Dom.lastTextNode(child);
                if (result) {
                    return result;
                }
            }
            return result;
        },
        is: function(node, nodeName) {
            return Dom.name(node) == nodeName;
        },
        isMarker: function(node) {
            return node.className == KMARKER;
        },
        isWhitespace: function(node) {
            return whitespace.test(node.nodeValue);
        },
        isBlock: function(node) {
            return block[Dom.name(node)];
        },
        isEmpty: function(node) {
            return empty[Dom.name(node)];
        },
        isInline: function(node) {
            return inline[Dom.name(node)];
        },
        scrollContainer: function(doc) {
            var wnd = Dom.windowFromDocument(doc), scrollContainer = (wnd.contentWindow || wnd).document || wnd.ownerDocument || wnd;
            if (kendo.support.browser.webkit || scrollContainer.compatMode == "BackCompat") {
                scrollContainer = scrollContainer.body;
            } else {
                scrollContainer = scrollContainer.documentElement;
            }
            return scrollContainer;
        },
        scrollTo: function(node) {
            var element = $(Dom.isDataNode(node) ? node.parentNode : node), wnd = Dom.windowFromDocument(node.ownerDocument), windowHeight = wnd.innerHeight, elementTop, elementHeight, scrollContainer = Dom.scrollContainer(node.ownerDocument);
            if (Dom.name(element[0]) == "br") {
                element = element.parent();
            }
            elementTop = element.offset().top;
            elementHeight = element[0].offsetHeight;
            if (elementHeight + elementTop > scrollContainer.scrollTop + windowHeight) {
                scrollContainer.scrollTop = elementHeight + elementTop - windowHeight;
            }
        },
        persistScrollTop: function(doc) {
            persistedScrollTop = Dom.scrollContainer(doc).scrollTop;
        },
        restoreScrollTop: function(doc) {
            Dom.scrollContainer(doc).scrollTop = persistedScrollTop;
        },
        insertAt: function(parent, newElement, position) {
            parent.insertBefore(newElement, parent.childNodes[position] || null);
        },
        insertBefore: function(newElement, referenceElement) {
            if (referenceElement.parentNode) {
                return referenceElement.parentNode.insertBefore(newElement, referenceElement);
            } else {
                return referenceElement;
            }
        },
        insertAfter: function(newElement, referenceElement) {
            return referenceElement.parentNode.insertBefore(newElement, referenceElement.nextSibling);
        },
        remove: function(node) {
            node.parentNode.removeChild(node);
        },
        trim: function(parent) {
            for (var i = parent.childNodes.length - 1; i >= 0; i--) {
                var node = parent.childNodes[i];
                if (Dom.isDataNode(node)) {
                    if (!node.nodeValue.replace(bom, "").length) {
                        Dom.remove(node);
                    }
                    if (Dom.isWhitespace(node)) {
                        Dom.insertBefore(node, parent);
                    }
                } else if (node.className != KMARKER) {
                    Dom.trim(node);
                    if (!node.childNodes.length && !Dom.isEmpty(node)) {
                        Dom.remove(node);
                    }
                }
            }
            return parent;
        },
        parentOfType: function(node, tags) {
            do {
                node = node.parentNode;
            } while (node && !Dom.ofType(node, tags));
            return node;
        },
        ofType: function(node, tags) {
            return $.inArray(Dom.name(node), tags) >= 0;
        },
        changeTag: function(referenceElement, tagName) {
            var newElement = Dom.create(referenceElement.ownerDocument, tagName), attributes = referenceElement.attributes, i, len, name, value, attribute;
            for (i = 0, len = attributes.length; i < len; i++) {
                attribute = attributes[i];
                if (attribute.specified) {
                    // IE < 8 cannot set class or style via setAttribute
                    name = attribute.nodeName;
                    value = attribute.nodeValue;
                    if (name == CLASS) {
                        newElement.className = value;
                    } else if (name == STYLE) {
                        newElement.style.cssText = referenceElement.style.cssText;
                    } else {
                        newElement.setAttribute(name, value);
                    }
                }
            }
            while (referenceElement.firstChild) {
                newElement.appendChild(referenceElement.firstChild);
            }
            Dom.insertBefore(newElement, referenceElement);
            Dom.remove(referenceElement);
            return newElement;
        },
        wrap: function(node, wrapper) {
            Dom.insertBefore(wrapper, node);
            wrapper.appendChild(node);
            return wrapper;
        },
        unwrap: function(node) {
            var parent = node.parentNode;
            while (node.firstChild) {
                parent.insertBefore(node.firstChild, node);
            }
            parent.removeChild(node);
        },
        create: function(document, tagName, attributes) {
            return Dom.attr(document.createElement(tagName), attributes);
        },
        attr: function(element, attributes) {
            attributes = extend({}, attributes);
            if (attributes && STYLE in attributes) {
                Dom.style(element, attributes.style);
                delete attributes.style;
            }
            for (var attr in attributes) {
                if (attributes[attr] === null) {
                    element.removeAttribute(attr);
                    delete attributes[attr];
                }
            }
            return extend(element, attributes);
        },
        style: function(node, value) {
            $(node).css(value || {});
        },
        unstyle: function(node, value) {
            for (var key in value) {
                if (key == FLOAT) {
                    key = $.support.cssFloat ? CSSFLOAT : STYLEFLOAT;
                }
                node.style[key] = "";
            }
            if (node.style.cssText === "") {
                node.removeAttribute(STYLE);
            }
        },
        inlineStyle: function(document, name, attributes) {
            var span = $(Dom.create(document, name, attributes)), style;
            document.body.appendChild(span[0]);
            style = map(cssAttributes, function(value) {
                if (browser.msie && value == "line-height" && span.css(value) == "1px") {
                    return "line-height:1.5";
                } else {
                    return value + ":" + span.css(value);
                }
            }).join(";");
            span.remove();
            return style;
        },
        removeClass: function(node, classNames) {
            var className = " " + node.className + " ", classes = classNames.split(" "), i, len;
            for (i = 0, len = classes.length; i < len; i++) {
                className = className.replace(" " + classes[i] + " ", " ");
            }
            className = $.trim(className);
            if (className.length) {
                node.className = className;
            } else {
                node.removeAttribute(CLASS);
            }
        },
        commonAncestor: function() {
            var count = arguments.length, paths = [], minPathLength = Infinity, output = null, i, ancestors, node, first, j;
            if (!count) {
                return null;
            }
            if (count == 1) {
                return arguments[0];
            }
            for (i = 0; i < count; i++) {
                ancestors = [];
                node = arguments[i];
                while (node) {
                    ancestors.push(node);
                    node = node.parentNode;
                }
                paths.push(ancestors.reverse());
                minPathLength = Math.min(minPathLength, ancestors.length);
            }
            if (count == 1) {
                return paths[0][0];
            }
            for (i = 0; i < minPathLength; i++) {
                first = paths[0][i];
                for (j = 1; j < count; j++) {
                    if (first != paths[j][i]) {
                        return output;
                    }
                }
                output = first;
            }
            return output;
        }
    };
    kendo.ui.editor.Dom = Dom;
})(window.kendo.jQuery);

(function($, undefined) {
    // Imports ================================================================
    var kendo = window.kendo, Editor = kendo.ui.editor, dom = Editor.Dom, extend = $.extend;
    var fontSizeMappings = "xx-small,x-small,small,medium,large,x-large,xx-large".split(","), quoteRe = /"/g, brRe = /<br[^>]*>/i, emptyPRe = /<p><\/p>/i, cssDeclaration = /([\w|\-]+)\s*:\s*([^;]+);?/i;
    var Serializer = {
        domToXhtml: function(root) {
            var result = [];
            var tagMap = {
                "telerik:script": {
                    start: function(node) {
                        result.push("<script");
                        attr(node);
                        result.push(">");
                    },
                    end: function() {
                        result.push("</script>");
                    }
                },
                b: {
                    start: function() {
                        result.push("<strong>");
                    },
                    end: function() {
                        result.push("</strong>");
                    }
                },
                i: {
                    start: function() {
                        result.push("<em>");
                    },
                    end: function() {
                        result.push("</em>");
                    }
                },
                u: {
                    start: function() {
                        result.push('<span style="text-decoration:underline;">');
                    },
                    end: function() {
                        result.push("</span>");
                    }
                },
                iframe: {
                    start: function(node) {
                        result.push("<iframe");
                        attr(node);
                        result.push(">");
                    },
                    end: function() {
                        result.push("</iframe>");
                    }
                },
                font: {
                    start: function(node) {
                        result.push('<span style="');
                        var color = node.getAttribute("color");
                        var size = fontSizeMappings[node.getAttribute("size")];
                        var face = node.getAttribute("face");
                        if (color) {
                            result.push("color:");
                            result.push(dom.toHex(color));
                            result.push(";");
                        }
                        if (face) {
                            result.push("font-face:");
                            result.push(face);
                            result.push(";");
                        }
                        if (size) {
                            result.push("font-size:");
                            result.push(size);
                            result.push(";");
                        }
                        result.push('">');
                    },
                    end: function() {
                        result.push("</span>");
                    }
                }
            };
            function attr(node) {
                var specifiedAttributes = [], attributes = node.attributes, attribute, i, l, trim = $.trim;
                if (dom.is(node, "img")) {
                    var width = node.style.width, height = node.style.height, $node = $(node);
                    if (width) {
                        $node.attr("width", parseInt(width, 10));
                        dom.unstyle(node, {
                            width: undefined
                        });
                    }
                    if (height) {
                        $node.attr("height", parseInt(height, 10));
                        dom.unstyle(node, {
                            height: undefined
                        });
                    }
                }
                for (i = 0, l = attributes.length; i < l; i++) {
                    attribute = attributes[i];
                    var name = attribute.nodeName;
                    // In IE < 8 the 'value' attribute is not returned as 'specified'. The same goes for type="text"
                    if (attribute.specified || name == "value" && !node.value || name == "type" && attribute.nodeValue == "text") {
                        // altHtml is injected by IE8 when an <object> tag is used in the Editor
                        if (name.indexOf("_moz") < 0 && name != "complete" && name != "altHtml") {
                            specifiedAttributes.push(attribute);
                        }
                    }
                }
                if (!specifiedAttributes.length) {
                    return;
                }
                specifiedAttributes.sort(function(a, b) {
                    return a.nodeName > b.nodeName ? 1 : a.nodeName < b.nodeName ? -1 : 0;
                });
                for (i = 0, l = specifiedAttributes.length; i < l; i++) {
                    attribute = specifiedAttributes[i];
                    var attributeName = attribute.nodeName;
                    var attributeValue = attribute.nodeValue;
                    result.push(" ");
                    result.push(attributeName);
                    result.push('="');
                    if (attributeName == "style") {
                        // In IE < 8 the style attribute does not return proper nodeValue
                        var css = trim(attributeValue || node.style.cssText).split(";");
                        for (var cssIndex = 0, len = css.length; cssIndex < len; cssIndex++) {
                            var pair = css[cssIndex];
                            if (pair.length) {
                                var match = cssDeclaration.exec(pair);
                                var property = trim(match[1].toLowerCase()), value = trim(match[2]);
                                if (property == "font-size-adjust" || property == "font-stretch") {
                                    continue;
                                }
                                if (property.indexOf("color") >= 0) {
                                    value = dom.toHex(value);
                                }
                                if (property.indexOf("font") >= 0) {
                                    value = value.replace(quoteRe, "'");
                                }
                                result.push(property);
                                result.push(":");
                                result.push(value);
                                result.push(";");
                            }
                        }
                    } else if (attributeName == "src" || attributeName == "href") {
                        result.push(node.getAttribute(attributeName, 2));
                    } else {
                        result.push(dom.fillAttrs[attributeName] ? attributeName : attributeValue);
                    }
                    result.push('"');
                }
            }
            function children(node, skip) {
                for (var childNode = node.firstChild; childNode; childNode = childNode.nextSibling) {
                    child(childNode, skip);
                }
            }
            function child(node, skip) {
                var nodeType = node.nodeType, tagName, mapper, parent, value, previous;
                if (nodeType == 1) {
                    tagName = dom.name(node);
                    if (!tagName || (node.attributes._moz_dirty || node.attributes._moz_editor_bogus_node) && dom.is(node, "br") || node.className == "k-marker") {
                        return;
                    }
                    mapper = tagMap[tagName];
                    if (mapper) {
                        mapper.start(node);
                        children(node);
                        mapper.end(node);
                        return;
                    }
                    result.push("<");
                    result.push(tagName);
                    attr(node);
                    if (dom.empty[tagName]) {
                        result.push(" />");
                    } else {
                        result.push(">");
                        children(node, skip || dom.is(node, "pre"));
                        result.push("</");
                        result.push(tagName);
                        result.push(">");
                    }
                } else if (nodeType == 3) {
                    value = node.nodeValue;
                    if (!skip && $.support.leadingWhitespace) {
                        parent = node.parentNode;
                        previous = node.previousSibling;
                        if (!previous) {
                            previous = (dom.isInline(parent) ? parent : node).previousSibling;
                        }
                        if (!previous || previous.innerHTML === "" || dom.isBlock(previous)) {
                            value = value.replace(/^[\r\n\v\f\t ]+/, "");
                        }
                        value = value.replace(/ +/, " ");
                    }
                    result.push(dom.encode(value));
                } else if (nodeType == 4) {
                    result.push("<![CDATA[");
                    result.push(node.data);
                    result.push("]]>");
                } else if (nodeType == 8) {
                    if (node.data.indexOf("[CDATA[") < 0) {
                        result.push("<!--");
                        result.push(node.data);
                        result.push("-->");
                    } else {
                        result.push("<!");
                        result.push(node.data);
                        result.push(">");
                    }
                }
            }
            children(root);
            result = result.join("");
            // if serialized dom contains only whitespace elements, consider it empty (required field validation)
            if (result.replace(brRe, "").replace(emptyPRe, "") === "") {
                return "";
            }
            return result;
        }
    };
    extend(Editor, {
        Serializer: Serializer
    });
})(window.kendo.jQuery);

(function($) {
    // Imports ================================================================
    var kendo = window.kendo, Class = kendo.Class, extend = $.extend, Editor = kendo.ui.editor, browser = kendo.support.browser, dom = Editor.Dom, findNodeIndex = dom.findNodeIndex, isDataNode = dom.isDataNode, findClosestAncestor = dom.findClosestAncestor, getNodeLength = dom.getNodeLength, normalize = dom.normalize;
    var SelectionUtils = {
        selectionFromWindow: function(window) {
            if (!("getSelection" in window)) {
                return new W3CSelection(window.document);
            }
            return window.getSelection();
        },
        selectionFromRange: function(range) {
            var rangeDocument = RangeUtils.documentFromRange(range);
            return SelectionUtils.selectionFromDocument(rangeDocument);
        },
        selectionFromDocument: function(document) {
            return SelectionUtils.selectionFromWindow(dom.windowFromDocument(document));
        }
    };
    var W3CRange = Class.extend({
        init: function(doc) {
            $.extend(this, {
                ownerDocument: doc,
                /* not part of the spec; used when cloning ranges, traversing the dom and creating fragments */
                startContainer: doc,
                endContainer: doc,
                commonAncestorContainer: doc,
                startOffset: 0,
                endOffset: 0,
                collapsed: true
            });
        },
        // Positioning Methods
        setStart: function(node, offset) {
            this.startContainer = node;
            this.startOffset = offset;
            updateRangeProperties(this);
            fixIvalidRange(this, true);
        },
        setEnd: function(node, offset) {
            this.endContainer = node;
            this.endOffset = offset;
            updateRangeProperties(this);
            fixIvalidRange(this, false);
        },
        setStartBefore: function(node) {
            this.setStart(node.parentNode, findNodeIndex(node));
        },
        setStartAfter: function(node) {
            this.setStart(node.parentNode, findNodeIndex(node) + 1);
        },
        setEndBefore: function(node) {
            this.setEnd(node.parentNode, findNodeIndex(node));
        },
        setEndAfter: function(node) {
            this.setEnd(node.parentNode, findNodeIndex(node) + 1);
        },
        selectNode: function(node) {
            this.setStartBefore(node);
            this.setEndAfter(node);
        },
        selectNodeContents: function(node) {
            this.setStart(node, 0);
            this.setEnd(node, node[node.nodeType === 1 ? "childNodes" : "nodeValue"].length);
        },
        collapse: function(toStart) {
            var that = this;
            if (toStart) {
                that.setEnd(that.startContainer, that.startOffset);
            } else {
                that.setStart(that.endContainer, that.endOffset);
            }
        },
        // Editing Methods
        deleteContents: function() {
            var that = this, range = that.cloneRange();
            if (that.startContainer != that.commonAncestorContainer) {
                that.setStartAfter(findClosestAncestor(that.commonAncestorContainer, that.startContainer));
            }
            that.collapse(true);
            (function deleteSubtree(iterator) {
                while (iterator.next()) {
                    if (iterator.hasPartialSubtree()) {
                        deleteSubtree(iterator.getSubtreeIterator());
                    } else {
                        iterator.remove();
                    }
                }
            })(new RangeIterator(range));
        },
        cloneContents: function() {
            // clone subtree
            var document = RangeUtils.documentFromRange(this);
            return function cloneSubtree(iterator) {
                var node, frag = document.createDocumentFragment();
                while (node = iterator.next()) {
                    node = node.cloneNode(!iterator.hasPartialSubtree());
                    if (iterator.hasPartialSubtree()) {
                        node.appendChild(cloneSubtree(iterator.getSubtreeIterator()));
                    }
                    frag.appendChild(node);
                }
                return frag;
            }(new RangeIterator(this));
        },
        extractContents: function() {
            var that = this, range = that.cloneRange();
            if (that.startContainer != that.commonAncestorContainer) {
                that.setStartAfter(findClosestAncestor(that.commonAncestorContainer, that.startContainer));
            }
            that.collapse(true);
            var document = RangeUtils.documentFromRange(that);
            return function extractSubtree(iterator) {
                var node, frag = document.createDocumentFragment();
                while (node = iterator.next()) {
                    if (iterator.hasPartialSubtree()) {
                        node = node.cloneNode(false);
                        node.appendChild(extractSubtree(iterator.getSubtreeIterator()));
                    } else {
                        iterator.remove(that.originalRange);
                    }
                    frag.appendChild(node);
                }
                return frag;
            }(new RangeIterator(range));
        },
        insertNode: function(node) {
            var that = this;
            if (isDataNode(that.startContainer)) {
                if (that.startOffset != that.startContainer.nodeValue.length) {
                    dom.splitDataNode(that.startContainer, that.startOffset);
                }
                dom.insertAfter(node, that.startContainer);
            } else {
                dom.insertAt(that.startContainer, node, that.startOffset);
            }
            that.setStart(that.startContainer, that.startOffset);
        },
        cloneRange: function() {
            // fast copy
            return $.extend(new W3CRange(this.ownerDocument), {
                startContainer: this.startContainer,
                endContainer: this.endContainer,
                commonAncestorContainer: this.commonAncestorContainer,
                startOffset: this.startOffset,
                endOffset: this.endOffset,
                collapsed: this.collapsed,
                originalRange: this
            });
        },
        // used for debug purposes
        toString: function() {
            var startNodeName = this.startContainer.nodeName, endNodeName = this.endContainer.nodeName;
            return [ startNodeName == "#text" ? this.startContainer.nodeValue : startNodeName, "(", this.startOffset, ") : ", endNodeName == "#text" ? this.endContainer.nodeValue : endNodeName, "(", this.endOffset, ")" ].join("");
        }
    });
    /* can be used in Range.compareBoundaryPoints if we need it one day */
    function compareBoundaries(start, end, startOffset, endOffset) {
        if (start == end) {
            return endOffset - startOffset;
        }
        // end is child of start
        var container = end;
        while (container && container.parentNode != start) {
            container = container.parentNode;
        }
        if (container) {
            return findNodeIndex(container) - startOffset;
        }
        // start is child of end
        container = start;
        while (container && container.parentNode != end) {
            container = container.parentNode;
        }
        if (container) {
            return endOffset - findNodeIndex(container) - 1;
        }
        // deep traversal
        var root = dom.commonAncestor(start, end);
        var startAncestor = start;
        while (startAncestor && startAncestor.parentNode != root) {
            startAncestor = startAncestor.parentNode;
        }
        if (!startAncestor) {
            startAncestor = root;
        }
        var endAncestor = end;
        while (endAncestor && endAncestor.parentNode != root) {
            endAncestor = endAncestor.parentNode;
        }
        if (!endAncestor) {
            endAncestor = root;
        }
        if (startAncestor == endAncestor) {
            return 0;
        }
        return findNodeIndex(endAncestor) - findNodeIndex(startAncestor);
    }
    function fixIvalidRange(range, toStart) {
        function isInvalidRange(range) {
            try {
                return compareBoundaries(range.startContainer, range.endContainer, range.startOffset, range.endOffset) < 0;
            } catch (ex) {
                // range was initially invalid (e.g. when cloned from invalid range) - it must be fixed
                return true;
            }
        }
        if (isInvalidRange(range)) {
            if (toStart) {
                range.commonAncestorContainer = range.endContainer = range.startContainer;
                range.endOffset = range.startOffset;
            } else {
                range.commonAncestorContainer = range.startContainer = range.endContainer;
                range.startOffset = range.endOffset;
            }
            range.collapsed = true;
        }
    }
    function updateRangeProperties(range) {
        range.collapsed = range.startContainer == range.endContainer && range.startOffset == range.endOffset;
        var node = range.startContainer;
        while (node && node != range.endContainer && !dom.isAncestorOf(node, range.endContainer)) {
            node = node.parentNode;
        }
        range.commonAncestorContainer = node;
    }
    var RangeIterator = Class.extend({
        init: function(range) {
            $.extend(this, {
                range: range,
                _current: null,
                _next: null,
                _end: null
            });
            if (range.collapsed) {
                return;
            }
            var root = range.commonAncestorContainer;
            this._next = range.startContainer == root && !isDataNode(range.startContainer) ? range.startContainer.childNodes[range.startOffset] : findClosestAncestor(root, range.startContainer);
            this._end = range.endContainer == root && !isDataNode(range.endContainer) ? range.endContainer.childNodes[range.endOffset] : findClosestAncestor(root, range.endContainer).nextSibling;
        },
        hasNext: function() {
            return !!this._next;
        },
        next: function() {
            var that = this, current = that._current = that._next;
            that._next = that._current && that._current.nextSibling != that._end ? that._current.nextSibling : null;
            if (isDataNode(that._current)) {
                if (that.range.endContainer == that._current) {
                    current = current.cloneNode(true);
                    current.deleteData(that.range.endOffset, current.length - that.range.endOffset);
                }
                if (that.range.startContainer == that._current) {
                    current = current.cloneNode(true);
                    current.deleteData(0, that.range.startOffset);
                }
            }
            return current;
        },
        traverse: function(callback) {
            var that = this, current;
            function next() {
                that._current = that._next;
                that._next = that._current && that._current.nextSibling != that._end ? that._current.nextSibling : null;
                return that._current;
            }
            while (current = next()) {
                if (that.hasPartialSubtree()) {
                    that.getSubtreeIterator().traverse(callback);
                } else {
                    callback(current);
                }
            }
            return current;
        },
        remove: function(originalRange) {
            var that = this, inStartContainer = that.range.startContainer == that._current, inEndContainer = that.range.endContainer == that._current, start, end, delta;
            if (isDataNode(that._current) && (inStartContainer || inEndContainer)) {
                start = inStartContainer ? that.range.startOffset : 0;
                end = inEndContainer ? that.range.endOffset : that._current.length;
                delta = end - start;
                if (originalRange && (inStartContainer || inEndContainer)) {
                    if (that._current == originalRange.startContainer && start <= originalRange.startOffset) {
                        originalRange.startOffset -= delta;
                    }
                    if (that._current == originalRange.endContainer && end <= originalRange.endOffset) {
                        originalRange.endOffset -= delta;
                    }
                }
                that._current.deleteData(start, delta);
            } else {
                var parent = that._current.parentNode;
                if (originalRange && (that.range.startContainer == parent || that.range.endContainer == parent)) {
                    var nodeIndex = findNodeIndex(that._current);
                    if (parent == originalRange.startContainer && nodeIndex <= originalRange.startOffset) {
                        originalRange.startOffset -= 1;
                    }
                    if (parent == originalRange.endContainer && nodeIndex < originalRange.endOffset) {
                        originalRange.endOffset -= 1;
                    }
                }
                dom.remove(that._current);
            }
        },
        hasPartialSubtree: function() {
            return !isDataNode(this._current) && (dom.isAncestorOrSelf(this._current, this.range.startContainer) || dom.isAncestorOrSelf(this._current, this.range.endContainer));
        },
        getSubtreeIterator: function() {
            var that = this, subRange = that.range.cloneRange();
            subRange.selectNodeContents(that._current);
            if (dom.isAncestorOrSelf(that._current, that.range.startContainer)) {
                subRange.setStart(that.range.startContainer, that.range.startOffset);
            }
            if (dom.isAncestorOrSelf(that._current, that.range.endContainer)) {
                subRange.setEnd(that.range.endContainer, that.range.endOffset);
            }
            return new RangeIterator(subRange);
        }
    });
    var W3CSelection = Class.extend({
        init: function(doc) {
            this.ownerDocument = doc;
            this.rangeCount = 1;
        },
        addRange: function(range) {
            var textRange = this.ownerDocument.body.createTextRange();
            // end container should be adopted first in order to prevent selection with negative length
            adoptContainer(textRange, range, false);
            adoptContainer(textRange, range, true);
            textRange.select();
        },
        removeAllRanges: function() {
            this.ownerDocument.selection.empty();
        },
        getRangeAt: function() {
            var textRange, range = new W3CRange(this.ownerDocument), selection = this.ownerDocument.selection, element;
            try {
                textRange = selection.createRange();
                element = textRange.item ? textRange.item(0) : textRange.parentElement();
                if (element.ownerDocument != this.ownerDocument) {
                    return range;
                }
            } catch (ex) {
                return range;
            }
            if (selection.type == "Control") {
                range.selectNode(textRange.item(0));
            } else {
                adoptEndPoint(textRange, range, true);
                adoptEndPoint(textRange, range, false);
                if (range.startContainer.nodeType == 9) {
                    range.setStart(range.endContainer, range.startOffset);
                }
                if (range.endContainer.nodeType == 9) {
                    range.setEnd(range.startContainer, range.endOffset);
                }
                if (textRange.compareEndPoints("StartToEnd", textRange) === 0) {
                    range.collapse(false);
                }
                var startContainer = range.startContainer, endContainer = range.endContainer, body = this.ownerDocument.body;
                if (!range.collapsed && range.startOffset === 0 && range.endOffset == getNodeLength(range.endContainer) && // check for full body selection
                !(startContainer == endContainer && isDataNode(startContainer) && startContainer.parentNode == body)) {
                    // but not when single textnode is selected
                    var movedStart = false, movedEnd = false;
                    while (findNodeIndex(startContainer) === 0 && startContainer == startContainer.parentNode.firstChild && startContainer != body) {
                        startContainer = startContainer.parentNode;
                        movedStart = true;
                    }
                    while (findNodeIndex(endContainer) == getNodeLength(endContainer.parentNode) - 1 && endContainer == endContainer.parentNode.lastChild && endContainer != body) {
                        endContainer = endContainer.parentNode;
                        movedEnd = true;
                    }
                    if (startContainer == body && endContainer == body && movedStart && movedEnd) {
                        range.setStart(startContainer, 0);
                        range.setEnd(endContainer, getNodeLength(body));
                    }
                }
            }
            return range;
        }
    });
    function adoptContainer(textRange, range, start) {
        // find anchor node and offset
        var container = range[start ? "startContainer" : "endContainer"];
        var offset = range[start ? "startOffset" : "endOffset"], textOffset = 0;
        var anchorNode = isDataNode(container) ? container : container.childNodes[offset] || null;
        var anchorParent = isDataNode(container) ? container.parentNode : container;
        // visible data nodes need a text offset
        if (container.nodeType == 3 || container.nodeType == 4) {
            textOffset = offset;
        }
        // create a cursor element node to position range (since we can't select text nodes)
        var cursorNode = anchorParent.insertBefore(dom.create(range.ownerDocument, "a"), anchorNode);
        var cursor = range.ownerDocument.body.createTextRange();
        cursor.moveToElementText(cursorNode);
        dom.remove(cursorNode);
        cursor[start ? "moveStart" : "moveEnd"]("character", textOffset);
        cursor.collapse(false);
        textRange.setEndPoint(start ? "StartToStart" : "EndToStart", cursor);
    }
    function adoptEndPoint(textRange, range, start) {
        var cursorNode = dom.create(range.ownerDocument, "a"), cursor = textRange.duplicate();
        cursor.collapse(start);
        var parent = cursor.parentElement();
        do {
            parent.insertBefore(cursorNode, cursorNode.previousSibling);
            cursor.moveToElementText(cursorNode);
        } while (cursor.compareEndPoints(start ? "StartToStart" : "StartToEnd", textRange) > 0 && cursorNode.previousSibling);
        cursor.setEndPoint(start ? "EndToStart" : "EndToEnd", textRange);
        var target = cursorNode.nextSibling;
        if (!target) {
            // at end of text node
            target = cursorNode.previousSibling;
            if (target && isDataNode(target)) {
                // in case of collapsed range in empty tag
                range.setEnd(target, target.nodeValue.length);
                dom.remove(cursorNode);
            } else {
                range.selectNodeContents(parent);
                dom.remove(cursorNode);
                range.endOffset -= 1;
            }
            return;
        }
        dom.remove(cursorNode);
        if (isDataNode(target)) {
            range[start ? "setStart" : "setEnd"](target, cursor.text.length);
        } else {
            range[start ? "setStartBefore" : "setEndBefore"](target);
        }
    }
    var RangeEnumerator = Class.extend({
        init: function(range) {
            this.enumerate = function() {
                var nodes = [];
                function visit(node) {
                    if (dom.is(node, "img") || node.nodeType == 3 && !dom.isWhitespace(node)) {
                        nodes.push(node);
                    } else {
                        node = node.firstChild;
                        while (node) {
                            visit(node);
                            node = node.nextSibling;
                        }
                    }
                }
                new RangeIterator(range).traverse(visit);
                return nodes;
            };
        }
    });
    var RestorePoint = Class.extend({
        init: function(range) {
            var that = this;
            that.range = range;
            that.rootNode = RangeUtils.documentFromRange(range);
            that.body = that.rootNode.body;
            that.html = that.body.innerHTML;
            that.startContainer = that.nodeToPath(range.startContainer);
            that.endContainer = that.nodeToPath(range.endContainer);
            that.startOffset = that.offset(range.startContainer, range.startOffset);
            that.endOffset = that.offset(range.endContainer, range.endOffset);
        },
        index: function(node) {
            var result = 0, lastType = node.nodeType;
            while (node = node.previousSibling) {
                var nodeType = node.nodeType;
                if (nodeType != 3 || lastType != nodeType) {
                    result++;
                }
                lastType = nodeType;
            }
            return result;
        },
        offset: function(node, value) {
            if (node.nodeType == 3) {
                while ((node = node.previousSibling) && node.nodeType == 3) {
                    value += node.nodeValue.length;
                }
            }
            return value;
        },
        nodeToPath: function(node) {
            var path = [];
            while (node != this.rootNode) {
                path.push(this.index(node));
                node = node.parentNode;
            }
            return path;
        },
        toRangePoint: function(range, start, path, denormalizedOffset) {
            var node = this.rootNode, length = path.length, offset = denormalizedOffset;
            while (length--) {
                node = node.childNodes[path[length]];
            }
            while (node.nodeType == 3 && node.nodeValue.length < offset) {
                offset -= node.nodeValue.length;
                node = node.nextSibling;
            }
            range[start ? "setStart" : "setEnd"](node, offset);
        },
        toRange: function() {
            var that = this, result = that.range.cloneRange();
            that.toRangePoint(result, true, that.startContainer, that.startOffset);
            that.toRangePoint(result, false, that.endContainer, that.endOffset);
            return result;
        }
    });
    var Marker = Class.extend({
        init: function() {
            this.caret = null;
        },
        addCaret: function(range) {
            var that = this;
            that.caret = dom.create(RangeUtils.documentFromRange(range), "span", {
                className: "k-marker"
            });
            range.insertNode(that.caret);
            range.selectNode(that.caret);
            return that.caret;
        },
        removeCaret: function(range) {
            var that = this, previous = that.caret.previousSibling, startOffset = 0;
            if (previous) {
                startOffset = isDataNode(previous) ? previous.nodeValue.length : findNodeIndex(previous);
            }
            var container = that.caret.parentNode;
            var containerIndex = previous ? findNodeIndex(previous) : 0;
            dom.remove(that.caret);
            normalize(container);
            var node = container.childNodes[containerIndex];
            if (isDataNode(node)) {
                range.setStart(node, startOffset);
            } else if (node) {
                var textNode = dom.lastTextNode(node);
                if (textNode) {
                    range.setStart(textNode, textNode.nodeValue.length);
                } else {
                    range[previous ? "setStartAfter" : "setStartBefore"](node);
                }
            } else {
                if (!browser.msie && !container.innerHTML) {
                    container.innerHTML = '<br _moz_dirty="" />';
                }
                range.selectNodeContents(container);
            }
            range.collapse(true);
        },
        add: function(range, expand) {
            var that = this;
            if (expand && range.collapsed) {
                that.addCaret(range);
                range = RangeUtils.expand(range);
            }
            var rangeBoundary = range.cloneRange();
            rangeBoundary.collapse(false);
            that.end = dom.create(RangeUtils.documentFromRange(range), "span", {
                className: "k-marker"
            });
            rangeBoundary.insertNode(that.end);
            rangeBoundary = range.cloneRange();
            rangeBoundary.collapse(true);
            that.start = that.end.cloneNode(true);
            rangeBoundary.insertNode(that.start);
            range.setStartBefore(that.start);
            range.setEndAfter(that.end);
            normalize(range.commonAncestorContainer);
            return range;
        },
        remove: function(range) {
            var that = this, start = that.start, end = that.end, shouldNormalizeStart, shouldNormalizeEnd, shouldNormalize;
            normalize(range.commonAncestorContainer);
            while (!start.nextSibling && start.parentNode) {
                start = start.parentNode;
            }
            while (!end.previousSibling && end.parentNode) {
                end = end.parentNode;
            }
            // merely accessing the siblings will solve range issues in IE
            shouldNormalizeStart = start.previousSibling && start.previousSibling.nodeType == 3 && start.nextSibling && start.nextSibling.nodeType == 3;
            shouldNormalizeEnd = end.previousSibling && end.previousSibling.nodeType == 3 && end.nextSibling && end.nextSibling.nodeType == 3;
            shouldNormalize = shouldNormalizeStart && shouldNormalizeEnd;
            start = start.nextSibling;
            end = end.previousSibling;
            var collapsed = false;
            var collapsedToStart = false;
            // collapsed range
            if (start == that.end) {
                collapsedToStart = !!that.start.previousSibling;
                start = end = that.start.previousSibling || that.end.nextSibling;
                collapsed = true;
            }
            dom.remove(that.start);
            dom.remove(that.end);
            if (!start || !end) {
                range.selectNodeContents(range.commonAncestorContainer);
                range.collapse(true);
                return;
            }
            var startOffset = collapsed ? isDataNode(start) ? start.nodeValue.length : start.childNodes.length : 0;
            var endOffset = isDataNode(end) ? end.nodeValue.length : end.childNodes.length;
            if (start.nodeType == 3) {
                while (start.previousSibling && start.previousSibling.nodeType == 3) {
                    start = start.previousSibling;
                    startOffset += start.nodeValue.length;
                }
            }
            if (end.nodeType == 3) {
                while (end.previousSibling && end.previousSibling.nodeType == 3) {
                    end = end.previousSibling;
                    endOffset += end.nodeValue.length;
                }
            }
            var startIndex = findNodeIndex(start), startParent = start.parentNode;
            var endIndex = findNodeIndex(end), endParent = end.parentNode;
            for (var startPointer = start; startPointer.previousSibling; startPointer = startPointer.previousSibling) {
                if (startPointer.nodeType == 3 && startPointer.previousSibling.nodeType == 3) {
                    startIndex--;
                }
            }
            for (var endPointer = end; endPointer.previousSibling; endPointer = endPointer.previousSibling) {
                if (endPointer.nodeType == 3 && endPointer.previousSibling.nodeType == 3) {
                    endIndex--;
                }
            }
            normalize(startParent);
            if (start.nodeType == 3) {
                start = startParent.childNodes[startIndex];
            }
            normalize(endParent);
            if (end.nodeType == 3) {
                end = endParent.childNodes[endIndex];
            }
            if (collapsed) {
                if (start.nodeType == 3) {
                    range.setStart(start, startOffset);
                } else {
                    range[collapsedToStart ? "setStartAfter" : "setStartBefore"](start);
                }
                range.collapse(true);
            } else {
                if (start.nodeType == 3) {
                    range.setStart(start, startOffset);
                } else {
                    range.setStartBefore(start);
                }
                if (end.nodeType == 3) {
                    range.setEnd(end, endOffset);
                } else {
                    range.setEndAfter(end);
                }
            }
            if (that.caret) {
                that.removeCaret(range);
            }
        }
    });
    var boundary = /[\u0009-\u000d]|\u0020|\u00a0|\ufeff|\.|,|;|:|!|\(|\)|\?/;
    var RangeUtils = {
        nodes: function(range) {
            var nodes = RangeUtils.textNodes(range);
            if (!nodes.length) {
                range.selectNodeContents(range.commonAncestorContainer);
                nodes = RangeUtils.textNodes(range);
                if (!nodes.length) {
                    nodes = dom.significantChildNodes(range.commonAncestorContainer);
                }
            }
            return nodes;
        },
        textNodes: function(range) {
            return new RangeEnumerator(range).enumerate();
        },
        documentFromRange: function(range) {
            var startContainer = range.startContainer;
            return startContainer.nodeType == 9 ? startContainer : startContainer.ownerDocument;
        },
        createRange: function(document) {
            if (browser.msie && browser.version < 9) {
                return new W3CRange(document);
            }
            return document.createRange();
        },
        selectRange: function(range) {
            var image = RangeUtils.image(range);
            if (image) {
                range.setStartAfter(image);
                range.setEndAfter(image);
            }
            var selection = SelectionUtils.selectionFromRange(range);
            selection.removeAllRanges();
            selection.addRange(range);
        },
        split: function(range, node, trim) {
            function partition(start) {
                var partitionRange = range.cloneRange();
                partitionRange.collapse(start);
                partitionRange[start ? "setStartBefore" : "setEndAfter"](node);
                var contents = partitionRange.extractContents();
                if (trim) {
                    contents = dom.trim(contents);
                }
                dom[start ? "insertBefore" : "insertAfter"](contents, node);
            }
            partition(true);
            partition(false);
        },
        getMarkers: function(range) {
            var markers = [];
            new RangeIterator(range).traverse(function(node) {
                if (node.className == "k-marker") {
                    markers.push(node);
                }
            });
            return markers;
        },
        image: function(range) {
            var nodes = [];
            new RangeIterator(range).traverse(function(node) {
                if (dom.is(node, "img")) {
                    nodes.push(node);
                }
            });
            if (nodes.length == 1) {
                return nodes[0];
            }
        },
        expand: function(range) {
            var result = range.cloneRange();
            var startContainer = result.startContainer.childNodes[result.startOffset === 0 ? 0 : result.startOffset - 1];
            var endContainer = result.endContainer.childNodes[result.endOffset];
            if (!isDataNode(startContainer) || !isDataNode(endContainer)) {
                return result;
            }
            var beforeCaret = startContainer.nodeValue;
            var afterCaret = endContainer.nodeValue;
            if (!beforeCaret || !afterCaret) {
                return result;
            }
            var startOffset = beforeCaret.split("").reverse().join("").search(boundary);
            var endOffset = afterCaret.search(boundary);
            if (!startOffset || !endOffset) {
                return result;
            }
            endOffset = endOffset == -1 ? afterCaret.length : endOffset;
            startOffset = startOffset == -1 ? 0 : beforeCaret.length - startOffset;
            result.setStart(startContainer, startOffset);
            result.setEnd(endContainer, endOffset);
            return result;
        },
        isExpandable: function(range) {
            var node = range.startContainer;
            var rangeDocument = RangeUtils.documentFromRange(range);
            if (node == rangeDocument || node == rangeDocument.body) {
                return false;
            }
            var result = range.cloneRange();
            var value = node.nodeValue;
            if (!value) {
                return false;
            }
            var beforeCaret = value.substring(0, result.startOffset);
            var afterCaret = value.substring(result.startOffset);
            var startOffset = 0, endOffset = 0;
            if (beforeCaret) {
                startOffset = beforeCaret.split("").reverse().join("").search(boundary);
            }
            if (afterCaret) {
                endOffset = afterCaret.search(boundary);
            }
            return startOffset && endOffset;
        }
    };
    extend(Editor, {
        SelectionUtils: SelectionUtils,
        W3CRange: W3CRange,
        RangeIterator: RangeIterator,
        W3CSelection: W3CSelection,
        RangeEnumerator: RangeEnumerator,
        RestorePoint: RestorePoint,
        Marker: Marker,
        RangeUtils: RangeUtils
    });
})(window.kendo.jQuery);

(function($) {
    // Imports ================================================================
    var kendo = window.kendo, Class = kendo.Class, Editor = kendo.ui.editor, EditorUtils = Editor.EditorUtils, registerTool = EditorUtils.registerTool, dom = Editor.Dom, RangeUtils = Editor.RangeUtils, selectRange = RangeUtils.selectRange, Tool = Editor.Tool, ToolTemplate = Editor.ToolTemplate, RestorePoint = Editor.RestorePoint, Marker = Editor.Marker, extend = $.extend;
    var Command = Class.extend({
        init: function(options) {
            var that = this;
            that.options = options;
            that.restorePoint = new RestorePoint(options.range);
            that.marker = new Marker();
            that.formatter = options.formatter;
        },
        getRange: function() {
            return this.restorePoint.toRange();
        },
        lockRange: function(expand) {
            return this.marker.add(this.getRange(), expand);
        },
        releaseRange: function(range) {
            this.marker.remove(range);
            selectRange(range);
        },
        undo: function() {
            var point = this.restorePoint;
            point.body.innerHTML = point.html;
            selectRange(point.toRange());
        },
        redo: function() {
            this.exec();
        },
        exec: function() {
            var that = this, range = that.lockRange(true);
            that.formatter.editor = that.editor;
            that.formatter.toggle(range);
            that.releaseRange(range);
        }
    });
    var GenericCommand = Class.extend({
        init: function(startRestorePoint, endRestorePoint) {
            this.body = startRestorePoint.body;
            this.startRestorePoint = startRestorePoint;
            this.endRestorePoint = endRestorePoint;
        },
        redo: function() {
            this.body.innerHTML = this.endRestorePoint.html;
            selectRange(this.endRestorePoint.toRange());
        },
        undo: function() {
            this.body.innerHTML = this.startRestorePoint.html;
            selectRange(this.startRestorePoint.toRange());
        }
    });
    var InsertHtmlCommand = Command.extend({
        init: function(options) {
            Command.fn.init.call(this, options);
            this.managesUndoRedo = true;
        },
        exec: function() {
            var editor = this.editor;
            var range = editor.getRange();
            var startRestorePoint = new RestorePoint(range);
            editor.clipboard.paste(this.options.value || "");
            editor.undoRedoStack.push(new GenericCommand(startRestorePoint, new RestorePoint(editor.getRange())));
            editor.focus();
        }
    });
    var InsertHtmlTool = Tool.extend({
        initialize: function(ui, initOptions) {
            var editor = initOptions.editor, options = this.options, dataSource = options.items ? options.items : editor.options.insertHtml;
            new Editor.SelectBox(ui, {
                dataSource: dataSource,
                dataTextField: "text",
                dataValueField: "value",
                change: function() {
                    Tool.exec(editor, "insertHtml", this.value());
                },
                title: editor.options.messages.insertHtml,
                highlightFirst: false
            });
        },
        command: function(commandArguments) {
            return new InsertHtmlCommand(commandArguments);
        },
        update: function(ui) {
            var selectbox = ui.data("kendoSelectBox") || ui.find("select").data("kendoSelectBox");
            selectbox.close();
            selectbox.value(selectbox.options.title);
        }
    });
    var UndoRedoStack = Class.extend({
        init: function() {
            this.stack = [];
            this.currentCommandIndex = -1;
        },
        push: function(command) {
            var that = this;
            that.stack = that.stack.slice(0, that.currentCommandIndex + 1);
            that.currentCommandIndex = that.stack.push(command) - 1;
        },
        undo: function() {
            if (this.canUndo()) {
                this.stack[this.currentCommandIndex--].undo();
            }
        },
        redo: function() {
            if (this.canRedo()) {
                this.stack[++this.currentCommandIndex].redo();
            }
        },
        canUndo: function() {
            return this.currentCommandIndex >= 0;
        },
        canRedo: function() {
            return this.currentCommandIndex != this.stack.length - 1;
        }
    });
    var TypingHandler = Class.extend({
        init: function(editor) {
            this.editor = editor;
        },
        keydown: function(e) {
            var that = this, editor = that.editor, keyboard = editor.keyboard, isTypingKey = keyboard.isTypingKey(e), evt = extend($.Event(), e);
            that.editor.trigger("keydown", evt);
            if (evt.isDefaultPrevented()) {
                e.preventDefault();
            }
            if (!evt.isDefaultPrevented() && isTypingKey && !keyboard.isTypingInProgress()) {
                var range = editor.getRange();
                that.startRestorePoint = new RestorePoint(range);
                keyboard.startTyping(function() {
                    editor.selectionRestorePoint = that.endRestorePoint = new RestorePoint(editor.getRange());
                    editor.undoRedoStack.push(new GenericCommand(that.startRestorePoint, that.endRestorePoint));
                });
                return true;
            }
            return false;
        },
        keyup: function(e) {
            var keyboard = this.editor.keyboard;
            this.editor.trigger("keyup", e);
            if (keyboard.isTypingInProgress()) {
                keyboard.endTyping();
                return true;
            }
            return false;
        }
    });
    var SystemHandler = Class.extend({
        init: function(editor) {
            this.editor = editor;
            this.systemCommandIsInProgress = false;
        },
        createUndoCommand: function() {
            var that = this;
            that.endRestorePoint = new RestorePoint(that.editor.getRange());
            that.editor.undoRedoStack.push(new GenericCommand(that.startRestorePoint, that.endRestorePoint));
            that.startRestorePoint = that.endRestorePoint;
        },
        changed: function() {
            if (this.startRestorePoint) {
                return this.startRestorePoint.html != this.editor.body.innerHTML;
            }
            return false;
        },
        keydown: function(e) {
            var that = this, editor = that.editor, keyboard = editor.keyboard;
            if (keyboard.isModifierKey(e)) {
                if (keyboard.isTypingInProgress()) {
                    keyboard.endTyping(true);
                }
                that.startRestorePoint = new RestorePoint(editor.getRange());
                return true;
            }
            if (keyboard.isSystem(e)) {
                that.systemCommandIsInProgress = true;
                if (that.changed()) {
                    that.systemCommandIsInProgress = false;
                    that.createUndoCommand();
                }
                return true;
            }
            return false;
        },
        keyup: function(e) {
            var that = this;
            if (that.systemCommandIsInProgress && that.changed()) {
                that.systemCommandIsInProgress = false;
                that.createUndoCommand(e);
                return true;
            }
            return false;
        }
    });
    var Keyboard = Class.extend({
        init: function(handlers) {
            this.handlers = handlers;
            this.typingInProgress = false;
        },
        isCharacter: function(keyCode) {
            return keyCode >= 48 && keyCode <= 90 || keyCode >= 96 && keyCode <= 111 || keyCode >= 186 && keyCode <= 192 || keyCode >= 219 && keyCode <= 222;
        },
        toolFromShortcut: function(tools, e) {
            var key = String.fromCharCode(e.keyCode), toolName, toolOptions;
            for (toolName in tools) {
                toolOptions = $.extend({
                    ctrl: false,
                    alt: false,
                    shift: false
                }, tools[toolName].options);
                if ((toolOptions.key == key || toolOptions.key == e.keyCode) && toolOptions.ctrl == e.ctrlKey && toolOptions.alt == e.altKey && toolOptions.shift == e.shiftKey) {
                    return toolName;
                }
            }
        },
        isTypingKey: function(e) {
            var keyCode = e.keyCode;
            return this.isCharacter(keyCode) && !e.ctrlKey && !e.altKey || keyCode == 32 || keyCode == 13 || keyCode == 8 || keyCode == 46 && !e.shiftKey && !e.ctrlKey && !e.altKey;
        },
        isModifierKey: function(e) {
            var keyCode = e.keyCode;
            return keyCode == 17 && !e.shiftKey && !e.altKey || keyCode == 16 && !e.ctrlKey && !e.altKey || keyCode == 18 && !e.ctrlKey && !e.shiftKey;
        },
        isSystem: function(e) {
            return e.keyCode == 46 && e.ctrlKey && !e.altKey && !e.shiftKey;
        },
        startTyping: function(callback) {
            this.onEndTyping = callback;
            this.typingInProgress = true;
        },
        stopTyping: function() {
            this.typingInProgress = false;
            if (this.onEndTyping) {
                this.onEndTyping();
            }
        },
        endTyping: function(force) {
            var that = this;
            that.clearTimeout();
            if (force) {
                that.stopTyping();
            } else {
                that.timeout = window.setTimeout($.proxy(that.stopTyping, that), 1e3);
            }
        },
        isTypingInProgress: function() {
            return this.typingInProgress;
        },
        clearTimeout: function() {
            window.clearTimeout(this.timeout);
        },
        notify: function(e, what) {
            var i, handlers = this.handlers;
            for (i = 0; i < handlers.length; i++) {
                if (handlers[i][what](e)) {
                    break;
                }
            }
        },
        keydown: function(e) {
            this.notify(e, "keydown");
        },
        keyup: function(e) {
            this.notify(e, "keyup");
        }
    });
    var Clipboard = Class.extend({
        init: function(editor) {
            this.editor = editor;
            this.cleaners = [ new MSWordFormatCleaner(), new WebkitFormatCleaner() ];
        },
        htmlToFragment: function(html) {
            var editor = this.editor, doc = editor.document, container = dom.create(doc, "div"), fragment = doc.createDocumentFragment();
            container.innerHTML = html;
            while (container.firstChild) {
                fragment.appendChild(container.firstChild);
            }
            return fragment;
        },
        isBlock: function(html) {
            return /<(div|p|ul|ol|table|h[1-6])/i.test(html);
        },
        oncut: function() {
            var editor = this.editor, startRestorePoint = new RestorePoint(editor.getRange());
            setTimeout(function() {
                editor.undoRedoStack.push(new GenericCommand(startRestorePoint, new RestorePoint(editor.getRange())));
            });
        },
        onpaste: function(e) {
            var editor = this.editor, range = editor.getRange(), bom = "﻿", startRestorePoint = new RestorePoint(range), clipboardNode = dom.create(editor.document, "div", {
                className: "k-paste-container",
                innerHTML: bom
            });
            dom.persistScrollTop(editor.document);
            editor.body.appendChild(clipboardNode);
            if (editor.body.createTextRange) {
                e.preventDefault();
                var r = editor.createRange();
                r.selectNodeContents(clipboardNode);
                editor.selectRange(r);
                var textRange = editor.body.createTextRange();
                textRange.moveToElementText(clipboardNode);
                $(editor.body).unbind("paste");
                textRange.execCommand("Paste");
                $(editor.body).bind("paste", $.proxy(arguments.callee, this));
            } else {
                var clipboardRange = editor.createRange();
                clipboardRange.selectNodeContents(clipboardNode);
                selectRange(clipboardRange);
            }
            range.deleteContents();
            setTimeout(function() {
                var html, args = {
                    html: ""
                };
                selectRange(range);
                // iOS5 will substitute the paste container with its own element
                if (!clipboardNode.parentNode) {
                    clipboardNode = editor.body.lastChild;
                }
                dom.remove(clipboardNode);
                if (clipboardNode.lastChild && dom.is(clipboardNode.lastChild, "br")) {
                    dom.remove(clipboardNode.lastChild);
                }
                html = clipboardNode.innerHTML;
                if (html != bom) {
                    args.html = html;
                }
                editor.trigger("paste", args);
                editor.clipboard.paste(args.html, true);
                editor.undoRedoStack.push(new GenericCommand(startRestorePoint, new RestorePoint(editor.getRange())));
                Editor.EditorUtils.select(editor);
            });
        },
        splittableParent: function(block, node) {
            var parentNode, body;
            if (block) {
                return dom.parentOfType(node, [ "p", "ul", "ol" ]) || node.parentNode;
            }
            parentNode = node.parentNode;
            body = node.ownerDocument.body;
            if (dom.isInline(parentNode)) {
                while (parentNode.parentNode != body && !dom.isBlock(parentNode.parentNode)) {
                    parentNode = parentNode.parentNode;
                }
            }
            return parentNode;
        },
        paste: function(html, clean) {
            var editor = this.editor, i, l;
            for (i = 0, l = this.cleaners.length; i < l; i++) {
                if (this.cleaners[i].applicable(html)) {
                    html = this.cleaners[i].clean(html);
                }
            }
            if (clean) {
                // remove br elements which immediately precede block elements
                html = html.replace(/(<br>(\s|&nbsp;)*)+(<\/?(div|p|li|col|t))/gi, "$3");
                // remove empty inline elements
                html = html.replace(/<(a|span)[^>]*><\/\1>/gi, "");
            }
            // It is possible in IE to copy just <li> tags
            html = html.replace(/^<li/i, "<ul><li").replace(/li>$/g, "li></ul>");
            var block = this.isBlock(html);
            var range = editor.getRange();
            range.deleteContents();
            if (range.startContainer == editor.document) {
                range.selectNodeContents(editor.body);
            }
            var marker = new Marker();
            var caret = marker.addCaret(range);
            var parent = this.splittableParent(block, caret);
            var unwrap = false;
            if (!/body|td/.test(dom.name(parent)) && (block || dom.isInline(parent))) {
                range.selectNode(caret);
                RangeUtils.split(range, parent, true);
                unwrap = true;
            }
            var fragment = this.htmlToFragment(html);
            if (fragment.firstChild && fragment.firstChild.className === "k-paste-container") {
                var fragmentsHtml = [];
                for (i = 0, l = fragment.childNodes.length; i < l; i++) {
                    fragmentsHtml.push(fragment.childNodes[i].innerHTML);
                }
                fragment = this.htmlToFragment(fragmentsHtml.join("<br />"));
            }
            range.insertNode(fragment);
            parent = this.splittableParent(block, caret);
            if (unwrap) {
                while (caret.parentNode != parent) {
                    dom.unwrap(caret.parentNode);
                }
                dom.unwrap(caret.parentNode);
            }
            dom.normalize(range.commonAncestorContainer);
            caret.style.display = "inline";
            dom.restoreScrollTop(editor.document);
            dom.scrollTo(caret);
            marker.removeCaret(range);
            selectRange(range);
        }
    });
    var MSWordFormatCleaner = Class.extend({
        init: function() {
            this.replacements = [ /<\?xml[^>]*>/gi, "", /<!--(.|\n)*?-->/g, "", /* comments */
            /&quot;/g, "'", /* encoded quotes (in attributes) */
            /(?:<br>&nbsp;[\s\r\n]+|<br>)*(<\/?(h[1-6]|hr|p|div|table|tbody|thead|tfoot|th|tr|td|li|ol|ul|caption|address|pre|form|blockquote|dl|dt|dd|dir|fieldset)[^>]*>)(?:<br>&nbsp;[\s\r\n]+|<br>)*/g, "$1", /<br><br>/g, "<BR><BR>", /<br>/g, " ", /<table([^>]*)>(\s|&nbsp;)+<t/gi, "<table$1><t", /<tr[^>]*>(\s|&nbsp;)*<\/tr>/gi, "", /<tbody[^>]*>(\s|&nbsp;)*<\/tbody>/gi, "", /<table[^>]*>(\s|&nbsp;)*<\/table>/gi, "", /<BR><BR>/g, "<br>", /^\s*(&nbsp;)+/gi, "", /(&nbsp;|<br[^>]*>)+\s*$/gi, "", /mso-[^;"]*;?/gi, "", /* office-related CSS attributes */
            /<(\/?)b(\s[^>]*)?>/gi, "<$1strong$2>", /<(\/?)i(\s[^>]*)?>/gi, "<$1em$2>", /<\/?(meta|link|style|o:|v:|x:)[^>]*>((?:.|\n)*?<\/(meta|link|style|o:|v:|x:)[^>]*>)?/gi, "", /* external references and namespaced tags */
            /style=(["|'])\s*\1/g, "" ];
        },
        applicable: function(html) {
            return /class="?Mso|style="[^"]*mso-/i.test(html);
        },
        listType: function(html) {
            if (/^[\u2022\u00b7\u00a7\u00d8o]\u00a0+/.test(html)) {
                return "ul";
            }
            if (/^\s*\w+[\.\)]\u00a0{2,}/.test(html)) {
                return "ol";
            }
        },
        lists: function(html) {
            var placeholder = dom.create(document, "div", {
                innerHTML: html
            });
            var blockChildren = $(dom.blockElements.join(","), placeholder);
            var lastMargin = -1, lastType, levels = {
                ul: {},
                ol: {}
            }, li = placeholder;
            for (var i = 0; i < blockChildren.length; i++) {
                var p = blockChildren[i];
                html = p.innerHTML.replace(/<\/?\w+[^>]*>/g, "").replace(/&nbsp;/g, " ");
                var type = this.listType(html);
                if (!type || dom.name(p) != "p") {
                    if (!p.innerHTML) {
                        dom.remove(p);
                    } else {
                        levels = {
                            ul: {},
                            ol: {}
                        };
                        li = placeholder;
                        lastMargin = -1;
                    }
                    continue;
                }
                var margin = parseFloat(p.style.marginLeft || 0);
                var list = levels[type][margin];
                if (margin > lastMargin || !list) {
                    list = dom.create(document, type);
                    if (li == placeholder) {
                        dom.insertBefore(list, p);
                    } else {
                        li.appendChild(list);
                    }
                    levels[type][margin] = list;
                }
                if (lastType != type) {
                    for (var key in levels) {
                        for (var child in levels[key]) {
                            if ($.contains(list, levels[key][child])) {
                                delete levels[key][child];
                            }
                        }
                    }
                }
                dom.remove(p.firstChild);
                li = dom.create(document, "li", {
                    innerHTML: p.innerHTML
                });
                list.appendChild(li);
                dom.remove(p);
                lastMargin = margin;
                lastType = type;
            }
            return placeholder.innerHTML;
        },
        stripEmptyAnchors: function(html) {
            return html.replace(/<a([^>]*)>\s*<\/a>/gi, function(a, attributes) {
                if (!attributes || attributes.indexOf("href") < 0) {
                    return "";
                }
                return a;
            });
        },
        clean: function(html) {
            var that = this, replacements = that.replacements, i, l;
            for (i = 0, l = replacements.length; i < l; i += 2) {
                html = html.replace(replacements[i], replacements[i + 1]);
            }
            html = that.stripEmptyAnchors(html);
            html = that.lists(html);
            html = html.replace(/\s+class="?[^"\s>]*"?/gi, "");
            return html;
        }
    });
    var WebkitFormatCleaner = Class.extend({
        init: function() {
            this.replacements = [ /\s+class="Apple-style-span[^"]*"/gi, "", /<(div|p|h[1-6])\s+style="[^"]*"/gi, "<$1", /^<div>(.*)<\/div>$/, "$1" ];
        },
        applicable: function(html) {
            return /class="?Apple-style-span|style="[^"]*-webkit-nbsp-mode/i.test(html);
        },
        clean: function(html) {
            var that = this, replacements = that.replacements, i, l;
            for (i = 0, l = replacements.length; i < l; i += 2) {
                html = html.replace(replacements[i], replacements[i + 1]);
            }
            return html;
        }
    });
    extend(Editor, {
        Command: Command,
        GenericCommand: GenericCommand,
        InsertHtmlCommand: InsertHtmlCommand,
        InsertHtmlTool: InsertHtmlTool,
        UndoRedoStack: UndoRedoStack,
        TypingHandler: TypingHandler,
        SystemHandler: SystemHandler,
        Keyboard: Keyboard,
        Clipboard: Clipboard,
        MSWordFormatCleaner: MSWordFormatCleaner,
        WebkitFormatCleaner: WebkitFormatCleaner
    });
    registerTool("insertHtml", new InsertHtmlTool({
        template: new ToolTemplate({
            template: EditorUtils.dropDownListTemplate,
            title: "Insert HTML",
            initialValue: "Insert HTML"
        })
    }));
})(window.kendo.jQuery);

(function($) {
    var kendo = window.kendo, Class = kendo.Class, Editor = kendo.ui.editor, formats = kendo.ui.Editor.fn.options.formats, EditorUtils = Editor.EditorUtils, Tool = Editor.Tool, ToolTemplate = Editor.ToolTemplate, FormatTool = Editor.FormatTool, dom = Editor.Dom, RangeUtils = Editor.RangeUtils, extend = $.extend, registerTool = Editor.EditorUtils.registerTool, registerFormat = Editor.EditorUtils.registerFormat, KMARKER = "k-marker";
    var InlineFormatFinder = Class.extend({
        init: function(format) {
            this.format = format;
        },
        numberOfSiblings: function(referenceNode) {
            var textNodesCount = 0, elementNodesCount = 0, markerCount = 0, parentNode = referenceNode.parentNode, node;
            for (node = parentNode.firstChild; node; node = node.nextSibling) {
                if (node != referenceNode) {
                    if (node.className == KMARKER) {
                        markerCount++;
                    } else if (node.nodeType == 3) {
                        textNodesCount++;
                    } else {
                        elementNodesCount++;
                    }
                }
            }
            if (markerCount > 1 && parentNode.firstChild.className == KMARKER && parentNode.lastChild.className == KMARKER) {
                // full node selection
                return 0;
            } else {
                return elementNodesCount + textNodesCount;
            }
        },
        findSuitable: function(sourceNode, skip) {
            if (!skip && this.numberOfSiblings(sourceNode) > 0) {
                return null;
            }
            return dom.parentOfType(sourceNode, this.format[0].tags);
        },
        findFormat: function(sourceNode) {
            var format = this.format, attrEquals = dom.attrEquals, i, len, node, tags, attributes;
            for (i = 0, len = format.length; i < len; i++) {
                node = sourceNode;
                tags = format[i].tags;
                attributes = format[i].attr;
                if (node && dom.ofType(node, tags) && attrEquals(node, attributes)) {
                    return node;
                }
                while (node) {
                    node = dom.parentOfType(node, tags);
                    if (node && attrEquals(node, attributes)) {
                        return node;
                    }
                }
            }
            return null;
        },
        isFormatted: function(nodes) {
            var i, len;
            for (i = 0, len = nodes.length; i < len; i++) {
                if (this.findFormat(nodes[i])) {
                    return true;
                }
            }
            return false;
        }
    });
    var InlineFormatter = Class.extend({
        init: function(format, values) {
            var that = this;
            that.finder = new InlineFormatFinder(format);
            that.attributes = extend({}, format[0].attr, values);
            that.tag = format[0].tags[0];
        },
        wrap: function(node) {
            return dom.wrap(node, dom.create(node.ownerDocument, this.tag, this.attributes));
        },
        activate: function(range, nodes) {
            var that = this;
            if (that.finder.isFormatted(nodes)) {
                that.split(range);
                that.remove(nodes);
            } else {
                that.apply(nodes);
            }
        },
        toggle: function(range) {
            var nodes = RangeUtils.textNodes(range);
            if (nodes.length > 0) {
                this.activate(range, nodes);
            }
        },
        apply: function(nodes) {
            var that = this, formatNodes = [], i, l, node, formatNode;
            for (i = 0, l = nodes.length; i < l; i++) {
                node = nodes[i];
                formatNode = that.finder.findSuitable(node);
                if (formatNode) {
                    dom.attr(formatNode, that.attributes);
                } else {
                    formatNode = that.wrap(node);
                }
                formatNodes.push(formatNode);
            }
            that.consolidate(formatNodes);
        },
        remove: function(nodes) {
            var that = this, i, l, formatNode;
            for (i = 0, l = nodes.length; i < l; i++) {
                formatNode = that.finder.findFormat(nodes[i]);
                if (formatNode) {
                    if (that.attributes && that.attributes.style) {
                        dom.unstyle(formatNode, that.attributes.style);
                        if (!formatNode.style.cssText) {
                            dom.unwrap(formatNode);
                        }
                    } else {
                        dom.unwrap(formatNode);
                    }
                }
            }
        },
        split: function(range) {
            var nodes = RangeUtils.textNodes(range), l = nodes.length, i, formatNode;
            if (l > 0) {
                for (i = 0; i < l; i++) {
                    formatNode = this.finder.findFormat(nodes[i]);
                    if (formatNode) {
                        RangeUtils.split(range, formatNode, true);
                    }
                }
            }
        },
        consolidate: function(nodes) {
            var node, last;
            while (nodes.length > 1) {
                node = nodes.pop();
                last = nodes[nodes.length - 1];
                if (node.previousSibling && node.previousSibling.className == KMARKER) {
                    last.appendChild(node.previousSibling);
                }
                if (node.tagName == last.tagName && node.previousSibling == last && node.style.cssText == last.style.cssText) {
                    while (node.firstChild) {
                        last.appendChild(node.firstChild);
                    }
                    dom.remove(node);
                }
            }
        }
    });
    var GreedyInlineFormatFinder = InlineFormatFinder.extend({
        init: function(format, greedyProperty) {
            var that = this;
            that.format = format;
            that.greedyProperty = greedyProperty;
            InlineFormatFinder.fn.init.call(that, format);
        },
        getInlineCssValue: function(node) {
            var attributes = node.attributes, trim = $.trim, i, l, attribute, name, attributeValue, css, pair, cssIndex, len, propertyAndValue, property, value;
            if (!attributes) {
                return;
            }
            for (i = 0, l = attributes.length; i < l; i++) {
                attribute = attributes[i];
                name = attribute.nodeName;
                attributeValue = attribute.nodeValue;
                if (attribute.specified && name == "style") {
                    css = trim(attributeValue || node.style.cssText).split(";");
                    for (cssIndex = 0, len = css.length; cssIndex < len; cssIndex++) {
                        pair = css[cssIndex];
                        if (pair.length) {
                            propertyAndValue = pair.split(":");
                            property = trim(propertyAndValue[0].toLowerCase());
                            value = trim(propertyAndValue[1]);
                            if (property != this.greedyProperty) {
                                continue;
                            }
                            return property.indexOf("color") >= 0 ? dom.toHex(value) : value;
                        }
                    }
                }
            }
        },
        getFormatInner: function(node) {
            var $node = $(dom.isDataNode(node) ? node.parentNode : node), parents = $node.parents().andSelf(), i, len, value;
            for (i = 0, len = parents.length; i < len; i++) {
                value = this.greedyProperty == "className" ? parents[i].className : this.getInlineCssValue(parents[i]);
                if (value) {
                    return value;
                }
            }
            return "inherit";
        },
        getFormat: function(nodes) {
            var result = this.getFormatInner(nodes[0]), i, len;
            for (i = 1, len = nodes.length; i < len; i++) {
                if (result != this.getFormatInner(nodes[i])) {
                    return "";
                }
            }
            return result;
        },
        isFormatted: function(nodes) {
            return this.getFormat(nodes) !== "";
        }
    });
    var GreedyInlineFormatter = InlineFormatter.extend({
        init: function(format, values, greedyProperty) {
            var that = this;
            InlineFormatter.fn.init.call(that, format, values);
            that.greedyProperty = greedyProperty;
            that.values = values;
            that.finder = new GreedyInlineFormatFinder(format, greedyProperty);
        },
        activate: function(range, nodes) {
            var that = this, camelCase, greedyProperty = that.greedyProperty, action = "apply";
            that.split(range);
            if (greedyProperty) {
                camelCase = greedyProperty.replace(/-([a-z])/, function(all, letter) {
                    return letter.toUpperCase();
                });
                if (that.values.style[camelCase] == "inherit") {
                    action = "remove";
                }
            }
            that[action](nodes);
        }
    });
    function inlineFormatWillDelayExecution(range) {
        return range.collapsed && !RangeUtils.isExpandable(range);
    }
    var InlineFormatTool = FormatTool.extend({
        init: function(options) {
            FormatTool.fn.init.call(this, extend(options, {
                finder: new InlineFormatFinder(options.format),
                formatter: function() {
                    return new InlineFormatter(options.format);
                }
            }));
            this.willDelayExecution = inlineFormatWillDelayExecution;
        }
    });
    var DelayedExecutionTool = Tool.extend({
        willDelayExecution: inlineFormatWillDelayExecution,
        update: function(ui, nodes, pendingFormats) {
            var list = ui.data(this.type), pendingFormat = pendingFormats.getPending(this.name), format;
            if (pendingFormat && pendingFormat.options.params) {
                format = pendingFormat.options.params.value;
            } else {
                format = this.finder.getFormat(nodes);
            }
            list.close();
            list.value(format);
        }
    });
    var FontTool = DelayedExecutionTool.extend({
        init: function(options) {
            var that = this;
            Tool.fn.init.call(that, options);
            // IE has single selection hence we are using select box instead of combobox
            that.type = kendo.support.browser.msie || kendo.support.touch ? "kendoDropDownList" : "kendoComboBox";
            that.format = [ {
                tags: [ "span" ]
            } ];
            that.finder = new GreedyInlineFormatFinder(that.format, options.cssAttr);
        },
        command: function(commandArguments) {
            var options = this.options, format = this.format, style = {};
            return new Editor.FormatCommand(extend(commandArguments, {
                formatter: function() {
                    style[options.domAttr] = commandArguments.value;
                    return new GreedyInlineFormatter(format, {
                        style: style
                    }, options.cssAttr);
                }
            }));
        },
        initialize: function(ui, initOptions) {
            var editor = initOptions.editor, options = this.options, toolName = options.name, dataSource, defaultValue = [];
            if (options.defaultValue) {
                defaultValue = [ {
                    text: editor.options.messages[options.defaultValue[0].text],
                    value: options.defaultValue[0].value
                } ];
            }
            dataSource = defaultValue.concat(options.items ? options.items : editor.options[toolName]);
            ui[this.type]({
                dataTextField: "text",
                dataValueField: "value",
                dataSource: dataSource,
                change: function() {
                    Tool.exec(editor, toolName, this.value());
                },
                highlightFirst: false
            });
            ui.closest(".k-widget").removeClass("k-" + toolName).find("*").andSelf().attr("unselectable", "on");
            ui.data(this.type).value("inherit");
        }
    });
    var ColorTool = Tool.extend({
        init: function(options) {
            Tool.fn.init.call(this, options);
            this.options = options;
            this.format = [ {
                tags: [ "span" ]
            } ];
        },
        update: function() {
            this._widget.close();
        },
        command: function(commandArguments) {
            var options = this.options, format = this.format, style = {};
            return new Editor.FormatCommand(extend(commandArguments, {
                formatter: function() {
                    style[options.domAttr] = commandArguments.value;
                    return new GreedyInlineFormatter(format, {
                        style: style
                    }, options.cssAttr);
                }
            }));
        },
        willDelayExecution: inlineFormatWillDelayExecution,
        initialize: function(ui, initOptions) {
            var editor = initOptions.editor, toolName = this.name;
            ui = this._widget = new kendo.ui.ColorPicker(ui, {
                value: "#000",
                toolIcon: "k-" + this.options.name,
                palette: "websafe",
                change: function() {
                    var color = ui.value();
                    if (color) {
                        Tool.exec(editor, toolName, color);
                    }
                }
            });
            ui.bind("activate", function(ev) {
                ev.preventDefault();
                ui.trigger("change");
                editor.focus();
            });
            ui.element.attr("title", initOptions.title);
        }
    });
    var StyleTool = DelayedExecutionTool.extend({
        init: function(options) {
            var that = this;
            Tool.fn.init.call(that, options);
            that.type = "kendoSelectBox";
            that.format = [ {
                tags: [ "span" ]
            } ];
            that.finder = new GreedyInlineFormatFinder(that.format, "className");
        },
        command: function(commandArguments) {
            var format = this.format;
            return new Editor.FormatCommand(extend(commandArguments, {
                formatter: function() {
                    return new GreedyInlineFormatter(format, {
                        className: commandArguments.value
                    });
                }
            }));
        },
        initialize: function(ui, initOptions) {
            var editor = initOptions.editor, options = this.options;
            new Editor.SelectBox(ui, {
                dataTextField: "text",
                dataValueField: "value",
                dataSource: options.items || editor.options.style,
                title: editor.options.messages.style,
                change: function() {
                    Tool.exec(editor, "style", this.value());
                },
                highlightFirst: false
            });
            ui.closest(".k-widget").removeClass("k-" + this.name).find("*").andSelf().attr("unselectable", "on");
        }
    });
    extend(Editor, {
        InlineFormatFinder: InlineFormatFinder,
        InlineFormatter: InlineFormatter,
        GreedyInlineFormatFinder: GreedyInlineFormatFinder,
        GreedyInlineFormatter: GreedyInlineFormatter,
        InlineFormatTool: InlineFormatTool,
        FontTool: FontTool,
        ColorTool: ColorTool,
        StyleTool: StyleTool
    });
    registerTool("style", new Editor.StyleTool({
        template: new ToolTemplate({
            template: EditorUtils.dropDownListTemplate,
            title: "Styles"
        })
    }));
    registerFormat("bold", [ {
        tags: [ "strong" ]
    }, {
        tags: [ "span" ],
        attr: {
            style: {
                fontWeight: "bold"
            }
        }
    } ]);
    registerTool("bold", new InlineFormatTool({
        key: "B",
        ctrl: true,
        format: formats.bold,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Bold"
        })
    }));
    registerFormat("italic", [ {
        tags: [ "em" ]
    }, {
        tags: [ "span" ],
        attr: {
            style: {
                fontStyle: "italic"
            }
        }
    } ]);
    registerTool("italic", new InlineFormatTool({
        key: "I",
        ctrl: true,
        format: formats.italic,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Italic"
        })
    }));
    registerFormat("underline", [ {
        tags: [ "span" ],
        attr: {
            style: {
                textDecoration: "underline"
            }
        }
    } ]);
    registerTool("underline", new InlineFormatTool({
        key: "U",
        ctrl: true,
        format: formats.underline,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Underline"
        })
    }));
    registerFormat("strikethrough", [ {
        tags: [ "del" ]
    }, {
        tags: [ "span" ],
        attr: {
            style: {
                textDecoration: "line-through"
            }
        }
    } ]);
    registerTool("strikethrough", new InlineFormatTool({
        format: formats.strikethrough,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Strikethrough"
        })
    }));
    registerFormat("superscript", [ {
        tags: [ "sup" ]
    } ]);
    registerTool("superscript", new InlineFormatTool({
        format: formats.superscript,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Superscript"
        })
    }));
    registerFormat("subscript", [ {
        tags: [ "sub" ]
    } ]);
    registerTool("subscript", new InlineFormatTool({
        format: formats.subscript,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Subscript"
        })
    }));
    registerTool("foreColor", new ColorTool({
        cssAttr: "color",
        domAttr: "color",
        name: "foreColor",
        template: new ToolTemplate({
            template: EditorUtils.colorPickerTemplate,
            title: "Color"
        })
    }));
    registerTool("backColor", new ColorTool({
        cssAttr: "background-color",
        domAttr: "backgroundColor",
        name: "backColor",
        template: new ToolTemplate({
            template: EditorUtils.colorPickerTemplate,
            title: "Background Color"
        })
    }));
    registerTool("fontName", new FontTool({
        cssAttr: "font-family",
        domAttr: "fontFamily",
        name: "fontName",
        defaultValue: [ {
            text: "fontNameInherit",
            value: "inherit"
        } ],
        template: new ToolTemplate({
            template: EditorUtils.comboBoxTemplate,
            title: "Font Name"
        })
    }));
    registerTool("fontSize", new FontTool({
        cssAttr: "font-size",
        domAttr: "fontSize",
        name: "fontSize",
        defaultValue: [ {
            text: "fontSizeInherit",
            value: "inherit"
        } ],
        template: new ToolTemplate({
            template: EditorUtils.comboBoxTemplate,
            title: "Font Size"
        })
    }));
})(window.kendo.jQuery);

(function($) {
    var kendo = window.kendo, Class = kendo.Class, extend = $.extend, Editor = kendo.ui.editor, formats = kendo.ui.Editor.fn.options.formats, dom = Editor.Dom, Command = Editor.Command, Tool = Editor.Tool, ToolTemplate = Editor.ToolTemplate, FormatTool = Editor.FormatTool, EditorUtils = Editor.EditorUtils, registerTool = EditorUtils.registerTool, registerFormat = EditorUtils.registerFormat, RangeUtils = Editor.RangeUtils;
    var BlockFormatFinder = Class.extend({
        init: function(format) {
            this.format = format;
        },
        contains: function(node, children) {
            var i, len, child;
            for (i = 0, len = children.length; i < len; i++) {
                child = children[i];
                if (!child || !dom.isAncestorOrSelf(node, child)) {
                    return false;
                }
            }
            return true;
        },
        findSuitable: function(nodes) {
            var format = this.format, suitable = [], i, len, candidate;
            for (i = 0, len = nodes.length; i < len; i++) {
                candidate = dom.ofType(nodes[i], format[0].tags) ? nodes[i] : dom.parentOfType(nodes[i], format[0].tags);
                if (!candidate) {
                    return [];
                }
                if ($.inArray(candidate, suitable) < 0) {
                    suitable.push(candidate);
                }
            }
            for (i = 0, len = suitable.length; i < len; i++) {
                if (this.contains(suitable[i], suitable)) {
                    return [ suitable[i] ];
                }
            }
            return suitable;
        },
        findFormat: function(sourceNode) {
            var format = this.format, i, len, node, tags, attributes;
            for (i = 0, len = format.length; i < len; i++) {
                node = sourceNode;
                tags = format[i].tags;
                attributes = format[i].attr;
                while (node) {
                    if (dom.ofType(node, tags) && dom.attrEquals(node, attributes)) {
                        return node;
                    }
                    node = node.parentNode;
                }
            }
            return null;
        },
        getFormat: function(nodes) {
            var that = this, findFormat = function(node) {
                return that.findFormat(dom.isDataNode(node) ? node.parentNode : node);
            }, result = findFormat(nodes[0]), i, len;
            if (!result) {
                return "";
            }
            for (i = 1, len = nodes.length; i < len; i++) {
                if (result != findFormat(nodes[i])) {
                    return "";
                }
            }
            return result.nodeName.toLowerCase();
        },
        isFormatted: function(nodes) {
            for (var i = 0, len = nodes.length; i < len; i++) {
                if (!this.findFormat(nodes[i])) {
                    return false;
                }
            }
            return true;
        }
    });
    var BlockFormatter = Class.extend({
        init: function(format, values) {
            this.format = format;
            this.values = values;
            this.finder = new BlockFormatFinder(format);
        },
        wrap: function(tag, attributes, nodes) {
            var commonAncestor = nodes.length == 1 ? dom.blockParentOrBody(nodes[0]) : dom.commonAncestor.apply(null, nodes);
            if (dom.isInline(commonAncestor)) {
                commonAncestor = dom.blockParentOrBody(commonAncestor);
            }
            var ancestors = dom.significantChildNodes(commonAncestor), position = dom.findNodeIndex(ancestors[0]), wrapper = dom.create(commonAncestor.ownerDocument, tag, attributes), i, ancestor;
            for (i = 0; i < ancestors.length; i++) {
                ancestor = ancestors[i];
                if (dom.isBlock(ancestor)) {
                    dom.attr(ancestor, attributes);
                    if (wrapper.childNodes.length) {
                        dom.insertBefore(wrapper, ancestor);
                        wrapper = wrapper.cloneNode(false);
                    }
                    position = dom.findNodeIndex(ancestor) + 1;
                    continue;
                }
                wrapper.appendChild(ancestor);
            }
            if (wrapper.firstChild) {
                dom.insertAt(commonAncestor, wrapper, position);
            }
        },
        apply: function(nodes) {
            var that = this, formatNodes = dom.is(nodes[0], "img") ? [ nodes[0] ] : that.finder.findSuitable(nodes), formatToApply = formatNodes.length ? EditorUtils.formatByName(dom.name(formatNodes[0]), that.format) : that.format[0], tag = formatToApply.tags[0], attributes = extend({}, formatToApply.attr, that.values), i, len;
            if (formatNodes.length) {
                for (i = 0, len = formatNodes.length; i < len; i++) {
                    dom.attr(formatNodes[i], attributes);
                }
            } else {
                that.wrap(tag, attributes, nodes);
            }
        },
        remove: function(nodes) {
            var i, l, formatNode, namedFormat;
            for (i = 0, l = nodes.length; i < l; i++) {
                formatNode = this.finder.findFormat(nodes[i]);
                if (formatNode) {
                    if (dom.ofType(formatNode, [ "p", "img", "li" ])) {
                        namedFormat = EditorUtils.formatByName(dom.name(formatNode), this.format);
                        if (namedFormat.attr.style) {
                            dom.unstyle(formatNode, namedFormat.attr.style);
                        }
                        if (namedFormat.attr.className) {
                            dom.removeClass(formatNode, namedFormat.attr.className);
                        }
                    } else {
                        dom.unwrap(formatNode);
                    }
                }
            }
        },
        toggle: function(range) {
            var that = this, nodes = RangeUtils.nodes(range);
            if (that.finder.isFormatted(nodes)) {
                that.remove(nodes);
            } else {
                that.apply(nodes);
            }
        }
    });
    var GreedyBlockFormatter = Class.extend({
        init: function(format, values) {
            var that = this;
            that.format = format;
            that.values = values;
            that.finder = new BlockFormatFinder(format);
        },
        apply: function(nodes) {
            var format = this.format, blocks = dom.blockParents(nodes), formatTag = format[0].tags[0], i, len, list, formatter, range;
            if (blocks.length) {
                for (i = 0, len = blocks.length; i < len; i++) {
                    if (dom.is(blocks[i], "li")) {
                        list = blocks[i].parentNode;
                        formatter = new Editor.ListFormatter(list.nodeName.toLowerCase(), formatTag);
                        range = this.editor.createRange();
                        range.selectNode(blocks[i]);
                        formatter.toggle(range);
                    } else {
                        dom.changeTag(blocks[i], formatTag);
                    }
                }
            } else {
                new BlockFormatter(format, this.values).apply(nodes);
            }
        },
        toggle: function(range) {
            var nodes = RangeUtils.textNodes(range);
            if (!nodes.length) {
                range.selectNodeContents(range.commonAncestorContainer);
                nodes = RangeUtils.textNodes(range);
                if (!nodes.length) {
                    nodes = dom.significantChildNodes(range.commonAncestorContainer);
                }
            }
            this.apply(nodes);
        }
    });
    var FormatCommand = Command.extend({
        init: function(options) {
            options.formatter = options.formatter();
            Command.fn.init.call(this, options);
        }
    });
    var BlockFormatTool = FormatTool.extend({
        init: function(options) {
            FormatTool.fn.init.call(this, extend(options, {
                finder: new BlockFormatFinder(options.format),
                formatter: function() {
                    return new BlockFormatter(options.format);
                }
            }));
        }
    });
    var FormatBlockTool = Tool.extend({
        init: function(options) {
            Tool.fn.init.call(this, options);
            this.finder = new BlockFormatFinder([ {
                tags: dom.blockElements
            } ]);
        },
        command: function(commandArguments) {
            return new FormatCommand(extend(commandArguments, {
                formatter: function() {
                    return new GreedyBlockFormatter([ {
                        tags: [ commandArguments.value ]
                    } ], {});
                }
            }));
        },
        update: function(ui, nodes) {
            var list;
            if (ui.is("select")) {
                list = ui.data("kendoSelectBox");
            } else {
                list = ui.find("select").data("kendoSelectBox");
            }
            list.close();
            list.value(this.finder.getFormat(nodes));
        },
        initialize: function(ui, initOptions) {
            var editor = initOptions.editor, toolName = "formatBlock";
            new Editor.SelectBox(ui, {
                dataTextField: "text",
                dataValueField: "value",
                dataSource: this.options.items ? this.options.items : editor.options.formatBlock,
                title: editor.options.messages.formatBlock,
                change: function() {
                    Tool.exec(editor, toolName, this.value());
                },
                highlightFirst: false
            });
            ui.closest(".k-widget").removeClass("k-" + toolName).find("*").andSelf().attr("unselectable", "on");
        }
    });
    extend(Editor, {
        BlockFormatFinder: BlockFormatFinder,
        BlockFormatter: BlockFormatter,
        GreedyBlockFormatter: GreedyBlockFormatter,
        FormatCommand: FormatCommand,
        BlockFormatTool: BlockFormatTool,
        FormatBlockTool: FormatBlockTool
    });
    registerTool("formatBlock", new FormatBlockTool({
        template: new ToolTemplate({
            template: EditorUtils.dropDownListTemplate
        })
    }));
    registerFormat("justifyLeft", [ {
        tags: dom.blockElements,
        attr: {
            style: {
                textAlign: "left"
            }
        }
    }, {
        tags: [ "img" ],
        attr: {
            style: {
                "float": "left"
            }
        }
    } ]);
    registerTool("justifyLeft", new BlockFormatTool({
        format: formats.justifyLeft,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Justify Left"
        })
    }));
    registerFormat("justifyCenter", [ {
        tags: dom.blockElements,
        attr: {
            style: {
                textAlign: "center"
            }
        }
    }, {
        tags: [ "img" ],
        attr: {
            style: {
                display: "block",
                marginLeft: "auto",
                marginRight: "auto"
            }
        }
    } ]);
    registerTool("justifyCenter", new BlockFormatTool({
        format: formats.justifyCenter,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Justify Center"
        })
    }));
    registerFormat("justifyRight", [ {
        tags: dom.blockElements,
        attr: {
            style: {
                textAlign: "right"
            }
        }
    }, {
        tags: [ "img" ],
        attr: {
            style: {
                "float": "right"
            }
        }
    } ]);
    registerTool("justifyRight", new BlockFormatTool({
        format: formats.justifyRight,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Justify Right"
        })
    }));
    registerFormat("justifyFull", [ {
        tags: dom.blockElements,
        attr: {
            style: {
                textAlign: "justify"
            }
        }
    } ]);
    registerTool("justifyFull", new BlockFormatTool({
        format: formats.justifyFull,
        template: new ToolTemplate({
            template: EditorUtils.buttonTemplate,
            title: "Justify Full"
        })
    }));
})(window.kendo.jQuery);

(function($) {
    // Imports ================================================================
    var kendo = window.kendo, extend = $.extend, Editor = kendo.ui.editor, dom = Editor.Dom, Command = Editor.Command, Tool = Editor.Tool, BlockFormatter = Editor.BlockFormatter, normalize = dom.normalize, RangeUtils = Editor.RangeUtils, registerTool = Editor.EditorUtils.registerTool;
    var ParagraphCommand = Command.extend({
        init: function(options) {
            this.options = options;
            Command.fn.init.call(this, options);
        },
        exec: function() {
            var range = this.getRange(), doc = RangeUtils.documentFromRange(range), parent, previous, next, container, emptyParagraphContent = kendo.support.browser.msie ? "" : '<br _moz_dirty="" />', paragraph, marker, li, heading, rng, // necessary while the emptyParagraphContent is empty under IE
            blocks = "p,h1,h2,h3,h4,h5,h6".split(","), startInBlock = dom.parentOfType(range.startContainer, blocks), endInBlock = dom.parentOfType(range.endContainer, blocks), shouldTrim = startInBlock && !endInBlock || !startInBlock && endInBlock;
            function clean(node) {
                if (node.firstChild && dom.is(node.firstChild, "br")) {
                    dom.remove(node.firstChild);
                }
                if (dom.isDataNode(node) && !node.nodeValue) {
                    node = node.parentNode;
                }
                if (node && !dom.is(node, "img")) {
                    while (node.firstChild && node.firstChild.nodeType == 1) {
                        node = node.firstChild;
                    }
                    if (node.innerHTML === "") {
                        node.innerHTML = emptyParagraphContent;
                    }
                }
            }
            range.deleteContents();
            marker = dom.create(doc, "a");
            range.insertNode(marker);
            if (!marker.parentNode) {
                // inserting paragraph in Firefox full body range
                container = range.commonAncestorContainer;
                container.innerHTML = "";
                container.appendChild(marker);
            }
            normalize(marker.parentNode);
            li = dom.parentOfType(marker, [ "li" ]);
            heading = dom.parentOfType(marker, "h1,h2,h3,h4,h5,h6".split(","));
            if (li) {
                rng = range.cloneRange();
                rng.selectNode(li);
                // hitting 'enter' in empty li
                if (!RangeUtils.textNodes(rng).length) {
                    paragraph = dom.create(doc, "p");
                    if (li.nextSibling) {
                        RangeUtils.split(rng, li.parentNode);
                    }
                    dom.insertAfter(paragraph, li.parentNode);
                    dom.remove(li.parentNode.childNodes.length == 1 ? li.parentNode : li);
                    paragraph.innerHTML = emptyParagraphContent;
                    next = paragraph;
                }
            } else if (heading && !marker.nextSibling) {
                paragraph = dom.create(doc, "p");
                dom.insertAfter(paragraph, heading);
                paragraph.innerHTML = emptyParagraphContent;
                dom.remove(marker);
                next = paragraph;
            }
            if (!next) {
                if (!(li || heading)) {
                    new BlockFormatter([ {
                        tags: [ "p" ]
                    } ]).apply([ marker ]);
                }
                range.selectNode(marker);
                parent = dom.parentOfType(marker, [ li ? "li" : heading ? dom.name(heading) : "p" ]);
                RangeUtils.split(range, parent, shouldTrim);
                previous = parent.previousSibling;
                if (dom.is(previous, "li") && previous.firstChild && !dom.is(previous.firstChild, "br")) {
                    previous = previous.firstChild;
                }
                next = parent.nextSibling;
                if (dom.is(next, "li") && next.firstChild && !dom.is(next.firstChild, "br")) {
                    next = next.firstChild;
                }
                dom.remove(parent);
                clean(previous);
                clean(next);
                // normalize updates the caret display in Gecko
                normalize(previous);
            }
            normalize(next);
            if (dom.is(next, "img")) {
                range.setStartBefore(next);
            } else {
                range.selectNodeContents(next);
                var textNode = RangeUtils.textNodes(range)[0];
                if (textNode) {
                    range.selectNodeContents(textNode);
                }
            }
            range.collapse(true);
            dom.scrollTo(next);
            RangeUtils.selectRange(range);
        }
    });
    var NewLineCommand = Command.extend({
        init: function(options) {
            this.options = options;
            Command.fn.init.call(this, options);
        },
        exec: function() {
            var range = this.getRange();
            range.deleteContents();
            var br = dom.create(RangeUtils.documentFromRange(range), "br");
            range.insertNode(br);
            normalize(br.parentNode);
            if (!kendo.support.browser.msie && (!br.nextSibling || dom.isWhitespace(br.nextSibling))) {
                //Gecko and WebKit cannot put the caret after only one br.
                var filler = br.cloneNode(true);
                filler.setAttribute("_moz_dirty", "");
                dom.insertAfter(filler, br);
            }
            range.setStartAfter(br);
            range.collapse(true);
            dom.scrollTo(br.nextSibling);
            RangeUtils.selectRange(range);
        }
    });
    extend(Editor, {
        ParagraphCommand: ParagraphCommand,
        NewLineCommand: NewLineCommand
    });
    registerTool("insertLineBreak", new Tool({
        key: 13,
        shift: true,
        command: NewLineCommand
    }));
    registerTool("insertParagraph", new Tool({
        key: 13,
        command: ParagraphCommand
    }));
})(window.kendo.jQuery);

(function($) {
    // Imports ================================================================
    var kendo = window.kendo, Class = kendo.Class, extend = $.extend, Editor = kendo.ui.editor, dom = Editor.Dom, RangeUtils = Editor.RangeUtils, EditorUtils = Editor.EditorUtils, Command = Editor.Command, ToolTemplate = Editor.ToolTemplate, FormatTool = Editor.FormatTool, BlockFormatFinder = Editor.BlockFormatFinder, textNodes = RangeUtils.textNodes, registerTool = Editor.EditorUtils.registerTool;
    var ListFormatFinder = BlockFormatFinder.extend({
        init: function(tag) {
            this.tag = tag;
            var tags = this.tags = [ tag == "ul" ? "ol" : "ul", tag ];
            BlockFormatFinder.fn.init.call(this, [ {
                tags: tags
            } ]);
        },
        isFormatted: function(nodes) {
            var formatNodes = [], formatNode;
            for (var i = 0; i < nodes.length; i++) {
                if ((formatNode = this.findFormat(nodes[i])) && dom.name(formatNode) == this.tag) {
                    formatNodes.push(formatNode);
                }
            }
            if (formatNodes.length < 1) {
                return false;
            }
            if (formatNodes.length != nodes.length) {
                return false;
            }
            // check if sequential lists are selected
            for (i = 0; i < formatNodes.length; i++) {
                if (formatNodes[i].parentNode != formatNode.parentNode) {
                    break;
                }
                if (formatNodes[i] != formatNode) {
                    return false;
                }
            }
            return true;
        },
        findSuitable: function(nodes) {
            var candidate = dom.parentOfType(nodes[0], this.tags);
            if (candidate && dom.name(candidate) == this.tag) {
                return candidate;
            }
            return null;
        }
    });
    var ListFormatter = Class.extend({
        init: function(tag, unwrapTag) {
            var that = this;
            that.finder = new ListFormatFinder(tag);
            that.tag = tag;
            that.unwrapTag = unwrapTag;
        },
        wrap: function(list, nodes) {
            var li = dom.create(list.ownerDocument, "li"), i, node;
            for (i = 0; i < nodes.length; i++) {
                node = nodes[i];
                if (dom.is(node, "li")) {
                    list.appendChild(node);
                    continue;
                }
                if (dom.is(node, "ul") || dom.is(node, "ol")) {
                    while (node.firstChild) {
                        list.appendChild(node.firstChild);
                    }
                    continue;
                }
                if (dom.is(node, "td")) {
                    while (node.firstChild) {
                        li.appendChild(node.firstChild);
                    }
                    list.appendChild(li);
                    node.appendChild(list);
                    list = list.cloneNode(false);
                    li = li.cloneNode(false);
                    continue;
                }
                li.appendChild(node);
                if (dom.isBlock(node)) {
                    list.appendChild(li);
                    dom.unwrap(node);
                    li = li.cloneNode(false);
                }
            }
            if (li.firstChild) {
                list.appendChild(li);
            }
        },
        containsAny: function(parent, nodes) {
            for (var i = 0; i < nodes.length; i++) {
                if (dom.isAncestorOrSelf(parent, nodes[i])) {
                    return true;
                }
            }
            return false;
        },
        suitable: function(candidate, nodes) {
            if (candidate.className == "k-marker") {
                var sibling = candidate.nextSibling;
                if (sibling && dom.isBlock(sibling)) {
                    return false;
                }
                sibling = candidate.previousSibling;
                if (sibling && dom.isBlock(sibling)) {
                    return false;
                }
            }
            return this.containsAny(candidate, nodes) || dom.isInline(candidate) || candidate.nodeType == 3;
        },
        split: function(range) {
            var nodes = textNodes(range), start, end;
            if (nodes.length) {
                start = dom.parentOfType(nodes[0], [ "li" ]);
                end = dom.parentOfType(nodes[nodes.length - 1], [ "li" ]);
                range.setStartBefore(start);
                range.setEndAfter(end);
                for (var i = 0, l = nodes.length; i < l; i++) {
                    var formatNode = this.finder.findFormat(nodes[i]);
                    if (formatNode) {
                        var parents = $(formatNode).parents("ul,ol");
                        if (parents[0]) {
                            RangeUtils.split(range, parents.last()[0], true);
                        } else {
                            RangeUtils.split(range, formatNode, true);
                        }
                    }
                }
            }
        },
        merge: function(tag, formatNode) {
            var prev = formatNode.previousSibling, next;
            while (prev && (prev.className == "k-marker" || prev.nodeType == 3 && dom.isWhitespace(prev))) {
                prev = prev.previousSibling;
            }
            // merge with previous list
            if (prev && dom.name(prev) == tag) {
                while (formatNode.firstChild) {
                    prev.appendChild(formatNode.firstChild);
                }
                dom.remove(formatNode);
                formatNode = prev;
            }
            next = formatNode.nextSibling;
            while (next && (next.className == "k-marker" || next.nodeType == 3 && dom.isWhitespace(next))) {
                next = next.nextSibling;
            }
            // merge with next list
            if (next && dom.name(next) == tag) {
                while (formatNode.lastChild) {
                    next.insertBefore(formatNode.lastChild, next.firstChild);
                }
                dom.remove(formatNode);
            }
        },
        applyOnSection: function(section, nodes) {
            var tag = this.tag, commonAncestor;
            if (nodes.length == 1) {
                commonAncestor = dom.parentOfType(nodes[0], [ "ul", "ol" ]);
            } else {
                commonAncestor = dom.commonAncestor.apply(null, nodes);
            }
            if (!commonAncestor) {
                commonAncestor = dom.parentOfType(nodes[0], [ "p", "td" ]) || nodes[0].ownerDocument.body;
            }
            if (dom.isInline(commonAncestor)) {
                commonAncestor = dom.blockParentOrBody(commonAncestor);
            }
            var ancestors = [];
            var formatNode = this.finder.findSuitable(nodes);
            if (!formatNode) {
                formatNode = new ListFormatFinder(tag == "ul" ? "ol" : "ul").findSuitable(nodes);
            }
            var childNodes = dom.significantChildNodes(commonAncestor);
            if (!childNodes.length) {
                childNodes = nodes;
            }
            if (/table|tbody/.test(dom.name(commonAncestor))) {
                childNodes = $.map(nodes, function(node) {
                    return dom.parentOfType(node, [ "td" ]);
                });
            }
            function pushAncestor() {
                ancestors.push(this);
            }
            for (var i = 0; i < childNodes.length; i++) {
                var child = childNodes[i];
                var nodeName = dom.name(child);
                if (this.suitable(child, nodes) && (!formatNode || !dom.isAncestorOrSelf(formatNode, child))) {
                    if (formatNode && (nodeName == "ul" || nodeName == "ol")) {
                        // merging lists
                        //Array.prototype.push.apply(ancestors, $.toArray(child.childNodes));
                        $.each(child.childNodes, pushAncestor);
                        dom.remove(child);
                    } else {
                        ancestors.push(child);
                    }
                }
            }
            if (ancestors.length == childNodes.length && commonAncestor != nodes[0].ownerDocument.body && !/table|tbody|tr|td/.test(dom.name(commonAncestor))) {
                ancestors = [ commonAncestor ];
            }
            if (!formatNode) {
                formatNode = dom.create(commonAncestor.ownerDocument, tag);
                dom.insertBefore(formatNode, ancestors[0]);
            }
            this.wrap(formatNode, ancestors);
            if (!dom.is(formatNode, tag)) {
                dom.changeTag(formatNode, tag);
            }
            this.merge(tag, formatNode);
        },
        apply: function(nodes) {
            var i = 0, sections = [], lastSection, lastNodes, section;
            // split nodes into sections that need to be different lists
            do {
                section = dom.parentOfType(nodes[i], [ "td", "body" ]);
                if (!lastSection || section != lastSection) {
                    if (lastSection) {
                        sections.push({
                            section: lastSection,
                            nodes: lastNodes
                        });
                    }
                    lastNodes = [ nodes[i] ];
                    lastSection = section;
                } else {
                    lastNodes.push(nodes[i]);
                }
                i++;
            } while (i < nodes.length);
            sections.push({
                section: lastSection,
                nodes: lastNodes
            });
            for (i = 0; i < sections.length; i++) {
                this.applyOnSection(sections[i].section, sections[i].nodes);
            }
        },
        unwrap: function(ul) {
            var fragment = ul.ownerDocument.createDocumentFragment(), unwrapTag = this.unwrapTag, parents, li, p, child;
            for (li = ul.firstChild; li; li = li.nextSibling) {
                p = dom.create(ul.ownerDocument, unwrapTag || "p");
                while (li.firstChild) {
                    child = li.firstChild;
                    if (dom.isBlock(child)) {
                        if (p.firstChild) {
                            fragment.appendChild(p);
                            p = dom.create(ul.ownerDocument, unwrapTag || "p");
                        }
                        fragment.appendChild(child);
                    } else {
                        p.appendChild(child);
                    